/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuReflect;

public class PgFrame
extends PsObject {
    public PdVector base;
    public PdVector e1;
    public PdVector e2;
    public PdVector e3;
    private static /* synthetic */ Class class$jvx$geom$PgFrame;

    public PgFrame(int n) {
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PgFrame != null ? class$jvx$geom$PgFrame : (class$jvx$geom$PgFrame = PgFrame.class$("jvx.geom.PgFrame")))) {
            this.init();
        }
    }

    public boolean blend(double d, PgFrame pgFrame, double d2, PgFrame pgFrame2) {
        if (pgFrame == null || pgFrame2 == null) {
            PsDebug.warning((String)"missing argument frame");
            return false;
        }
        if (Math.abs(d) < 1.0E-10) {
            d = 0.0;
        }
        if (Math.abs(d2) < 1.0E-10) {
            d2 = 0.0;
        }
        this.base.blend(d, pgFrame.base, d2, pgFrame2.base);
        this.e1.blend(d, pgFrame.e1, d2, pgFrame2.e1);
        this.e2.blend(d, pgFrame.e2, d2, pgFrame2.e2);
        this.e3.blend(d, pgFrame.e3, d2, pgFrame2.e3);
        this.e1.normalize();
        this.e2.normalize();
        this.e3.normalize();
        return true;
    }

    public void parallelTranslate(PgFrame pgFrame, PgFrame pgFrame2, PdVector pdVector, PdVector pdVector2) {
        pgFrame2.base.copy(pdVector);
        this.base.copy(pdVector);
        double d = PdVector.angle((PdVector)pgFrame.e1, (PdVector)pdVector2);
        if (Math.abs(d) < 179.999 && Math.abs(d) > 0.001) {
            d *= Math.PI / 180;
            PdVector pdVector3 = new PdVector(3);
            pdVector3.cross(pgFrame.e1, pdVector2);
            pdVector3.normalize();
            PdMatrix pdMatrix = new PdMatrix(3);
            boolean bl = PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pdVector3, (double)(d / 2.0));
            if (!bl) {
                return;
            }
            pgFrame2.leftMultMatrix(pdMatrix, pgFrame);
            this.leftMultMatrix(pdMatrix, pgFrame2);
            PdMatrix pdMatrix2 = new PdMatrix(3);
            PdMatrix pdMatrix3 = new PdMatrix(3);
            pdMatrix2.setIdentity();
            pdMatrix2.m_data[2][2] = 1.0 / Math.cos(d / 2.0);
            pdMatrix3.setRow(0, pgFrame2.e1);
            pdMatrix3.setRow(1, pdVector3);
            PdVector pdVector4 = new PdVector(3);
            pdVector4.cross(pdVector3, pgFrame2.e1);
            pdMatrix3.setRow(2, pdVector4);
            pdMatrix2.rightMult(pdMatrix3);
            pdMatrix3.transpose();
            pdMatrix2.leftMult(pdMatrix3);
            pgFrame2.leftMultMatrix(pdMatrix2);
            return;
        }
        pgFrame2.copyVectors(pgFrame);
        this.copyVectors(pgFrame);
    }

    public void copy(PgFrame pgFrame) {
        if (pgFrame == null) {
            PsDebug.warning((String)"missing argument");
            return;
        }
        this.base.copy(pgFrame.base);
        this.e1.copy(pgFrame.e1);
        this.e2.copy(pgFrame.e2);
        this.e3.copy(pgFrame.e3);
    }

    public void leftMultMatrix(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            PsDebug.error((String)"missing aMatrix arg", (Object)((Object)this));
            return;
        }
        this.e1.leftMultMatrix(pdMatrix);
        this.e2.leftMultMatrix(pdMatrix);
        this.e3.leftMultMatrix(pdMatrix);
    }

    public void leftMultMatrix(PdMatrix pdMatrix, PgFrame pgFrame) {
        if (pdMatrix == null || pgFrame == null) {
            PsDebug.error((String)"missing arg", (Object)((Object)this));
            return;
        }
        this.e1.leftMultMatrix(pdMatrix, pgFrame.e1);
        this.e2.leftMultMatrix(pdMatrix, pgFrame.e2);
        this.e3.leftMultMatrix(pdMatrix, pgFrame.e3);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void copyVectors(PgFrame pgFrame) {
        if (pgFrame == null) {
            PsDebug.warning((String)"missing argument");
            return;
        }
        this.e1.copy(pgFrame.e1);
        this.e2.copy(pgFrame.e2);
        this.e3.copy(pgFrame.e3);
    }

    public void init() {
        super.init();
        this.base = new PdVector(3);
        this.e1 = new PdVector(3);
        this.e2 = new PdVector(3);
        this.e3 = new PdVector(3);
    }

    public static PgFrame[] realloc(PgFrame[] pgFrameArray, int n, int n2) {
        if (pgFrameArray != null && pgFrameArray.length == n) {
            return pgFrameArray;
        }
        PgFrame[] pgFrameArray2 = new PgFrame[n];
        int n3 = pgFrameArray == null ? 0 : Math.min(pgFrameArray.length, n);
        int n4 = 0;
        while (n4 < n3) {
            pgFrameArray2[n4] = pgFrameArray[n4];
            ++n4;
        }
        n4 = n3;
        while (n4 < n) {
            pgFrameArray2[n4] = new PgFrame(n2);
            ++n4;
        }
        return pgFrameArray2;
    }
}

