/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;

public class PgPolygonOnElementSet
extends PsObject {
    public static double BARYEPS = 0.005;
    public double m_eps = BARYEPS;
    private double m_meps = -this.m_eps;
    protected PgElementSet m_geom;
    protected int m_maxNum;
    protected int m_size;
    protected PiVector m_elem;
    protected PdBary[] m_pos;
    private PdVector[] bary = new PdVector[3];
    private PdBaryDir diff = new PdBaryDir(3);
    private int[] notzero = new int[2];
    private int[] zero = new int[2];
    private int[] numzero = new int[2];
    private PdBary[] v = null;
    private int[] n = new int[2];
    private PiVector[] altelem = null;
    private PgVertexStar[] star = null;
    private boolean[] starused = new boolean[2];
    private PdBary m_expBary = new PdBary(3);
    private PdVector m_expPoint = new PdVector(3);
    private PdBaryDir m_expDir = new PdBaryDir(3);
    private PdBaryDir m_expEdge = new PdBaryDir(3);
    private PdBaryDir m_expHalf = new PdBaryDir(3);
    private PdBaryDir m_expNormal = new PdBaryDir(3);

    public void setNumVertices(int n) {
        if (n > this.m_maxNum) {
            this.setMaxNumVertices(n);
        }
        this.m_size = n;
    }

    public int getNumVertices() {
        return this.m_size;
    }

    public void addPolygon(PgPolygonOnElementSet pgPolygonOnElementSet) {
        int n = this.m_size;
        this.setNumVertices(n + pgPolygonOnElementSet.getNumVertices());
        PiVector piVector = pgPolygonOnElementSet.getElemInd();
        PdBary[] pdBaryArray = pgPolygonOnElementSet.getBary();
        int n2 = 0;
        int n3 = n;
        while (n3 < this.m_size) {
            this.m_elem.m_data[n3] = piVector.m_data[n2];
            this.m_pos[n3].copy(pdBaryArray[n2]);
            ++n2;
            ++n3;
        }
    }

    public PiVector getElemInd() {
        return this.m_elem;
    }

    public int getElemInd(int n) {
        if (n >= this.m_size || n < 0) {
            PsDebug.warning((String)("Array index out of bounds: " + n + "."));
            return -1;
        }
        return this.m_elem.m_data[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgPolygonOnElementSet ******\n");
        stringBuffer.append("\t m_size = " + this.m_size + "\n");
        stringBuffer.append("\t ******* m_elem *******\n");
        if (this.m_elem != null && this.m_size > 0) {
            stringBuffer.append("\t m_elem = " + this.m_elem.toShortString());
        } else {
            stringBuffer.append("\t m_elem = null\n");
        }
        stringBuffer.append("\t ******* m_pos *******\n");
        if (this.m_pos != null && this.m_size > 0) {
            int n = 0;
            while (n < this.m_size) {
                stringBuffer.append("\t [" + n + "] = " + this.m_pos[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_pos = null\n");
        }
        return stringBuffer.toString();
    }

    public PgPolygonOnElementSet(PgElementSet pgElementSet) {
        this.m_geom = pgElementSet;
        this.m_size = 0;
        this.m_elem = new PiVector(0);
        this.m_pos = null;
    }

    public void setVertex(int n, int n2, PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"Missing coordinates.");
            return;
        }
        if (n >= this.m_size) {
            PsDebug.warning((String)("Array index out of bounds: " + n + "."));
            return;
        }
        this.m_pos[n].copy(pdBary);
        this.m_elem.m_data[n] = n2;
    }

    public PdBaryDir exp(int n, PdBary pdBary, PdBaryDir pdBaryDir, double d) {
        return this.exp(n, pdBary, pdBaryDir, d, null);
    }

    public PdBaryDir exp(int n, PdBary pdBary, PdBaryDir pdBaryDir, double d, PgPolygon pgPolygon) {
        int n2;
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing element set.");
            return null;
        }
        if (pdBary == null || pdBary.getSize() != 3) {
            PsDebug.warning((String)"No valid initial barycentric point.");
            return null;
        }
        if (n < 0 || n >= this.m_geom.getNumElements()) {
            PsDebug.warning((String)("Not a valid initial element index " + n + "."));
            return null;
        }
        int n3 = n2 = 100;
        if (pgPolygon != null) {
            pgPolygon.setNumVertices(n3);
        }
        this.setNumVertices(n3);
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        this.m_expBary.copy(pdBary);
        int n4 = n;
        double d2 = 0.0;
        int n5 = 0;
        if (pgPolygon != null) {
            PdBary.getVertex((PdVector)this.m_expPoint, (PdBary)this.m_expBary, (PdVector)pdVectorArray[piVectorArray[n4].m_data[0]], (PdVector)pdVectorArray[piVectorArray[n4].m_data[1]], (PdVector)pdVectorArray[piVectorArray[n4].m_data[2]]);
            pgPolygon.setVertex(n5, this.m_expPoint);
        }
        this.m_pos[n5].copy(this.m_expBary);
        this.m_elem.m_data[n5] = n4;
        if (d < 0.0) {
            PsDebug.warning((String)("Not a valid length " + d + "."));
            if (pgPolygon != null) {
                pgPolygon.setNumVertices(1);
            }
            this.setNumVertices(1);
            return null;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"No valid initial barycentric direction.");
            if (pgPolygon != null) {
                pgPolygon.setNumVertices(1);
            }
            this.setNumVertices(1);
            return null;
        }
        double d3 = PwBary.norm(this.m_geom, n, pdBaryDir, true);
        if (d3 < 1.0E-10) {
            PsDebug.warning((String)"No (valid) direction.");
            if (pgPolygon != null) {
                pgPolygon.setNumVertices(1);
            }
            this.setNumVertices(1);
            return null;
        }
        double d4 = d * d3;
        this.m_expDir.copy(pdBaryDir);
        this.m_expDir.multScalar(1.0 / d3);
        if (d4 < 1.0E-10) {
            if (pgPolygon != null) {
                pgPolygon.setNumVertices(1);
            }
            this.setNumVertices(1);
            return this.m_expDir;
        }
        boolean bl = false;
        double d5 = -1.0E-10;
        while (d2 < d4 && !bl) {
            int n6 = -1;
            int n7 = -1;
            int n8 = 0;
            int n9 = 0;
            do {
                if (this.m_expBary.m_data[n9] > this.m_eps || this.m_expBary.m_data[n9] < this.m_meps) {
                    n6 = n9;
                    continue;
                }
                ++n8;
                n7 = n9;
            } while (++n9 < 3);
            if (n8 == 2) {
                if (this.m_expDir.m_data[n6] > 0.0 && this.m_expDir.m_data[(n6 + 1) % 3] < 1.0E-10 && this.m_expDir.m_data[(n6 + 2) % 3] < 1.0E-10) {
                    this.m_expDir.multScalar(-1.0);
                    int n10 = PwBary.rotateAtVertex(this.m_geom, n4, n6, this.m_expDir, this.m_expDir, this.m_expBary, Math.PI);
                    if (n10 < 0) {
                        bl = true;
                        continue;
                    }
                    n4 = n10;
                    if (pgPolygon != null) {
                        PdBary.getVertex((PdVector)this.m_expPoint, (PdBary)this.m_expBary, (PdVector)pdVectorArray[piVectorArray[n4].m_data[0]], (PdVector)pdVectorArray[piVectorArray[n4].m_data[1]], (PdVector)pdVectorArray[piVectorArray[n4].m_data[2]]);
                        pgPolygon.setVertex(n5, this.m_expPoint);
                    }
                    this.m_pos[n5].copy(this.m_expBary);
                    this.m_elem.m_data[n5] = n4;
                } else {
                    n8 = 0;
                    n7 = -1;
                    n6 = -1;
                    n9 = 0;
                    do {
                        if (this.m_expBary.m_data[n9] > 1.0E-10 || this.m_expBary.m_data[n9] < d5) {
                            n6 = n9;
                            continue;
                        }
                        ++n8;
                        n7 = n9;
                    } while (++n9 < 3);
                }
            }
            if (n8 == 1 && this.m_expDir.m_data[n7] < 0.0) {
                double d6;
                int n11 = piVectorArray2[n4].m_data[n7];
                if (n11 < 0) {
                    bl = true;
                    continue;
                }
                int n12 = this.m_geom.getOppVertexLocInd(n4, n7);
                int n13 = (n7 + 1) % 3;
                int n14 = (n7 + 2) % 3;
                int n15 = (n12 + 1) % 3;
                int n16 = (n12 + 2) % 3;
                this.m_expEdge.m_data[n14] = 1.0;
                this.m_expEdge.m_data[n13] = -1.0;
                this.m_expEdge.m_data[n7] = 0.0;
                double d7 = PwBary.norm(this.m_geom, n4, this.m_expEdge, false);
                if (d7 < 1.0E-10) {
                    PsDebug.warning((String)"Edges degenerated in element set.");
                    bl = true;
                    continue;
                }
                double d8 = PwBary.scalar(this.m_geom, n4, this.m_expEdge, this.m_expDir, false) / d7;
                double d9 = 1.0 - d8 * d8;
                if (d9 < 1.0E-10) {
                    d9 = 0.0;
                }
                double d10 = Math.sqrt(d9);
                n4 = n11;
                this.m_expEdge.m_data[n16] = -1.0;
                this.m_expEdge.m_data[n15] = 1.0;
                this.m_expEdge.m_data[n12] = 0.0;
                d7 = PwBary.norm(this.m_geom, n4, this.m_expEdge, false);
                if (d7 < 1.0E-10) {
                    PsDebug.warning((String)"Edges degenerated in element set.");
                    bl = true;
                    continue;
                }
                this.m_expEdge.multScalar(1.0 / d7);
                this.m_expHalf.m_data[n16] = -0.5;
                this.m_expHalf.m_data[n15] = -0.5;
                this.m_expHalf.m_data[n12] = 1.0;
                this.m_expNormal.copy(this.m_expEdge);
                this.m_expNormal.multScalar(-1.0 * PwBary.scalar(this.m_geom, n4, this.m_expHalf, this.m_expEdge, false));
                this.m_expNormal.m_data[0] = this.m_expNormal.m_data[0] + this.m_expHalf.m_data[0];
                this.m_expNormal.m_data[1] = this.m_expNormal.m_data[1] + this.m_expHalf.m_data[1];
                this.m_expNormal.m_data[2] = this.m_expNormal.m_data[2] + this.m_expHalf.m_data[2];
                double d11 = PwBary.norm(this.m_geom, n4, this.m_expNormal, false);
                if (d11 < 1.0E-10) {
                    PsDebug.warning((String)"Edges degenerated in element set.");
                    bl = true;
                    continue;
                }
                n9 = 0;
                do {
                    this.m_expDir.m_data[n9] = this.m_expNormal.m_data[n9] / d11 * d10 + this.m_expEdge.m_data[n9] * d8;
                } while (++n9 < 3);
                double d12 = this.m_expBary.m_data[n14];
                this.m_expBary.m_data[n16] = d6 = this.m_expBary.m_data[n13];
                this.m_expBary.m_data[n15] = d12;
                this.m_expBary.m_data[n12] = 0.0;
                this.m_expBary.validate();
                this.m_pos[n5].copy(this.m_expBary);
                this.m_elem.m_data[n5] = n4;
            }
            double d13 = -1.0;
            n9 = 0;
            while (n9 < this.m_expBary.m_data.length) {
                double d14;
                if ((this.m_expDir.m_data[n9] > 1.0E-10 || this.m_expDir.m_data[n9] < d5) && (d14 = -this.m_expBary.m_data[n9] / this.m_expDir.m_data[n9]) > 1.0E-10 && (d13 <= 0.0 || d14 < d13)) {
                    d13 = d14;
                }
                ++n9;
            }
            if (d13 < 1.0E-10) {
                bl = true;
                PsDebug.warning((String)("Cannot calc. l = " + d13 + "."));
                PsDebug.warning((String)("m_expDir: " + this.m_expDir.toString()));
                PsDebug.warning((String)("m_expBary: " + this.m_expBary.toString()));
                continue;
            }
            if (d4 - d2 < d13) {
                d13 = d4 - d2;
            }
            d2 += d13;
            n9 = 0;
            while (n9 < this.m_expBary.m_data.length) {
                int n17 = n9;
                this.m_expBary.m_data[n17] = this.m_expBary.m_data[n17] + d13 * this.m_expDir.m_data[n9];
                ++n9;
            }
            if (++n5 >= n3) {
                n3 += n2;
                if (pgPolygon != null) {
                    pgPolygon.setNumVertices(n3);
                }
                this.setNumVertices(n3);
            }
            if (pgPolygon != null) {
                PdBary.getVertex((PdVector)this.m_expPoint, (PdBary)this.m_expBary, (PdVector)pdVectorArray[piVectorArray[n4].m_data[0]], (PdVector)pdVectorArray[piVectorArray[n4].m_data[1]], (PdVector)pdVectorArray[piVectorArray[n4].m_data[2]]);
                pgPolygon.setVertex(n5, this.m_expPoint);
            }
            this.m_pos[n5].copy(this.m_expBary);
            this.m_elem.m_data[n5] = n4;
        }
        if (pgPolygon != null) {
            pgPolygon.setNumVertices(n5 + 1);
        }
        this.setNumVertices(n5 + 1);
        return this.m_expDir;
    }

    public void setAccuracy(double d) {
        this.m_eps = Math.abs(d);
    }

    protected void setMaxNumVertices(int n) {
        this.m_maxNum = n;
        this.m_elem.setSize(n);
        PdBary[] pdBaryArray = this.m_pos;
        this.m_pos = new PdBary[n];
        int n2 = 0;
        if (pdBaryArray != null) {
            n2 = 0;
            while (n2 < pdBaryArray.length && n2 < n) {
                this.m_pos[n2] = pdBaryArray[n2] == null ? new PdBary(3) : pdBaryArray[n2];
                ++n2;
            }
        }
        while (n2 < n) {
            this.m_pos[n2] = new PdBary(3);
            ++n2;
        }
    }

    public void setGeometry(PgElementSet pgElementSet) {
        this.m_geom = pgElementSet;
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public PgPolygon getPolygon() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing element set.");
            return null;
        }
        PgPolygon pgPolygon = new PgPolygon(this.m_geom.getDimOfVertices());
        this.getPolygon(pgPolygon);
        return pgPolygon;
    }

    public boolean getPolygon(PgPolygon pgPolygon) {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing element set.");
            return false;
        }
        if (pgPolygon == null) {
            PsDebug.warning((String)"Missing polygon.");
            return false;
        }
        PdVector pdVector = new PdVector(this.m_geom.getDimOfVertices());
        int n = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        pgPolygon.setNumVertices(this.m_size);
        int n2 = 0;
        while (n2 < this.m_size) {
            if (n <= this.m_elem.m_data[n2]) {
                PsDebug.warning((String)("Element index out of bounds: " + n2 + "."));
                pgPolygon.setNumVertices(n2);
                return false;
            }
            PdBary.getVertex((PdVector)pdVector, (PdBary)this.m_pos[n2], (PdVector)this.m_geom.getVertex(piVectorArray[this.m_elem.m_data[n2]].m_data[0]), (PdVector)this.m_geom.getVertex(piVectorArray[this.m_elem.m_data[n2]].m_data[1]), (PdVector)this.m_geom.getVertex(piVectorArray[this.m_elem.m_data[n2]].m_data[2]));
            pgPolygon.setVertex(n2, pdVector);
            ++n2;
        }
        return true;
    }

    public PdBary[] getBary() {
        return this.m_pos;
    }

    public PdBary getBary(int n) {
        if (n >= this.m_size || n < 0) {
            PsDebug.warning((String)("Array index out of bounds: " + n + "."));
            return null;
        }
        return this.m_pos[n];
    }

    public double eval(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PiVector piVector, double d) {
        int n;
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing geometry (forgot call of 'setGeometry(..)'?).");
            return 0.0;
        }
        if (this.m_size < 1) {
            pdVector.setSize(0);
            pdVector2.setSize(0);
            pdVector3.setSize(0);
            piVector.setSize(0);
            return 0.0;
        }
        int n2 = pdVector.getSize();
        int n3 = 100;
        this.bary[0] = pdVector;
        this.bary[1] = pdVector2;
        this.bary[2] = pdVector3;
        int n4 = 0;
        do {
            this.bary[n4].setSize(n2);
        } while (++n4 < 3);
        piVector.setSize(n2);
        n4 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n5 = 0;
        if (this.v == null) {
            this.v = new PdBary[2];
            this.v[0] = new PdBary(3);
            this.v[1] = new PdBary(3);
        }
        if (this.star == null) {
            this.star = new PgVertexStar[2];
            this.star[0] = new PgVertexStar();
            this.star[1] = new PgVertexStar();
        }
        if (this.altelem == null) {
            this.altelem = new PiVector[2];
            this.altelem[0] = new PiVector();
            this.altelem[1] = new PiVector();
        }
        boolean bl = false;
        int n6 = 0;
        do {
            this.bary[n6].m_data[0] = this.m_pos[0].m_data[n6];
        } while (++n6 < 3);
        piVector.m_data[0] = this.m_elem.m_data[0];
        n6 = 1;
        while (!bl) {
            int n7;
            d5 = d4;
            d4 += d;
            while (d2 + d3 <= d4) {
                if (n4 + 1 >= this.m_size) break;
                d2 += d3;
                if (this.m_elem.m_data[n4] != this.m_elem.m_data[n4 + 1]) {
                    int n8 = 0;
                    do {
                        this.notzero[n8] = -1;
                        this.zero[n8] = -1;
                        this.numzero[n8] = 0;
                        n7 = 0;
                        do {
                            if (Math.abs(this.m_pos[n4 + n8].m_data[n7]) > 1.0E-10) {
                                this.notzero[n8] = n7;
                                continue;
                            }
                            int n9 = n8;
                            this.numzero[n9] = this.numzero[n9] + 1;
                            this.zero[n8] = n7;
                        } while (++n7 < 3);
                    } while (++n8 < 2);
                    if (this.numzero[0] < 1 && this.numzero[1] < 1) {
                        PsDebug.warning((String)"Cannot do it in barycoords.");
                        return 0.0;
                    }
                    this.starused[0] = false;
                    this.starused[1] = false;
                    n7 = 0;
                    do {
                        if (this.numzero[n7] == 2) {
                            this.starused[n7] = true;
                            this.star[n7].makeVertexStar(this.m_geom, this.m_geom.getElement((int)this.m_elem.m_data[n4 + n7]).m_data[this.notzero[n7]], this.m_elem.m_data[n4 + n7]);
                            this.altelem[n7] = this.star[n7].getElement();
                            continue;
                        }
                        if (this.numzero[n7] == 1) {
                            this.altelem[n7].setSize(2);
                            this.altelem[n7].m_data[0] = this.m_elem.m_data[n4 + n7];
                            this.altelem[n7].m_data[1] = this.m_geom.getNeighbour((int)this.m_elem.m_data[n4 + n7]).m_data[this.zero[n7]];
                            continue;
                        }
                        this.altelem[n7].setSize(1);
                        this.altelem[n7].m_data[0] = this.m_elem.m_data[n4 + n7];
                    } while (++n7 < 2);
                    int n10 = -1;
                    int n11 = this.altelem[0].getSize();
                    int n12 = this.altelem[1].getSize();
                    this.n[0] = 0;
                    while (this.n[0] < n11) {
                        this.n[1] = 0;
                        while (this.n[1] < n12) {
                            if (this.altelem[0].m_data[this.n[0]] == this.altelem[1].m_data[this.n[1]]) {
                                n10 = this.altelem[0].m_data[this.n[0]];
                                break;
                            }
                            this.n[1] = this.n[1] + 1;
                        }
                        if (n10 != -1) break;
                        this.n[0] = this.n[0] + 1;
                    }
                    if (n10 == -1) {
                        PsDebug.warning((String)"Cannot do it in barycoords.");
                        return 0.0;
                    }
                    n7 = 0;
                    do {
                        int n13;
                        if (this.starused[n7]) {
                            n13 = this.star[n7].getVertexLocInd().m_data[this.n[n7]];
                            this.v[n7].m_data[n13] = 1.0;
                            this.v[n7].m_data[(n13 + 1) % 3] = 0.0;
                            this.v[n7].m_data[(n13 + 2) % 3] = 0.0;
                            continue;
                        }
                        if (this.numzero[n7] == 1 && this.m_elem.m_data[n4 + n7] != n10) {
                            double d6;
                            n13 = this.m_geom.getOppVertexLocInd(this.m_elem.m_data[n4 + n7], this.zero[n7]);
                            this.v[n7].m_data[n13] = 0.0;
                            int n14 = (n13 + 1) % 3;
                            int n15 = (n13 + 2) % 3;
                            n11 = (this.zero[n7] + 1) % 3;
                            n12 = (this.zero[n7] + 2) % 3;
                            this.v[n7].m_data[n14] = d6 = this.m_pos[n4 + n7].m_data[n12];
                            this.v[n7].m_data[n15] = d6 = this.m_pos[n4 + n7].m_data[n11];
                            continue;
                        }
                        this.v[n7].copy(this.m_pos[n4 + n7]);
                    } while (++n7 < 2);
                    n5 = n10;
                } else {
                    this.v[0].copy(this.m_pos[n4]);
                    this.v[1].copy(this.m_pos[n4 + 1]);
                    n5 = this.m_elem.m_data[n4];
                }
                n7 = 0;
                do {
                    this.diff.m_data[n7] = this.v[1].m_data[n7] - this.v[0].m_data[n7];
                } while (++n7 < 3);
                d3 = PwBary.norm(this.m_geom, n5, this.diff, n6 == 0);
                ++n4;
            }
            if (d2 + d3 <= d4) {
                d3 = 0.0;
                d4 = d2 += d3;
                n = 0;
                do {
                    this.bary[n].m_data[n6] = this.v[1].m_data[n];
                } while (++n < 3);
                piVector.m_data[n6] = n5;
                bl = true;
            } else {
                double d7 = (d4 - d2) / d3;
                n7 = 0;
                do {
                    this.bary[n7].m_data[n6] = d7 * this.diff.m_data[n7] + this.v[0].m_data[n7];
                } while (++n7 < 3);
                piVector.m_data[n6] = n5;
            }
            if (++n6 < n2) continue;
            n2 += n3;
            n = 0;
            do {
                this.bary[n].setSize(n2);
            } while (++n < 3);
            piVector.setSize(n2);
        }
        n = 0;
        do {
            this.bary[n].setSize(n6);
        } while (++n < 3);
        piVector.setSize(n6);
        return d2 - d5;
    }

    public double getLength() {
        return this.getPolygon().getLength();
    }
}

