/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgOffLoader
implements PgLoaderIf {
    protected PvDisplayOption m_displayOption;
    private static final String StrNL = "\n";

    protected PgJvxSrc parse(BufferedReader bufferedReader) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.ordinaryChars(47, 47);
        streamTokenizer.whitespaceChars(59, 59);
        streamTokenizer.commentChar(35);
        PgJvxSrc pgJvxSrc = this.parseGeom(streamTokenizer);
        return pgJvxSrc;
    }

    private PgJvxSrc parseList(StreamTokenizer streamTokenizer) {
        PsDebug.warning((String)"method parseList not implemented yet, send you geometry to JavaView authors.");
        return null;
    }

    private PgJvxSrc parseInst(StreamTokenizer streamTokenizer) {
        PgJvxSrc pgJvxSrc = null;
        PdMatrix pdMatrix = null;
        try {
            do {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning((String)"identifier \"geom\" or \"transform\" expected in Inst");
                        return null;
                    }
                    case -3: 
                }
                if (streamTokenizer.sval.equals("geom")) {
                    pgJvxSrc = this.parseGeom(streamTokenizer);
                    continue;
                }
                if (streamTokenizer.sval.equals("transform")) {
                    pdMatrix = new PdMatrix(4);
                    int n = 0;
                    do {
                        int n2 = 0;
                        do {
                            pdMatrix.m_data[n2][n] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                        } while (++n2 < 4);
                    } while (++n < 4);
                    this.m_displayOption = new PvDisplayOption();
                    this.m_displayOption.setCameraMatrix(0, pdMatrix);
                    continue;
                }
                PsDebug.warning((String)"identifier \"geom\" or \"transform\" expected in Inst");
                return null;
            } while (pgJvxSrc == null || pdMatrix == null);
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
        return pgJvxSrc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PgJvxSrc parseGeom(StreamTokenizer streamTokenizer) {
        try {
            block6: while (true) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        continue block6;
                    }
                    case -1: {
                        PsDebug.warning((String)"could not find magic keyword OFF");
                        return null;
                    }
                    case -3: 
                }
                if (streamTokenizer.sval.endsWith("OFF")) {
                    return this.parseOff(streamTokenizer);
                }
                if (streamTokenizer.sval.endsWith("VECT")) {
                    return this.parseVect(streamTokenizer);
                }
                if (streamTokenizer.sval.endsWith("LIST")) {
                    return this.parseList(streamTokenizer);
                }
                if (streamTokenizer.sval.endsWith("INST")) break;
            }
            return this.parseInst(streamTokenizer);
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
    }

    private PgJvxSrc parseOff(StreamTokenizer streamTokenizer) {
        int n = 4;
        int n2 = 200;
        double[] dArray = new double[n];
        int[] nArray = new int[n2];
        try {
            int n3;
            int n4 = 3;
            PgJvxSrc pgJvxSrc = new PgJvxSrc();
            pgJvxSrc.setType(33);
            String string = streamTokenizer.sval;
            boolean bl = string.indexOf("C") != -1;
            boolean bl2 = string.indexOf("N") != -1;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning((String)("missing number of vertices=" + streamTokenizer.lineno()));
                return null;
            }
            pgJvxSrc.setDimOfVertices(n4);
            pgJvxSrc.setNumVertices((int)streamTokenizer.nval);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning((String)("missing number of elements=" + streamTokenizer.lineno()));
                return null;
            }
            pgJvxSrc.setDimOfElements(-1);
            pgJvxSrc.setNumElements((int)streamTokenizer.nval);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning((String)("missing number of edges=" + streamTokenizer.lineno()));
                return null;
            }
            int n5 = pgJvxSrc.getNumVertices();
            PdVector[] pdVectorArray = pgJvxSrc.getVertices();
            Color[] colorArray = null;
            PdVector[] pdVectorArray2 = null;
            if (bl) {
                pgJvxSrc.assureVertexColors();
                colorArray = new Color[n5];
            }
            if (bl2) {
                pgJvxSrc.assureVertexNormals();
                pdVectorArray2 = pgJvxSrc.getVertexNormals();
            }
            int n6 = 0;
            n6 = 0;
            while (n6 < n5) {
                n3 = 0;
                while (n3 < n4) {
                    dArray[n3] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                    ++n3;
                }
                pdVectorArray[n6].set(dArray, n4);
                if (bl2) {
                    n3 = 0;
                    while (n3 < n4) {
                        dArray[n3] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                        ++n3;
                    }
                    pdVectorArray2[n6].set(dArray, n4);
                }
                ++n6;
            }
            if (colorArray != null) {
                pgJvxSrc.setVertexColors(colorArray);
                pgJvxSrc.showVertexColors(true);
            }
            if (pdVectorArray2 != null) {
                pgJvxSrc.setVertexNormals(pdVectorArray2);
            }
            int n7 = pgJvxSrc.getNumElements();
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            Color[] colorArray2 = null;
            streamTokenizer.eolIsSignificant(true);
            int n8 = 0;
            while (n8 < n7) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 10) continue;
                if (streamTokenizer.ttype != -2) {
                    PsDebug.warning((String)("missing size of face[" + n8 + "] at line=" + streamTokenizer.lineno()));
                    return null;
                }
                int n9 = (int)streamTokenizer.nval;
                n3 = 0;
                while (n3 < n9) {
                    streamTokenizer.nextToken();
                    nArray[n3] = (int)streamTokenizer.nval;
                    ++n3;
                }
                piVectorArray[n8].setSize(n9);
                piVectorArray[n8].set(nArray, n9);
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 10) {
                    if (colorArray2 == null) {
                        colorArray2 = new Color[n7];
                        int n10 = 0;
                        while (n10 < n8) {
                            colorArray2[n10] = Color.white;
                            ++n10;
                        }
                    }
                    streamTokenizer.pushBack();
                    n3 = 0;
                    do {
                        dArray[n3] = PgLoader.parseDouble((StreamTokenizer)streamTokenizer);
                        if (!(dArray[n3] > 1.0)) continue;
                        int n11 = n3;
                        dArray[n11] = dArray[n11] / 255.0;
                    } while (++n3 < 3);
                    colorArray2[n8] = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
                } else if (colorArray2 != null) {
                    colorArray2[n8] = Color.white;
                }
                ++n8;
            }
            streamTokenizer.eolIsSignificant(false);
            if (colorArray2 != null) {
                pgJvxSrc.setElementColors(colorArray2);
                pgJvxSrc.showElementColors(true);
            }
            return pgJvxSrc;
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = this.parse(bufferedReader);
        if (pgJvxSrc == null) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        this.geomInitType(pgJvxSrc);
        return new PgJvxSrc[]{pgJvxSrc};
    }

    public PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open((String)string);
        if (bufferedReader == null) {
            PsDebug.warning((String)("could not open = " + string));
            return null;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        PgJvxSrc[] pgJvxSrcArray = this.read(bufferedReader);
        if (pgJvxSrcArray != null && pgJvxSrcArray.length > 0 && pgJvxSrcArray[0] != null) {
            if (pgJvxSrcArray.length == 1) {
                pgJvxSrcArray[0].setName(PsUtil.getFileBaseName((String)string));
            } else {
                int n = 0;
                while (n < pgJvxSrcArray.length) {
                    pgJvxSrcArray[n].setName(PsUtil.getFileBaseName((String)string) + "[" + n + "]");
                    ++n;
                }
            }
        }
        return pgJvxSrcArray;
    }

    public PvDisplayOption getDisplayOption() {
        return this.m_displayOption;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
        this.m_displayOption = pvDisplayOption;
    }

    public void setAnimation(boolean bl) {
    }

    private PgJvxSrc parseVect(StreamTokenizer streamTokenizer) {
        PsDebug.warning((String)"method parseVect not implemented yet, send you geometry to JavaView authors.");
        return null;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        PdVector[] pdVectorArray;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        if (pgJvxSrc.getType() != 33) {
            PsDebug.warning((String)"geometry is not an element set");
            return false;
        }
        String string = "";
        Color[] colorArray = pgJvxSrc.getVertexColors();
        if (colorArray != null) {
            string = string + "C";
        }
        if ((pdVectorArray = pgJvxSrc.getVertexNormals()) != null) {
            string = string + "N";
        }
        Color[] colorArray2 = pgJvxSrc.getElementColors();
        int n = pgJvxSrc.getNumVertices();
        int n2 = pgJvxSrc.getNumElements();
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + StrNL);
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + StrNL);
        writer.write("# by " + PsConfig.getAuthors() + StrNL);
        writer.write("#     File Format = GeomView OFF" + StrNL);
        writer.write("#     Geometry    = " + pgJvxSrc.getName() + StrNL);
        writer.write("#     Date        = " + new Date().toString() + StrNL);
        writer.write("#" + StrNL);
        writer.write("#     Number of Vertices = " + n + StrNL);
        writer.write("#     Number of Elements = " + n2 + StrNL);
        if (colorArray != null) {
            writer.write("#     Additional: Vertex Colors\n");
        }
        if (pdVectorArray != null) {
            writer.write("#     Additional: Vertex Normals\n");
        }
        if (colorArray2 != null) {
            writer.write("#     Additional: Element Colors\n");
        }
        writer.write("#\n# End of Header\n");
        writer.write(string + "OFF\n");
        writer.write("\t" + String.valueOf(pgJvxSrc.getNumVertices()) + " " + String.valueOf(pgJvxSrc.getNumElements()) + " 0\n");
        writer.write(PgOffLoader.writeVertices("\t", n, pgJvxSrc.getVertices(), colorArray, pdVectorArray));
        writer.write(PgOffLoader.writeElements("\t", n2, pgJvxSrc.getElements(), colorArray2));
        return true;
    }

    public boolean isAnimation() {
        return false;
    }

    private void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    protected static String writeVertices(String string, int n, PdVector[] pdVectorArray, Color[] colorArray, PdVector[] pdVectorArray2) {
        if (n <= 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string);
            if (pdVectorArray[n2] == null) {
                PsDebug.warning((String)("missing vertex, ind = " + n2));
                return null;
            }
            int n3 = 0;
            while (n3 < pdVectorArray[n2].m_data.length) {
                if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                    stringBuffer.append((float)pdVectorArray[n2].m_data[n3]);
                } else {
                    stringBuffer.append(0.0f);
                }
                if (n3 < pdVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            if (colorArray != null) {
                stringBuffer.append("\t");
                stringBuffer.append(" " + colorArray[n2].getRed() + " " + colorArray[n2].getGreen() + " " + colorArray[n2].getBlue());
            }
            if (pdVectorArray2 != null) {
                stringBuffer.append("\t");
                n3 = 0;
                do {
                    if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                        stringBuffer.append(" " + String.valueOf((float)pdVectorArray2[n2].m_data[n3]));
                        continue;
                    }
                    stringBuffer.append(" " + String.valueOf(0.0f));
                } while (++n3 < 3);
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected static String writeElements(String string, int n, PiVector[] piVectorArray, Color[] colorArray) {
        if (n <= 0 || piVectorArray == null || n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n) {
            if (piVectorArray[n2] == null) {
                PsDebug.warning((String)("missing element, ind = " + n2));
                return null;
            }
            stringBuffer.append(string);
            stringBuffer.append(String.valueOf(piVectorArray[n2].getSize()) + " ");
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                stringBuffer.append(String.valueOf(piVectorArray[n2].m_data[n3]));
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            if (colorArray != null) {
                stringBuffer.append("\t");
                stringBuffer.append(" " + colorArray[n2].getRed() + " " + colorArray[n2].getGreen() + " " + colorArray[n2].getBlue());
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

