/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;

public final class PgWrlLoader
implements PgLoaderIf {
    private static Hashtable m_namedItems;
    private static Hashtable m_geometries;
    private static boolean m_bVRML_1_MODE;
    private static PdVector[] m_vertex;
    private static Color[] m_color;
    private static PdVector[] m_normal;
    private static PiVector[] m_element;
    private static String m_geomName;
    private static Color m_colorDiffuse;
    private static Color m_colorEmissive;
    private static final String StrSpace = " ";
    private static final String StrNL = "\n";
    private static final String Str1CBracket = "}\n";
    private static final String Str2CBracket = "}\n}\n";
    private static final String Str1Bracket = "]\n";
    private static final String StrNegOne = "-1";
    private static final String Str1Zero = "0";
    private static final String Str2Zero = "0 0";
    private static final String Str3Zero = "0 0 0";
    private static final String Str1One = "1";
    private static final String Str3One = "1 1 1";
    private static final String FALSE = "FALSE\n";
    private static final String TRUE = "TRUE\n";
    private static final String App = "appearance Appearance {\nmaterial Material {\n";
    private static final String Colors = "color Color {\ncolor [\n";
    private static final String ColorPV = "colorPerVertex ";
    private static final String Coord = "coord Coordinate {\n";
    private static final String CoordIdx = "coordIndex [\n";
    private static final String Diff = "diffuseColor ";
    private static final String Emiss = "emissiveColor ";
    private static final String Group = "Group {\nchildren [\n";
    private static final String IdxFS = "IndexedFaceSet {\n";
    private static final String IdxLS = "IndexedLineSet {\n";
    private static final String PointSet = "PointSet {\n";
    private static final String Solid = "solid ";
    private static final String Point = "point [\n";
    private static final String Shape = "Shape {\ngeometry ";
    private static final String ID = "#VRML V2.0 utf8\n";
    protected boolean m_bIsAnimation = false;

    protected static synchronized PgJvxSrc[] parse(BufferedReader bufferedReader) {
        Object object;
        try {
            object = bufferedReader.readLine();
            if (object == null || !((String)object).startsWith("#VRML")) {
                PsDebug.warning((String)"not a a VRML stream");
                return null;
            }
            if (((String)object).startsWith("#VRML V1.0")) {
                PsDebug.warning((String)"Parsing of VRML 1.0 format not fully supported.");
                m_bVRML_1_MODE = true;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)"Failed to parse header of VRML reader");
            return null;
        }
        object = new StreamTokenizer(bufferedReader);
        ((StreamTokenizer)object).eolIsSignificant(false);
        ((StreamTokenizer)object).commentChar(35);
        ((StreamTokenizer)object).ordinaryChar(34);
        ((StreamTokenizer)object).ordinaryChar(45);
        ((StreamTokenizer)object).ordinaryChar(43);
        ((StreamTokenizer)object).ordinaryChar(46);
        ((StreamTokenizer)object).ordinaryChars(48, 48);
        ((StreamTokenizer)object).ordinaryChars(49, 57);
        ((StreamTokenizer)object).wordChars(94, 94);
        ((StreamTokenizer)object).wordChars(38, 38);
        ((StreamTokenizer)object).wordChars(36, 36);
        ((StreamTokenizer)object).wordChars(40, 40);
        ((StreamTokenizer)object).wordChars(41, 41);
        ((StreamTokenizer)object).wordChars(126, 126);
        ((StreamTokenizer)object).wordChars(64, 64);
        ((StreamTokenizer)object).wordChars(45, 45);
        ((StreamTokenizer)object).wordChars(43, 43);
        ((StreamTokenizer)object).wordChars(42, 42);
        ((StreamTokenizer)object).wordChars(48, 48);
        ((StreamTokenizer)object).wordChars(49, 57);
        ((StreamTokenizer)object).wordChars(46, 46);
        ((StreamTokenizer)object).wordChars(44, 44);
        ((StreamTokenizer)object).wordChars(59, 59);
        ((StreamTokenizer)object).wordChars(95, 95);
        ((StreamTokenizer)object).wordChars(58, 58);
        ((StreamTokenizer)object).whitespaceChars(44, 44);
        ((StreamTokenizer)object).whitespaceChars(61, 61);
        m_namedItems = new Hashtable();
        m_geometries = new Hashtable();
        PgWrlLoader.parseVrml((StreamTokenizer)object, null);
        PgJvxSrc[] pgJvxSrcArray = null;
        if (m_geometries.size() > 0) {
            pgJvxSrcArray = new PgJvxSrc[m_geometries.size()];
            int n = 0;
            Enumeration enumeration = m_geometries.elements();
            while (enumeration.hasMoreElements()) {
                pgJvxSrcArray[n++] = (PgJvxSrc)enumeration.nextElement();
            }
        }
        m_namedItems = null;
        m_geometries = null;
        if (m_bVRML_1_MODE) {
            m_vertex = null;
            m_color = null;
            m_normal = null;
            m_element = null;
            m_bVRML_1_MODE = false;
        }
        return pgJvxSrcArray;
    }

    private static Hashtable parseColorSet(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, Color[]> hashtable = new Hashtable<String, Color[]>();
        streamTokenizer.nextToken();
        if (!"Color".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Color[] colorArray = PgWrlLoader.parseColorArray(streamTokenizer);
        if (colorArray == null) {
            return null;
        }
        if (m_bVRML_1_MODE) {
            m_color = colorArray;
        }
        hashtable.put("color", colorArray);
        streamTokenizer.nextToken();
        return hashtable;
    }

    private static Hashtable parseIndexedLineSet(String string, StreamTokenizer streamTokenizer) throws IOException {
        Hashtable hashtable = new Hashtable();
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        if (string != null) {
            pgJvxSrc.setName(string);
        }
        pgJvxSrc.setType(32);
        pgJvxSrc.showEdges(true);
        pgJvxSrc.showPolygons(true);
        streamTokenizer.nextToken();
        if (!"IndexedLineSet".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Color[] colorArray = null;
        PdVector[] pdVectorArray = null;
        PiVector[] piVectorArray = null;
        boolean bl = true;
        PiVector[] piVectorArray2 = null;
        while (true) {
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (m_bVRML_1_MODE) {
                    if (m_vertex != null) {
                        pgJvxSrc.setNumVertices(m_vertex.length);
                        pgJvxSrc.setVertices(m_vertex);
                    }
                    if (piVectorArray2 != null) {
                        pgJvxSrc.setNumPolygons(piVectorArray2.length);
                        pgJvxSrc.setPolygons(piVectorArray2);
                    } else {
                        PsDebug.warning((String)"missing polygon array in IndexedFaceSet");
                    }
                    if (m_color != null) {
                        if (m_color.length == pgJvxSrc.getNumVertices()) {
                            pgJvxSrc.setVertexColors(m_color);
                            pgJvxSrc.showVertexColors(true);
                        } else if (m_color.length == pgJvxSrc.getNumPolygons()) {
                            pgJvxSrc.setPolygonColors(m_color);
                            pgJvxSrc.showPolygonColors(true);
                        } else {
                            PsDebug.warning((String)"length of color and vertex/polygon arrays differ");
                        }
                    } else if (m_colorDiffuse != null) {
                        pgJvxSrc.setGlobalPolygonColor(m_colorDiffuse);
                    }
                } else {
                    if (pdVectorArray != null) {
                        pgJvxSrc.setNumVertices(pdVectorArray.length);
                        pgJvxSrc.setVertices(pdVectorArray);
                    } else {
                        PsDebug.warning((String)"missing vertex array");
                    }
                    if (piVectorArray2 != null) {
                        pgJvxSrc.setNumPolygons(piVectorArray2.length);
                        pgJvxSrc.setPolygons(piVectorArray2);
                    } else {
                        PsDebug.warning((String)"missing polygon array");
                    }
                    if (colorArray != null) {
                        int n = pgJvxSrc.getNumPolygons();
                        if (!bl) {
                            if (piVectorArray != null) {
                                if (piVectorArray[0].getSize() >= n) {
                                    Color[] colorArray2 = new Color[n];
                                    int n2 = 0;
                                    while (n2 < n) {
                                        colorArray2[n2] = colorArray[piVectorArray[0].m_data[n2]];
                                        ++n2;
                                    }
                                    pgJvxSrc.setPolygonColors(colorArray2);
                                    pgJvxSrc.showPolygonColors(true);
                                } else {
                                    PsDebug.warning((String)"colorIndex array smaller than polygon array");
                                }
                            } else {
                                pgJvxSrc.setPolygonColors(colorArray);
                                pgJvxSrc.showPolygonColors(true);
                            }
                        } else if (piVectorArray != null) {
                            if (piVectorArray.length >= n) {
                                Color[] colorArray3 = new Color[n];
                                int n3 = 0;
                                while (n3 < n) {
                                    float f = 0.0f;
                                    float f2 = 0.0f;
                                    float f3 = 0.0f;
                                    int n4 = piVectorArray[n3].getSize();
                                    int n5 = 0;
                                    while (n5 < n4) {
                                        f += (float)colorArray[piVectorArray[n3].m_data[n5]].getRed();
                                        f2 += (float)colorArray[piVectorArray[n3].m_data[n5]].getGreen();
                                        f3 += (float)colorArray[piVectorArray[n3].m_data[n5]].getBlue();
                                        ++n5;
                                    }
                                    colorArray3[n3] = new Color(f /= (float)(n4 * 255), f2 /= (float)(n4 * 255), f3 /= (float)(n4 * 255));
                                    ++n3;
                                }
                                pgJvxSrc.setPolygonColors(colorArray3);
                                pgJvxSrc.showPolygonColors(true);
                            } else {
                                PsDebug.warning((String)"colorIndex array smaller than element array");
                            }
                        } else {
                            pgJvxSrc.setPolygonColors(colorArray);
                            pgJvxSrc.showPolygonColors(true);
                        }
                    } else if (m_colorDiffuse != null) {
                        pgJvxSrc.setGlobalPolygonColor(m_colorDiffuse);
                    }
                }
                m_geometries.put(pgJvxSrc.getName(), pgJvxSrc);
                return hashtable;
            }
            if (string2.equals("coord")) {
                Hashtable hashtable2 = PgWrlLoader.parseSFNode(streamTokenizer);
                if (hashtable2 == null) {
                    return null;
                }
                pdVectorArray = (PdVector[])hashtable2.get("point");
                continue;
            }
            if (string2.equals("coordIndex")) {
                piVectorArray2 = PgWrlLoader.parseElementArray(streamTokenizer);
                continue;
            }
            if (string2.equals("color")) {
                Hashtable hashtable3 = PgWrlLoader.parseSFNode(streamTokenizer);
                if (hashtable3 == null) {
                    return null;
                }
                colorArray = (Color[])hashtable3.get("color");
                continue;
            }
            if (string2.equals("colorPerVertex")) {
                String string3 = PgWrlLoader.parseWord(streamTokenizer);
                if (string3 == null) continue;
                bl = string3.equalsIgnoreCase("true");
                continue;
            }
            if (string2.equals("colorIndex")) {
                if (!bl) {
                    piVectorArray = PiVector.realloc(null, (int)1);
                    int n = 1000;
                    if (pdVectorArray != null) {
                        n = pdVectorArray.length;
                    }
                    piVectorArray[0] = PgWrlLoader.parsePiVector(streamTokenizer, n);
                    continue;
                }
                piVectorArray = PgWrlLoader.parseElementArray(streamTokenizer);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing buffered reader");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = PgWrlLoader.parse(bufferedReader);
        if (pgJvxSrcArray == null) {
            PsDebug.warning((String)"error when parsing reader");
            return null;
        }
        return pgJvxSrcArray;
    }

    private static Hashtable parseMFNode(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        int n = 0;
        Object var3_3 = null;
        block5: while (true) {
            switch (streamTokenizer.nextToken()) {
                default: {
                    throw new IOException(streamTokenizer.toString());
                }
                case 93: {
                    if (--n != 0) continue block5;
                    return hashtable;
                }
                case 91: {
                    ++n;
                    continue block5;
                }
                case -3: 
            }
            streamTokenizer.pushBack();
            Hashtable hashtable2 = PgWrlLoader.parseSFNode(streamTokenizer);
            if (hashtable2 != null) {
                String string = (String)hashtable2.get("vrmlType");
                hashtable.put(string, hashtable2);
            }
            if (var3_3 == null && n == 0) break;
        }
        return hashtable;
    }

    protected static void createIdxCoord(StringBuffer stringBuffer, int n, PdVector[] pdVectorArray, PiVector[] piVectorArray) {
        PgWrlLoader.createCoord(stringBuffer, n, pdVectorArray);
        stringBuffer.append(CoordIdx);
        int n2 = 0;
        while (n2 < piVectorArray.length) {
            int[] nArray = piVectorArray[n2].m_data;
            int n3 = 0;
            while (n3 < nArray.length) {
                stringBuffer.append(nArray[n3]);
                stringBuffer.append(n3 < nArray.length - 1 && n3 % 11 == 10 ? StrNL : StrSpace);
                ++n3;
            }
            stringBuffer.append(StrNegOne);
            if (n2 < piVectorArray.length - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        stringBuffer.append(Str1Bracket);
    }

    protected static void drawVertices(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        boolean bl = pgJvxSrc.getVertexColors() == null;
        stringBuffer.append(Shape);
        stringBuffer.append(PointSet);
        PgWrlLoader.createCoord(stringBuffer, pgJvxSrc.getDimOfVertices(), pgJvxSrc.getVertices());
        if (!bl) {
            PgWrlLoader.createColors(stringBuffer, pgJvxSrc.getNumVertices(), pgJvxSrc.getVertexColors());
        }
        stringBuffer.append(Str1CBracket);
        PgWrlLoader.createDiffuseColor(stringBuffer, pgJvxSrc.getGlobalVertexColor());
        stringBuffer.append(Str1CBracket);
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        writer.write(ID);
        writer.write("# File written with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + StrNL);
        writer.write("#     File Format = WRL\n");
        writer.write("#     Date        = " + new Date().toString() + "\n#\n");
        int n = 0;
        while (n < pgJvxSrcArray.length) {
            if (pgJvxSrcArray[n] != null) {
                writer.write("#     Geometry    = " + pgJvxSrcArray[n].getName() + StrNL);
                writer.write("#     Number of Vertices = " + pgJvxSrcArray[n].getNumVertices() + StrNL);
                if (pgJvxSrcArray[n].getType() == 32) {
                    writer.write("#     Number of Polygons = " + pgJvxSrcArray[n].getNumPolygons() + StrNL);
                }
                if (pgJvxSrcArray[n].getType() == 33) {
                    writer.write("#     Number of Elements = " + pgJvxSrcArray[n].getNumElements() + StrNL);
                }
            }
            ++n;
        }
        writer.write("#\n# End of Header\n");
        writer.write(Group);
        n = 0;
        while (n < pgJvxSrcArray.length) {
            String string = PgWrlLoader.createVRMLdesc(pgJvxSrcArray[n]);
            if (string != null) {
                writer.write(string);
            }
            ++n;
        }
        writer.write(Str1Bracket);
        writer.write(Str1CBracket);
        return true;
    }

    private static Hashtable parseTextureCoordinate(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, PdVector[]> hashtable = new Hashtable<String, PdVector[]>();
        streamTokenizer.nextToken();
        if (!"TextureCoordinate".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        PdVector[] pdVectorArray = PgWrlLoader.parseVertexArray(streamTokenizer, 2);
        if (pdVectorArray == null) {
            return null;
        }
        hashtable.put("point", pdVectorArray);
        streamTokenizer.nextToken();
        return hashtable;
    }

    private static PiVector parsePiVector(StreamTokenizer streamTokenizer, int n) throws IOException {
        PiVector piVector = new PiVector(n);
        try {
            int n2 = 0;
            while (true) {
                if (streamTokenizer.nextToken() != -3) {
                    return null;
                }
                int n3 = Integer.parseInt(streamTokenizer.sval);
                if (n3 == -1) {
                    piVector.setSize(n2);
                    return piVector;
                }
                piVector.setEntry(n2++, n3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning((String)("wrong format in integer string = " + streamTokenizer.sval));
            return null;
        }
    }

    private static Double parseDouble(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != -3) {
            return null;
        }
        return new Double(PgLoader.parseDouble((String)streamTokenizer.sval));
    }

    private static Integer parseInteger(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != -3) {
            return null;
        }
        try {
            return new Integer(Integer.parseInt(streamTokenizer.sval));
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning((String)("wrong format in integer string = " + streamTokenizer.sval));
            return null;
        }
    }

    private static Hashtable parseTransform(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        streamTokenizer.nextToken();
        if (!"Transform".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        int n = 0;
        PdVector pdVector = null;
        PdVector pdVector2 = null;
        PdVector pdVector3 = null;
        PdVector pdVector4 = null;
        PdVector pdVector5 = null;
        PdVector pdVector6 = null;
        PdVector pdVector7 = null;
        boolean bl = false;
        PdMatrix pdMatrix = null;
        PdMatrix pdMatrix2 = null;
        PdMatrix pdMatrix3 = null;
        PdMatrix pdMatrix4 = null;
        PdMatrix pdMatrix5 = null;
        PdMatrix pdMatrix6 = null;
        PdMatrix pdMatrix7 = null;
        block5: while (true) {
            PdVector pdVector8;
            String string;
            switch (streamTokenizer.nextToken()) {
                default: {
                    throw new IOException(streamTokenizer.toString());
                }
                case 125: {
                    if (--n != 0) continue block5;
                    if (bl) {
                        string = new PdMatrix(4);
                        string.setIdentity();
                        if (pdVector != null) {
                            string.leftMult(pdMatrix6);
                        }
                        if (pdVector4 != null) {
                            string.leftMult(pdMatrix7);
                        }
                        if (pdVector3 != null) {
                            string.leftMult(pdMatrix3);
                        }
                        if (pdVector4 != null) {
                            string.leftMult(pdMatrix4);
                        }
                        if (pdVector2 != null) {
                            string.leftMult(pdMatrix2);
                        }
                        if (pdVector != null) {
                            string.leftMult(pdMatrix);
                        }
                        if (pdVector5 != null) {
                            string.leftMult(pdMatrix5);
                        }
                        hashtable.put("transform", string);
                    }
                    return hashtable;
                }
                case 123: {
                    ++n;
                    continue block5;
                }
                case -3: 
            }
            string = streamTokenizer.sval;
            if (string.equals("children")) {
                hashtable.put("children", PgWrlLoader.parseMFNode(streamTokenizer));
                continue;
            }
            if (string.equals("center")) {
                pdVector = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (pdVector == null) continue;
                hashtable.put("center", pdVector);
                pdMatrix6 = PuReflect.translate((PdVector)pdVector);
                pdVector.multScalar(-1.0);
                pdMatrix = PuReflect.translate((PdVector)pdVector);
                bl = true;
                continue;
            }
            if (string.equals("rotation")) {
                pdVector2 = PgWrlLoader.parsePdVector(streamTokenizer, 4);
                if (pdVector2 == null) continue;
                hashtable.put("rotation", pdVector2);
                pdVector8 = new PdVector(3);
                pdMatrix2 = PuReflect.rotateLine((PdVector)pdVector8, (PdVector)pdVector2, (double)pdVector2.getEntry(3));
                bl = true;
                continue;
            }
            if (string.equals("scale")) {
                pdVector3 = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (pdVector3 == null) continue;
                pdMatrix3 = PuReflect.scale((PdVector)pdVector3);
                hashtable.put("scale", pdVector3);
                bl = true;
                continue;
            }
            if (string.equals("scaleOrientation")) {
                pdVector4 = PgWrlLoader.parsePdVector(streamTokenizer, 4);
                if (pdVector4 == null) continue;
                hashtable.put("scaleOrientation", pdVector4);
                pdVector8 = new PdVector(3);
                pdMatrix4 = PuReflect.rotateLine((PdVector)pdVector8, (PdVector)pdVector4, (double)pdVector4.getEntry(3));
                pdMatrix7 = PuReflect.rotateLine((PdVector)pdVector8, (PdVector)pdVector4, (double)(-pdVector4.getEntry(3)));
                bl = true;
                continue;
            }
            if (string.equals("translation")) {
                pdVector5 = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (pdVector5 == null) continue;
                hashtable.put("translation", pdVector5);
                pdMatrix5 = PuReflect.translate((PdVector)pdVector5);
                bl = true;
                continue;
            }
            if (string.equals("bboxCenter")) {
                pdVector6 = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (pdVector6 == null) continue;
                hashtable.put("bboxCenter", pdVector6);
                continue;
            }
            if (!string.equals("bboxSize") || (pdVector7 = PgWrlLoader.parsePdVector(streamTokenizer, 3)) == null) continue;
            hashtable.put("bboxSize", pdVector7);
        }
    }

    private static Color[] parseColorArray(StreamTokenizer streamTokenizer) throws IOException {
        Color[] colorArray = null;
        streamTokenizer.nextToken();
        if (!"color".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Vector<Color> vector = new Vector<Color>();
        Color color = null;
        while ((color = PgWrlLoader.parseColor(streamTokenizer)) != null) {
            vector.addElement(color);
        }
        int n = vector.size();
        if (n != 0) {
            colorArray = new Color[n];
            int n2 = 0;
            while (n2 < n) {
                colorArray[n2] = (Color)vector.elementAt(n2);
                ++n2;
            }
        }
        return colorArray;
    }

    private static Hashtable parseIndexedFaceSet(String string, StreamTokenizer streamTokenizer) throws IOException {
        Hashtable hashtable = new Hashtable();
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        if (string != null) {
            pgJvxSrc.setName(string);
        }
        pgJvxSrc.setType(33);
        streamTokenizer.nextToken();
        if (!"IndexedFaceSet".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Color[] colorArray = null;
        PdVector[] pdVectorArray = null;
        PdVector[] pdVectorArray2 = null;
        PiVector[] piVectorArray = null;
        boolean bl = true;
        PiVector[] piVectorArray2 = null;
        PiVector[] piVectorArray3 = null;
        boolean bl2 = true;
        while (true) {
            Color[] colorArray2;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (m_bVRML_1_MODE) {
                    if (m_vertex != null) {
                        pgJvxSrc.setNumVertices(m_vertex.length);
                        pgJvxSrc.setVertices(m_vertex);
                    }
                    if (piVectorArray2 != null) {
                        pgJvxSrc.setNumElements(piVectorArray2.length);
                        pgJvxSrc.setElements(piVectorArray2);
                    } else {
                        PsDebug.warning((String)"missing element array in IndexedFaceSet");
                    }
                    if (m_color != null) {
                        if (m_color.length == pgJvxSrc.getNumVertices()) {
                            pgJvxSrc.setVertexColors(m_color);
                            pgJvxSrc.showVertexColors(true);
                        } else if (m_color.length == pgJvxSrc.getNumElements()) {
                            pgJvxSrc.setElementColors(m_color);
                            pgJvxSrc.showElementColors(true);
                        } else {
                            PsDebug.warning((String)"length of color and vertex/element arrays differ");
                        }
                    } else if (m_colorDiffuse != null) {
                        pgJvxSrc.setGlobalElementColor(m_colorDiffuse);
                    }
                    if (m_normal != null) {
                        if (m_normal.length == pgJvxSrc.getNumVertices()) {
                            pgJvxSrc.setVertexNormals(m_normal);
                        } else if (m_normal.length == pgJvxSrc.getNumElements()) {
                            pgJvxSrc.setElementNormals(m_normal);
                        } else {
                            PsDebug.warning((String)"length of normal and vertex/element arrays differ");
                        }
                    }
                } else {
                    int n;
                    int n2;
                    if (pdVectorArray != null) {
                        pgJvxSrc.setNumVertices(pdVectorArray.length);
                        pgJvxSrc.setVertices(pdVectorArray);
                    } else {
                        PsDebug.warning((String)"missing vertex array");
                    }
                    if (piVectorArray2 != null) {
                        pgJvxSrc.setNumElements(piVectorArray2.length);
                        pgJvxSrc.setElements(piVectorArray2);
                    } else {
                        PsDebug.warning((String)"missing element array");
                    }
                    if (colorArray != null) {
                        n2 = pgJvxSrc.getNumElements();
                        if (!bl) {
                            if (piVectorArray != null) {
                                if (piVectorArray[0].getSize() >= n2) {
                                    colorArray2 = new Color[n2];
                                    n = 0;
                                    while (n < n2) {
                                        colorArray2[n] = colorArray[piVectorArray[0].m_data[n]];
                                        ++n;
                                    }
                                    pgJvxSrc.setElementColors(colorArray2);
                                    pgJvxSrc.showElementColors(true);
                                } else {
                                    PsDebug.warning((String)"colorIndex array smaller than element array");
                                }
                            } else {
                                pgJvxSrc.setElementColors(colorArray);
                                pgJvxSrc.showElementColors(true);
                            }
                        } else if (piVectorArray != null) {
                            if (piVectorArray.length >= n2) {
                                colorArray2 = new Color[n2];
                                n = 0;
                                while (n < n2) {
                                    float f = 0.0f;
                                    float f2 = 0.0f;
                                    float f3 = 0.0f;
                                    int n3 = piVectorArray[n].getSize();
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        f += (float)colorArray[piVectorArray[n].m_data[n4]].getRed();
                                        f2 += (float)colorArray[piVectorArray[n].m_data[n4]].getGreen();
                                        f3 += (float)colorArray[piVectorArray[n].m_data[n4]].getBlue();
                                        ++n4;
                                    }
                                    colorArray2[n] = new Color(f /= (float)(n3 * 255), f2 /= (float)(n3 * 255), f3 /= (float)(n3 * 255));
                                    ++n;
                                }
                                pgJvxSrc.setElementColors(colorArray2);
                                pgJvxSrc.showElementColors(true);
                            } else {
                                PsDebug.warning((String)"colorIndex array smaller than element array");
                            }
                        } else {
                            pgJvxSrc.setElementColors(colorArray);
                            pgJvxSrc.showElementColors(true);
                        }
                    } else if (m_colorDiffuse != null) {
                        pgJvxSrc.setGlobalElementColor(m_colorDiffuse);
                    }
                    if (pdVectorArray2 != null) {
                        n2 = pgJvxSrc.getNumElements();
                        if (!bl2) {
                            if (piVectorArray3 != null) {
                                if (piVectorArray3[0].getSize() >= n2) {
                                    colorArray2 = PdVector.realloc(null, (int)n2, (int)3);
                                    n = 0;
                                    while (n < n2) {
                                        colorArray2[n].copyArray(pdVectorArray2[piVectorArray3[0].m_data[n]]);
                                        ++n;
                                    }
                                    pgJvxSrc.setElementNormals((PdVector[])colorArray2);
                                } else {
                                    PsDebug.warning((String)"normalIndex array smaller than element array");
                                }
                            } else {
                                pgJvxSrc.setElementNormals(pdVectorArray2);
                            }
                        } else if (piVectorArray3 != null) {
                            if (piVectorArray3.length >= n2) {
                                colorArray2 = PdVector.realloc(null, (int)n2, (int)3);
                                n = 0;
                                while (n < n2) {
                                    int n5 = piVectorArray3[n].getSize();
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        colorArray2[n].add(pdVectorArray2[piVectorArray3[n].m_data[n6]]);
                                        ++n6;
                                    }
                                    colorArray2[n].normalize();
                                    ++n;
                                }
                                pgJvxSrc.setElementNormals((PdVector[])colorArray2);
                            } else {
                                PsDebug.warning((String)"normalIndex array smaller than element array");
                            }
                        } else {
                            pgJvxSrc.setElementNormals(pdVectorArray2);
                        }
                    }
                }
                m_geometries.put(pgJvxSrc.getName(), pgJvxSrc);
                return hashtable;
            }
            if (string2.equals("coord")) {
                Hashtable hashtable2 = PgWrlLoader.parseSFNode(streamTokenizer);
                if (hashtable2 == null) {
                    return null;
                }
                pdVectorArray = (PdVector[])hashtable2.get("point");
                continue;
            }
            if (string2.equals("coordIndex")) {
                piVectorArray2 = PgWrlLoader.parseElementArray(streamTokenizer);
                continue;
            }
            if (string2.equals("color")) {
                Hashtable hashtable3 = PgWrlLoader.parseSFNode(streamTokenizer);
                if (hashtable3 == null) {
                    return null;
                }
                colorArray = (Color[])hashtable3.get("color");
                continue;
            }
            if (string2.equals("colorPerVertex")) {
                String string3 = PgWrlLoader.parseWord(streamTokenizer);
                if (string3 == null) continue;
                bl = string3.equalsIgnoreCase("true");
                continue;
            }
            if (string2.equals("colorIndex")) {
                if (!bl) {
                    piVectorArray = PiVector.realloc(null, (int)1);
                    int n = 1000;
                    if (pdVectorArray != null) {
                        n = pdVectorArray.length;
                    }
                    piVectorArray[0] = PgWrlLoader.parsePiVector(streamTokenizer, n);
                    continue;
                }
                piVectorArray = PgWrlLoader.parseElementArray(streamTokenizer);
                continue;
            }
            if (string2.equals("normal")) {
                Hashtable hashtable4 = PgWrlLoader.parseSFNode(streamTokenizer);
                if (hashtable4 == null) {
                    return null;
                }
                pdVectorArray2 = (PdVector[])hashtable4.get("vector");
                continue;
            }
            if (string2.equals("normalPerVertex")) {
                String string4 = PgWrlLoader.parseWord(streamTokenizer);
                if (string4 == null) continue;
                bl2 = string4.equalsIgnoreCase("true");
                continue;
            }
            if (string2.equals("normalIndex")) {
                if (!bl2) {
                    piVectorArray3 = PiVector.realloc(null, (int)1);
                    int n = 1000;
                    if (pdVectorArray != null) {
                        n = pdVectorArray.length;
                    }
                    piVectorArray3[0] = PgWrlLoader.parsePiVector(streamTokenizer, n);
                    continue;
                }
                piVectorArray3 = PgWrlLoader.parseElementArray(streamTokenizer);
                continue;
            }
            if (string2.equals("texCoord")) {
                Hashtable hashtable5 = PgWrlLoader.parseSFNode(streamTokenizer);
                if (hashtable5 == null) {
                    return null;
                }
                colorArray2 = (PdVector[])hashtable5.get("point");
                if (colorArray2 == null) {
                    return null;
                }
                pgJvxSrc.setVertexTextures((PdVector[])colorArray2);
                continue;
            }
            if (string2.equals("texCoordIndex")) {
                PsDebug.warning((String)"texCoordIndex not implemented yet");
                streamTokenizer.pushBack();
                PgWrlLoader.parseUnknown(streamTokenizer);
                continue;
            }
            if (string2.equals("ccw")) {
                PgWrlLoader.parseWord(streamTokenizer);
                continue;
            }
            if (string2.equals("convex")) {
                PgWrlLoader.parseWord(streamTokenizer);
                continue;
            }
            if (string2.equals("creaseAngle")) {
                PgWrlLoader.parseDouble(streamTokenizer);
                continue;
            }
            if (string2.equals("solid")) {
                PgWrlLoader.parseWord(streamTokenizer);
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private static Hashtable parsePointSet(String string, StreamTokenizer streamTokenizer) throws IOException {
        Hashtable hashtable = new Hashtable();
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        if (string != null) {
            pgJvxSrc.setName(string);
        }
        pgJvxSrc.setType(30);
        pgJvxSrc.showVertices(true);
        streamTokenizer.nextToken();
        if (!"PointSet".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        Color[] colorArray = null;
        PdVector[] pdVectorArray = null;
        while (true) {
            Hashtable hashtable2;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                if (m_bVRML_1_MODE) {
                    pdVectorArray = m_vertex;
                    colorArray = m_color;
                }
                if (pdVectorArray != null) {
                    pgJvxSrc.setNumVertices(pdVectorArray.length);
                    pgJvxSrc.setVertices(pdVectorArray);
                } else {
                    PsDebug.warning((String)"missing vertex array");
                }
                if (colorArray != null) {
                    if (colorArray.length < pgJvxSrc.getNumVertices()) {
                        PsDebug.warning((String)"color array smaller than vertex array");
                    } else {
                        pgJvxSrc.setVertexColors(colorArray);
                        pgJvxSrc.showVertexColors(true);
                    }
                } else if (m_colorEmissive != null) {
                    pgJvxSrc.setGlobalPolygonColor(m_colorEmissive);
                } else if (m_colorDiffuse != null) {
                    pgJvxSrc.setGlobalPolygonColor(m_colorDiffuse);
                }
                m_geometries.put(pgJvxSrc.getName(), pgJvxSrc);
                return hashtable;
            }
            if (string2.equals("coord")) {
                hashtable2 = PgWrlLoader.parseSFNode(streamTokenizer);
                if (hashtable2 == null) {
                    return null;
                }
                pdVectorArray = (PdVector[])hashtable2.get("point");
                continue;
            }
            if (string2.equals("color")) {
                hashtable2 = PgWrlLoader.parseSFNode(streamTokenizer);
                if (hashtable2 == null) {
                    return null;
                }
                colorArray = (Color[])hashtable2.get("color");
                continue;
            }
            streamTokenizer.pushBack();
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
    }

    private static Hashtable parseMaterial(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        if (m_bVRML_1_MODE) {
            PsDebug.warning((String)"material of Vrml 1.0 is ignored");
            PgWrlLoader.parseUnknown(streamTokenizer);
            return hashtable;
        }
        streamTokenizer.nextToken();
        if (!"Material".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        String string;
        while ((string = PgWrlLoader.parseWord(streamTokenizer)) != null) {
            if (string.equals("ambientIntensity")) {
                hashtable.put("ambientIntensity", PgWrlLoader.parseDouble(streamTokenizer));
                continue;
            }
            if (string.equals("diffuseColor")) {
                m_colorDiffuse = PgWrlLoader.parseColor(streamTokenizer);
                hashtable.put("diffuseColor", m_colorDiffuse);
                continue;
            }
            if (string.equals("emissiveColor")) {
                m_colorEmissive = PgWrlLoader.parseColor(streamTokenizer);
                hashtable.put("emissiveColor", m_colorEmissive);
                continue;
            }
            if (string.equals("shininess")) {
                hashtable.put("shininess", PgWrlLoader.parseDouble(streamTokenizer));
                continue;
            }
            if (string.equals("specularColor")) {
                hashtable.put("specularColor", PgWrlLoader.parseColor(streamTokenizer));
                continue;
            }
            if (!string.equals("transparency")) continue;
            hashtable.put("transparency", PgWrlLoader.parseDouble(streamTokenizer));
        }
        return hashtable;
    }

    protected static void createColors(StringBuffer stringBuffer, int n, Color[] colorArray) {
        Color color = null;
        stringBuffer.append(Colors);
        int n2 = 0;
        while (n2 < n) {
            if (n2 < colorArray.length) {
                color = colorArray[n2];
            }
            if (color == null) {
                stringBuffer.append(Str3One);
            } else {
                stringBuffer.append((float)color.getRed() / 255.0f);
                stringBuffer.append(StrSpace);
                stringBuffer.append((float)color.getGreen() / 255.0f);
                stringBuffer.append(StrSpace);
                stringBuffer.append((float)color.getBlue() / 255.0f);
            }
            if (n2 < colorArray.length - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        stringBuffer.append(Str1Bracket);
        stringBuffer.append(Str1CBracket);
    }

    private static String parseWord(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != -3) {
            return null;
        }
        return streamTokenizer.sval;
    }

    /*
     * Unable to fully structure code
     */
    private static Hashtable parseUnknown(StreamTokenizer var0) throws IOException {
        var1_1 = 0;
        var0.nextToken();
        if (var0.sval != null) {
            PsDebug.warning((String)("parsing not implemented of identifier = " + var0.sval));
        }
        block5: while (true) {
            switch (var0.nextToken()) lbl-1000:
            // 3 sources

            {
                default: {
                    continue block5;
                }
                case 93: 
                case 125: {
                    if (--var1_1 != 0) ** GOTO lbl-1000
                    return null;
                }
                case 91: 
                case 123: {
                    ++var1_1;
                    ** GOTO lbl-1000
                }
                case -1: 
            }
            break;
        }
        if (var1_1 != 0) {
            PsDebug.warning((String)("numOpenNodes = " + var1_1 + "\n\tnum of lines  = " + var0.lineno()));
        }
        return null;
    }

    private static Hashtable parseVrml(StreamTokenizer streamTokenizer, Hashtable hashtable) {
        Hashtable<String, Hashtable> hashtable2 = new Hashtable<String, Hashtable>();
        try {
            while (true) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        throw new IOException(streamTokenizer.toString());
                    }
                    case -1: {
                        return hashtable2;
                    }
                    case -3: 
                }
                streamTokenizer.pushBack();
                Hashtable hashtable3 = PgWrlLoader.parseSFNode(streamTokenizer);
                if (hashtable3 == null) continue;
                String string = (String)hashtable3.get("vrmlType");
                if (string != null) {
                    hashtable2.put(string, hashtable3);
                    continue;
                }
                PsDebug.warning((String)"missing vrml type.");
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((Exception)iOException, (String)("Parsing broke abnormally\n\tIOException thrown e = " + iOException));
            return null;
        }
    }

    private static Hashtable parseAppearance(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        streamTokenizer.nextToken();
        if (!"Appearance".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        while (true) {
            Object var2_2 = null;
            String string = PgWrlLoader.parseWord(streamTokenizer);
            if (string == null) {
                return hashtable;
            }
            if (string.equals("material")) {
                Hashtable hashtable2 = PgWrlLoader.parseSFNode(streamTokenizer);
                if (hashtable2 == null) {
                    throw new IOException();
                }
                hashtable.put("material", hashtable2);
                var2_2 = null;
                continue;
            }
            if (string.equals("texture")) {
                PgWrlLoader.parseUnknown(streamTokenizer);
                continue;
            }
            if (!string.equals("textureTransform")) break;
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
        throw new IOException(streamTokenizer.toString());
    }

    private static PdVector[] parseVertexArray(StreamTokenizer streamTokenizer, int n) throws IOException {
        PdVector[] pdVectorArray = null;
        streamTokenizer.nextToken();
        String string = streamTokenizer.sval;
        if (string != null && (string.equals("point") || string.equals("vector"))) {
            streamTokenizer.nextToken();
            Vector<PdVector> vector = new Vector<PdVector>();
            PdVector pdVector = null;
            while ((pdVector = PgWrlLoader.parsePdVector(streamTokenizer, n)) != null) {
                vector.addElement(pdVector);
            }
            int n2 = vector.size();
            if (n2 != 0) {
                pdVectorArray = new PdVector[n2];
                int n3 = 0;
                while (n3 < n2) {
                    pdVectorArray[n3] = (PdVector)vector.elementAt(n3);
                    ++n3;
                }
            }
        } else {
            throw new IOException(streamTokenizer.toString());
        }
        return pdVectorArray;
    }

    private static PiVector[] parseElementArray(StreamTokenizer streamTokenizer) throws IOException {
        Vector<PiVector> vector = new Vector<PiVector>();
        PiVector piVector = null;
        streamTokenizer.nextToken();
        while ((piVector = PgWrlLoader.parsePiVector(streamTokenizer, 4)) != null) {
            vector.addElement(piVector);
        }
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        PiVector[] piVectorArray = new PiVector[n];
        int n2 = 0;
        while (n2 < n) {
            piVectorArray[n2] = (PiVector)vector.elementAt(n2);
            ++n2;
        }
        return piVectorArray;
    }

    private static Hashtable parseNormal(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, PdVector[]> hashtable = new Hashtable<String, PdVector[]>();
        streamTokenizer.nextToken();
        if (!"Normal".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        PdVector[] pdVectorArray = PgWrlLoader.parseVertexArray(streamTokenizer, 3);
        if (pdVectorArray == null) {
            return null;
        }
        if (m_bVRML_1_MODE) {
            m_normal = pdVectorArray;
        }
        hashtable.put("vector", pdVectorArray);
        streamTokenizer.nextToken();
        return hashtable;
    }

    private static String parseString(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != 34) {
            return null;
        }
        return streamTokenizer.sval;
    }

    private static Hashtable parseCoordinate(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, PdVector[]> hashtable = new Hashtable<String, PdVector[]>();
        streamTokenizer.nextToken();
        if (!"Coordinate".equals(streamTokenizer.sval) && !"Coordinate3".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        PdVector[] pdVectorArray = PgWrlLoader.parseVertexArray(streamTokenizer, 3);
        if (pdVectorArray == null) {
            return null;
        }
        if (m_bVRML_1_MODE) {
            m_vertex = pdVectorArray;
        }
        hashtable.put("point", pdVectorArray);
        streamTokenizer.nextToken();
        return hashtable;
    }

    private static void appendColor(StringBuffer stringBuffer, Color color) {
        if (color == null) {
            stringBuffer.append(Str3One);
        } else {
            stringBuffer.append((float)color.getRed() / 255.0f);
            stringBuffer.append(StrSpace);
            stringBuffer.append((float)color.getGreen() / 255.0f);
            stringBuffer.append(StrSpace);
            stringBuffer.append((float)color.getBlue() / 255.0f);
        }
        stringBuffer.append(StrNL);
    }

    protected static void createDiffuseColor(StringBuffer stringBuffer, Color color) {
        stringBuffer.append(App);
        stringBuffer.append(Diff);
        PgWrlLoader.appendColor(stringBuffer, color);
        stringBuffer.append(Str2CBracket);
    }

    protected static void createEmissiveColor(StringBuffer stringBuffer, Color color) {
        stringBuffer.append(App);
        stringBuffer.append(Emiss);
        PgWrlLoader.appendColor(stringBuffer, color);
        stringBuffer.append(Str2CBracket);
    }

    private static Hashtable parseShape(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        streamTokenizer.nextToken();
        if (!"Shape".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        while (true) {
            Hashtable hashtable2;
            String string;
            if ((string = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                return hashtable;
            }
            if (string.equals("appearance")) {
                hashtable2 = PgWrlLoader.parseSFNode(streamTokenizer);
                if (hashtable2 == null) {
                    throw new IOException("failed parsing appearance");
                }
                hashtable.put("appearance", hashtable2);
                continue;
            }
            if (!string.equals("geometry")) break;
            hashtable2 = PgWrlLoader.parseSFNode(streamTokenizer);
            if (hashtable2 == null) continue;
            hashtable.put("geometry", hashtable2);
        }
        throw new IOException(streamTokenizer.toString());
    }

    protected static void createCoord(StringBuffer stringBuffer, int n, PdVector[] pdVectorArray) {
        stringBuffer.append(Coord);
        stringBuffer.append(Point);
        int n2 = 0;
        while (n2 < pdVectorArray.length) {
            double[] dArray = pdVectorArray[n2].m_data;
            if (n < 1) {
                stringBuffer.append(Str3Zero);
            } else {
                stringBuffer.append((float)dArray[0]);
                stringBuffer.append(StrSpace);
                if (n < 2) {
                    stringBuffer.append(Str2Zero);
                } else {
                    stringBuffer.append((float)dArray[1]);
                    stringBuffer.append(StrSpace);
                    if (n < 3) {
                        stringBuffer.append(Str1Zero);
                    } else {
                        stringBuffer.append((float)dArray[2]);
                    }
                }
            }
            if (n2 < pdVectorArray.length - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        stringBuffer.append(Str1Bracket);
        stringBuffer.append(Str1CBracket);
    }

    protected static String createVRMLdesc(PgJvxSrc pgJvxSrc) {
        if (pgJvxSrc == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (pgJvxSrc.getNumElements() != 0) {
            PgWrlLoader.drawElements(stringBuffer, pgJvxSrc);
        } else if (pgJvxSrc.getNumPolygons() != 0) {
            PgWrlLoader.drawPolygons(stringBuffer, pgJvxSrc);
        } else {
            PgWrlLoader.drawVertices(stringBuffer, pgJvxSrc);
        }
        return stringBuffer.toString();
    }

    private static Hashtable parseSwitch(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        streamTokenizer.nextToken();
        if (!"Switch".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        while (true) {
            int n = 0;
            String string = PgWrlLoader.parseWord(streamTokenizer);
            if (string == null) {
                return hashtable;
            }
            if (string.equals("choice")) {
                hashtable.put("choice", PgWrlLoader.parseMFNode(streamTokenizer));
                continue;
            }
            if (string.equals("whichChoice")) {
                hashtable.put("whichChoice", PgWrlLoader.parseInteger(streamTokenizer));
                continue;
            }
            Hashtable hashtable2 = PgWrlLoader.parseSFNode(streamTokenizer);
            if (hashtable2 == null) continue;
            hashtable.put("choice_" + n++, hashtable2);
        }
    }

    protected static void drawElements(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        boolean bl = pgJvxSrc.getElementColors() == null;
        stringBuffer.append(Shape);
        stringBuffer.append(IdxFS);
        stringBuffer.append(Solid);
        stringBuffer.append(FALSE);
        PgWrlLoader.createIdxCoord(stringBuffer, pgJvxSrc.getDimOfVertices(), pgJvxSrc.getVertices(), pgJvxSrc.getElements());
        if (!bl) {
            stringBuffer.append(ColorPV);
            stringBuffer.append(FALSE);
            PgWrlLoader.createColors(stringBuffer, pgJvxSrc.getNumElements(), pgJvxSrc.getElementColors());
        }
        stringBuffer.append(Str1CBracket);
        PgWrlLoader.createDiffuseColor(stringBuffer, pgJvxSrc.getGlobalElementColor());
        stringBuffer.append(Str1CBracket);
    }

    private static Hashtable parseSeparator(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        streamTokenizer.nextToken();
        if (!"Separator".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        while (true) {
            streamTokenizer.nextToken();
            String string = streamTokenizer.sval;
            if (string == null) {
                return hashtable;
            }
            if (string.equals("renderCulling")) {
                PgWrlLoader.parseWord(streamTokenizer);
                continue;
            }
            streamTokenizer.pushBack();
            Hashtable hashtable2 = PgWrlLoader.parseSFNode(streamTokenizer);
            if (hashtable2 == null) continue;
            String string2 = (String)hashtable2.get("vrmlType");
            if (string2 != null) {
                hashtable.put(string2, hashtable2);
                continue;
            }
            PsDebug.warning((String)"missing vrml type");
        }
    }

    static {
        m_bVRML_1_MODE = false;
    }

    private static Hashtable parseSFNode(StreamTokenizer streamTokenizer) throws IOException {
        switch (streamTokenizer.nextToken()) {
            default: {
                throw new IOException(streamTokenizer.toString());
            }
            case -3: 
        }
        String string = streamTokenizer.sval;
        String string2 = null;
        Hashtable hashtable = null;
        if (string.equals("USE")) {
            String string3 = PgWrlLoader.parseWord(streamTokenizer);
            if (string3 != null) {
                hashtable = (Hashtable)m_namedItems.get(string3);
            }
            if (hashtable == null) {
                PsDebug.warning((String)("named node not found in hashtable, name = " + string3));
            }
            return hashtable;
        }
        if (string.equals("DEF")) {
            string2 = PgWrlLoader.parseWord(streamTokenizer);
            streamTokenizer.nextToken();
            string = streamTokenizer.sval;
        }
        streamTokenizer.pushBack();
        if (string.equals("Appearance")) {
            hashtable = PgWrlLoader.parseAppearance(streamTokenizer);
        } else if (string.equals("Material")) {
            hashtable = PgWrlLoader.parseMaterial(streamTokenizer);
        } else if (string.equals("Shape")) {
            hashtable = PgWrlLoader.parseShape(streamTokenizer);
        } else if (string.equals("Switch")) {
            hashtable = PgWrlLoader.parseSwitch(streamTokenizer);
        } else if (string.equals("Group")) {
            hashtable = PgWrlLoader.parseGroup(streamTokenizer);
        } else if (string.equals("Transform")) {
            hashtable = PgWrlLoader.parseTransform(streamTokenizer);
        } else if (string.equals("Color")) {
            hashtable = PgWrlLoader.parseColorSet(streamTokenizer);
        } else if (string.equals("Coordinate")) {
            hashtable = PgWrlLoader.parseCoordinate(streamTokenizer);
        } else if (string.equals("Coordinate3")) {
            hashtable = PgWrlLoader.parseCoordinate(streamTokenizer);
        } else if (string.equals("Normal")) {
            hashtable = PgWrlLoader.parseNormal(streamTokenizer);
        } else if (string.equals("TextureCoordinate")) {
            hashtable = PgWrlLoader.parseTextureCoordinate(streamTokenizer);
        } else if (string.equals("Separator")) {
            hashtable = PgWrlLoader.parseSeparator(streamTokenizer);
        } else if (string.equals("WorldInfo")) {
            hashtable = PgWrlLoader.parseWorldInfo(streamTokenizer);
        } else if (string.equals("IndexedFaceSet")) {
            hashtable = PgWrlLoader.parseIndexedFaceSet(string2, streamTokenizer);
        } else if (string.equals("IndexedLineSet")) {
            hashtable = PgWrlLoader.parseIndexedLineSet(string2, streamTokenizer);
        } else {
            if (string.equals("PointSet")) {
                return PgWrlLoader.parsePointSet(string2, streamTokenizer);
            }
            PgWrlLoader.parseUnknown(streamTokenizer);
        }
        if (hashtable != null) {
            hashtable.put("vrmlType", string);
            if (string2 != null) {
                m_namedItems.put(string2, hashtable);
            }
        }
        return hashtable;
    }

    protected static void drawPolygons(StringBuffer stringBuffer, PgJvxSrc pgJvxSrc) {
        boolean bl = pgJvxSrc.getPolygonColors() == null;
        stringBuffer.append(Shape);
        stringBuffer.append(IdxLS);
        PgWrlLoader.createIdxCoord(stringBuffer, pgJvxSrc.getDimOfVertices(), pgJvxSrc.getVertices(), pgJvxSrc.getPolygons());
        if (!bl) {
            stringBuffer.append(ColorPV);
            stringBuffer.append(FALSE);
            PgWrlLoader.createColors(stringBuffer, pgJvxSrc.getNumPolygons(), pgJvxSrc.getPolygonColors());
        }
        stringBuffer.append(Str1CBracket);
        PgWrlLoader.createDiffuseColor(stringBuffer, pgJvxSrc.getGlobalPolygonColor());
        stringBuffer.append(Str1CBracket);
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private static Hashtable parseGroup(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable hashtable = new Hashtable();
        streamTokenizer.nextToken();
        if (!"Group".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        if (streamTokenizer.nextToken() != 123) {
            return null;
        }
        String string;
        while ((string = PgWrlLoader.parseWord(streamTokenizer)) != null) {
            Object object;
            if (string.equals("children")) {
                hashtable.put("children", PgWrlLoader.parseMFNode(streamTokenizer));
                continue;
            }
            if (string.equals("bboxCenter")) {
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (object == null) continue;
                hashtable.put("bboxCenter", object);
                continue;
            }
            if (string.equals("bboxSize")) {
                object = PgWrlLoader.parsePdVector(streamTokenizer, 3);
                if (object == null) continue;
                hashtable.put("bboxSize", object);
                continue;
            }
            if (!string.equals("Separator")) continue;
            streamTokenizer.pushBack();
            object = PgWrlLoader.parseSeparator(streamTokenizer);
            if (object == null) continue;
            hashtable.put("Separator", object);
        }
        return hashtable;
    }

    private static Color parseColor(StreamTokenizer streamTokenizer) throws IOException {
        int n = 3;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            if (streamTokenizer.nextToken() != -3) {
                return null;
            }
            fArray[n2] = (float)PgLoader.parseDouble((String)streamTokenizer.sval);
            ++n2;
        }
        return new Color(fArray[0], fArray[1], fArray[2]);
    }

    private static PdVector parsePdVector(StreamTokenizer streamTokenizer, int n) throws IOException {
        PdVector pdVector = new PdVector(n);
        int n2 = 0;
        while (n2 < n) {
            if (streamTokenizer.nextToken() != -3) {
                return null;
            }
            pdVector.setEntry(n2, PgLoader.parseDouble((String)streamTokenizer.sval));
            ++n2;
        }
        return pdVector;
    }

    private static Hashtable parseWorldInfo(StreamTokenizer streamTokenizer) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        streamTokenizer.nextToken();
        if (!"WorldInfo".equals(streamTokenizer.sval)) {
            throw new IOException(streamTokenizer.toString());
        }
        streamTokenizer.nextToken();
        streamTokenizer.quoteChar(34);
        while (true) {
            String string;
            String string2;
            if ((string2 = PgWrlLoader.parseWord(streamTokenizer)) == null) {
                streamTokenizer.ordinaryChar(34);
                return hashtable;
            }
            if (string2.equals("info")) {
                streamTokenizer.nextToken();
                string = null;
                while (PgWrlLoader.parseString(streamTokenizer) != null) {
                    string = string == null ? streamTokenizer.sval : string + StrNL + streamTokenizer.sval;
                }
                if (string == null) continue;
                hashtable.put("info", string);
                continue;
            }
            if (!string2.equals("title") || (string = PgWrlLoader.parseString(streamTokenizer)) == null) continue;
            hashtable.put("title", string);
        }
    }
}

