/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;

public class PnJacobi {
    public static void printEigenvalues(int n, PdVector pdVector) {
        int n2 = (int)PuMath.log((double)10.0, (double)n) + 1 + 1;
        int[] nArray = new int[n];
        PuMath.heapsort((int)n, (double[])pdVector.m_data, (int[])nArray);
        StringBuffer stringBuffer = new StringBuffer("Print Eigenvalues:\n");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(" eValue[" + PuString.intToString((int)n3, (int)n2) + "] = " + String.valueOf(pdVector.getEntry(nArray[n3])) + "\n");
            ++n3;
        }
        PsDebug.message((String)stringBuffer.toString());
    }

    public static boolean test(PdMatrix pdMatrix, int n, PdVector pdVector, PdVector[] pdVectorArray) {
        int n2 = (int)PuMath.log((double)10.0, (double)n) + 1 + 1;
        boolean bl = true;
        PdVector pdVector2 = new PdVector(n);
        StringBuffer stringBuffer = new StringBuffer("Starting test of eigenvector computation:\n");
        int n3 = 0;
        while (n3 < n) {
            pdVector2.setConstant(0.0);
            pdVector2.leftMultMatrix(pdMatrix, pdVectorArray[n3]);
            pdVectorArray[n3].multScalar(pdVector.getEntry(n3));
            pdVector2.sub(pdVectorArray[n3]);
            double d = pdVector2.length();
            stringBuffer.append("\t Abs(Mat*eVec[" + PuString.intToString((int)n3, (int)n2) + "]-eValue[" + PuString.intToString((int)n3, (int)n2) + "]*eVec[" + PuString.intToString((int)n3, (int)n2) + "]) = " + d + "\n");
            if (d > 1.0E-10) {
                bl = false;
            }
            ++n3;
        }
        PsDebug.message((String)stringBuffer.toString());
        return bl;
    }

    public static void main(String[] stringArray) {
        int n = 2;
        PdMatrix pdMatrix = new PdMatrix(n);
        pdMatrix.m_data[0][0] = 2.0;
        pdMatrix.m_data[0][1] = 1.0;
        pdMatrix.m_data[1][0] = 1.0;
        pdMatrix.m_data[1][1] = 1.0;
        PdVector pdVector = new PdVector(n);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)n, (int)n);
        PnJacobi pnJacobi = new PnJacobi();
        PnJacobi.computeEigenvectors(pdMatrix, n, pdVector, pdVectorArray);
        PnJacobi.test(pdMatrix, n, pdVector, pdVectorArray);
    }

    public static int computeEigenvectors(PdMatrix pdMatrix, int n, PdVector pdVector, PdVector[] pdVectorArray) {
        int n2;
        double[] dArray = pdVector.m_data;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[][] dArray4 = new double[n][n];
        int n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < n) {
                dArray4[n3][n2] = pdMatrix.m_data[n3][n2];
                ++n2;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            pdVectorArray[n4].setConstant(0.0);
            pdVectorArray[n4].setEntry(n4, 1.0);
            dArray2[n4] = dArray4[n4][n4];
            dArray[n4] = dArray2[n4];
            dArray3[n4] = 0.0;
            ++n4;
        }
        int n5 = 0;
        n3 = 0;
        do {
            int n6;
            double d = 0.0;
            n4 = 0;
            while (n4 < n - 1) {
                n6 = n4 + 1;
                while (n6 < n) {
                    d += Math.abs(dArray4[n4][n6]);
                    ++n6;
                }
                ++n4;
            }
            if (d < 1.0E-10) {
                return n5;
            }
            double d2 = n3 < 3 ? 0.2 * d / (double)(n * n) : 0.0;
            n4 = 0;
            while (n4 < n - 1) {
                n6 = n4 + 1;
                while (n6 < n) {
                    double d3 = 100.0 * Math.abs(dArray4[n4][n6]);
                    if (n3 > 3 && (float)(Math.abs(dArray[n4]) + d3) == (float)Math.abs(dArray[n4]) && (float)(Math.abs(dArray[n6]) + d3) == (float)Math.abs(dArray[n6])) {
                        dArray4[n4][n6] = 0.0;
                    } else if (Math.abs(dArray4[n4][n6]) > d2) {
                        double d4;
                        double d5 = dArray[n6] - dArray[n4];
                        if ((float)(Math.abs(d5) + d3) == (float)Math.abs(d5)) {
                            d4 = dArray4[n4][n6] / d5;
                        } else {
                            double d6 = 0.5 * d5 / dArray4[n4][n6];
                            d4 = 1.0 / (Math.abs(d6) + Math.sqrt(1.0 + d6 * d6));
                            if (d6 < 0.0) {
                                d4 = -d4;
                            }
                        }
                        double d7 = 1.0 / Math.sqrt(1.0 + d4 * d4);
                        double d8 = d4 * d7;
                        double d9 = d8 / (1.0 + d7);
                        d5 = d4 * dArray4[n4][n6];
                        int n7 = n4;
                        dArray3[n7] = dArray3[n7] - d5;
                        int n8 = n6;
                        dArray3[n8] = dArray3[n8] + d5;
                        int n9 = n4;
                        dArray[n9] = dArray[n9] - d5;
                        int n10 = n6;
                        dArray[n10] = dArray[n10] + d5;
                        dArray4[n4][n6] = 0.0;
                        n2 = 0;
                        while (n2 < n4) {
                            d3 = dArray4[n2][n4];
                            d5 = dArray4[n2][n6];
                            dArray4[n2][n4] = d3 - d8 * (d5 + d3 * d9);
                            dArray4[n2][n6] = d5 + d8 * (d3 - d5 * d9);
                            ++n2;
                        }
                        n2 = n4 + 1;
                        while (n2 < n6) {
                            d3 = dArray4[n4][n2];
                            d5 = dArray4[n2][n6];
                            dArray4[n4][n2] = d3 - d8 * (d5 + d3 * d9);
                            dArray4[n2][n6] = d5 + d8 * (d3 - d5 * d9);
                            ++n2;
                        }
                        n2 = n6 + 1;
                        while (n2 < n) {
                            d3 = dArray4[n4][n2];
                            d5 = dArray4[n6][n2];
                            dArray4[n4][n2] = d3 - d8 * (d5 + d3 * d9);
                            dArray4[n6][n2] = d5 + d8 * (d3 - d5 * d9);
                            ++n2;
                        }
                        n2 = 0;
                        while (n2 < n) {
                            d3 = pdVectorArray[n4].m_data[n2];
                            d5 = pdVectorArray[n6].m_data[n2];
                            pdVectorArray[n4].m_data[n2] = d3 - d8 * (d5 + d3 * d9);
                            pdVectorArray[n6].m_data[n2] = d5 + d8 * (d3 - d5 * d9);
                            ++n2;
                        }
                        ++n5;
                    }
                    ++n6;
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < n) {
                int n11 = n4;
                dArray2[n11] = dArray2[n11] + dArray3[n4];
                dArray[n4] = dArray2[n4];
                dArray3[n4] = 0.0;
                ++n4;
            }
        } while (++n3 < 50);
        PsDebug.warning((String)"Too many iterations in routine jacobi");
        return n5;
    }

    public static void printEigenvectors(int n, PdVector pdVector, PdVector[] pdVectorArray) {
        int n2 = (int)PuMath.log((double)10.0, (double)n) + 1 + 1;
        int[] nArray = new int[n];
        PuMath.heapsort((int)n, (double[])pdVector.m_data, (int[])nArray);
        StringBuffer stringBuffer = new StringBuffer("Print Eigenvalues and Eigenvectors:\n");
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(" eValue[" + PuString.intToString((int)n3, (int)n2) + "] = " + String.valueOf(pdVector.getEntry(nArray[n3])));
            stringBuffer.append(" eVector[" + PuString.intToString((int)n3, (int)n2) + "] = ");
            stringBuffer.append(pdVectorArray[nArray[n3]].toShortString());
            ++n3;
        }
        PsDebug.message((String)stringBuffer.toString());
    }

    public static boolean testWayneExample(double d, double d2, double d3) {
        int n = 12;
        PdMatrix pdMatrix = new PdMatrix(n);
        double[][] dArrayArray = new double[12][];
        double[] dArray = new double[12];
        dArray[0] = d;
        dArray[3] = -d2;
        dArray[4] = -d3;
        dArray[9] = -d2;
        dArray[10] = d3;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[12];
        dArray2[1] = d;
        dArray2[4] = -d2;
        dArray2[10] = -d2;
        dArrayArray[1] = dArray2;
        double[] dArray3 = new double[12];
        dArray3[2] = d;
        dArray3[5] = -d2;
        dArray3[11] = -d2;
        dArrayArray[2] = dArray3;
        double[] dArray4 = new double[12];
        dArray4[0] = -d2;
        dArray4[3] = d;
        dArray4[6] = -d2;
        dArrayArray[3] = dArray4;
        double[] dArray5 = new double[12];
        dArray5[0] = -d3;
        dArray5[1] = -d2;
        dArray5[4] = d;
        dArray5[6] = d3;
        dArray5[7] = -d2;
        dArrayArray[4] = dArray5;
        double[] dArray6 = new double[12];
        dArray6[2] = -d2;
        dArray6[5] = d;
        dArray6[8] = -d2;
        dArrayArray[5] = dArray6;
        double[] dArray7 = new double[12];
        dArray7[3] = -d2;
        dArray7[4] = d3;
        dArray7[6] = d;
        dArray7[9] = -d2;
        dArray7[10] = -d3;
        dArrayArray[6] = dArray7;
        double[] dArray8 = new double[12];
        dArray8[4] = -d2;
        dArray8[7] = d;
        dArray8[10] = -d2;
        dArrayArray[7] = dArray8;
        double[] dArray9 = new double[12];
        dArray9[5] = -d2;
        dArray9[8] = d;
        dArray9[11] = -d2;
        dArrayArray[8] = dArray9;
        double[] dArray10 = new double[12];
        dArray10[0] = -d2;
        dArray10[6] = -d2;
        dArray10[9] = d;
        dArrayArray[9] = dArray10;
        double[] dArray11 = new double[12];
        dArray11[0] = d3;
        dArray11[1] = -d2;
        dArray11[6] = -d3;
        dArray11[7] = -d2;
        dArray11[10] = d;
        dArrayArray[10] = dArray11;
        double[] dArray12 = new double[12];
        dArray12[2] = -d2;
        dArray12[8] = -d2;
        dArray12[11] = d;
        dArrayArray[11] = dArray12;
        double[][] dArrayArray2 = dArrayArray;
        pdMatrix.m_data = dArrayArray2;
        PdMatrix pdMatrix2 = new PdMatrix(n);
        pdMatrix2.copy(pdMatrix);
        PdVector pdVector = new PdVector(n);
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)n, (int)n);
        PnJacobi pnJacobi = new PnJacobi();
        PnJacobi.computeEigenvectors(pdMatrix, n, pdVector, pdVectorArray);
        PsDebug.message((String)pdMatrix2.toString());
        PnJacobi.printEigenvalues(n, pdVector);
        PnJacobi.test(pdMatrix2, n, pdVector, pdVectorArray);
        return true;
    }
}

