/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jvx.numeric.PnFunction;

final class PnLinMin_Local {
    protected static double ITMAX = 100.0;
    protected static double ZEPS = 1.0E-10;
    protected double m_xmin;
    protected PdVector m_xt = new PdVector();
    protected PdVector m_df = new PdVector();
    protected int m_dim;
    protected static double GLIMIT = 100.0;
    protected static double TINY = 1.0E-10;
    public double m_ax;
    public double m_bx;
    public double m_cx;
    protected double m_fa;
    protected double m_fb;
    protected double m_fc;

    protected double f1dim(double d, PdVector pdVector, PdVector pdVector2, PnFunction pnFunction) {
        int n = 0;
        while (n < this.m_dim) {
            this.m_xt.m_data[n] = pdVector.m_data[n] + d * pdVector2.m_data[n];
            ++n;
        }
        return pnFunction.eval(this.m_xt);
    }

    protected double df1dim(double d, PdVector pdVector, PdVector pdVector2, PnFunction pnFunction) {
        int n = 0;
        while (n < this.m_dim) {
            this.m_xt.m_data[n] = pdVector.m_data[n] + d * pdVector2.m_data[n];
            ++n;
        }
        pnFunction.evalGradient(this.m_xt, this.m_df);
        double d2 = 0.0;
        n = 0;
        while (n < this.m_dim) {
            d2 += this.m_df.m_data[n] * pdVector2.m_data[n];
            ++n;
        }
        return d2;
    }

    public double dlinmin(double d, PdVector pdVector, PdVector pdVector2, PnFunction pnFunction) {
        this.mnbrak(0.0, 1.0, pdVector, pdVector2, pnFunction);
        double d2 = this.dbrent(this.m_ax, this.m_bx, this.m_cx, d, pdVector, pdVector2, pnFunction);
        int n = 0;
        while (n < this.m_dim) {
            int n2 = n;
            pdVector2.m_data[n2] = pdVector2.m_data[n2] * this.m_xmin;
            int n3 = n;
            pdVector.m_data[n3] = pdVector.m_data[n3] + pdVector2.m_data[n];
            ++n;
        }
        return d2;
    }

    protected double dbrent(double d, double d2, double d3, double d4, PdVector pdVector, PdVector pdVector2, PnFunction pnFunction) {
        double d5;
        double d6;
        double d7;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = d < d3 ? d : d3;
        double d11 = d > d3 ? d : d3;
        double d12 = d7 = d2;
        double d13 = d7;
        double d14 = d6 = this.f1dim(d13, pdVector, pdVector2, pnFunction);
        double d15 = d6;
        double d16 = d5 = this.df1dim(d13, pdVector, pdVector2, pnFunction);
        double d17 = d5;
        int n = 0;
        while ((double)n < ITMAX) {
            double d18;
            double d19;
            if (!pnFunction.isEvaluable()) {
                return d6;
            }
            double d20 = 0.5 * (d10 + d11);
            double d21 = d4 * Math.abs(d13) + ZEPS;
            double d22 = 2.0 * d21;
            if (Math.abs(d13 - d20) <= d22 - 0.5 * (d11 - d10)) {
                this.m_xmin = d13;
                return d6;
            }
            if (Math.abs(d9) > d21) {
                double d23;
                double d24 = d23 = 2.0 * (d11 - d10);
                if (d17 != d5) {
                    d23 = (d12 - d13) * d5 / (d5 - d17);
                }
                if (d16 != d5) {
                    d24 = (d7 - d13) * d5 / (d5 - d16);
                }
                double d25 = d13 + d23;
                double d26 = d13 + d24;
                boolean bl = (d10 - d25) * (d25 - d11) > 0.0 && d5 * d23 <= 0.0;
                boolean bl2 = (d10 - d26) * (d26 - d11) > 0.0 && d5 * d24 <= 0.0;
                double d27 = d9;
                d9 = d8;
                if (bl || bl2) {
                    d8 = bl && bl2 ? (Math.abs(d23) < Math.abs(d24) ? d23 : d24) : (bl ? d23 : d24);
                    if (Math.abs(d8) <= Math.abs(0.5 * d27)) {
                        d19 = d13 + d8;
                        if (d19 - d10 < d22 || d11 - d19 < d22) {
                            d8 = PuMath.sign((double)d21, (double)(d20 - d13));
                        }
                    } else {
                        d9 = d5 >= 0.0 ? d10 - d13 : d11 - d13;
                        d8 = 0.5 * d9;
                    }
                } else {
                    d9 = d5 >= 0.0 ? d10 - d13 : d11 - d13;
                    d8 = 0.5 * d9;
                }
            } else {
                d9 = d5 >= 0.0 ? d10 - d13 : d11 - d13;
                d8 = 0.5 * d9;
            }
            if (Math.abs(d8) >= d21) {
                d19 = d13 + d8;
                d18 = this.f1dim(d19, pdVector, pdVector2, pnFunction);
            } else {
                d19 = d13 + PuMath.sign((double)d21, (double)d8);
                d18 = this.f1dim(d19, pdVector, pdVector2, pnFunction);
                if (d18 > d6) {
                    this.m_xmin = d13;
                    return d6;
                }
            }
            double d28 = this.df1dim(d19, pdVector, pdVector2, pnFunction);
            if (d18 <= d6) {
                if (d19 >= d13) {
                    d10 = d13;
                } else {
                    d11 = d13;
                }
                d7 = d12;
                d14 = d15;
                d16 = d17;
                d12 = d13;
                d15 = d6;
                d17 = d5;
                d13 = d19;
                d6 = d18;
                d5 = d28;
            } else {
                if (d19 < d13) {
                    d10 = d19;
                } else {
                    d11 = d19;
                }
                if (d18 <= d15 || d12 == d13) {
                    d7 = d12;
                    d14 = d15;
                    d16 = d17;
                    d12 = d19;
                    d15 = d18;
                    d17 = d28;
                } else if (d18 < d14 || d7 == d13 || d7 == d12) {
                    d7 = d19;
                    d14 = d18;
                    d16 = d28;
                }
            }
            ++n;
        }
        PsDebug.warning((String)("Too many iterations=" + (n + 1) + " in routine DBRENT"));
        this.m_xmin = d13;
        return d6;
    }

    public void setDim(int n) {
        if (this.m_dim == n) {
            return;
        }
        this.m_dim = n;
        this.m_xt.setSize(this.m_dim);
        this.m_df.setSize(this.m_dim);
    }

    public void mnbrak(double d, double d2, PdVector pdVector, PdVector pdVector2, PnFunction pnFunction) {
        this.m_ax = d;
        this.m_bx = d2;
        this.m_fa = this.f1dim(this.m_ax, pdVector, pdVector2, pnFunction);
        this.m_fb = this.f1dim(this.m_bx, pdVector, pdVector2, pnFunction);
        if (this.m_fb > this.m_fa) {
            double d3 = this.m_ax;
            this.m_ax = this.m_bx;
            this.m_bx = d3;
            d3 = this.m_fb;
            this.m_fb = this.m_fa;
            this.m_fa = d3;
        }
        this.m_cx = this.m_bx + 1.61803398875 * (this.m_bx - this.m_ax);
        this.m_fc = this.f1dim(this.m_cx, pdVector, pdVector2, pnFunction);
        while (this.m_fb > this.m_fc) {
            double d4;
            double d5 = (this.m_bx - this.m_ax) * (this.m_fb - this.m_fc);
            double d6 = (this.m_bx - this.m_cx) * (this.m_fb - this.m_fa);
            double d7 = this.m_bx - ((this.m_bx - this.m_cx) * d6 - (this.m_bx - this.m_ax) * d5) / (2.0 * PuMath.sign((double)Math.max(Math.abs(d6 - d5), TINY), (double)(d6 - d5)));
            double d8 = this.m_bx + GLIMIT * (this.m_cx - this.m_bx);
            if ((this.m_bx - d7) * (d7 - this.m_cx) > 0.0) {
                d4 = this.f1dim(d7, pdVector, pdVector2, pnFunction);
                if (d4 < this.m_fc) {
                    this.m_ax = this.m_bx;
                    this.m_bx = d7;
                    this.m_fa = this.m_fb;
                    this.m_fb = d4;
                    return;
                }
                if (d4 > this.m_fb) {
                    this.m_cx = d7;
                    this.m_fc = d4;
                    return;
                }
                d7 = this.m_cx + 1.61803398875 * (this.m_cx - this.m_bx);
                d4 = this.f1dim(d7, pdVector, pdVector2, pnFunction);
            } else if ((this.m_cx - d7) * (d7 - d8) > 0.0) {
                d4 = this.f1dim(d7, pdVector, pdVector2, pnFunction);
                if (d4 < this.m_fc) {
                    this.m_bx = this.m_cx;
                    this.m_cx = d7;
                    d7 = this.m_cx + 1.61803398875 * (this.m_cx - this.m_bx);
                    this.m_fb = this.m_fc;
                    this.m_fc = d4;
                    d4 = this.f1dim(d7, pdVector, pdVector2, pnFunction);
                }
            } else if ((d7 - d8) * (d8 - this.m_cx) >= 0.0) {
                d7 = d8;
                d4 = this.f1dim(d7, pdVector, pdVector2, pnFunction);
            } else {
                d7 = this.m_cx + 1.61803398875 * (this.m_cx - this.m_bx);
                d4 = this.f1dim(d7, pdVector, pdVector2, pnFunction);
            }
            this.m_ax = this.m_bx;
            this.m_bx = this.m_cx;
            this.m_cx = d7;
            this.m_fa = this.m_fb;
            this.m_fb = this.m_fc;
            this.m_fc = d4;
        }
    }
}

