/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;

public class PnMatrix {
    public static double ludcmp(double[][] dArray, int n, int[] nArray) throws ArithmeticException {
        int n2;
        double d;
        double d2 = 1.0E-20;
        int n3 = 0;
        double[] dArray2 = new double[n];
        double d3 = 1.0;
        int n4 = 0;
        while (n4 < n) {
            d = 0.0;
            n2 = 0;
            while (n2 < n) {
                double d4;
                double d5 = Math.abs(dArray[n4][n2]);
                if (d4 > d) {
                    d = d5;
                }
                ++n2;
            }
            if (d == 0.0) {
                throw new ArithmeticException("Singular matrix in routine LUDCMP");
            }
            dArray2[n4] = 1.0 / d;
            ++n4;
        }
        n2 = 0;
        while (n2 < n) {
            double d6;
            int n5;
            double d7;
            n4 = 0;
            while (n4 < n2) {
                d7 = dArray[n4][n2];
                n5 = 0;
                while (n5 < n4) {
                    d7 -= dArray[n4][n5] * dArray[n5][n2];
                    ++n5;
                }
                dArray[n4][n2] = d7;
                ++n4;
            }
            d = 0.0;
            n4 = n2;
            while (n4 < n) {
                double d8;
                d7 = dArray[n4][n2];
                n5 = 0;
                while (n5 < n2) {
                    d7 -= dArray[n4][n5] * dArray[n5][n2];
                    ++n5;
                }
                dArray[n4][n2] = d7;
                d6 = dArray2[n4] * Math.abs(d7);
                if (d8 >= d) {
                    d = d6;
                    n3 = n4;
                }
                ++n4;
            }
            if (n2 != n3) {
                n5 = 0;
                while (n5 < n) {
                    d6 = dArray[n3][n5];
                    dArray[n3][n5] = dArray[n2][n5];
                    dArray[n2][n5] = d6;
                    ++n5;
                }
                d3 = -1.0 * d3;
                dArray2[n3] = dArray2[n2];
            }
            nArray[n2] = n3;
            if (dArray[n2][n2] == 0.0) {
                dArray[n2][n2] = d2;
            }
            if (n2 != n) {
                d6 = 1.0 / dArray[n2][n2];
                n4 = n2 + 1;
                while (n4 < n) {
                    double[] dArray3 = dArray[n4];
                    int n6 = n2;
                    dArray3[n6] = dArray3[n6] * d6;
                    ++n4;
                }
            }
            ++n2;
        }
        return d3;
    }

    public static void lubksb(double[][] dArray, int n, int[] nArray, double[] dArray2) {
        int n2;
        double d;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            int n5 = nArray[n4];
            d = dArray2[n5];
            dArray2[n5] = dArray2[n4];
            if (n3 != -1) {
                n2 = n3;
                while (n2 <= n4 - 1) {
                    d -= dArray[n4][n2] * dArray2[n2];
                    ++n2;
                }
            } else if (d != 0.0) {
                n3 = n4;
            }
            dArray2[n4] = d;
            ++n4;
        }
        n4 = n - 1;
        while (n4 >= 0) {
            d = dArray2[n4];
            n2 = n4 + 1;
            while (n2 < n) {
                d -= dArray[n4][n2] * dArray2[n2];
                ++n2;
            }
            dArray2[n4] = d / dArray[n4][n4];
            --n4;
        }
    }

    public static void main(String[] stringArray) {
        int n = 2;
        PdMatrix pdMatrix = new PdMatrix(n);
        pdMatrix.m_data[0][0] = 2.0;
        pdMatrix.m_data[0][1] = 1.0;
        pdMatrix.m_data[1][0] = 0.0;
        pdMatrix.m_data[1][1] = 1.0;
        PsDebug.message((String)pdMatrix.toString());
        PdMatrix pdMatrix2 = new PdMatrix(n);
        pdMatrix2.copy(pdMatrix);
        PdMatrix pdMatrix3 = new PdMatrix(n);
        PnMatrix.invert(pdMatrix3.m_data, pdMatrix.m_data, n);
        PsDebug.message((String)pdMatrix3.toString());
        PdMatrix pdMatrix4 = new PdMatrix(n);
        pdMatrix4.mult(pdMatrix2, pdMatrix3);
        PsDebug.message((String)pdMatrix4.toString());
        n = 12;
        pdMatrix = new PdMatrix(n);
        int n2 = 0;
        while (n2 < n) {
            pdMatrix.m_data[n2][n2] = 2.0;
            ++n2;
        }
        n2 = 1;
        while (n2 < n) {
            pdMatrix.m_data[n2 - 1][n2] = 1.0;
            ++n2;
        }
        n2 = 1;
        while (n2 < n) {
            pdMatrix.m_data[n2][n2 - 1] = 1.0;
            ++n2;
        }
        PsDebug.message((String)pdMatrix.toString());
        double d = PnMatrix.determinant(pdMatrix.m_data, n);
        PsDebug.message((String)("determinant = " + d));
        pdMatrix2 = new PdMatrix(n);
        pdMatrix2.copy(pdMatrix);
        pdMatrix3 = new PdMatrix(n);
        PnMatrix.invert(pdMatrix3.m_data, pdMatrix.m_data, n);
        PsDebug.message((String)pdMatrix3.toString());
        pdMatrix4 = new PdMatrix(n);
        pdMatrix4.mult(pdMatrix2, pdMatrix3);
        PsDebug.message((String)pdMatrix4.toString());
    }

    public static double determinant(double[][] dArray, int n) {
        double[][] dArray2 = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                dArray2[n2][n3] = dArray[n2][n3];
                ++n3;
            }
            ++n2;
        }
        int[] nArray = new int[n];
        double d = 0.0;
        try {
            d = PnMatrix.ludcmp(dArray2, n, nArray);
        }
        catch (ArithmeticException arithmeticException) {
            PsDebug.warning((String)"matrix singular.");
            return 0.0;
        }
        n2 = 0;
        while (n2 < n) {
            d *= dArray2[n2][n2];
            ++n2;
        }
        return d;
    }

    public static boolean invert(double[][] dArray, double[][] dArray2, int n) {
        int n2;
        double[][] dArray3 = new double[n][n];
        int n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < n) {
                dArray3[n3][n2] = dArray2[n3][n2];
                ++n2;
            }
            ++n3;
        }
        int[] nArray = new int[n];
        try {
            PnMatrix.ludcmp(dArray3, n, nArray);
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
        double[] dArray4 = new double[n];
        n3 = 0;
        while (n3 < n) {
            n2 = 0;
            while (n2 < n) {
                dArray4[n2] = 0.0;
                ++n2;
            }
            dArray4[n3] = 1.0;
            PnMatrix.lubksb(dArray3, n, nArray, dArray4);
            n2 = 0;
            while (n2 < n) {
                dArray[n2][n3] = dArray4[n2];
                ++n2;
            }
            ++n3;
        }
        return true;
    }
}

