/*
 * Decompiled with CFR 0.152.
 */
package dev.app.frame;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import jv.object.PsDebug;

public class PsImageLabel
extends Panel {
    protected Image m_image;
    protected String m_imageString;
    protected String m_alternateText;
    protected int m_margin = 0;
    protected int m_width;
    protected int m_height;
    protected boolean m_explicitSize = false;
    protected int m_explicitWidth = 0;
    protected int m_explicitHeight = 0;
    protected Color m_marginColor = null;
    protected MediaTracker m_tracker;
    protected static int lastTrackerID = 0;
    protected int currentTrackerID;
    protected boolean m_bDoneLoading = false;
    protected Container parentContainer;

    public PsImageLabel(String string) {
        this.m_imageString = string;
        this.m_alternateText = string;
        this.m_image = Toolkit.getDefaultToolkit().getImage(string);
        this.init();
    }

    public PsImageLabel(Image image, String string) {
        this.m_image = image;
        this.m_imageString = string;
        this.m_alternateText = string;
        this.init();
    }

    public void paint(Graphics graphics) {
        if (!this.m_bDoneLoading) {
            this.waitForImage(true);
        }
        if (this.m_explicitSize) {
            graphics.drawImage(this.m_image, this.m_margin, this.m_margin, this.m_width - 2 * this.m_margin, this.m_height - 2 * this.m_margin, this);
        } else {
            graphics.drawImage(this.m_image, this.m_margin, this.m_margin, this);
        }
        this.drawRect(graphics, 0, 0, this.m_width - 1, this.m_height - 1, this.m_margin, this.m_marginColor);
    }

    public void waitForImage(boolean bl) {
        if (!this.m_bDoneLoading) {
            try {
                this.m_tracker.waitForID(this.currentTrackerID);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                PsDebug.warning((String)("Error loading " + this.m_imageString + ": " + exception.getMessage()));
                exception.printStackTrace();
            }
            if (this.m_tracker.isErrorID(this.currentTrackerID)) {
                new Throwable("Error loading image " + this.m_imageString).printStackTrace();
            }
            this.m_bDoneLoading = true;
            this.m_width = this.m_explicitWidth != 0 ? this.m_explicitWidth : this.m_image.getWidth(this) + 2 * this.m_margin;
            this.m_height = this.m_explicitHeight != 0 ? this.m_explicitHeight : this.m_image.getHeight(this) + 2 * this.m_margin;
            this.setSize(this.m_width, this.m_height);
            this.parentContainer = this.getParent();
            if (this.parentContainer != null && bl) {
                this.setBackground(this.parentContainer.getBackground());
                this.parentContainer.doLayout();
            }
        }
    }

    public Dimension getPreferredSize() {
        if (!this.m_bDoneLoading) {
            this.waitForImage(false);
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (!this.m_bDoneLoading) {
            this.waitForImage(false);
        }
        return super.getMinimumSize();
    }

    public void setSize(int n, int n2) {
        if (!this.m_bDoneLoading) {
            this.m_explicitSize = true;
            if (n > 0) {
                this.m_explicitWidth = n;
            }
            if (n2 > 0) {
                this.m_explicitHeight = n2;
            }
        }
        super.setSize(n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (!this.m_bDoneLoading) {
            this.m_explicitSize = true;
            if (n3 > 0) {
                this.m_explicitWidth = n3;
            }
            if (n4 > 0) {
                this.m_explicitHeight = n4;
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void init() {
        this.m_tracker = new MediaTracker(this);
        this.currentTrackerID = lastTrackerID++;
        this.m_tracker.addImage(this.m_image, this.currentTrackerID);
    }

    public void centerAt(int n, int n2) {
        this.setLocation(n - this.m_width / 2, n2 - this.m_height / 2);
    }

    protected void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(color);
        int n6 = 0;
        while (n6 < n5) {
            graphics.drawRect(n, n2, n3, n4);
            if (n6 < n5 - 1) {
                ++n;
                ++n2;
                n3 -= 2;
                n4 -= 2;
            }
            ++n6;
        }
    }
}

