/*
 * Decompiled with CFR 0.152.
 */
package dev.app.hodgeasc;

import dev.app.hodgeasc.PgAscLoader;
import dev.app.hodgeasc.PjHodgeAsc_IP;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.image.MemoryImageSource;
import java.util.Date;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnElementRK;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnEnergyMinimizer;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnHodgeU;
import jvx.numeric.PnHodgeW;
import jvx.numeric.PnLIC;
import jvx.surface.PgGraph;

public class PjHodgeAsc
extends PjProject
implements Runnable {
    protected static final String DEFAULT_VECTORFIELD = "vgp/vector/hodgeasc/flow1.asc";
    protected static final String DEFAULT_GEOMETRY = "vgp/vector/hodgeasc/all.dat";
    protected static final int m_dimOfDomain = 2;
    protected PgElementSet m_domain;
    protected PgElementSet[] m_texDomain;
    protected PgVectorField m_vf = new PgVectorField(2);
    protected PnEnergyMinimizer m_diriU;
    protected PgElementSet m_u;
    protected PgGraph m_uGraph;
    protected PgVectorField m_gradU;
    protected PnEnergyMinimizer m_diriW;
    protected PgElementSet m_w;
    protected PgGraph m_wGraph;
    protected PgVectorField m_coGradW;
    protected PgVectorField m_v;
    protected Thread m_LIC;
    private static /* synthetic */ Class class$dev$app$hodgeasc$PjHodgeAsc;

    public void computeGradient() {
        PdVector[][] pdVectorArray = ((PnHodgeU)this.m_diriU.getEnergy()).getGradFi();
        if (pdVectorArray == null) {
            return;
        }
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray2 = this.m_u.getVertices();
        this.m_gradU.setNumVectors(n);
        PdVector[] pdVectorArray3 = this.m_gradU.getVectors();
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray3[n2].setConstant(0.0);
            int n3 = 0;
            do {
                int n4 = piVectorArray[n2].m_data[n3];
                int n5 = 0;
                do {
                    int n6 = n5;
                    pdVectorArray3[n2].m_data[n6] = pdVectorArray3[n2].m_data[n6] + pdVectorArray2[n4].m_data[0] * pdVectorArray[n2][n3].m_data[n5];
                } while (++n5 < 2);
            } while (++n3 < 3);
            ++n2;
        }
    }

    public void computeJGradient() {
        PdVector[][] pdVectorArray = ((PnHodgeW)this.m_diriW.getEnergy()).getJGradFi();
        if (pdVectorArray == null) {
            return;
        }
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray2 = this.m_w.getVertices();
        this.m_coGradW.setNumVectors(n);
        PdVector[] pdVectorArray3 = this.m_coGradW.getVectors();
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray3[n2].setConstant(0.0);
            int n3 = 0;
            do {
                int n4 = piVectorArray[n2].m_data[n3];
                int n5 = 0;
                do {
                    int n6 = n5;
                    pdVectorArray3[n2].m_data[n6] = pdVectorArray3[n2].m_data[n6] + pdVectorArray2[n4].m_data[0] * pdVectorArray[n2][n3].m_data[n5];
                } while (++n5 < 2);
            } while (++n3 < 3);
            ++n2;
        }
    }

    public void computeHarmonic() {
        int n = this.m_domain.getNumElements();
        this.m_v.setNumVectors(n);
        PdVector[] pdVectorArray = this.m_v.getVectors();
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray[n2].sub(this.m_vf.getVector(n2), this.m_gradU.getVector(n2));
            pdVectorArray[n2].sub(this.m_coGradW.getVector(n2));
            ++n2;
        }
    }

    public PjHodgeAsc() {
        super("Potential");
        this.m_vf.setBasedOn(1);
        this.m_vf.setName("Vector Field");
        this.m_vf.setParent((PsUpdateIf)this);
        this.m_domain = new PgElementSet(2);
        this.m_domain.setName("Triangulation with Vectorfield");
        this.m_domain.setParent((PsUpdateIf)this);
        this.m_texDomain = new PgElementSet[3];
        int n = 0;
        do {
            this.m_texDomain[n] = new PgElementSet(2);
            this.m_texDomain[n].setName("Domain No " + n);
            this.m_texDomain[n].showElements(false);
            this.m_texDomain[n].showEdges(false);
        } while (++n < 3);
        this.m_u = new PgElementSet(1);
        this.m_u.setName("u");
        this.m_uGraph = new PgGraph(3);
        this.m_uGraph.setName("Graph of u");
        this.m_diriU = new PnEnergyMinimizer();
        this.m_diriU.setName("u Minimizer");
        this.m_diriU.setParent((PsUpdateIf)this);
        PnHodgeU pnHodgeU = new PnHodgeU();
        pnHodgeU.setVectorField(this.m_vf);
        this.m_diriU.setEnergy((PnEnergy)pnHodgeU);
        this.m_diriU.enableUpdateDomain(false);
        this.m_gradU = new PgVectorField(2);
        this.m_gradU.setBasedOn(1);
        this.m_gradU.setName("Gradient u");
        this.m_w = new PgElementSet(1);
        this.m_w.setName("w");
        this.m_wGraph = new PgGraph(3);
        this.m_wGraph.setName("Graph of w");
        this.m_diriW = new PnEnergyMinimizer();
        this.m_diriW.setName("w Minimizer");
        this.m_diriW.setParent((PsUpdateIf)this);
        PnHodgeW pnHodgeW = new PnHodgeW();
        pnHodgeW.setVectorField(this.m_vf);
        this.m_diriW.setEnergy((PnEnergy)pnHodgeW);
        this.m_diriW.enableUpdateDomain(false);
        this.m_coGradW = new PgVectorField(2);
        this.m_coGradW.setBasedOn(1);
        this.m_coGradW.setName("Gradient w");
        this.m_v = new PgVectorField(2);
        this.m_v.setBasedOn(1);
        this.m_v.setName("Harmonic v");
        if (this.getClass() == (class$dev$app$hodgeasc$PjHodgeAsc != null ? class$dev$app$hodgeasc$PjHodgeAsc : (class$dev$app$hodgeasc$PjHodgeAsc = PjHodgeAsc.class$("dev.app.hodgeasc.PjHodgeAsc")))) {
            this.init();
        }
    }

    public void computeLIC() {
        if (this.m_LIC == null || !this.m_LIC.isAlive()) {
            this.m_LIC = new Thread(this);
            this.m_LIC.start();
        }
    }

    public boolean update(Object object) {
        if (object == null) {
            super.update(null);
        } else {
            if (object == ((PsObject)this).m_infoPanel) {
                this.m_vf.update(null);
                return true;
            }
            if (object == this.m_vf) {
                return true;
            }
            if (object == this.m_domain) {
                this.m_domain.setTexture(null);
                int n = 0;
                do {
                    this.m_texDomain[n].setTexture(null);
                    this.m_texDomain[n].copy((PgGeometry)this.m_domain);
                    this.m_texDomain[n].showElements(false);
                    this.m_texDomain[n].showEdges(false);
                    this.m_texDomain[n].update(null);
                } while (++n < 3);
                return true;
            }
            if (object == this.m_diriU) {
                this.m_uGraph.update((Object)this.m_u);
                this.computeGradient();
                this.computeJGradient();
                this.computeHarmonic();
                int n = 0;
                do {
                    this.m_texDomain[n].update(null);
                } while (++n < 3);
                return true;
            }
            if (object == this.m_diriW) {
                this.m_wGraph.update((Object)this.m_w);
                this.computeGradient();
                this.computeJGradient();
                this.computeHarmonic();
                int n = 0;
                do {
                    this.m_texDomain[n].update(null);
                } while (++n < 3);
                return true;
            }
        }
        return super.update(object);
    }

    public void load(String string, String string2) {
        PgAscLoader pgAscLoader = new PgAscLoader();
        PgVectorField pgVectorField = pgAscLoader.read(this.m_domain, PsConfig.getCodeBase() + string, PsConfig.getCodeBase() + string2);
        this.m_vf.setGeometry((PgPointSet)this.m_domain);
        int n = this.m_domain.getNumElements();
        int n2 = this.m_vf.getDimOfVertices();
        PiVector[] piVectorArray = this.m_domain.getElements();
        int n3 = 0;
        while (n3 < n) {
            PdVector pdVector = new PdVector(n2);
            pdVector.setConstant(0.0);
            int n4 = 0;
            do {
                pdVector.add(pgVectorField.getVector(piVectorArray[n3].getEntry(n4)));
            } while (++n4 < 3);
            pdVector.multScalar(0.3333333333333333);
            this.m_vf.setVector(n3, pdVector);
            ++n3;
        }
    }

    public void start() {
        this.m_texDomain[0].addVectorField(this.m_gradU);
        this.m_gradU.setGeometry((PgPointSet)this.m_texDomain[0]);
        this.m_texDomain[1].addVectorField(this.m_coGradW);
        this.m_coGradW.setGeometry((PgPointSet)this.m_texDomain[1]);
        this.m_texDomain[2].addVectorField(this.m_v);
        this.m_v.setGeometry((PgPointSet)this.m_texDomain[2]);
        this.m_domain.showEdges(false);
        this.m_domain.showElements(false);
        this.m_domain.update((Object)this.m_domain);
        this.addGeometry((PgGeometryIf)this.m_domain);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.selectCamera(1);
        PvViewerIf pvViewerIf = this.getViewer();
        pvDisplayIf = pvViewerIf.newDisplay("Grad-U");
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_texDomain[0]);
        pvDisplayIf.selectCamera(1);
        this.addDisplay(pvDisplayIf);
        pvDisplayIf = pvViewerIf.newDisplay("CoGrad-W");
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_texDomain[1]);
        pvDisplayIf.selectCamera(1);
        this.addDisplay(pvDisplayIf);
        pvDisplayIf = pvViewerIf.newDisplay("Harmonic Part");
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_texDomain[2]);
        pvDisplayIf.selectCamera(1);
        this.addDisplay(pvDisplayIf);
        pvDisplayIf = pvViewerIf.newDisplay("Display u Graph");
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_uGraph);
        pvDisplayIf.selectCamera(0);
        this.addDisplay(pvDisplayIf);
        pvDisplayIf = pvViewerIf.newDisplay("Display w Pair");
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_wGraph);
        pvDisplayIf.selectCamera(0);
        this.addDisplay(pvDisplayIf);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void minimize() {
        this.m_diriU.minimize();
        this.m_diriW.minimize();
    }

    public void run() {
        PvDisplayIf pvDisplayIf = this.getDisplay();
        PgElementSet pgElementSet = null;
        PgVectorField pgVectorField = null;
        long l = new Date().getTime();
        PjHodgeAsc_IP pjHodgeAsc_IP = (PjHodgeAsc_IP)this.getInfoPanel();
        String string = pjHodgeAsc_IP.m_bMakeLIC.getLabel();
        int n = 0;
        do {
            pjHodgeAsc_IP.m_bMakeLIC.setLabel("LIC preparing...");
            pgElementSet = n == 0 ? this.m_domain : this.m_texDomain[n - 1];
            pgVectorField = n == 0 ? this.m_vf : (n == 1 ? this.m_gradU : (n == 2 ? this.m_coGradW : this.m_v));
            pgElementSet.showElements(true);
            pgElementSet.showElementTexture(true);
            PnElementRK pnElementRK = new PnElementRK(pgElementSet);
            pjHodgeAsc_IP.m_bMakeLIC.setLabel("LIC make barycentric...");
            pnElementRK.setVectorField(pgVectorField);
            pnElementRK.setFirstOrder(true);
            PgTexture pgTexture = new PgTexture();
            Frame frame = PsConfig.getFrame();
            Dimension dimension = this.getDisplay().getSize();
            int n2 = (dimension.width + dimension.height) / 2;
            n2 = 1000;
            int[] nArray = new int[n2 * n2];
            pjHodgeAsc_IP.m_bMakeLIC.setLabel("LIC init...");
            PnLIC pnLIC = new PnLIC(pgElementSet, n2, 0.0, (PnGeodesicRK)pnElementRK);
            pnLIC.setConvolutionWidth(60);
            int n3 = pgElementSet.getNumElements();
            pjHodgeAsc_IP.m_bMakeLIC.setLabel("LIC 0%");
            int n4 = n3 - 1;
            while (n4 >= 0) {
                pnLIC.makeElement(n4);
                if (n3 >= 10 && n4 % (n3 / 10) == 0) {
                    pjHodgeAsc_IP.m_bMakeLIC.setLabel("LIC " + (100 - (int)((double)n4 / ((double)n3 / 10.0) * 10.0)) + "%");
                } else if (n3 < 10) {
                    pjHodgeAsc_IP.m_bMakeLIC.setLabel("LIC " + (int)((double)(n3 - n4) * 100.0 / (double)n3) + "%");
                }
                --n4;
            }
            PjHodgeAsc pjHodgeAsc = this;
            synchronized (pjHodgeAsc) {
                pnLIC.getPixArray(nArray);
                pgTexture.setImage(frame.createImage(new MemoryImageSource(n2, n2, nArray, 0, n2)));
                pgElementSet.setTexture(pgTexture);
                if (n == 0) {
                    pvDisplayIf.update((Object)this.m_domain);
                } else {
                    pgElementSet.update(null);
                }
                pnLIC = null;
                nArray = null;
                System.gc();
                Object var19_18 = null;
            }
        } while (++n < 1);
        pjHodgeAsc_IP.m_bMakeLIC.setLabel(string);
        new Date().getTime();
        PsDebug.flushMessages();
    }

    public void init() {
        super.init();
        this.load(DEFAULT_VECTORFIELD, DEFAULT_GEOMETRY);
        this.m_u.setNumVertices(this.m_domain.getNumVertices());
        this.m_u.copyElementSet(this.m_domain);
        this.m_uGraph.setSurfaces(this.m_domain, this.m_u);
        this.m_uGraph.update((Object)this.m_u);
        this.m_diriU.setSurface(this.m_domain, this.m_u);
        this.m_w.setNumVertices(this.m_domain.getNumVertices());
        this.m_w.copyElementSet(this.m_domain);
        this.m_wGraph.setSurfaces(this.m_domain, this.m_w);
        this.m_wGraph.update((Object)this.m_w);
        this.m_diriW.setSurface(this.m_domain, this.m_w);
    }
}

