/*
 * Decompiled with CFR 0.152.
 */
package dev.app.knotBook;

import dev.app.knotBook.BooknotProject;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jv.loader.PsCategoryList_IP;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

public class BooknotProject_IP
extends PjProject_IP
implements ItemListener,
ActionListener,
KeyListener {
    protected BooknotProject dp;
    protected Panel mainPanel;
    protected PuInteger upPageIndex;
    protected PuInteger downPageIndex;
    protected PuInteger arcDisc;
    protected CheckboxGroup viewType;
    protected Checkbox view2D;
    protected Checkbox view3D;
    protected Button butSimplify;
    protected Button butRotate;
    protected Label processLabel;
    protected Label numPointsLabel;
    protected Label numComponentsLabel;
    protected TextArea inputArea;
    protected Frame inputFrame;
    protected Button hideButton;
    protected Button clearButton;
    protected Button loadGcButton;
    protected Button decodeGcButton;
    protected Button saveGcButton;
    protected Label doc1;
    protected Label doc2;
    protected Label doc3;
    protected Label modelSelect;
    protected Button butSelectModel;
    protected Button showInputGC;
    protected Button savePresentKnot;
    protected Button reset;
    protected CheckboxGroup knotType;
    protected Checkbox knotGC;
    protected Checkbox knot3D;
    protected List selectModelList;
    protected String[] cat = new String[]{"jkb", "gc", "txt"};
    protected String[][] entry;
    private static /* synthetic */ Class class$dev$app$knotBook$BooknotProject_IP;

    public BooknotProject_IP() {
        this.setTitle("Booknoot Project");
        this.mainPanel = new Panel();
        this.mainPanel.setLayout(new GridLayout(20, 1, 2, 2));
        Label label = new Label("Set Model:");
        this.mainPanel.add(label);
        this.modelSelect = new Label("");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 1));
        panel.setBackground(Color.white);
        panel.add(this.modelSelect);
        this.mainPanel.add(panel);
        this.butSelectModel = new Button("Choose Knot");
        this.showInputGC = new Button("Edit New Knot");
        this.butSelectModel.addActionListener(this);
        this.showInputGC.addActionListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2, 2, 2));
        panel2.add(this.butSelectModel);
        panel2.add(this.showInputGC);
        this.mainPanel.add(panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 2));
        this.savePresentKnot = new Button("Save Present Knot");
        this.savePresentKnot.addActionListener(this);
        this.reset = new Button("Reset");
        this.reset.addActionListener(this);
        panel3.add(this.reset);
        panel3.add(this.savePresentKnot);
        this.mainPanel.add(panel3);
        this.upPageIndex = new PuInteger("Upper Page", (PsUpdateIf)this);
        this.downPageIndex = new PuInteger("Lower Page", (PsUpdateIf)this);
        this.viewType = new CheckboxGroup();
        this.view2D = new Checkbox("2D", this.viewType, false);
        this.view3D = new Checkbox("3D", this.viewType, true);
        this.mainPanel.add(new Panel());
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(1, 4));
        panel4.add(new Label("View Mode:"));
        panel4.add(this.view2D);
        panel4.add(this.view3D);
        this.mainPanel.add(panel4);
        this.arcDisc = new PuInteger("Points per Arc", (PsUpdateIf)this);
        this.mainPanel.add((Component)this.arcDisc.getInfoPanel());
        this.view2D.addItemListener(this);
        this.view3D.addItemListener(this);
        this.mainPanel.add((Component)this.upPageIndex.getInfoPanel());
        this.mainPanel.add((Component)this.downPageIndex.getInfoPanel());
        Panel panel5 = new Panel();
        panel5.setLayout(new GridLayout(1, 2, 2, 2));
        this.butSimplify = new Button("Simplify");
        this.butSimplify.addActionListener(this);
        this.butRotate = new Button("Vertex Permutation");
        this.butRotate.addActionListener(this);
        panel5.add(this.butSimplify);
        panel5.add(this.butRotate);
        this.mainPanel.add(panel5);
        this.processLabel = new Label();
        this.mainPanel.add(this.processLabel);
        this.numPointsLabel = new Label();
        this.mainPanel.add(this.numPointsLabel);
        this.numComponentsLabel = new Label();
        this.mainPanel.add(this.numComponentsLabel);
        this.inputFrame = new Frame("Type Knot");
        this.inputFrame.setLayout(new CardLayout());
        ((Component)this.inputFrame).setBackground(Color.lightGray);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout());
        panel6.setBackground(Color.lightGray);
        this.inputFrame.add((Component)panel6, "Input");
        this.knotType = new CheckboxGroup();
        this.knotGC = new Checkbox("Gauss Code", this.knotType, false);
        this.knot3D = new Checkbox("3D Polygon", this.knotType, true);
        this.knotGC.addItemListener(this);
        this.knot3D.addItemListener(this);
        Panel panel7 = new Panel();
        panel7.add(this.knotGC);
        panel7.add(this.knot3D);
        panel6.add((Component)panel7, "North");
        this.inputArea = new TextArea("");
        this.inputArea.addKeyListener(this);
        this.inputArea.setName("New Knot");
        panel6.add((Component)this.inputArea, "Center");
        Panel panel8 = new Panel();
        Panel panel9 = new Panel();
        Panel panel10 = new Panel();
        Panel panel11 = new Panel();
        panel8.setLayout(new BorderLayout());
        panel8.add((Component)panel9, "West");
        panel8.add((Component)panel10, "East");
        panel8.add((Component)panel11, "North");
        panel9.setBackground(Color.lightGray);
        panel10.setBackground(Color.lightGray);
        panel11.setBackground(new Color(230, 230, 230));
        panel8.setBackground(Color.lightGray);
        panel9.setLayout(new FlowLayout(0));
        panel10.setLayout(new FlowLayout(2));
        panel11.setLayout(new FlowLayout(1));
        panel11.setLayout(new GridLayout(3, 1));
        this.hideButton = new Button("Cancel");
        this.hideButton.addActionListener(this);
        this.clearButton = new Button("Clear");
        this.clearButton.addActionListener(this);
        this.loadGcButton = new Button("Load");
        this.loadGcButton.addActionListener(this);
        this.saveGcButton = new Button("Save");
        this.saveGcButton.addActionListener(this);
        this.decodeGcButton = new Button("Ok");
        this.decodeGcButton.addActionListener(this);
        this.doc1 = new Label();
        this.doc2 = new Label();
        this.doc3 = new Label();
        this.doc1.setText("3D Polygon:  Type 3D coordinates sequentially according the knot");
        this.doc2.setText("             orientation. Separate coordinates by spaces, vertices");
        this.doc3.setText("             by a newline, and knot components by a blank line.");
        panel10.add(this.decodeGcButton);
        panel10.add(this.clearButton);
        panel10.add(this.hideButton);
        panel9.add(this.loadGcButton);
        panel9.add(this.saveGcButton);
        panel11.add(this.doc1);
        panel11.add(this.doc2);
        panel11.add(this.doc3);
        panel6.add((Component)panel8, "South");
        this.inputFrame.addWindowListener(new WindowAdapter(){
            {
                BooknotProject_IP.this.getClass();
            }

            public void windowClosing(WindowEvent windowEvent) {
                BooknotProject_IP.this.cancelInput();
            }
        });
        this.inputFrame.addKeyListener(this);
        this.inputFrame.pack();
        ((Component)this.inputFrame).setSize(400, 400);
        ((Component)this.inputFrame).setLocation(10, 10);
        ((Component)this.inputFrame).setVisible(false);
        ((Container)((Object)this)).add(this.mainPanel);
        if (this.getClass() == (class$dev$app$knotBook$BooknotProject_IP != null ? class$dev$app$knotBook$BooknotProject_IP : (class$dev$app$knotBook$BooknotProject_IP = BooknotProject_IP.class$("dev.app.knotBook.BooknotProject_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.dp == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.view2D) {
            this.dp.set2D();
            this.upPageIndex.setEnabled(true);
            this.downPageIndex.setEnabled(true);
            this.dp.update(this);
            return;
        }
        if (object == this.view3D) {
            this.dp.set3D();
            this.upPageIndex.setEnabled(false);
            this.downPageIndex.setEnabled(false);
            this.dp.update(this);
            return;
        }
        if (object == this.knotGC) {
            this.doc1.setText("Gauss Code:  see Documentation.");
            this.doc2.setText("");
            this.doc3.setText("");
        }
        if (object == this.knot3D) {
            this.doc1.setText("3D Polygon:  Type 3D coordinates sequentially according the knot");
            this.doc2.setText("             orientation. Separate coordinates by spaces, vertices");
            this.doc3.setText("             by a newline, and knot components by a blank line.");
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.dp = (BooknotProject)psUpdateIf;
        if (this.dp != null) {
            this.modelSelect.setText(this.dp.getDefaultKnotFileName());
            this.upPageIndex.setDefValue(this.dp.getBKView().getUpPage());
            this.upPageIndex.setDefBounds(0, this.dp.getBKView().getNumPages() - 1, 1, 1);
            this.upPageIndex.init();
            this.downPageIndex.setDefValue(this.dp.getBKView().getDownPage());
            this.downPageIndex.setDefBounds(0, this.dp.getBKView().getNumPages() - 1, 1, 1);
            this.downPageIndex.init();
            this.setTitle(this.dp.getName());
            this.dp.getViewer().getDisplay().addKeyListener((KeyListener)this);
            if (this.dp.getViewer().getFrame() == null) {
                this.loadGcButton.setEnabled(false);
                this.loadGcButton.setVisible(false);
                this.saveGcButton.setEnabled(false);
                this.saveGcButton.setVisible(false);
                this.savePresentKnot.setEnabled(false);
                this.savePresentKnot.setVisible(false);
                this.setCategoriesEntry();
            }
        }
    }

    private String getEntry() {
        PsCategoryList_IP psCategoryList_IP = new PsCategoryList_IP();
        psCategoryList_IP.setCategories(this.cat, this.entry);
        psCategoryList_IP.setTitle("New geometry replaces current scene");
        PsDialog psDialog = new PsDialog(PsConfig.getFrame(), "Select New Knot", true);
        psDialog.setLayout(new BorderLayout());
        psDialog.add("Center", (Component)psCategoryList_IP);
        psDialog.add("South", psDialog.getBottomButtons(5));
        psDialog.setLocation(10, 10);
        psDialog.setSize(300, 330);
        psDialog.validate();
        psDialog.setVisible(true);
        int n = psDialog.getUserAction();
        if (n != 4) {
            return "";
        }
        String string = psCategoryList_IP.getSelectedEntry();
        return string;
    }

    void cancelInput() {
        ((Component)this.inputFrame).setVisible(false);
    }

    public boolean update(Object object) {
        if (this.dp == null) {
            PsDebug.warning((String)"BooknotProject_IP.update(): missing parent, setParent not called");
            return false;
        }
        if (object == this.dp) {
            return true;
        }
        if (object == this.arcDisc) {
            this.dp.setArcDisc(this.arcDisc.getValue());
            return this.dp.update(this);
        }
        if (object == this.upPageIndex) {
            this.dp.setUpPage(this.upPageIndex.getValue());
            return this.dp.update(this);
        }
        if (object == this.downPageIndex) {
            this.dp.setDownPage(this.downPageIndex.getValue());
            return this.dp.update(this);
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (this.dp == null) {
            return;
        }
        Object object2 = actionEvent.getSource();
        if (object2 == this.butSimplify) {
            this.dp.simplify();
            this.dp.update(this);
            return;
        }
        if (object2 == this.butRotate) {
            this.dp.doRotate();
            this.dp.update(this);
            return;
        }
        if (object2 == this.clearButton) {
            this.inputArea.setText("");
            return;
        }
        if (object2 == this.hideButton) {
            this.cancelInput();
            return;
        }
        if (object2 == this.butSelectModel) {
            if (this.dp.getViewer().getFrame() == null) {
                object = this.getEntry();
                if (((String)object).equals("") || object == null) {
                    return;
                }
                if (((String)object).endsWith(".jkb") && this.dp.readAndSetJKB((String)object)) {
                    this.modelSelect.setText((String)object);
                    this.dp.update(this);
                }
                if (((String)object).endsWith(".gc") && this.dp.readAndSetGC((String)object)) {
                    this.modelSelect.setText((String)object);
                    this.dp.update(this);
                }
                if (((String)object).endsWith(".txt") && this.dp.readAndSet3D((String)object)) {
                    this.modelSelect.setText((String)object);
                    this.dp.update(this);
                }
            } else {
                object = this.dp.selectModel(0);
                if (object != null && !(object[0] + object[1]).equals("")) {
                    if (object[1].endsWith(".jkb") && this.dp.readAndSetJKB((String)object[0], (String)object[1])) {
                        this.modelSelect.setText((String)object[1]);
                        this.dp.update(this);
                    }
                    if (((String)object[1]).endsWith(".gc") && this.dp.readAndSetGC((String)object[0], (String)object[1])) {
                        this.modelSelect.setText((String)object[1]);
                        this.dp.update(this);
                    }
                    if (((String)object[1]).endsWith(".txt") && this.dp.readAndSet3D((String)object[0], (String)object[1])) {
                        this.modelSelect.setText((String)object[1]);
                        this.dp.update(this);
                    }
                }
            }
        }
        if (object2 == this.showInputGC) {
            object = (CardLayout)this.inputFrame.getLayout();
            ((CardLayout)object).show(this.inputFrame, "Input");
            ((Component)this.inputFrame).setVisible(true);
            return;
        }
        if (object2 == this.loadGcButton) {
            if (this.knotGC.getState()) {
                object = this.dp.selectModel(2);
                if (object == null) {
                    return;
                }
                String string = this.dp.readFile(object[0], object[1]);
                if (string == null || string.equals("")) {
                    return;
                }
                this.inputArea.setText(string);
                return;
            }
            object = this.dp.selectModel(3);
            if (object == null) {
                return;
            }
            String string = this.dp.readFile(object[0], object[1]);
            if (string == null || string.equals("")) {
                return;
            }
            this.inputArea.setText(string);
            return;
        }
        if (object2 == this.decodeGcButton) {
            this.okInput();
            return;
        }
        if (object2 == this.saveGcButton) {
            if (this.knotGC.getState()) {
                this.dp.exportGk(this.inputArea.getText());
                return;
            }
            this.dp.export3D(this.inputArea.getText());
            return;
        }
        if (object2 == this.savePresentKnot) {
            this.dp.exportKbx();
            return;
        }
        if (object2 == this.reset) {
            object = this.dp.getCurrentKnotFileName();
            if (object == null || ((String)object).equals("")) {
                return;
            }
            if (((String)object).equals("New Knot")) {
                if (this.dp.decode(this.inputArea.getText(), "New Knot")) {
                    this.dp.update(this);
                }
                return;
            }
            String string = ((String)object).substring(Math.max(((String)object).lastIndexOf("\\"), ((String)object).lastIndexOf("/")) + 1);
            String string2 = ((String)object).substring(0, Math.max(((String)object).lastIndexOf("\\"), ((String)object).lastIndexOf("/")) + 1);
            if (string.endsWith(".jkb") && this.dp.readAndSetJKB(string2, string)) {
                this.dp.update(this);
            }
            if (string.endsWith(".gc") && this.dp.readAndSetGC(string2, string)) {
                this.dp.update(this);
            }
            if (string.endsWith(".txt") && this.dp.readAndSet3D(string2, string)) {
                this.dp.update(this);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private void okInput() {
        if (this.knotGC.getState() && this.dp.decode(this.inputArea.getText(), "New Knot")) {
            this.modelSelect.setText("New Knot");
            this.dp.setCurrentKnotFileName("New Knot");
            this.dp.update(this);
        }
        if (this.knot3D.getState()) {
            String string = this.dp.getGCfromString(this.inputArea.getText());
            if (!string.equals("") && string != null) {
                this.inputArea.setText(string);
                this.knotGC.setState(true);
                this.dp.update(this);
            }
            return;
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.upPageIndex.setEnabled(false);
        this.downPageIndex.setEnabled(false);
        this.arcDisc.setDefBounds(3, 30, 1, 2);
        this.arcDisc.setDefValue(20);
        this.arcDisc.init();
    }

    private void setCategoriesEntry() {
        int n;
        String[] stringArray = this.dp.getKnotFileNames();
        int n2 = stringArray.length;
        int[] nArray = new int[this.cat.length];
        this.entry = new String[this.cat.length][0];
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < this.cat.length) {
                if (stringArray[n3].endsWith(this.cat[n])) {
                    int n4 = n;
                    nArray[n4] = nArray[n4] + 1;
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.cat.length) {
            this.entry[n3] = new String[nArray[n3]];
            n = 0;
            int n5 = 0;
            while (n5 < n2) {
                if (stringArray[n5].endsWith(this.cat[n3])) {
                    this.entry[n3][n] = stringArray[n5];
                    ++n;
                }
                ++n5;
            }
            ++n3;
        }
    }

    public void setNumPointsLabel(int n) {
        if (n >= 0) {
            this.numPointsLabel.setText("Number of Points: " + n);
            return;
        }
        this.numPointsLabel.setText("no Points");
    }

    public void setNumComponentsLabel(int n) {
        if (n >= 0) {
            this.numComponentsLabel.setText("Number of Components: " + n);
            return;
        }
        this.numComponentsLabel.setText("no Components");
    }

    public void setProcessStatusLabel(String string) {
        this.processLabel.setText("Status: " + string);
    }
}

