/*
 * Decompiled with CFR 0.152.
 */
package dev.app.knotBook;

import dev.app.knotBook.BooknotProject;
import dev.app.knotBook.PgKnotArc;
import dev.app.knotBook.PgKnotBook;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class BooknotView {
    private BooknotProject m_project;
    private PgKnotBook m_kb;
    public final int i2D = 0;
    public final int i3D = 1;
    private PgElementSet pages = new PgElementSet();
    private PgPolygonSet knot = new PgPolygonSet();
    private int iNumPages = 0;
    private double dThickness = 0.1;
    private boolean isNotTubed = true;
    private int m_ipageUp = 0;
    private int m_ipageDown = 2;
    private int dimCircl = 19;
    private double[] dPageAngle;
    private double[] dPageCos;
    private double[] dPageSin;
    private double[] dCircleCos;
    private double[] dCircleSin;

    public void setDThickness(double d) {
        this.dThickness = d;
    }

    protected void set2DArc(PgKnotArc pgKnotArc, Color color, int n) {
        int n2 = (this.dimCircl + 1) * n;
        double d = this.m_kb.getVertices()[pgKnotArc.getBase()].getEntry(0);
        double d2 = this.m_kb.getVertices()[pgKnotArc.getEnd()].getEntry(0);
        double d3 = (d2 - d) / 2.0;
        int n3 = pgKnotArc.getPage() == this.m_ipageUp ? 1 : -1;
        double d4 = Math.abs(d3) * (double)n3;
        double d5 = d + d3;
        int n4 = 0;
        while (n4 <= this.dimCircl) {
            this.knot.setVertex(n2 + n4, d5 - this.dCircleCos[n4] * d3, this.dCircleSin[n4] * d4, 0.0);
            ++n4;
        }
        int[] nArray = new int[this.dimCircl + 1];
        int n5 = 0;
        while (n5 <= this.dimCircl) {
            nArray[n5] = n2 + n5;
            ++n5;
        }
        PiVector piVector = new PiVector(nArray);
        this.knot.setPolygon(n, piVector);
        this.knot.setPolygonColor(n, color);
    }

    public BooknotView(BooknotProject booknotProject) {
        this.m_project = booknotProject;
        this.pages.setName("Book");
        this.knot.setName("Knot");
        this.m_project.addGeometry((PgGeometryIf)this.pages);
        this.m_project.addGeometry((PgGeometryIf)this.knot);
    }

    public void setCameraMode(int n) {
        PvDisplayIf pvDisplayIf = this.m_project.getDisplay();
        if (pvDisplayIf != null) {
            switch (n) {
                case 0: {
                    pvDisplayIf.selectCamera(1);
                    pvDisplayIf.setMajorMode(6);
                    return;
                }
                case 1: {
                    pvDisplayIf.selectCamera(0);
                    pvDisplayIf.setMajorMode(0);
                    return;
                }
            }
        }
    }

    protected double[] getMaxMinCoord() {
        PdVector[] pdVectorArray = this.m_kb.getVertices();
        double[] dArray = new double[2];
        int n = this.m_kb.getNumVertices();
        if (n == 0) {
            return dArray;
        }
        dArray[0] = pdVectorArray[0].getEntry(0);
        dArray[1] = pdVectorArray[0].getEntry(0);
        int n2 = 1;
        while (n2 < n) {
            dArray[0] = dArray[0] > pdVectorArray[n2].getEntry(0) ? pdVectorArray[n2].getEntry(0) : dArray[0];
            dArray[1] = dArray[1] < pdVectorArray[n2].getEntry(0) ? pdVectorArray[n2].getEntry(0) : dArray[1];
            ++n2;
        }
        return dArray;
    }

    public int getNumPages() {
        return this.iNumPages;
    }

    public void setUpPage(int n) {
        this.m_ipageUp = n;
    }

    public int getUpPage() {
        return this.m_ipageUp;
    }

    private void preparingView() {
        this.iNumPages = this.m_kb.getNumPages();
        this.dPageAngle = new double[this.iNumPages];
        this.dPageCos = new double[this.iNumPages];
        this.dPageSin = new double[this.iNumPages];
        this.dCircleCos = new double[this.dimCircl + 1];
        this.dCircleSin = new double[this.dimCircl + 1];
        int n = 0;
        while (n < this.iNumPages) {
            this.dPageAngle[n] = Math.PI * 2 * (double)n / (double)this.iNumPages;
            this.dPageCos[n] = Math.cos(this.dPageAngle[n]);
            this.dPageSin[n] = Math.sin(this.dPageAngle[n]);
            ++n;
        }
        n = 0;
        while (n <= this.dimCircl) {
            this.dCircleCos[n] = Math.cos((double)n * Math.PI / (double)this.dimCircl);
            this.dCircleSin[n] = Math.sin((double)n * Math.PI / (double)this.dimCircl);
            ++n;
        }
    }

    public void setArcDisc(int n) {
        this.dimCircl = n - 1;
    }

    public void setDownPage(int n) {
        this.m_ipageDown = n;
    }

    public int getDownPage() {
        return this.m_ipageDown;
    }

    private void feetDisplay() {
        PvDisplayIf pvDisplayIf = this.m_project.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.fit();
        }
    }

    public void compute3DView(PgKnotBook pgKnotBook) {
        if (pgKnotBook == null) {
            PsDebug.warning((String)"in BooknotView.compute3DView(PgKnotBook kb)  kb = null");
            return;
        }
        this.m_kb = pgKnotBook;
        this.iNumPages = this.m_kb.getNumPages();
        this.preparingView();
        double[] dArray = this.getMaxMinCoord();
        double d = dArray[0] - 1.0;
        double d2 = dArray[1] + 1.0;
        double d3 = Math.abs(d2 - d) * 0.5;
        double d4 = 0.0;
        this.pages.setNumElements(this.iNumPages);
        this.pages.setNumVertices(2 + this.iNumPages * 2);
        this.pages.setVertex(this.iNumPages * 2, d + d4, 0.0, 0.0);
        this.pages.setVertex(this.iNumPages * 2 + 1, d2 + d4, 0.0, 0.0);
        int n = 0;
        while (n < this.iNumPages) {
            double d5 = d3 * Math.cos(this.dPageAngle[n]);
            double d6 = d3 * Math.sin(this.dPageAngle[n]);
            this.pages.setVertex(n * 2, d + d4, d5, d6);
            this.pages.setVertex(n * 2 + 1, d2 + d4, d5, d6);
            PiVector piVector = new PiVector(this.iNumPages * 2, n * 2, n * 2 + 1, this.iNumPages * 2 + 1);
            this.pages.setElement(n, piVector);
            ++n;
        }
        this.pages.makeVertexNormals();
        this.pages.makeNeighbour();
        this.pages.showElements(false);
        PgKnotArc[] pgKnotArcArray = this.m_kb.getArcs();
        int n2 = this.m_kb.getNumArcs();
        int[] nArray = this.m_kb.getComponents();
        int n3 = this.m_kb.getNumComponents();
        Color[] colorArray = new Color[n3];
        int n4 = 0;
        while (n4 < n3) {
            colorArray[n4] = PdColor.hsv2rgb((int)((int)((double)n4 * 255.0 / (double)n3)), (int)255, (int)255);
            ++n4;
        }
        this.knot.setNumVertices(n2 * this.dimCircl);
        this.knot.setNumPolygons(n2);
        n4 = 0;
        while (n4 < n2) {
            PgKnotArc pgKnotArc = pgKnotArcArray[n4];
            this.set3DArc(pgKnotArc, colorArray[nArray[n4]]);
            ++n4;
        }
        this.knot.setGlobalPolygonSize(this.dThickness * 10.0);
        this.knot.useGlobalPolygonSize(false);
        this.knot.showPolygonColors(true);
        this.knot.showVertices(false);
        this.knot.showPolygonEndArrow(true);
        this.knot.update((Object)this.knot);
        this.pages.update((Object)this.pages);
        this.feetDisplay();
    }

    public void compute2DView(PgKnotBook pgKnotBook) {
        if (pgKnotBook == null) {
            PsDebug.warning((String)"in BooknotView.compute2DView(PgKnotBook kb)  kb = null");
            return;
        }
        this.m_kb = pgKnotBook;
        this.iNumPages = this.m_kb.getNumPages();
        this.pages.setNumVertices(6);
        this.pages.setNumElements(2);
        this.preparingView();
        double[] dArray = this.getMaxMinCoord();
        double d = dArray[0] - 1.0;
        double d2 = dArray[1] + 1.0;
        double d3 = Math.abs(d2 - d) * 0.5;
        this.pages.setVertex(0, d, 0.0, 0.0);
        this.pages.setVertex(1, d2, 0.0, 0.0);
        this.pages.setVertex(2, d, d3, 0.0);
        this.pages.setVertex(3, d2, d3, 0.0);
        this.pages.setVertex(4, d, -d3, 0.0);
        this.pages.setVertex(5, d2, -d3, 0.0);
        PiVector piVector = new PiVector(0, 2, 3, 1);
        PiVector piVector2 = new PiVector(0, 4, 5, 1);
        this.pages.setElement(0, piVector);
        if (this.m_ipageUp != this.m_ipageDown) {
            this.pages.setElement(1, piVector2);
        }
        this.pages.makeVertexNormals();
        this.pages.makeNeighbour();
        this.pages.showElements(false);
        PgKnotArc[] pgKnotArcArray = this.m_kb.getArcs();
        int n = this.m_kb.getNumArcs();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (pgKnotArcArray[n3].getPage() == this.m_ipageUp || pgKnotArcArray[n3].getPage() == this.m_ipageDown) {
                ++n2;
            }
            ++n3;
        }
        this.knot.setNumVertices(n2 * (this.dimCircl + 1));
        this.knot.setNumPolygons(n2);
        int[] nArray = this.m_kb.getComponents();
        int n4 = this.m_kb.getNumComponents();
        Color[] colorArray = new Color[n4];
        int n5 = 0;
        while (n5 < n4) {
            colorArray[n5] = PdColor.hsv2rgb((int)((int)((double)n5 * 255.0 / (double)n4)), (int)255, (int)255);
            ++n5;
        }
        n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            PgKnotArc pgKnotArc = pgKnotArcArray[n6];
            int n7 = pgKnotArc.getPage();
            if (n7 == this.m_ipageUp || n7 == this.m_ipageDown) {
                this.set2DArc(pgKnotArc, colorArray[nArray[n6]], n5);
                ++n5;
            }
            ++n6;
        }
        this.knot.setGlobalPolygonSize(this.dThickness * 10.0);
        this.knot.showVertices(false);
        this.knot.useGlobalPolygonSize(false);
        this.knot.showPolygonColors(true);
        this.knot.showPolygonEndArrow(true);
        this.knot.update((Object)this.knot);
        this.pages.update((Object)this.pages);
        this.feetDisplay();
    }

    protected void set3DArc(PgKnotArc pgKnotArc, Color color) {
        int n = pgKnotArc.getPage();
        int n2 = pgKnotArc.getBase();
        int n3 = this.dimCircl * n2;
        int n4 = this.dimCircl * pgKnotArc.getEnd();
        double d = this.m_kb.getVertices()[pgKnotArc.getBase()].getEntry(0);
        double d2 = (this.m_kb.getVertices()[pgKnotArc.getEnd()].getEntry(0) - d) / 2.0;
        double d3 = Math.abs(d2);
        double d4 = d + d2;
        this.knot.setVertex(n3, d, 0.0, 0.0);
        int n5 = 1;
        while (n5 < this.dimCircl) {
            this.knot.setVertex(n3 + n5, d4 - this.dCircleCos[n5] * d2, this.dCircleSin[n5] * this.dPageCos[n] * d3, this.dCircleSin[n5] * this.dPageSin[n] * d3);
            ++n5;
        }
        int[] nArray = new int[this.dimCircl + 1];
        int n6 = 0;
        while (n6 < this.dimCircl) {
            nArray[n6] = n3 + n6;
            ++n6;
        }
        nArray[this.dimCircl] = n4;
        PiVector piVector = new PiVector(nArray);
        this.knot.setPolygon(n2, piVector);
        this.knot.setPolygonColor(n2, color);
    }
}

