/*
 * Decompiled with CFR 0.152.
 */
package dev.app.knotBook;

import dev.app.knotBook.PgKnotArc;
import dev.app.knotBook.PgKnotBook;
import java.awt.Color;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;

public class PsKbxLoader {
    protected static PgKnotBook parseRsrcTree(PsXmlSrc psXmlSrc) {
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning((String)"PsKbxLoader.parseRsrcTree:missing root model.");
            return null;
        }
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"geometries");
        String[] stringArray = new String[]{"tag"};
        if (psXmlNode2 != null) {
            PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode2, (String)"geometry");
            if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
                PsDebug.warning((String)"PsKbxLoader.parseRsrcTree: no geometry.");
                return null;
            }
            int n = 0;
            while (n < psXmlNodeArray.length) {
                PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"knotBook");
                if (psXmlNode3 != null) {
                    PsXmlNode psXmlNode4;
                    PsXmlNode psXmlNode5;
                    Color[] colorArray;
                    Color color;
                    PdVector[] pdVectorArray;
                    PgKnotBook pgKnotBook = new PgKnotBook();
                    pgKnotBook.setName(psXmlNodeArray[n].getAttribute("name"));
                    PsXmlNode psXmlNode6 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode3, (String)"points");
                    if (psXmlNode6 != null) {
                        double d;
                        pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)psXmlNode6, (String)"p", (String[])stringArray);
                        if (pdVectorArray != null) {
                            pgKnotBook.setNumVertices(pdVectorArray.length, pdVectorArray[0].getSize());
                            pgKnotBook.setVertices(pdVectorArray);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)psXmlNode6, (String)"size")) != 0.0) {
                            pgKnotBook.setGlobalVertexSize(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode6, (String)"color")) != null) {
                            pgKnotBook.setGlobalVertexColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode6, (String)"colorTag")) != null) {
                            pgKnotBook.setGlobalVertexTagColor(color);
                        }
                    }
                    if ((pdVectorArray = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode3, (String)"colors")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)pdVectorArray, (String)"c")) != null) {
                        pgKnotBook.setVertexColors(colorArray);
                    }
                    if ((psXmlNode5 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode3, (String)"arcs")) != null) {
                        psXmlNode4 = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode5, (String)"arc");
                        pgKnotBook.setNumArcs(((PsXmlNode)psXmlNode4).length);
                        n = 0;
                        while (n < ((PsXmlNode)psXmlNode4).length) {
                            int n2 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)psXmlNode4[n], (String)"base");
                            int n3 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)psXmlNode4[n], (String)"end");
                            int n4 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)psXmlNode4[n], (String)"onpage");
                            pgKnotBook.getArc(n).set(n2, n3, n4);
                            color = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode4[n], (String)"color");
                            if (color != null) {
                                pgKnotBook.setArcColor(n, color);
                            }
                            ++n;
                        }
                        color = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode5, (String)"color");
                        if (color != null) {
                            pgKnotBook.setGlobalArcColor(color);
                        }
                    }
                    if ((psXmlNode4 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode3, (String)"pages")) != null) {
                        PsXmlNode[] psXmlNodeArray2 = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode4, (String)"page");
                        if (psXmlNodeArray2 != null && psXmlNodeArray2.length > 0) {
                            pgKnotBook.setNumPages(psXmlNodeArray2.length);
                            n = 0;
                            while (n < psXmlNodeArray2.length) {
                                double d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)psXmlNode4, (String)"angle");
                                pgKnotBook.setPageAngle(n, d);
                                color = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNodeArray2[n], (String)"color");
                                if (color != null) {
                                    pgKnotBook.setPageColor(n, color);
                                }
                                ++n;
                            }
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)psXmlNode4, (String)"color")) != null) {
                            pgKnotBook.setGlobalPageColor(color);
                        }
                    }
                    return pgKnotBook;
                }
                ++n;
            }
        }
        return null;
    }

    public static PgKnotBook read(String string) {
        PsXmlSrc psXmlSrc = PsXmlLoader.read((String)string);
        if (psXmlSrc == null) {
            PsDebug.warning((String)("PsKbxLoader.read(): failed to parse XML in file = " + string));
            return null;
        }
        PgKnotBook pgKnotBook = PsKbxLoader.parseRsrcTree(psXmlSrc);
        if (pgKnotBook == null) {
            PsDebug.warning((String)("PsKbxLoader.read(): failed to interpret content of JVX file = " + string));
            return null;
        }
        return pgKnotBook;
    }

    public static String write(PgKnotBook pgKnotBook) {
        if (pgKnotBook == null) {
            PsDebug.warning((String)"PsKbxLoader.write(): missing geometries.");
            return null;
        }
        PsXmlSrc psXmlSrc = PsKbxLoader.fillRsrcTree(null, pgKnotBook);
        if (psXmlSrc == null) {
            PsDebug.warning((String)"PsKbxLoader.read(): failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write((PsXmlSrc)psXmlSrc);
    }

    protected static PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PgKnotBook pgKnotBook) {
        PgKnotArc[] pgKnotArcArray;
        PsXmlNode psXmlNode;
        if (pgKnotBook == null) {
            return null;
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode = psXmlSrc.getRootNode()) == null) {
            psXmlNode = new PsXmlNode("kbx-model");
            psXmlSrc.setRootNode(psXmlNode);
        }
        PsXmlNode[] psXmlNodeArray = new PsXmlNode[2];
        psXmlNodeArray[0] = psXmlNode.addChild("meta");
        psXmlNodeArray[0].addAttribute("generator", PsConfig.getProgram() + "v." + PsConfig.getVersion());
        psXmlNodeArray[1] = psXmlNode.addChild("meta");
        psXmlNodeArray[1].addAttribute("date", new Date().toString());
        if (pgKnotBook.getName() != null) {
            psXmlNode.addChild("title", pgKnotBook.getName());
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild("geometries");
        PsXmlNode psXmlNode3 = psXmlNode2.addChild("geometry");
        if (pgKnotBook.getName() != null) {
            psXmlNode3.addAttribute("name", pgKnotBook.getName());
        }
        PsXmlNode psXmlNode4 = psXmlNode3.addChild("knotBook");
        psXmlNode4.addAttribute("view", "3dbook");
        PsXmlNode psXmlNode5 = psXmlNode4.addChild("points");
        PdVector[] pdVectorArray = pgKnotBook.getVertices();
        int n = 0;
        while (n < pdVectorArray.length) {
            PsXmlNode psXmlNode6 = psXmlNode5.addChild("p");
            psXmlNode6.setContent(String.valueOf(pdVectorArray[n].getEntry(0)));
            ++n;
        }
        PsXmlNode psXmlNode7 = psXmlNode4.addChild("pages");
        int n2 = pgKnotBook.getNumPages();
        int n3 = 0;
        while (n3 < n2) {
            pgKnotArcArray = psXmlNode7.addChild("page");
            pgKnotArcArray.setContent(String.valueOf(360 / n2 * n3));
            ++n3;
        }
        PsXmlNode psXmlNode8 = psXmlNode4.addChild("arcs");
        pgKnotArcArray = pgKnotBook.getArcs();
        int n4 = 0;
        while (n4 < pgKnotArcArray.length) {
            PsXmlNode psXmlNode9 = psXmlNode8.addChild("arc");
            PsXmlNode psXmlNode10 = psXmlNode9.addChild("base");
            psXmlNode10.setContent(String.valueOf(pgKnotArcArray[n4].getBase()));
            PsXmlNode psXmlNode11 = psXmlNode9.addChild("end");
            psXmlNode11.setContent(String.valueOf(pgKnotArcArray[n4].getEnd()));
            PsXmlNode psXmlNode12 = psXmlNode9.addChild("onpage");
            psXmlNode12.setContent(String.valueOf(pgKnotArcArray[n4].getPage()));
            ++n4;
        }
        return psXmlSrc;
    }
}

