/*
 * Decompiled with CFR 0.152.
 */
package dev.app.knotBook;

import dev.app.knotBook.PgKnotArc;
import dev.app.knotBook.PgKnotBook;
import jv.vecmath.PdVector;

public class ThreePageLink {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int NOARC = -1;
    public static final int NOPAGE = -1;
    private int compleXity = 0;
    private int oldComplexity = 0;
    private int maX_Size = 0;
    private int numOfComponents = 0;
    private int lastVertex = -1;
    private static final int INITNUMCOMP = 10;
    private static final int NUMCOMPINC = 100;
    private int[][] stateOfComponents;
    private static final int NUMOFCFIELDS = 8;
    private static final int LENGTHF = 3;
    private static final int MAXLENF = 4;
    private static final int STARTVERTF = 5;
    private static final int STARTPAGEF = 6;
    private static final int ISTRIVIALF = 7;
    private int[] numArcs;
    private int[][] theDiagram;
    private static final int NUMOFVFIELDS = 8;
    private static final int NEXTF = 4;
    private static final int PREVF = 3;
    private static final int TYPEF = 5;
    private static final int AUXNUMF = 6;
    private static final int ONCOMPF = 7;
    private static final int VT_UNUSED = 0;
    private static final int VT_REGULAR = 1;
    private static final int VT_INTAIL = 2;
    private static final int VT_OUTTAIL = 3;
    private static final int VT_ONETAIL = 4;
    private static final int VT_NOTCONNECTED = -1;
    private static final int VT_REACHED_ONCE = -2;
    private static final int VT_REACHED_TWICE = -3;
    private static final int UNKNOWNCOMP = -1;
    private static final int VO_ATTACHIN = 0;
    private static final int VO_ATTACHOUT = 1;
    private static final int VO_ATTACH = 2;
    private static final int VO_DETACH = 3;
    private int freeSpaceEntry;
    private double[] x;
    private boolean isCoordinateSet = false;
    private boolean isVerticesOriented = false;
    private boolean isDefragmented = true;
    private boolean isSimplifyFinished = false;
    private boolean isCellSearched;
    private boolean isInExMvApplicable;
    private int errorCode = 0;
    private int[] errorRegistry;
    private static final int STARTSIMPLIFY = 1;
    private static final int SIMPLIFYING_STEP = 11;
    private static final int SIMPLIFYING__TRIAL = 111;
    private static final int DELETING__PATH_ = 1111;
    private static final int DEL__PATH__ARC = 11111;
    private static final int CONTR__TRIV__ARC = 11112;
    private static final int MOVE__TRIV_COMP_R = 11113;
    private static final int CLOSING__LINK_ = 1112;
    private static final int SEARCHING__PATH__ = 11121;
    private static final int SEARCHING__ARCS__ = 11122;
    private static final int ADDING__PATH__ = 11123;
    private static final int RES__SELF__INTSCTN = 11124;
    private static final int CLEANING__UP__ = 11125;
    private static final int FINISHEDSIMPLIFY = 2;
    private static final int EXCHANGE__MOVE = 112;
    private int interruptLevel = 0;
    private int currMode = 1;
    private int lastMode = 0;
    private int subMode = 0;
    private long maxStepCounter = Long.MAX_VALUE;
    private long stepCounter = 0L;
    private int trialCounter = 0;
    private int currComp;
    private static final int maxTrialFactor = 1;
    private static final int maxCompFactor = 1;
    private int newTrivComponent;
    private int numOfNonTrivial = 0;
    private int compCounter = 0;
    private int pageOne;
    private int pageTwo;
    private int currPlane;
    private int pageThree;
    private int departVertex;
    private int departPage;
    private int arriveVertex;
    private int arrivePage;
    private int currVertex = 0;
    private int currPage;
    private int otherPage;
    private int currObst;
    private int prevV = 0;
    private int nextV = 0;
    private int fromVertex = 0;
    private int queuePointer = 0;
    private int queueLength = -1;
    private int[][] newVertexQueue;
    private int[][] newArcs;
    private int numOfNewArcs = 0;
    private int arcIdx;
    private static final int NUMOFQUEUEFIELDS = 4;
    private static final int Q_VERTEXF = 0;
    private static final int Q_PAGEF = 1;
    private static final int Q_WAITF = 2;
    private static final int Q_ARCIDXF = 3;
    private static final int NUMOFNEWARCFIELDS = 4;
    private static final int NA_BASEF = 0;
    private static final int NA_ENDF = 1;
    private static final int NA_PAGEF = 2;
    private static final int NA_OBSTF = 3;
    private static final int NOOBSTACLE = -1;
    private int[][] regIon;

    public void setMaxStepCounter(int n) {
        this.maxStepCounter = n;
    }

    public PgKnotBook back_to_kb() {
        PgKnotBook pgKnotBook = new PgKnotBook();
        pgKnotBook.setNumPages(3);
        if (this.errorCode > 0) {
            this.writeErrorMessage();
            return null;
        }
        PgKnotArc[] pgKnotArcArray = new PgKnotArc[this.compleXity];
        int n = 2;
        if (this.currMode > 2) {
            n = 1;
        }
        this.doCheckDiagram(n);
        if (this.errorCode > 0) {
            this.writeErrorMessage();
            return null;
        }
        this.doDefrag();
        if (this.errorCode > 0) {
            this.writeErrorMessage();
            return null;
        }
        this.setOrientation();
        pgKnotBook.setNumVertices(this.compleXity, 1);
        PdVector[] pdVectorArray = new PdVector[this.compleXity];
        int n2 = 0;
        while (n2 < this.compleXity) {
            pdVectorArray[n2] = new PdVector(this.x[n2]);
            ++n2;
        }
        pgKnotBook.setVertices(pdVectorArray);
        if (!this.isVerticesOriented) {
            this.errorCode = 220;
            int[] nArray = new int[]{};
            this.errorRegistry = nArray;
            this.writeErrorMessage();
            return null;
        }
        pgKnotBook.setNumArcs(this.numArcs[3]);
        int n3 = this.lastVertex;
        int n4 = 0;
        n3 = 0;
        while (n3 < this.compleXity) {
            int n5 = this.theDiagram[n3][6];
            if (n5 != -1) {
                int n6 = this.theDiagram[n3][n5];
                pgKnotArcArray[n3] = new PgKnotArc();
                pgKnotArcArray[n3].setBase(n3);
                pgKnotArcArray[n3].setEnd(n6);
                pgKnotArcArray[n3].setPage(n5);
                pgKnotBook.setArc(n4, pgKnotArcArray[n3]);
                ++n4;
            }
            ++n3;
        }
        return pgKnotBook;
    }

    private void doSetCoordinate() {
        this.isCoordinateSet = false;
        int n = this.lastVertex;
        int n2 = 0;
        while (n2 < this.compleXity) {
            if (n2 > 0 && n == this.lastVertex) {
                this.errorCode = 63;
                int[] nArray = new int[]{n2, n};
                this.errorRegistry = nArray;
                return;
            }
            int n3 = n;
            if ((n = this.theDiagram[n3][4]) < 0 || n >= this.maX_Size - 1) {
                this.errorCode = 64;
                int[] nArray = new int[]{n2, n};
                this.errorRegistry = nArray;
                return;
            }
            if (this.theDiagram[n][5] == 0) {
                this.errorCode = 61;
                int[] nArray = new int[]{n2, n};
                this.errorRegistry = nArray;
                return;
            }
            if (this.theDiagram[n][3] != n3) {
                this.errorCode = 62;
                int[] nArray = new int[]{n2, n3, n};
                this.errorRegistry = nArray;
                return;
            }
            this.x[n] = n2;
            ++n2;
        }
        if (n != this.lastVertex) {
            this.errorCode = 60;
            int[] nArray = new int[]{this.compleXity, n, this.lastVertex};
            this.errorRegistry = nArray;
            return;
        }
        this.isCoordinateSet = true;
    }

    private void doChangeVertexState(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                if (this.theDiagram[n][n2] != -1) {
                    this.errorCode = 31;
                    int[] nArray = new int[]{n, n2};
                    this.errorRegistry = nArray;
                    return;
                }
                switch (this.theDiagram[n][5]) {
                    case -1: {
                        this.theDiagram[n][5] = 2;
                        return;
                    }
                    case 3: {
                        this.theDiagram[n][5] = 1;
                        return;
                    }
                }
                this.errorCode = 32;
                int[] nArray = new int[]{n, n2};
                this.errorRegistry = nArray;
                return;
            }
            case 1: {
                if (this.theDiagram[n][n2] != -1) {
                    this.errorCode = 33;
                    int[] nArray = new int[]{n, n2};
                    this.errorRegistry = nArray;
                    return;
                }
                switch (this.theDiagram[n][5]) {
                    case -1: {
                        this.theDiagram[n][5] = 3;
                        return;
                    }
                    case 2: {
                        this.theDiagram[n][5] = 1;
                        return;
                    }
                }
                this.errorCode = 34;
                int[] nArray = new int[]{n, n2};
                this.errorRegistry = nArray;
                return;
            }
            case 2: {
                if (this.theDiagram[n][n2] != -1) {
                    this.errorCode = 35;
                    int[] nArray = new int[]{n, n2};
                    this.errorRegistry = nArray;
                    return;
                }
                switch (this.theDiagram[n][5]) {
                    case -1: {
                        this.theDiagram[n][5] = 4;
                        return;
                    }
                    case 4: {
                        this.theDiagram[n][5] = 1;
                        return;
                    }
                    case -2: {
                        this.theDiagram[n][5] = 4;
                        return;
                    }
                    case -3: {
                        this.theDiagram[n][5] = 4;
                        return;
                    }
                }
                this.errorCode = 36;
                int[] nArray = new int[]{n, n2};
                this.errorRegistry = nArray;
                return;
            }
            case 3: {
                switch (this.theDiagram[n][5]) {
                    case 1: {
                        this.theDiagram[n][5] = 4;
                        return;
                    }
                    case 4: {
                        this.theDiagram[n][5] = -1;
                        return;
                    }
                }
                this.errorCode = 38;
                int[] nArray = new int[]{n, n2};
                this.errorRegistry = nArray;
                return;
            }
        }
        this.errorCode = 37;
        int[] nArray = new int[]{n, n2, n3};
        this.errorRegistry = nArray;
    }

    private void doPutArc(int n, int n2, int n3) {
        int n4;
        if (this.theDiagram[n2][7] != this.theDiagram[n][7]) {
            this.errorCode = 41;
            int[] nArray = new int[]{n, n2, n3};
            this.errorRegistry = nArray;
            return;
        }
        if (this.isVerticesOriented) {
            this.doChangeVertexState(n, n3, 1);
            if (this.errorCode > 0) {
                return;
            }
            this.doChangeVertexState(n2, n3, 0);
            if (this.errorCode > 0) {
                return;
            }
        } else {
            this.doChangeVertexState(n, n3, 2);
            if (this.errorCode > 0) {
                return;
            }
            this.doChangeVertexState(n2, n3, 2);
            if (this.errorCode > 0) {
                return;
            }
        }
        this.theDiagram[n][n3] = n2;
        this.theDiagram[n2][n3] = n;
        if (this.isVerticesOriented) {
            this.theDiagram[n][6] = n3;
        }
        if ((n4 = this.theDiagram[n2][7]) != -1) {
            int[] nArray = this.stateOfComponents[n4];
            int n5 = n3;
            nArray[n5] = nArray[n5] + 1;
            int[] nArray2 = this.stateOfComponents[n4];
            nArray2[3] = nArray2[3] + 1;
            int n6 = nArray2[3];
            int n7 = this.stateOfComponents[n4][4];
            if (n6 > n7) {
                this.stateOfComponents[n4][4] = n6;
            }
        }
        int n8 = n3;
        this.numArcs[n8] = this.numArcs[n8] + 1;
        this.numArcs[3] = this.numArcs[3] + 1;
    }

    public ThreePageLink() {
        this.stateOfComponents = new int[10][8];
        this.numArcs = new int[4];
    }

    private int doAddComponent(int n, int n2) {
        if (this.stateOfComponents.length == this.numOfComponents) {
            int n3 = this.numOfComponents + 100;
            int[][] nArray = new int[n3][8];
            int n4 = 0;
            while (n4 < this.numOfComponents) {
                int n5 = 0;
                do {
                    nArray[n4][n5] = this.stateOfComponents[n4][n5];
                } while (++n5 < 8);
                ++n4;
            }
            this.stateOfComponents = nArray;
        }
        this.stateOfComponents[this.numOfComponents][5] = n;
        this.stateOfComponents[this.numOfComponents][6] = n2;
        ++this.numOfComponents;
        return this.numOfComponents - 1;
    }

    public void writeDiagramState() {
        int n;
        String string;
        System.out.println("  Number of vertices  " + this.compleXity);
        System.out.println("  Number of arcs  " + this.numArcs[0] + "  " + this.numArcs[1] + "  " + this.numArcs[2] + "  " + this.numArcs[3]);
        System.out.println();
        System.out.println("  lastVertex " + this.lastVertex);
        System.out.println("  freeSpaceEntry " + this.freeSpaceEntry);
        int n2 = 0;
        while (n2 < this.numOfComponents) {
            System.out.println();
            System.out.println("  Component " + n2);
            string = " ";
            n = 0;
            do {
                string = string + this.myFormat(this.stateOfComponents[n2][n]);
            } while (++n < 8);
            System.out.println(string);
            ++n2;
        }
        this.doCheckDiagram(0);
        if (this.errorCode > 0) {
            this.writeErrorMessage();
        }
        System.out.println("      idx page0 page1 page2  prev  next  type  aux   compon  xcoord");
        if (!this.isCoordinateSet) {
            n2 = 0;
            while (n2 < this.maX_Size) {
                string = "  " + this.myFormat(n2);
                n = 0;
                do {
                    string = string + this.myFormat(this.theDiagram[n2][n]);
                } while (++n < 8);
                string = string + "   " + this.x[n2];
                System.out.println(string);
                ++n2;
            }
        } else {
            int n3 = this.theDiagram[this.lastVertex][4];
            n2 = 0;
            while (n2 < this.compleXity) {
                string = "  " + this.myFormat(n3);
                n = 0;
                do {
                    string = string + this.myFormat(this.theDiagram[n3][n]);
                } while (++n < 8);
                string = string + "   " + this.x[n3];
                System.out.println(string);
                this.isCoordinateSet = false;
                ++n2;
                n3 = this.theDiagram[n3][4];
            }
        }
        System.out.println("  queue pointer " + this.queuePointer);
        System.out.println("     vert  page  wait  idx");
        n2 = this.queuePointer;
        while (n2 < this.queueLength) {
            string = "  ";
            n = 0;
            do {
                string = string + this.myFormat(this.newVertexQueue[n2][n]);
            } while (++n < 4);
            System.out.println(string);
            ++n2;
        }
        System.out.println("     base end  page  obst");
        n2 = 0;
        while (n2 < this.numOfNewArcs) {
            string = "  ";
            n = 0;
            do {
                string = string + this.myFormat(this.newArcs[n2][n]);
            } while (++n < 4);
            System.out.println(string);
            ++n2;
        }
    }

    private int doInsertVertex(int n, int n2) {
        int n3;
        this.isDefragmented = false;
        if (this.isVerticesOriented || this.isCoordinateSet) {
            this.errorCode = 3;
            int[] nArray = new int[2];
            if (this.isVerticesOriented) {
                nArray[1] = 1;
            }
            if (this.isCoordinateSet) {
                nArray[2] = 1;
            }
            this.errorRegistry = nArray;
            return -1;
        }
        if (this.compleXity + 1 == this.theDiagram.length) {
            this.errorCode = 1;
            int[] nArray = new int[]{this.compleXity, n};
            this.errorRegistry = nArray;
            return -1;
        }
        if (this.theDiagram[this.freeSpaceEntry][5] != 0) {
            this.errorCode = 2;
            int[] nArray = new int[]{this.freeSpaceEntry, n};
            this.errorRegistry = nArray;
            return -1;
        }
        int n4 = this.freeSpaceEntry;
        if (this.compleXity == 0) {
            n3 = n4;
            n = n4;
            this.lastVertex = n4;
        } else {
            n3 = this.theDiagram[n][4];
        }
        this.freeSpaceEntry = this.theDiagram[this.freeSpaceEntry][4];
        this.theDiagram[n][4] = n4;
        this.theDiagram[n4][3] = n;
        this.theDiagram[n4][4] = n3;
        this.theDiagram[n3][3] = n4;
        this.theDiagram[n4][6] = this.maX_Size;
        this.theDiagram[n4][5] = -1;
        this.theDiagram[n4][7] = n2;
        this.theDiagram[n4][0] = -1;
        this.theDiagram[n4][1] = -1;
        this.theDiagram[n4][2] = -1;
        ++this.compleXity;
        return n4;
    }

    private void doDefrag() {
        int n;
        int n2;
        int[] nArray = new int[this.maX_Size];
        int n3 = this.maX_Size - 2;
        int n4 = 0;
        while (n4 < this.maX_Size) {
            nArray[n4] = n4;
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            if (this.theDiagram[n4][5] != 0) {
                ++n4;
                continue;
            }
            if (this.theDiagram[n3][5] == 0) {
                --n3;
                continue;
            }
            nArray[n4] = n3;
            nArray[n3] = n4;
            this.x[n4] = this.x[n3];
            n2 = 0;
            do {
                n = this.theDiagram[n4][n2];
                this.theDiagram[n4][n2] = this.theDiagram[n3][n2];
                this.theDiagram[n3][n2] = n;
            } while (++n2 < 8);
        }
        if (n3 != this.compleXity) {
            this.errorCode = 221;
            int[] nArray2 = new int[]{n3, this.compleXity};
            this.errorRegistry = nArray2;
            return;
        }
        this.lastVertex = nArray[this.lastVertex];
        this.currVertex = nArray[this.lastVertex];
        this.departVertex = nArray[this.departVertex];
        this.arriveVertex = nArray[this.arriveVertex];
        this.fromVertex = nArray[this.fromVertex];
        this.nextV = nArray[this.nextV];
        this.prevV = nArray[this.prevV];
        this.freeSpaceEntry = nArray[this.freeSpaceEntry];
        n4 = 0;
        while (n4 < this.maX_Size) {
            if (this.theDiagram[n4][5] > 0) {
                n = 0;
                do {
                    if ((n2 = this.theDiagram[n4][n]) < 0) continue;
                    this.theDiagram[n4][n] = nArray[n2];
                } while (++n < 3);
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.maX_Size) {
            n2 = this.theDiagram[n4][4];
            this.theDiagram[n4][4] = nArray[n2];
            n2 = this.theDiagram[n4][3];
            this.theDiagram[n4][3] = nArray[n2];
            ++n4;
        }
        n4 = 0;
        while (n4 < this.numOfComponents) {
            n2 = this.stateOfComponents[n4][5];
            this.stateOfComponents[n4][5] = nArray[n2];
            ++n4;
        }
        n4 = 0;
        while (n4 < this.queueLength) {
            n2 = this.newVertexQueue[n4][0];
            this.newVertexQueue[n4][0] = nArray[n2];
            ++n4;
        }
        n4 = 0;
        while (n4 < this.numOfNewArcs) {
            n2 = this.newArcs[n4][0];
            this.newArcs[n4][0] = nArray[n2];
            n2 = this.newArcs[n4][1];
            this.newArcs[n4][1] = nArray[n2];
            n2 = this.newArcs[n4][3];
            if (n2 >= 0) {
                this.newArcs[n4][3] = nArray[n2];
            }
            ++n4;
        }
        this.isDefragmented = true;
    }

    private void doDeleteVertex(int n) {
        this.isDefragmented = false;
        if (this.isVerticesOriented || this.isCoordinateSet) {
            this.errorCode = 14;
            int[] nArray = new int[2];
            if (this.isVerticesOriented) {
                nArray[0] = 1;
            }
            if (this.isCoordinateSet) {
                nArray[1] = 1;
            }
            this.errorRegistry = nArray;
            return;
        }
        if (this.theDiagram[n][0] != -1 || this.theDiagram[n][1] != -1 || this.theDiagram[n][2] != -1 || this.theDiagram[n][5] != -1) {
            this.errorCode = 11;
            int[] nArray = new int[]{n};
            this.errorRegistry = nArray;
            return;
        }
        int n2 = this.theDiagram[n][7];
        if (n == this.stateOfComponents[n2][5]) {
            this.errorCode = 13;
            int[] nArray = new int[]{n};
            this.errorRegistry = nArray;
            return;
        }
        if (this.compleXity <= 1) {
            this.errorCode = 12;
            int[] nArray = new int[]{n, this.compleXity};
            this.errorRegistry = nArray;
            return;
        }
        if (n == this.departVertex && this.currMode != 11113) {
            this.errorCode = 15;
            int[] nArray = new int[]{n, this.arriveVertex};
            this.errorRegistry = nArray;
            return;
        }
        this.prevV = this.theDiagram[n][3];
        this.nextV = this.theDiagram[n][4];
        if (this.lastVertex == n) {
            this.lastVertex = this.prevV;
        }
        this.theDiagram[n][4] = this.freeSpaceEntry;
        this.theDiagram[this.freeSpaceEntry][3] = n;
        this.theDiagram[n][5] = 0;
        this.freeSpaceEntry = n;
        this.theDiagram[this.prevV][4] = this.nextV;
        this.theDiagram[this.nextV][3] = this.prevV;
        --this.compleXity;
    }

    private int doDeleteArc(int n, int n2) {
        if (this.isVerticesOriented) {
            this.errorCode = 80;
            int[] nArray = new int[]{};
            this.errorRegistry = nArray;
            return -1;
        }
        int n3 = this.theDiagram[n][7];
        int n4 = this.theDiagram[n][n2];
        if (n3 < 0 || n3 > this.numOfComponents) {
            this.errorCode = 81;
            int[] nArray = new int[]{n, n3};
            this.errorRegistry = nArray;
            return -1;
        }
        if (n4 < 0 || n4 > this.maX_Size - 2) {
            this.errorCode = 82;
            int[] nArray = new int[]{n, n2, n4};
            this.errorRegistry = nArray;
            return -1;
        }
        if (n == this.departVertex) {
            this.departVertex = this.theDiagram[this.departVertex][this.departPage];
            this.departPage = (this.departPage + 1) % 3;
            if (this.theDiagram[this.departVertex][this.departPage] == -1) {
                this.departPage = (this.departPage + 1) % 3;
            }
            if (this.theDiagram[this.departVertex][this.departPage] == -1 && this.currMode != 11113) {
                this.errorCode = 305;
                int[] nArray = new int[]{this.currVertex, this.currPage, this.currPlane, this.pageThree, this.departVertex, this.departPage};
                this.errorRegistry = nArray;
                return -1;
            }
        } else if (n == this.arriveVertex) {
            this.arriveVertex = this.theDiagram[this.arriveVertex][this.arrivePage];
            this.arrivePage = (this.arrivePage + 1) % 3;
            if (this.theDiagram[this.arriveVertex][this.arrivePage] == -1) {
                this.arrivePage = (this.arrivePage + 1) % 3;
            }
            if (this.theDiagram[this.arriveVertex][this.arrivePage] == -1 && this.currMode != 11113) {
                this.errorCode = 302;
                int[] nArray = new int[]{this.currVertex, this.currPage, this.currPlane, this.pageThree, this.arriveVertex, this.arrivePage};
                this.errorRegistry = nArray;
                return -1;
            }
        }
        if (n == this.stateOfComponents[n3][5] && n2 == this.stateOfComponents[n3][6] && this.theDiagram[n4][5] == 1) {
            if (this.theDiagram[n4][(n2 + 1) % 3] == -1) {
                this.stateOfComponents[n3][6] = (n2 + 2) % 3;
            }
            if (this.theDiagram[n4][(n2 + 2) % 3] == -1) {
                this.stateOfComponents[n3][6] = (n2 + 1) % 3;
            }
            this.stateOfComponents[n3][5] = n4;
        }
        if (n4 == this.stateOfComponents[n3][5] && n2 == this.stateOfComponents[n3][6] && this.theDiagram[n][5] == 1) {
            if (this.theDiagram[n][(n2 + 1) % 3] == -1) {
                this.stateOfComponents[n3][6] = (n2 + 2) % 3;
            }
            if (this.theDiagram[n][(n2 + 2) % 3] == -1) {
                this.stateOfComponents[n3][6] = (n2 + 1) % 3;
            }
            this.stateOfComponents[n3][5] = n;
        }
        this.doChangeVertexState(n, n2, 3);
        if (this.errorCode > 0) {
            return -1;
        }
        this.doChangeVertexState(n4, n2, 3);
        if (this.errorCode > 0) {
            return -1;
        }
        this.theDiagram[n][n2] = -1;
        this.theDiagram[n4][n2] = -1;
        int n5 = n2;
        this.numArcs[n5] = this.numArcs[n5] + -1;
        int[] nArray = this.stateOfComponents[n3];
        int n6 = n2;
        nArray[n6] = nArray[n6] + -1;
        this.numArcs[3] = this.numArcs[3] + -1;
        int[] nArray2 = this.stateOfComponents[n3];
        nArray2[3] = nArray2[3] + -1;
        return n4;
    }

    public void writeErrorMessage() {
        if (this.errorCode == 0) {
            return;
        }
        System.out.println(" ThreePageLink  errorCode: " + this.errorCode);
        int n = this.errorRegistry.length;
        String string = " ThreePageLink  Errorregistry: ";
        int n2 = 0;
        while (n2 < n) {
            string = string + this.errorRegistry[n2] + "  ";
            ++n2;
        }
        System.out.println(string);
    }

    private void addToQueue(int n, int n2, int n3) {
        if (this.queueLength >= this.newVertexQueue.length) {
            this.errorCode = 330;
            int[] nArray = new int[]{this.queueLength, n, n2, n3};
            this.errorRegistry = nArray;
            return;
        }
        this.newVertexQueue[this.queueLength][0] = n;
        this.newVertexQueue[this.queueLength][1] = n2;
        this.newVertexQueue[this.queueLength][2] = 0;
        this.newVertexQueue[this.queueLength][3] = n3;
        ++this.queueLength;
    }

    private void addToQueue(int n) {
        if (this.queueLength >= this.newVertexQueue.length) {
            this.errorCode = 329;
            int[] nArray = new int[]{this.queueLength, n};
            this.errorRegistry = nArray;
            return;
        }
        this.newVertexQueue[this.queueLength][0] = this.newArcs[n][1];
        this.newVertexQueue[this.queueLength][2] = 1;
        this.newVertexQueue[this.queueLength][3] = n;
        ++this.queueLength;
    }

    public void setInterruptLevel(int n) {
        this.interruptLevel = n;
    }

    private void doCheckDiagram(int n) {
        int n2;
        if (this.lastVertex < 0 || this.lastVertex >= this.maX_Size - 1) {
            this.errorCode = 200;
            int[] nArray = new int[]{this.lastVertex};
            this.errorRegistry = nArray;
            return;
        }
        this.doSetCoordinate();
        if (!this.isCoordinateSet) {
            return;
        }
        if (this.freeSpaceEntry < 0 || this.freeSpaceEntry >= this.maX_Size - 1) {
            this.errorCode = 202;
            int[] nArray = new int[]{this.freeSpaceEntry};
            this.errorRegistry = nArray;
            return;
        }
        int n3 = this.freeSpaceEntry;
        int n4 = this.maX_Size - this.compleXity - 1;
        int n5 = 0;
        while (n5 < n4) {
            if (this.theDiagram[n3][5] != 0) {
                this.errorCode = 203;
                int[] nArray = new int[]{n5, n4, n3};
                this.errorRegistry = nArray;
                return;
            }
            n2 = this.theDiagram[n3][4];
            if (this.theDiagram[n2][3] != n3) {
                this.errorCode = 205;
                int[] nArray = new int[]{n3, n2, this.theDiagram[n2][3]};
                this.errorRegistry = nArray;
                return;
            }
            n3 = n2;
            ++n5;
        }
        if (n3 != this.maX_Size - 1) {
            this.errorCode = 204;
            int[] nArray = new int[]{n4, n3};
            this.errorRegistry = nArray;
            return;
        }
        if (n == 0) {
            return;
        }
        int n6 = 0;
        do {
            n4 = 0;
            n5 = 0;
            while (n5 < this.numOfComponents) {
                n4 += this.stateOfComponents[n5][n6];
                ++n5;
            }
            if (n4 != this.numArcs[n6]) {
                this.errorCode = 209;
                int[] nArray = new int[]{n4, n6};
                this.errorRegistry = nArray;
                return;
            }
            n5 = 0;
            while (n5 < this.numOfComponents) {
                n4 = 0;
                n6 = 0;
                do {
                    n4 += this.stateOfComponents[n5][n6];
                } while (++n6 < 3);
                if (n4 != this.stateOfComponents[n5][3]) {
                    this.errorCode = 210;
                    int[] nArray = new int[]{n5, n4};
                    this.errorRegistry = nArray;
                    return;
                }
                ++n5;
            }
            if (this.numArcs[0] + this.numArcs[1] + this.numArcs[2] == this.numArcs[3]) continue;
            this.errorCode = 211;
            int[] nArray = this.numArcs;
            this.errorRegistry = nArray;
            return;
        } while (++n6 < 3);
        if (n == 0) {
            return;
        }
        n6 = 0;
        do {
            n3 = this.theDiagram[this.lastVertex][4];
            n5 = 0;
            while (n5 < this.compleXity - 1) {
                if ((int)this.x[n3] != n5) {
                    this.errorCode = 201;
                    int[] nArray = new int[]{n5, (int)this.x[n5]};
                    this.errorRegistry = nArray;
                    return;
                }
                n2 = this.theDiagram[n3][n6];
                if (n2 != -1) {
                    if (n2 < 0 || n2 >= this.maX_Size - 1) {
                        this.errorCode = 206;
                        int[] nArray = new int[]{n3, n2, n6};
                        this.errorRegistry = nArray;
                        return;
                    }
                    double d = this.x[n2];
                    double d2 = this.x[n3];
                    if (d > d2) {
                        n4 = n3;
                        while (n4 != n2) {
                            double d3;
                            if (this.x[n4] > d || this.x[n4] < d2) {
                                this.errorCode = 207;
                                int[] nArray = new int[]{n3, n2, n4};
                                this.errorRegistry = nArray;
                                return;
                            }
                            int n7 = this.theDiagram[n4][n6];
                            if (n7 != -1 && ((d3 = this.x[n7]) < d2 || d3 > d)) {
                                this.errorCode = 208;
                                int[] nArray = new int[]{n3, n2, n4, n7, (int)d2, (int)d3, (int)d};
                                this.errorRegistry = nArray;
                                return;
                            }
                            n4 = this.theDiagram[n4][4];
                        }
                    }
                }
                n3 = this.theDiagram[n3][4];
                ++n5;
            }
        } while (++n6 < 3);
        if (n == 1) {
            return;
        }
        if (this.numArcs[3] != this.compleXity) {
            this.errorCode = 212;
            int[] nArray = new int[]{this.numArcs[3], this.compleXity};
            this.errorRegistry = nArray;
            return;
        }
        this.setOrientation();
    }

    public void kNotSimplyFire() {
        this.stepCounter = 0L;
        block31: while (!this.isSimplifyFinished) {
            ++this.stepCounter;
            if (this.currMode <= this.lastMode) {
                switch (this.interruptLevel) {
                    case 0: {
                        if (this.stepCounter < this.maxStepCounter) break;
                        this.stepCounter = 0L;
                        return;
                    }
                    case 1: {
                        if (this.currMode < 100) {
                            this.lastMode = -1;
                            return;
                        }
                    }
                    case 2: {
                        if (this.currMode < 1000) {
                            this.lastMode = -1;
                            return;
                        }
                    }
                    case 3: {
                        if (this.currMode < 10000) {
                            this.lastMode = -1;
                            return;
                        }
                    }
                    case 4: {
                        this.lastMode = -1;
                        return;
                    }
                }
            }
            this.lastMode = this.currMode;
            this.isCoordinateSet = false;
            this.isVerticesOriented = false;
            switch (this.currMode) {
                case 1: {
                    if (this.compleXity < 2) {
                        this.currMode = 2;
                        break;
                    }
                    this.newVertexQueue = new int[4 * this.maX_Size][4];
                    this.newArcs = new int[4 * this.maX_Size][4];
                    this.currComp = 0;
                    this.numOfNonTrivial = this.numOfComponents;
                    this.currMode = 11;
                    this.stepCounter = 0L;
                    break;
                }
                case 11: {
                    this.oldComplexity = this.compleXity;
                    this.compCounter = 0;
                    this.trialCounter = 0;
                    this.currMode = 111;
                    break;
                }
                case 111: {
                    int[] nArray;
                    int n3;
                    if (this.compCounter >= this.numOfNonTrivial * 1) {
                        this.currMode = 112;
                        break;
                    }
                    int n2 = this.stateOfComponents[this.currComp][4];
                    if (this.trialCounter > 1 * n2 || this.stateOfComponents[this.currComp][7] == 1) {
                        this.trialCounter = 0;
                        ++this.compCounter;
                        n3 = 0;
                        do {
                            ++this.currComp;
                            this.currComp %= this.numOfComponents;
                            if (++n3 <= this.numOfComponents) continue;
                            this.errorCode = 307;
                            nArray = new int[]{this.numOfNonTrivial, this.numOfComponents, this.currComp, n3};
                            this.errorRegistry = nArray;
                            return;
                        } while (this.stateOfComponents[this.currComp][7] == 1);
                        this.stateOfComponents[this.currComp][4] = this.stateOfComponents[this.currComp][3];
                    }
                    ++this.trialCounter;
                    this.arriveVertex = this.departVertex = this.stateOfComponents[this.currComp][5];
                    this.departPage = this.stateOfComponents[this.currComp][6];
                    if (this.theDiagram[this.arriveVertex][(this.departPage + 1) % 3] == -1) {
                        this.arrivePage = (this.departPage + 2) % 3;
                    }
                    if (this.theDiagram[this.arriveVertex][(this.departPage + 2) % 3] == -1) {
                        this.arrivePage = (this.departPage + 1) % 3;
                    }
                    this.currPlane = this.departPage + this.arrivePage;
                    this.pageOne = this.arrivePage;
                    this.pageThree = 3 - this.currPlane;
                    this.currMode = 1111;
                    break;
                }
                case 1111: {
                    int[] nArray;
                    if (this.departVertex != this.stateOfComponents[this.currComp][5] || this.departPage != this.stateOfComponents[this.currComp][6]) {
                        this.errorCode = 301;
                        nArray = new int[]{this.departVertex, this.currComp};
                        this.errorRegistry = nArray;
                        return;
                    }
                    if (this.departPage != this.pageThree) {
                        this.currVertex = this.departVertex;
                        this.currPage = this.departPage;
                        this.currMode = 11111;
                        break;
                    }
                    if (this.arrivePage != this.pageThree) {
                        this.pageOne = this.arrivePage;
                        this.currVertex = this.arriveVertex;
                        this.currPage = this.arrivePage;
                        this.currMode = 11111;
                        break;
                    }
                    this.pageTwo = this.currPlane - this.pageOne;
                    this.currMode = 1112;
                    break;
                }
                case 11111: {
                    int[] nArray;
                    if (this.theDiagram[this.departVertex][this.departPage] == this.arriveVertex && this.departPage != this.pageThree) {
                        if (this.theDiagram[this.arriveVertex][this.arrivePage] != this.departVertex) {
                            this.errorCode = 303;
                            nArray = new int[]{this.arriveVertex, this.departVertex};
                            this.errorRegistry = nArray;
                            return;
                        }
                        if (this.stateOfComponents[this.currComp][3] != 1) {
                            this.errorCode = 304;
                            nArray = new int[]{this.arriveVertex, this.departVertex};
                            this.errorRegistry = nArray;
                            return;
                        }
                        this.newTrivComponent = this.currComp;
                        this.currMode = 11113;
                        break;
                    }
                    int n10 = this.doDeleteArc(this.currVertex, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    if (n10 != this.arriveVertex && n10 != this.departVertex) {
                        this.errorCode = 306;
                        nArray = new int[]{this.currVertex, n10, this.arriveVertex, this.departVertex};
                        this.errorRegistry = nArray;
                        return;
                    }
                    if (this.currVertex != this.arriveVertex) {
                        this.doDeleteVertex(this.currVertex);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.currMode = 11112;
                        break;
                    }
                    this.currPage = this.arrivePage;
                    break;
                }
                case 11112: {
                    int[] nArray;
                    if (this.theDiagram[this.prevV][this.pageThree] != this.nextV) {
                        this.currMode = 1111;
                        break;
                    }
                    if (this.theDiagram[this.nextV][this.pageThree] != this.prevV) {
                        this.errorCode = 306;
                        nArray = new int[]{this.prevV, this.nextV, this.pageThree, this.currVertex};
                        this.errorRegistry = nArray;
                        return;
                    }
                    if (this.theDiagram[this.nextV][5] == 4) {
                        if (this.theDiagram[this.nextV][7] != this.currComp) {
                            this.errorCode = 308;
                            nArray = new int[]{this.currComp, this.nextV};
                            this.errorRegistry = nArray;
                            return;
                        }
                        if (this.theDiagram[this.prevV][5] == 4) {
                            if (this.theDiagram[this.prevV][7] != this.currComp) {
                                this.errorCode = 309;
                                nArray = new int[]{this.currComp, this.prevV};
                                this.errorRegistry = nArray;
                                return;
                            }
                            this.newTrivComponent = this.currComp;
                            this.currMode = 11113;
                            break;
                        }
                        this.doDeleteArc(this.nextV, this.pageThree);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.doDeleteVertex(this.nextV);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.currMode = 1111;
                        break;
                    }
                    if (this.theDiagram[this.prevV][5] == 4) {
                        if (this.theDiagram[this.prevV][7] != this.currComp) {
                            this.errorCode = 309;
                            nArray = new int[]{this.currComp, this.prevV};
                            this.errorRegistry = nArray;
                            return;
                        }
                        this.doDeleteArc(this.prevV, this.pageThree);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.doDeleteVertex(this.prevV);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.currMode = 1111;
                        break;
                    }
                    if (this.theDiagram[this.prevV][5] != 1 || this.theDiagram[this.nextV][5] != 1) {
                        this.errorCode = 311;
                        nArray = new int[]{this.prevV};
                        this.errorRegistry = nArray;
                        return;
                    }
                    if (this.theDiagram[this.prevV][this.currPage] == -1) {
                        this.currPage = this.currPlane - this.currPage;
                    }
                    if (this.theDiagram[this.prevV][this.currPage] == -1) {
                        this.errorCode = 312;
                        nArray = new int[]{this.prevV, this.pageThree, this.currPage};
                        this.errorRegistry = nArray;
                        return;
                    }
                    this.currVertex = this.doDeleteArc(this.prevV, this.pageThree);
                    this.currVertex = this.doDeleteArc(this.prevV, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    if (this.currVertex == this.nextV) {
                        this.newTrivComponent = this.theDiagram[this.nextV][7];
                        this.currMode = 11113;
                        break;
                    }
                    this.doDeleteVertex(this.prevV);
                    if (this.errorCode > 0) {
                        return;
                    }
                    int n10 = this.theDiagram[this.nextV][this.currPage];
                    if (n10 == -1) {
                        this.doPutArc(this.currVertex, this.nextV, this.currPage);
                        if (this.errorCode > 0) {
                            return;
                        }
                        this.currMode = 1111;
                        break;
                    }
                    n10 = this.doDeleteArc(this.nextV, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doDeleteVertex(this.nextV);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doPutArc(this.currVertex, n10, this.currPage);
                    this.currMode = 11112;
                    break;
                }
                case 11113: {
                    int[] nArray;
                    this.currVertex = this.stateOfComponents[this.newTrivComponent][5];
                    this.currPage = this.stateOfComponents[this.newTrivComponent][6];
                    int n10 = this.doInsertVertex(this.lastVertex, this.newTrivComponent);
                    if (this.errorCode > 0) {
                        return;
                    }
                    int n3 = this.doInsertVertex(n10, this.newTrivComponent);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.stateOfComponents[this.newTrivComponent][5] = n3;
                    this.stateOfComponents[this.newTrivComponent][6] = 0;
                    this.doPutArc(n3, n10, 0);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doPutArc(n3, n10, 1);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.lastVertex = n3;
                    n10 = this.doDeleteArc(this.currVertex, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doDeleteVertex(n10);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doDeleteVertex(this.currVertex);
                    if (this.errorCode > 0) {
                        return;
                    }
                    if (this.stateOfComponents[this.newTrivComponent][3] != 2) {
                        this.errorCode = 313;
                        nArray = new int[]{this.prevV, this.pageThree, this.currPage};
                        this.errorRegistry = nArray;
                        return;
                    }
                    this.numOfNonTrivial += -1;
                    this.stateOfComponents[this.newTrivComponent][7] = 1;
                    if (this.currComp == this.newTrivComponent) {
                        this.currMode = 11;
                        break;
                    }
                    this.currMode = 11112;
                    break;
                }
                case 1112: {
                    int n3 = this.departVertex;
                    this.departVertex = this.arriveVertex;
                    this.arriveVertex = n3;
                    this.theDiagram[this.departVertex][6] = 0;
                    this.theDiagram[this.arriveVertex][6] = this.compleXity;
                    this.queuePointer = 0;
                    this.numOfNewArcs = 0;
                    this.queueLength = 0;
                    this.addToQueue(this.departVertex, this.pageTwo, -1);
                    this.addToQueue(this.departVertex, this.pageOne, -1);
                    this.currMode = 11121;
                    break;
                }
                case 11121: {
                    int n;
                    int[] nArray;
                    int n3;
                    if (this.queuePointer >= this.queueLength) {
                        this.errorCode = 331;
                        nArray = new int[]{this.queuePointer, this.queueLength};
                        this.errorRegistry = nArray;
                        return;
                    }
                    this.fromVertex = this.newVertexQueue[this.queuePointer][0];
                    this.currPage = this.newVertexQueue[this.queuePointer][1];
                    int n4 = this.newVertexQueue[this.queuePointer][2];
                    this.arcIdx = this.newVertexQueue[this.queuePointer][3];
                    ++this.queuePointer;
                    if (n4 == 1) {
                        this.tryAttachNewArc(this.arcIdx);
                        break;
                    }
                    this.otherPage = this.currPlane - this.currPage;
                    if (this.fromVertex != this.departVertex) {
                        n = this.newArcs[this.arcIdx][2];
                        if (this.theDiagram[this.fromVertex][n] == -1) {
                            this.errorCode = 333;
                            nArray = new int[]{this.arcIdx, this.queuePointer - 1};
                            this.errorRegistry = nArray;
                            return;
                        }
                        if (this.theDiagram[this.fromVertex][n] != this.arcIdx) continue block31;
                    }
                    if ((n3 = this.theDiagram[this.fromVertex][this.currPage]) != -1 && this.newArcs[n3][3] == -1 && (this.theDiagram[this.fromVertex][4] != this.arriveVertex || this.theDiagram[this.fromVertex][this.otherPage] == -1)) continue block31;
                    this.currVertex = this.theDiagram[this.fromVertex][4];
                    this.isCellSearched = false;
                    this.currMode = 11122;
                    this.subMode = 0;
                    break;
                }
                case 11122: {
                    int[] nArray;
                    this.otherPage = this.currPlane - this.currPage;
                    int n3 = 0;
                    while (!this.isCellSearched) {
                        if (n3 > this.compleXity) {
                            System.out.println("Halted");
                            return;
                        }
                        ++n3;
                        switch (this.subMode) {
                            case 0: {
                                if (this.currVertex == this.arriveVertex) {
                                    this.subMode = 1;
                                    break;
                                }
                                if (this.theDiagram[this.currVertex][5] != 1) {
                                    this.errorCode = 334;
                                    nArray = new int[]{this.currVertex, this.arriveVertex, this.departVertex};
                                    this.errorRegistry = nArray;
                                    return;
                                }
                                if (this.theDiagram[this.currVertex][this.currPage] == -1) {
                                    this.subMode = 3;
                                    break;
                                }
                                if (this.theDiagram[this.currVertex][this.otherPage] == -1) {
                                    this.currVertex = this.theDiagram[this.currVertex][this.currPage];
                                    this.subMode = this.theDiagram[this.currVertex][this.otherPage] == -1 ? 3 : 12;
                                    break;
                                }
                                this.subMode = 7;
                                break;
                            }
                            case 1: {
                                this.arcIdx = this.createNewArc(this.fromVertex, this.arriveVertex, this.currPage, -1);
                                if (this.errorCode > 0) {
                                    return;
                                }
                                this.isCellSearched = true;
                                this.tryAttachNewArc(this.arcIdx);
                                if (this.theDiagram[this.arriveVertex][this.currPage] == this.arcIdx) {
                                    this.currVertex = this.arriveVertex;
                                    this.subMode = 0;
                                    this.otherPage = this.currPlane - this.currPage;
                                    this.currObst = -1;
                                    this.theDiagram[this.arriveVertex][this.currPage] = -1;
                                    this.isCellSearched = true;
                                    this.currMode = 11123;
                                    break;
                                }
                                this.numOfNewArcs += -1;
                                this.prevV = this.theDiagram[this.arriveVertex][3];
                                if (this.theDiagram[this.prevV][5] == 1) {
                                    this.prevV = this.doInsertVertex(this.prevV, this.currComp);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                    this.arcIdx = this.createNewArc(this.fromVertex, this.prevV, this.currPage, -1);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                    this.tryAttachNewArc(this.arcIdx);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                }
                                this.isCellSearched = true;
                                this.currMode = 11121;
                                break;
                            }
                            case 3: {
                                this.nextV = this.theDiagram[this.currVertex][4];
                                if (this.nextV == this.arriveVertex) {
                                    this.subMode = 1;
                                    break;
                                }
                                if (this.nextV == this.fromVertex) {
                                    this.currMode = 11121;
                                    this.isCellSearched = true;
                                    break;
                                }
                                if (this.theDiagram[this.nextV][5] == 1) {
                                    this.currVertex = this.doInsertVertex(this.currVertex, this.currComp);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                } else {
                                    this.currVertex = this.nextV;
                                }
                                this.arcIdx = this.createNewArc(this.fromVertex, this.currVertex, this.currPage, -1);
                                if (this.errorCode > 0) {
                                    return;
                                }
                                this.tryAttachNewArc(this.arcIdx);
                                if (this.errorCode > 0) {
                                    return;
                                }
                                this.currVertex = this.theDiagram[this.currVertex][4];
                                this.subMode = 0;
                                break;
                            }
                            case 7: {
                                this.nextV = this.theDiagram[this.currVertex][4];
                                if (this.nextV != this.departVertex) {
                                    if (this.theDiagram[this.nextV][5] > 0) {
                                        this.nextV = this.doInsertVertex(this.currVertex, this.currComp);
                                        if (this.errorCode > 0) {
                                            return;
                                        }
                                    }
                                    this.arcIdx = this.createNewArc(this.fromVertex, this.nextV, this.currPage, this.currVertex);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                    this.addToQueue(this.arcIdx);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                }
                                this.currVertex = this.theDiagram[this.currVertex][this.currPage];
                                if (this.theDiagram[this.currVertex][this.otherPage] == -1) {
                                    this.subMode = 3;
                                    break;
                                }
                                this.subMode = 12;
                                break;
                            }
                            case 12: {
                                this.prevV = this.theDiagram[this.currVertex][3];
                                if (this.prevV != this.departVertex) {
                                    if (this.theDiagram[this.prevV][5] > 0) {
                                        this.prevV = this.doInsertVertex(this.prevV, this.currComp);
                                        if (this.errorCode > 0) {
                                            return;
                                        }
                                    }
                                    this.arcIdx = this.createNewArc(this.fromVertex, this.prevV, this.currPage, this.currVertex);
                                    if (this.errorCode > 0) {
                                        return;
                                    }
                                    this.addToQueue(this.arcIdx);
                                }
                                this.subMode = 3;
                            }
                        }
                    }
                    continue block31;
                }
                case 11123: {
                    int n10;
                    int[] nArray;
                    if (this.currObst == -1) {
                        if (this.fromVertex == this.departVertex) {
                            this.doPutArc(this.fromVertex, this.currVertex, this.currPage);
                            this.currMode = 11124;
                            if (this.theDiagram[this.arriveVertex][this.currPage] == -1) {
                                this.currPage = this.otherPage;
                            }
                            this.fromVertex = this.theDiagram[this.arriveVertex][this.currPage];
                            break;
                        }
                        this.arcIdx = this.theDiagram[this.fromVertex][this.otherPage];
                        if (this.arcIdx != -1) {
                            this.theDiagram[this.fromVertex][0] = -1;
                            this.theDiagram[this.fromVertex][1] = -1;
                            this.theDiagram[this.fromVertex][2] = -1;
                            this.doPutArc(this.fromVertex, this.currVertex, this.currPage);
                            this.currPage = this.otherPage;
                            this.otherPage = this.currPlane - this.currPage;
                            this.currVertex = this.fromVertex;
                            this.fromVertex = this.newArcs[this.arcIdx][0];
                            this.currObst = this.newArcs[this.arcIdx][3];
                            break;
                        }
                        this.arcIdx = this.theDiagram[this.fromVertex][this.currPage];
                        this.currObst = this.newArcs[this.arcIdx][3];
                        if (this.theDiagram[this.currObst][4] != this.fromVertex) {
                            this.errorCode = 336;
                            nArray = new int[]{this.currObst, this.fromVertex, this.currVertex, this.currPage};
                            this.errorRegistry = nArray;
                            return;
                        }
                        this.fromVertex = this.newArcs[this.arcIdx][0];
                        break;
                    }
                    int n5 = this.theDiagram[this.currObst][7];
                    if (this.currObst == this.theDiagram[this.currVertex][4]) {
                        this.prevV = this.theDiagram[this.currVertex][3];
                        this.prevV = this.doInsertVertex(this.prevV, n5);
                        if (this.errorCode > 0) {
                            return;
                        }
                        n10 = this.doDeleteArc(this.currObst, this.currPage);
                        this.doPutArc(n10, this.prevV, this.currPage);
                        this.doPutArc(this.prevV, this.currObst, this.pageThree);
                        this.currObst = -1;
                        break;
                    }
                    if (this.currObst == this.theDiagram[this.currVertex][3]) {
                        this.nextV = this.doInsertVertex(this.currVertex, n5);
                        if (this.errorCode > 0) {
                            return;
                        }
                        n10 = this.doDeleteArc(this.currObst, this.currPage);
                        this.doPutArc(n10, this.nextV, this.currPage);
                        this.doPutArc(this.nextV, this.currObst, this.pageThree);
                        this.currObst = -1;
                        break;
                    }
                    n10 = this.doDeleteArc(this.currObst, this.currPage);
                    this.nextV = this.doInsertVertex(this.currVertex, n5);
                    this.doPutArc(n10, this.nextV, this.currPage);
                    this.prevV = this.theDiagram[this.currVertex][3];
                    this.prevV = this.doInsertVertex(this.prevV, n5);
                    this.doPutArc(this.prevV, this.nextV, this.pageThree);
                    this.doPutArc(this.currObst, this.prevV, this.currPage);
                    this.currObst = -1;
                    break;
                }
                case 11124: {
                    int n3 = this.theDiagram[this.arriveVertex][3];
                    int n10 = this.theDiagram[this.arriveVertex][4];
                    if (this.theDiagram[n10][this.pageThree] != n3) {
                        this.currMode = 11125;
                        break;
                    }
                    int n5 = this.theDiagram[n10][7];
                    this.doDeleteArc(n3, this.pageThree);
                    int n6 = this.doDeleteArc(n3, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    int n7 = this.doDeleteArc(n10, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.prevV = this.theDiagram[this.fromVertex][3];
                    this.prevV = this.doInsertVertex(this.prevV, n5);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.nextV = this.doInsertVertex(this.fromVertex, n5);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doPutArc(this.prevV, n7, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doPutArc(this.nextV, n6, this.currPage);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doPutArc(this.prevV, this.nextV, this.pageThree);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doDeleteVertex(n3);
                    if (this.errorCode > 0) {
                        return;
                    }
                    this.doDeleteVertex(n10);
                    if (this.errorCode <= 0) continue block31;
                    return;
                }
                case 11125: {
                    int[] nArray;
                    int n3 = 0;
                    while (n3 < this.queueLength) {
                        this.currVertex = this.newVertexQueue[n3][0];
                        if (this.theDiagram[this.currVertex][5] != 1 && this.theDiagram[this.currVertex][5] != 0) {
                            this.theDiagram[this.currVertex][0] = -1;
                            this.theDiagram[this.currVertex][1] = -1;
                            this.theDiagram[this.currVertex][2] = -1;
                            this.theDiagram[this.currVertex][5] = -1;
                            this.doDeleteVertex(this.currVertex);
                            if (this.errorCode > 0) {
                                return;
                            }
                        }
                        ++n3;
                    }
                    if (this.compleXity > this.oldComplexity) {
                        this.errorCode = 337;
                        nArray = new int[]{this.compleXity, this.oldComplexity};
                        this.errorRegistry = nArray;
                        return;
                    }
                    this.currMode = this.compleXity < this.oldComplexity ? 11 : 111;
                    break;
                }
                case 112: {
                    int n7;
                    int n;
                    int[] nArray;
                    int n3;
                    this.currMode = 2;
                    int n8 = 0;
                    this.currVertex = this.lastVertex;
                    do {
                        n = 0;
                        do {
                            this.regIon[this.currVertex][n] = -1;
                        } while (++n < 3);
                        this.currVertex = this.theDiagram[this.currVertex][4];
                    } while (this.currVertex != this.lastVertex);
                    n = 0;
                    do {
                        this.currVertex = this.theDiagram[this.currVertex][4];
                        if (this.regIon[this.currVertex][n] != -1) continue;
                        this.prevV = this.currVertex;
                        do {
                            this.regIon[this.prevV][n] = n8;
                            this.nextV = this.theDiagram[this.prevV][4];
                            int n9 = this.prevV = this.theDiagram[this.nextV][n] == -1 ? this.nextV : this.theDiagram[this.nextV][n];
                        } while (this.prevV != this.currVertex);
                        ++n8;
                    } while (this.currVertex != this.lastVertex || ++n < 3);
                    if (n8 != this.compleXity + 3) {
                        this.errorCode = 400;
                        nArray = new int[]{n8, this.compleXity};
                        this.errorRegistry = nArray;
                        this.writeErrorMessage();
                    }
                    int n6 = this.lastVertex;
                    this.isInExMvApplicable = false;
                    do {
                        n7 = this.theDiagram[n6][4];
                        while (n7 != this.lastVertex && !this.isInExMvApplicable) {
                            n3 = 0;
                            n = 0;
                            do {
                                if (this.regIon[n6][n] == this.regIon[n7][n]) {
                                    ++n3;
                                    continue;
                                }
                                this.pageThree = n;
                            } while (++n < 3);
                            if (n3 == 2) {
                                this.isInExMvApplicable = true;
                            }
                            n7 = this.theDiagram[n7][4];
                        }
                    } while ((n6 = this.theDiagram[n6][4]) != this.lastVertex && !this.isInExMvApplicable);
                    this.doSetCoordinate();
                    if (!this.isInExMvApplicable) continue block31;
                    this.setOrientation();
                    if (!this.isVerticesOriented) {
                        System.out.println("  orientation not set ");
                    }
                    n3 = this.theDiagram[n6][3];
                    int n10 = this.theDiagram[n7][3];
                    n8 = this.regIon[n3][this.pageThree];
                    this.prevV = n7;
                    while (this.regIon[this.prevV][this.pageThree] != n8) {
                        this.prevV = this.theDiagram[this.prevV][4];
                    }
                    this.nextV = n10;
                    while (this.regIon[this.nextV][this.pageThree] != n8) {
                        this.nextV = this.theDiagram[this.nextV][3];
                    }
                    this.nextV = this.theDiagram[this.nextV][4];
                    if (this.theDiagram[this.prevV][this.pageThree] != this.nextV) {
                        this.errorCode = 401;
                        nArray = new int[]{this.prevV, this.nextV};
                        this.errorRegistry = nArray;
                        this.writeErrorMessage();
                    }
                    this.theDiagram[n3][4] = n7;
                    this.theDiagram[n7][3] = n3;
                    this.theDiagram[n10][4] = n6;
                    this.theDiagram[n6][3] = n10;
                    n3 = this.theDiagram[this.prevV][4];
                    n10 = this.theDiagram[this.nextV][3];
                    this.theDiagram[this.prevV][4] = this.nextV;
                    this.theDiagram[this.nextV][3] = this.prevV;
                    this.theDiagram[n10][4] = n3;
                    this.theDiagram[n3][3] = n10;
                    this.currComp = this.theDiagram[this.prevV][7];
                    this.stateOfComponents[this.currComp][5] = this.prevV;
                    this.stateOfComponents[this.currComp][6] = this.theDiagram[this.prevV][6];
                    this.currMode = 11;
                    break;
                }
                case 2: {
                    this.isSimplifyFinished = true;
                    return;
                }
                default: {
                    this.errorCode = 300;
                    int[] nArray = new int[]{this.currMode};
                    this.errorRegistry = nArray;
                    return;
                }
            }
        }
    }

    public void kb_to_3P(PgKnotBook pgKnotBook) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = pgKnotBook.getNumPages();
        if (n4 != 3) {
            this.errorCode = 102;
            return;
        }
        int n5 = pgKnotBook.getNumVertices();
        if (n5 < 2) {
            this.errorCode = 103;
            int[] nArray = new int[]{n5};
            this.errorRegistry = nArray;
            this.writeErrorMessage();
            return;
        }
        if (n5 != pgKnotBook.getNumArcs()) {
            this.errorCode = 104;
            int[] nArray = new int[]{n5, pgKnotBook.getNumArcs()};
            this.errorRegistry = nArray;
            this.writeErrorMessage();
            return;
        }
        this.doCreateEmptyDiagram(n5);
        PdVector[] pdVectorArray = pgKnotBook.getVertices();
        this.x[0] = pdVectorArray[0].getEntry(0);
        this.doInsertVertex(0, -1);
        if (this.errorCode > 0) {
            return;
        }
        int n6 = 1;
        while (n6 < n5) {
            if (n6 != this.compleXity) {
                this.errorCode = 106;
                int[] nArray = new int[]{n6, this.compleXity, n5};
                this.errorRegistry = nArray;
                this.writeErrorMessage();
                return;
            }
            this.x[n6] = pdVectorArray[n6].getEntry(0);
            boolean bl = true;
            n2 = 0;
            while (bl && n2 < this.compleXity) {
                int n7 = this.theDiagram[n2][4];
                n3 = n2;
                bl = this.x[n2] < this.x[n7] & this.x[n7] < this.x[n6];
                bl = this.x[n7] < this.x[n6] & this.x[n6] < this.x[n2] || bl;
                bl = this.x[n6] < this.x[n2] & this.x[n2] < this.x[n7] || bl;
                ++n2;
            }
            if (bl) {
                this.errorCode = 101;
                int[] nArray = new int[]{n6, n2, this.compleXity, n5};
                this.errorRegistry = nArray;
                this.writeErrorMessage();
                return;
            }
            int n8 = this.doInsertVertex(n3, -1);
            if (n8 != n6) {
                this.errorCode = 105;
                int[] nArray = new int[]{n6, n2};
                this.errorRegistry = nArray;
                this.writeErrorMessage();
                return;
            }
            ++n6;
        }
        if (this.compleXity != n5) {
            this.errorCode = 107;
            int[] nArray = new int[]{this.compleXity, n5};
            this.errorRegistry = nArray;
            this.writeErrorMessage();
            return;
        }
        PgKnotArc pgKnotArc = new PgKnotArc();
        this.isVerticesOriented = true;
        n6 = 0;
        while (n6 < this.compleXity) {
            pgKnotArc = pgKnotBook.getArc(n6);
            int n9 = pgKnotArc.getBase();
            int n10 = pgKnotArc.getEnd();
            n = pgKnotArc.getPage();
            if (n9 < 0 || n9 >= this.compleXity) {
                this.errorCode = 120;
                int[] nArray = new int[]{this.compleXity, n9, n10, n};
                this.errorRegistry = nArray;
                this.writeErrorMessage();
                return;
            }
            if (n10 < 0 || n10 >= this.compleXity) {
                this.errorCode = 121;
                int[] nArray = new int[]{this.compleXity, n9, n10, n};
                this.errorRegistry = nArray;
                this.writeErrorMessage();
                return;
            }
            if (n < 0 || n >= 3) {
                this.errorCode = 122;
                int[] nArray = new int[]{this.compleXity, n9, n10, n};
                this.errorRegistry = nArray;
                this.writeErrorMessage();
                return;
            }
            this.doPutArc(n9, n10, n);
            if (this.errorCode > 0) {
                return;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.compleXity) {
            if (this.theDiagram[n6][7] == -1) {
                n2 = n6;
                n = this.theDiagram[n6][6];
                int n11 = this.doAddComponent(n6, n);
                do {
                    n = this.theDiagram[n2][6];
                    this.theDiagram[n2][7] = n11;
                    int[] nArray = this.stateOfComponents[n11];
                    int n12 = n;
                    nArray[n12] = nArray[n12] + 1;
                    int[] nArray2 = this.stateOfComponents[n11];
                    nArray2[3] = nArray2[3] + 1;
                    int n13 = nArray2[3];
                    if (n13 <= this.compleXity) continue;
                    this.errorCode = 110;
                    int[] nArray3 = this.stateOfComponents[n11];
                    this.errorRegistry = nArray3;
                    this.writeErrorMessage();
                    return;
                } while ((n2 = this.theDiagram[n2][n]) != n6);
                this.stateOfComponents[n11][4] = this.stateOfComponents[n11][3];
                n2 = this.stateOfComponents[n11][0];
                n2 += this.stateOfComponents[n11][1];
                if ((n2 += this.stateOfComponents[n11][2]) != this.stateOfComponents[n11][3]) {
                    this.errorCode = 111;
                    int[] nArray = this.stateOfComponents[n11];
                    this.errorRegistry = nArray;
                    this.writeErrorMessage();
                    return;
                }
            }
            ++n6;
        }
        this.lastVertex = this.theDiagram[0][3];
        n2 = 0;
        n6 = 0;
        while (n6 < this.numOfComponents) {
            n2 += this.stateOfComponents[n6][3];
            ++n6;
        }
        if (n2 != this.compleXity) {
            this.errorCode = 112;
            int[] nArray = new int[]{n2, this.compleXity};
            this.errorRegistry = nArray;
            this.writeErrorMessage();
            return;
        }
    }

    private String myFormat(int n) {
        String string = new String();
        if (n >= 0 && n < 10) {
            string = "     " + n;
        }
        if (n >= 10 && n < 100) {
            string = "    " + n;
        }
        if (n >= 100 && n < 1000) {
            string = "   " + n;
        }
        if (n >= 1000 && n < 10000) {
            string = "  " + n;
        }
        if (n >= 10000) {
            string = " " + n;
        }
        if (n > -10 && n < 0) {
            string = "    " + n;
        }
        if (n > -100 && n <= -10) {
            string = "   " + n;
        }
        if (n > -1000 && n <= -100) {
            string = "  " + n;
        }
        if (n > -10000 && n <= -1000) {
            string = " " + n;
        }
        if (n <= -10000) {
            string = "" + n;
        }
        return string;
    }

    private void doCreateEmptyDiagram(int n) {
        if (n <= 1) {
            this.errorCode = 51;
            int[] nArray = new int[]{n};
            this.errorRegistry = nArray;
            return;
        }
        this.maX_Size = 2 * n + 2;
        this.theDiagram = new int[this.maX_Size][8];
        this.x = new double[this.maX_Size];
        this.regIon = new int[this.maX_Size][3];
        int n2 = 0;
        while (n2 < this.maX_Size - 1) {
            this.theDiagram[n2][4] = n2 + 1;
            this.theDiagram[n2 + 1][3] = n2;
            this.theDiagram[n2][5] = 0;
            ++n2;
        }
        this.freeSpaceEntry = 0;
    }

    private int createNewArc(int n, int n2, int n3, int n4) {
        if (this.numOfNewArcs >= this.newArcs.length) {
            this.errorCode = 332;
            int[] nArray = new int[]{this.numOfNewArcs, n, n2, n3};
            this.errorRegistry = nArray;
            return -1;
        }
        this.newArcs[this.numOfNewArcs][0] = n;
        this.newArcs[this.numOfNewArcs][1] = n2;
        this.newArcs[this.numOfNewArcs][2] = n3;
        this.newArcs[this.numOfNewArcs][3] = n4;
        ++this.numOfNewArcs;
        return this.numOfNewArcs - 1;
    }

    private void tryAttachNewArc(int n) {
        int n2 = this.newArcs[n][0];
        int n3 = this.newArcs[n][1];
        int n4 = this.newArcs[n][2];
        int n5 = this.newArcs[n][3];
        this.otherPage = this.currPlane - n4;
        int n6 = this.theDiagram[n2][6] + 1;
        if (n5 != -1) {
            ++n6;
        }
        int n7 = this.theDiagram[n3][6];
        int n8 = this.theDiagram[n3][5];
        if (n7 < n6) {
            return;
        }
        int n9 = -2;
        if (this.theDiagram[n2][5] == -3 || this.theDiagram[n2][this.otherPage] != -1) {
            n9 = -3;
        }
        if (n6 == n7) {
            if (n8 == -3) {
                return;
            }
            if (n9 == -2 && this.theDiagram[n3][n4] != -1) {
                return;
            }
        }
        if (n3 == this.arriveVertex && n9 == -2 && n2 != this.departVertex) {
            return;
        }
        this.theDiagram[n3][n4] = n;
        if (this.theDiagram[n3][this.otherPage] != -1) {
            if (n6 != n7) {
                this.errorCode = 335;
                int[] nArray = new int[]{n6, n7, n3};
                this.errorRegistry = nArray;
                return;
            }
            n9 = -3;
        }
        this.theDiagram[n3][6] = n6;
        if (n3 != this.arriveVertex) {
            this.theDiagram[n3][5] = n9;
            this.addToQueue(n3, this.otherPage, n);
            if (n5 == this.theDiagram[n3][3]) {
                this.addToQueue(n3, n4, n);
            }
        }
    }

    private void setOrientation() {
        this.isVerticesOriented = false;
        int n = 0;
        while (n < this.numOfComponents) {
            int n2 = this.stateOfComponents[n][5];
            int n3 = this.stateOfComponents[n][6];
            int n4 = this.stateOfComponents[n][3];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                if (n3 < 0 || n3 > 2) {
                    this.errorCode = 75;
                    int[] nArray = new int[]{n, n6, n5};
                    this.errorRegistry = nArray;
                    return;
                }
                this.theDiagram[n5][6] = n3;
                if (n6 > 0 && n5 == n2) {
                    this.errorCode = 70;
                    int[] nArray = new int[]{n6, n5, n4};
                    this.errorRegistry = nArray;
                    return;
                }
                if (this.theDiagram[n5][7] != n) {
                    this.errorCode = 73;
                    int[] nArray = new int[]{n6, n5, this.theDiagram[n5][7]};
                    this.errorRegistry = nArray;
                    return;
                }
                if (this.theDiagram[n5][5] != 1 && this.currMode < 1000) {
                    this.errorCode = 72;
                    int[] nArray = new int[]{n6, n5};
                    this.errorRegistry = nArray;
                    return;
                }
                int n7 = this.theDiagram[n5][n3];
                if (n7 < 0 || n7 >= this.maX_Size - 1) {
                    this.errorCode = 76;
                    int[] nArray = new int[]{n6, n5};
                    this.errorRegistry = nArray;
                    return;
                }
                if (this.theDiagram[n7][n3] != n5) {
                    this.errorCode = 71;
                    int[] nArray = new int[]{n6, n5, n7};
                    this.errorRegistry = nArray;
                    return;
                }
                n5 = n7;
                if (this.theDiagram[n5][(n3 + 1) % 3] == -1) {
                    n3 = (n3 + 2) % 3;
                } else if (this.theDiagram[n5][(n3 + 2) % 3] == -1) {
                    n3 = (n3 + 1) % 3;
                } else if (this.currMode < 1000 || this.theDiagram[n7][5] != 4) {
                    this.errorCode = 74;
                    int[] nArray = new int[]{n, n6, n5};
                    this.errorRegistry = nArray;
                    return;
                }
                ++n6;
            }
            ++n;
        }
        this.isVerticesOriented = true;
    }
}

