/*
 * Decompiled with CFR 0.152.
 */
package dev.app.ruler;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgPolygonSet;
import jv.number.PdVector_IP;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgRuler
extends PgPolygonSet {
    private final int SF = 10;
    protected boolean m_bFixedMode;
    protected boolean m_bMajorMode;
    protected boolean m_bMinorMode;
    protected PuDouble m_min;
    protected PuDouble m_max;
    protected double[] m_tiMajor;
    protected double[] m_tiMinor;
    protected PdVector m_v3InitPt;
    protected PdVector m_v3FinlPt;
    protected PdVector m_v = new PdVector(3);
    protected PdVector m_vu = new PdVector(3);
    protected PdVector m_vup = new PdVector(3);
    protected double m_hMinor;
    protected double m_hMajor;
    protected PuInteger m_numMajorHashings;
    protected PuInteger m_numMinorHashings;
    protected PdVector m_fixedHashUnits;
    protected PdVector_IP m_pfixedHashUnits;
    private double m_defMin = 0.0;
    private double m_defMax = 0.0;
    private double m_defMajorHashUnit = 10.0;
    private double m_defMinorHashUnit = 2.0;
    private int m_defNumMajorHashings = 5;
    private int m_defNumMinorHashings = 2;
    private double m_defhMajor = 1.618033;
    private double m_defhMinor = 0.618033;
    private boolean m_defbFixedMode = true;
    private Color m_defhMajorColor = new Color(55, 55, 255);
    private Color m_defhMinorColor = new Color(55, 200, 55);
    public boolean m_bReset = false;
    private static /* synthetic */ Class class$dev$app$ruler$PgRuler;

    public boolean isShowingMajorHashings() {
        return this.m_bMajorMode;
    }

    public void showMajorHashings(boolean bl) {
        if (this.m_bMajorMode == bl) {
            return;
        }
        this.m_bMajorMode = bl;
    }

    protected void ConstructHashSet(PgPolygonSet pgPolygonSet, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, double[] dArray, double d, boolean bl) {
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        pdVector4.copy(pdVector3);
        pdVector4.multScalar(d);
        int n = pgPolygonSet.getNumVertices();
        int n2 = pgPolygonSet.getNumPolygons();
        pgPolygonSet.setNumVertices(n + 2 * dArray.length);
        pgPolygonSet.setNumPolygons(n2 + dArray.length);
        int n3 = n;
        int n4 = 0;
        while (n4 < dArray.length) {
            pdVector5.copy(pdVector2);
            pdVector5.multScalar(dArray[n4]);
            pdVector5.add(pdVector);
            pgPolygonSet.setVertex(n3, pdVector5);
            pdVector5.add(pdVector4);
            pgPolygonSet.setVertex(n3 + 1, pdVector5);
            pgPolygonSet.setPolygon(n2 + n4, new PiVector(n3, n3 + 1));
            PiVector piVector = pgPolygonSet.getPolygon(n2 + n4);
            if (bl) {
                piVector.setTag(1);
                pgPolygonSet.getVertex(piVector.getEntry(1)).setName(String.valueOf(dArray[n4]));
            }
            ++n3;
            ++n3;
            ++n4;
        }
    }

    protected double[] HashInterval(double d, double d2, boolean bl, double d3, boolean bl2) {
        Vector<Double> vector = new Vector<Double>();
        double d4 = !bl ? 1 : 0;
        double d5 = !bl2 ? 1 : 0;
        double d6 = d * Math.ceil((d2 + d4) / d);
        double d7 = d * Math.floor((d3 - d5) / d);
        double d8 = d6;
        while (d8 <= d7) {
            vector.addElement(new Double(d8));
            d8 += d;
        }
        double[] dArray = new double[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Double d9 = (Double)vector.elementAt(n);
            dArray[n] = d9;
            ++n;
        }
        return dArray;
    }

    protected double[] PartitionInterval(int n, double d, boolean bl, double d2, boolean bl2) {
        Vector<Double> vector = new Vector<Double>();
        double d3 = !bl ? 1 : 0;
        double d4 = !bl2 ? 1 : 0;
        double d5 = (d2 - d) / (double)(n + 1);
        double d6 = d + d3 * d5;
        double d7 = d2 - d4 * d5;
        double d8 = d6;
        while ((float)d8 <= (float)d7) {
            vector.addElement(new Double(d8));
            d8 += d5;
        }
        double[] dArray = new double[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            Double d9 = (Double)vector.elementAt(n2);
            dArray[n2] = d9;
            ++n2;
        }
        return dArray;
    }

    public PgRuler() {
        super(3);
        this.m_min = new PuDouble("Min", (PsUpdateIf)this);
        this.m_max = new PuDouble("Max", (PsUpdateIf)this);
        this.m_fixedHashUnits = new PdVector(this.m_defMajorHashUnit, this.m_defMinorHashUnit);
        this.m_pfixedHashUnits = new PdVector_IP();
        this.m_pfixedHashUnits.setTitle("Major|Minor Units:");
        this.m_pfixedHashUnits.setParent((PsUpdateIf)this);
        this.m_pfixedHashUnits.setVector(this.m_fixedHashUnits);
        this.m_numMajorHashings = new PuInteger("Major Hashings", (PsUpdateIf)this);
        this.m_numMinorHashings = new PuInteger("Minor Hashings", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$dev$app$ruler$PgRuler != null ? class$dev$app$ruler$PgRuler : (class$dev$app$ruler$PgRuler = PgRuler.class$("dev.app.ruler.PgRuler")))) {
            this.init();
        }
    }

    public void SetMajorMinorHashLen(double d, double d2) {
        this.m_hMajor = d;
        this.m_hMinor = d2;
    }

    private void makeUnit_PerpUnit(PdVector pdVector) {
        double d = pdVector.m_data[0];
        pdVector.m_data[0] = -pdVector.m_data[1];
        pdVector.m_data[1] = d;
        pdVector.m_data[2] = pdVector.m_data[2];
    }

    public boolean isShowingMinorHashings() {
        return this.m_bMinorMode;
    }

    public void showMinorHashings(boolean bl) {
        if (this.m_bMinorMode == bl) {
            return;
        }
        this.m_bMinorMode = bl;
    }

    protected void ComputeHashings() {
        this.ComputeBaseLine();
        if (this.m_bFixedMode) {
            this.ComputeFixedHashings();
            return;
        }
        this.ComputeDynamicHashings();
    }

    public boolean update(Object object) {
        if (object == this) {
            if (!this.m_bReset) {
                this.ComputeHashings();
            }
            return super.update((Object)this);
        }
        if (object == this.m_min) {
            if (this.m_min.getValue() <= this.m_max.getValue()) {
                this.ComputeHashings();
            } else {
                this.m_min.setValue(this.m_max.getValue());
            }
            return super.update(null);
        }
        if (object == this.m_max) {
            if (this.m_max.getValue() >= this.m_min.getValue()) {
                this.ComputeHashings();
            } else {
                this.m_max.setValue(this.m_min.getValue());
            }
            return super.update(null);
        }
        if (object == this.m_pfixedHashUnits) {
            this.ComputeHashings();
            return super.update(null);
        }
        if (object == this.m_numMajorHashings || object == this.m_numMinorHashings) {
            this.ComputeHashings();
            return super.update(null);
        }
        return super.update(object);
    }

    protected void ComputeBaseLine() {
        this.setNumVertices(2);
        PdVector pdVector = new PdVector();
        pdVector.copy(this.m_vu);
        pdVector.multScalar(this.m_min.getValue());
        pdVector.add(this.m_v3InitPt);
        this.setVertex(0, pdVector);
        pdVector.copy(this.m_vu);
        pdVector.multScalar(this.m_max.getValue());
        pdVector.add(this.m_v3InitPt);
        this.setVertex(1, pdVector);
        this.setNumPolygons(1);
        this.setPolygon(0, new PiVector(0, 1));
        this.getPolygon(0).setTag(1);
    }

    public boolean isShowingFixedMode() {
        return this.m_bFixedMode;
    }

    public void showFixedMode(boolean bl) {
        if (this.m_bFixedMode == bl) {
            return;
        }
        this.m_bFixedMode = bl;
    }

    protected void ComputeFixedHashings() {
        int n;
        double d;
        int n2;
        this.m_tiMajor = this.HashInterval(this.m_fixedHashUnits.getEntry(0), this.m_min.getValue(), true, this.m_max.getValue(), true);
        if (this.m_bMajorMode) {
            this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMajor, this.m_hMajor, true);
            if (this.m_bMinorMode) {
                n2 = this.m_tiMajor.length;
                if (n2 == 0) {
                    this.m_tiMinor = this.HashInterval(this.m_fixedHashUnits.getEntry(1), this.m_min.getValue(), true, this.m_max.getValue(), true);
                    this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMinor, this.m_hMinor, false);
                } else {
                    d = this.m_fixedHashUnits.getEntry(1);
                    this.m_tiMinor = this.HashInterval(d, this.m_min.getValue(), true, this.m_tiMajor[0], false);
                    this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMinor, this.m_hMinor, false);
                    this.m_tiMinor = this.HashInterval(d, this.m_tiMajor[n2 - 1], false, this.m_max.getValue(), true);
                    this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMinor, this.m_hMinor, false);
                    n = 1;
                    while (n < n2) {
                        this.m_tiMinor = this.HashInterval(d, this.m_tiMajor[n - 1], false, this.m_tiMajor[n], false);
                        this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMinor, this.m_hMinor, false);
                        ++n;
                    }
                }
            }
        }
        if (this.m_bMinorMode && !this.m_bMajorMode) {
            this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMajor, this.m_hMinor, true);
            n2 = this.m_tiMajor.length;
            if (n2 == 0) {
                this.m_tiMinor = this.HashInterval(this.m_fixedHashUnits.getEntry(1), this.m_min.getValue(), true, this.m_max.getValue(), true);
                this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMinor, this.m_hMinor, false);
                return;
            }
            d = this.m_fixedHashUnits.getEntry(1);
            this.m_tiMinor = this.HashInterval(d, this.m_min.getValue(), true, this.m_tiMajor[0], false);
            this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMinor, this.m_hMinor, false);
            this.m_tiMinor = this.HashInterval(d, this.m_tiMajor[n2 - 1], false, this.m_max.getValue(), true);
            this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMinor, this.m_hMinor, false);
            n = 1;
            while (n < n2) {
                this.m_tiMinor = this.HashInterval(d, this.m_tiMajor[n - 1], false, this.m_tiMajor[n], false);
                this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMinor, this.m_hMinor, false);
                ++n;
            }
        }
    }

    protected void ComputeDynamicHashings() {
        int n;
        this.m_tiMajor = this.PartitionInterval(this.m_numMajorHashings.getValue(), this.m_min.getValue(), true, this.m_max.getValue(), true);
        if (this.m_bMajorMode) {
            this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMajor, this.m_hMajor, true);
            if (this.m_bMinorMode) {
                n = 1;
                while (n < this.m_tiMajor.length) {
                    this.m_tiMinor = this.PartitionInterval(this.m_numMinorHashings.getValue(), this.m_tiMajor[n - 1], false, this.m_tiMajor[n], false);
                    this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMinor, this.m_hMinor, false);
                    ++n;
                }
            }
        }
        if (this.m_bMinorMode && !this.m_bMajorMode) {
            this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMajor, this.m_hMinor, true);
            n = 1;
            while (n < this.m_tiMajor.length) {
                this.m_tiMinor = this.PartitionInterval(this.m_numMinorHashings.getValue(), this.m_tiMajor[n - 1], false, this.m_tiMajor[n], false);
                this.ConstructHashSet(this, this.m_v3InitPt, this.m_vu, this.m_vup, this.m_tiMinor, this.m_hMinor, false);
                ++n;
            }
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void SetDefMinMajHashingBounds() {
        this.m_numMajorHashings.setDefValue(this.m_defNumMajorHashings);
        this.m_numMinorHashings.setDefValue(this.m_defNumMinorHashings);
        this.m_numMajorHashings.setDefBounds(0, 60, 1, 1);
        this.m_numMinorHashings.setDefBounds(0, 30, 1, 1);
    }

    public void SetDefMinMaxBounds() {
        this.m_min.setDefValue(this.m_defMin);
        this.m_max.setDefValue(this.m_defMax);
        this.m_min.setDefBounds(-100.0, 100.0, 0.1, 1.0);
        this.m_max.setDefBounds(-100.0, 100.0, 0.1, 1.0);
    }

    public void init() {
        super.init();
        this.m_bFixedMode = this.m_defbFixedMode;
        this.m_bMajorMode = true;
        this.m_bMinorMode = true;
        this.m_v3InitPt = new PdVector(3);
        this.m_v3FinlPt = new PdVector(3);
        this.m_hMajor = this.m_defhMajor;
        this.m_hMinor = this.m_defhMinor;
        this.SetDefMinMaxBounds();
        this.m_min.init();
        this.m_max.init();
        this.SetDefMinMajHashingBounds();
        this.m_numMajorHashings.init();
        this.m_numMinorHashings.init();
        this.showVertices(true);
        this.setDefaultLabelEnabled(false);
        this.showIndices(false);
        this.setGlobalPolygonSize(1.0);
        this.setGlobalVertexSize(0);
        this.setGlobalPolygonColor(this.m_defhMinorColor);
        this.setGlobalPolygonTagColor(this.m_defhMajorColor);
    }

    public void SetInitPoint(PdVector pdVector) {
        this.m_min.init();
        this.m_v3InitPt.copy(pdVector);
    }

    public void SetFinalPoint(PdVector pdVector) {
        this.m_v3FinlPt.copy(pdVector);
        this.m_v.sub(this.m_v3FinlPt, this.m_v3InitPt);
        this.m_vu.copy(this.m_v);
        this.m_vu.normalize();
        this.m_vup.copy(this.m_vu);
        this.makeUnit_PerpUnit(this.m_vup);
        this.m_max.setValue(this.m_v.length());
    }
}

