/*
 * Decompiled with CFR 0.152.
 */
package dev.app.tetraset;

import dev.app.tetraset.PgTetraSet;
import java.util.Vector;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PwTetraRivara {
    private static final int NUM = 4;
    private PgTetraSet m_geom;
    private PiVector[] m_neighbour;
    private int[] m_refinementEdge;
    private PiVector[] m_refinementEdges;
    private int[] m_refinementType;
    private PiVector[] m_tetra;
    private PdVector[] m_vertex;

    public PwTetraRivara(PgTetraSet pgTetraSet) {
        this.m_geom = pgTetraSet;
        this.loadMembers();
        this.m_refinementEdge = new int[0];
        this.m_refinementEdges = new PiVector[0];
        this.m_refinementType = new int[0];
        this.init();
    }

    private void assureRefinement() {
        int[] nArray;
        int n = this.m_refinementEdge.length;
        int n2 = this.m_geom.getNumElements();
        if (n != n2) {
            nArray = new int[n2];
            System.arraycopy(this.m_refinementEdge, 0, nArray, 0, n2 <= n ? n2 : n);
            this.m_refinementEdge = nArray;
        }
        if ((n = this.m_refinementEdges.length) != n2) {
            this.m_refinementEdges = PiVector.realloc((PiVector[])this.m_refinementEdges, (int)n2, (int)4);
        }
        n = 0;
        while (n < n2) {
            this.m_refinementEdges[n].setConstant(-1);
            ++n;
        }
        n = this.m_refinementType.length;
        if (n != n2) {
            nArray = new int[n2];
            System.arraycopy(this.m_refinementType, 0, nArray, 0, n2 <= n ? n2 : n);
            this.m_refinementType = nArray;
        }
    }

    private void makeRefinementType() {
        int n = 0;
        while (n < this.m_refinementEdge.length) {
            if (n >= this.m_refinementEdges.length || n >= this.m_refinementEdge.length || n >= this.m_refinementType.length) {
                return;
            }
            int[] nArray = this.m_refinementEdges[n].m_data;
            int n2 = -1;
            if (nArray[0] == nArray[1]) {
                n2 = nArray[2] == 3 && nArray[3] == 0 || nArray[2] == 4 && nArray[3] == 1 ? 0 : (nArray[2] == 3 && nArray[3] == 1 || nArray[2] == 4 && nArray[3] == 0 ? 1 : -1);
            } else if (nArray[0] == nArray[2]) {
                n2 = nArray[1] == 3 && nArray[3] == 0 || nArray[1] == 5 && nArray[3] == 2 ? 0 : (nArray[1] == 3 && nArray[3] == 2 || nArray[1] == 5 && nArray[3] == 0 ? 1 : -1);
            } else if (nArray[0] == nArray[3]) {
                n2 = nArray[1] == 1 && nArray[2] == 4 || nArray[1] == 5 && nArray[2] == 2 ? 0 : (nArray[1] == 1 && nArray[2] == 2 || nArray[1] == 5 && nArray[2] == 4 ? 1 : -1);
            } else if (nArray[1] == nArray[2]) {
                n2 = nArray[0] == 4 && nArray[3] == 1 || nArray[0] == 5 && nArray[3] == 2 ? 0 : (nArray[0] == 4 && nArray[3] == 2 || nArray[0] == 5 && nArray[3] == 1 ? 1 : -1);
            } else if (nArray[1] == nArray[3]) {
                n2 = nArray[0] == 0 && nArray[2] == 3 || nArray[0] == 5 && nArray[2] == 2 ? 0 : (nArray[0] == 0 && nArray[2] == 2 || nArray[0] == 5 && nArray[2] == 3 ? 1 : -1);
            } else if (nArray[2] == nArray[3]) {
                n2 = nArray[0] == 0 && nArray[1] == 3 || nArray[0] == 4 && nArray[1] == 1 ? 0 : (nArray[0] == 0 && nArray[1] == 1 || nArray[0] == 4 && nArray[1] == 3 ? 1 : -1);
            }
            this.m_refinementType[n] = n2;
            ++n;
        }
    }

    private int addElement(PiVector piVector) {
        int[] nArray;
        int n = this.m_geom.addElement(piVector);
        if (n == -1) {
            return -1;
        }
        this.m_tetra = this.m_geom.getElements();
        this.m_neighbour = this.m_geom.getNeighbours();
        int n2 = this.m_refinementEdge.length;
        int n3 = this.m_geom.getMaxNumElements();
        if (n2 != n3) {
            nArray = new int[n3];
            System.arraycopy(this.m_refinementEdge, 0, nArray, 0, n3 <= n2 ? n3 : n2);
            this.m_refinementEdge = nArray;
        }
        this.m_refinementEdges = PiVector.realloc((PiVector[])this.m_refinementEdges, (int)n3, (int)4);
        n2 = this.m_refinementType.length;
        if (n2 != n3) {
            nArray = new int[n3];
            System.arraycopy(this.m_refinementType, 0, nArray, 0, n3 <= n2 ? n3 : n2);
            this.m_refinementType = nArray;
        }
        return n;
    }

    private void makeRefinementEdges() {
        int n = 0;
        while (n < this.m_refinementEdge.length) {
            int[][] nArrayArray = new int[6][];
            nArrayArray[0] = new int[]{1, 2};
            int[] nArray = new int[2];
            nArray[1] = 2;
            nArrayArray[1] = nArray;
            int[] nArray2 = new int[2];
            nArray2[1] = 1;
            nArrayArray[2] = nArray2;
            int[] nArray3 = new int[2];
            nArray3[1] = 3;
            nArrayArray[3] = nArray3;
            nArrayArray[4] = new int[]{1, 3};
            nArrayArray[5] = new int[]{2, 3};
            int[][] nArrayArray2 = nArrayArray;
            if (n >= this.m_refinementEdges.length) {
                return;
            }
            int[] nArray4 = this.m_tetra[n].m_data;
            int[] nArray5 = this.m_refinementEdges[n].m_data;
            int n2 = this.findRefinementEdgeInTriangle(nArray4[1], nArray4[2], nArray4[3]);
            nArray5[0] = n2 == 0 ? 5 : (n2 == 1 ? 4 : 0);
            n2 = this.findRefinementEdgeInTriangle(nArray4[0], nArray4[2], nArray4[3]);
            nArray5[1] = n2 == 0 ? 5 : (n2 == 1 ? 3 : 1);
            n2 = this.findRefinementEdgeInTriangle(nArray4[0], nArray4[1], nArray4[3]);
            nArray5[2] = n2 == 0 ? 4 : (n2 == 1 ? 3 : 2);
            nArray5[3] = this.findRefinementEdgeInTriangle(nArray4[0], nArray4[1], nArray4[2]);
            int[] nArray6 = new int[6];
            this.m_refinementEdge[n] = -1;
            int n3 = 0;
            do {
                int n4 = nArray5[n3];
                nArray6[n4] = nArray6[n4] + 1;
                if (nArray6[nArray5[n3]] != 2) continue;
                if (this.m_refinementEdge[n] == -1) {
                    this.m_refinementEdge[n] = nArray5[n3];
                    continue;
                }
                int[] nArray7 = nArrayArray2[this.m_refinementEdge[n]];
                int[] nArray8 = nArrayArray2[nArray5[n3]];
                double d = Math.abs(PdVector.dist((PdVector)this.m_vertex[nArray7[0]], (PdVector)this.m_vertex[nArray7[1]]));
                double d2 = Math.abs(PdVector.dist((PdVector)this.m_vertex[nArray8[0]], (PdVector)this.m_vertex[nArray8[1]]));
                if (d2 > d) {
                    this.m_refinementEdge[n] = nArray5[n3];
                    continue;
                }
                if (d != d2 || (nArray8[0] >= nArray7[0] || nArray8[0] >= nArray7[1]) && (nArray8[1] >= nArray7[0] || nArray8[1] >= nArray7[1])) continue;
                this.m_refinementEdge[n] = nArray5[n3];
            } while (++n3 < 4);
            ++n;
        }
    }

    private void loadMembers() {
        this.m_vertex = this.m_geom.getVertices();
        this.m_tetra = this.m_geom.getElements();
        this.m_neighbour = this.m_geom.getNeighbours();
    }

    public void init() {
        this.loadMembers();
        this.assureRefinement();
        this.makeRefinementEdges();
        this.makeRefinementType();
    }

    private int[] makeAdjustment(int n) {
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = this.m_tetra[n].m_data;
        switch (this.m_refinementEdge[n]) {
            case 0: {
                if (nArray3[1] < nArray3[2]) {
                    int[] nArray4 = new int[4];
                    nArray4[0] = 1;
                    nArray4[1] = 2;
                    nArray4[3] = 3;
                    nArray = nArray4;
                    int[] nArray5 = new int[6];
                    nArray5[0] = 2;
                    nArray5[2] = 1;
                    nArray5[3] = 5;
                    nArray5[4] = 3;
                    nArray5[5] = 4;
                    nArray2 = nArray5;
                    break;
                }
                int[] nArray6 = new int[4];
                nArray6[0] = 2;
                nArray6[1] = 1;
                nArray6[2] = 3;
                nArray = nArray6;
                int[] nArray7 = new int[6];
                nArray7[0] = 2;
                nArray7[1] = 3;
                nArray7[2] = 4;
                nArray7[3] = 5;
                nArray7[5] = 1;
                nArray2 = nArray7;
                break;
            }
            case 1: {
                if (nArray3[0] < nArray3[2]) {
                    int[] nArray8 = new int[4];
                    nArray8[1] = 2;
                    nArray8[2] = 3;
                    nArray8[3] = 1;
                    nArray = nArray8;
                    int[] nArray9 = new int[6];
                    nArray9[0] = 4;
                    nArray9[1] = 2;
                    nArray9[2] = 3;
                    nArray9[3] = 1;
                    nArray9[4] = 5;
                    nArray2 = nArray9;
                    break;
                }
                int[] nArray10 = new int[4];
                nArray10[0] = 2;
                nArray10[2] = 1;
                nArray10[3] = 3;
                nArray = nArray10;
                int[] nArray11 = new int[6];
                nArray11[0] = 1;
                nArray11[1] = 2;
                nArray11[3] = 4;
                nArray11[4] = 5;
                nArray11[5] = 3;
                nArray2 = nArray11;
                break;
            }
            case 2: {
                if (nArray3[0] < nArray3[1]) {
                    int[] nArray12 = new int[4];
                    nArray12[1] = 1;
                    nArray12[2] = 2;
                    nArray12[3] = 3;
                    nArray = nArray12;
                    int[] nArray13 = new int[6];
                    nArray13[1] = 1;
                    nArray13[2] = 2;
                    nArray13[3] = 3;
                    nArray13[4] = 4;
                    nArray13[5] = 5;
                    nArray2 = nArray13;
                    break;
                }
                int[] nArray14 = new int[4];
                nArray14[0] = 1;
                nArray14[2] = 3;
                nArray14[3] = 2;
                nArray = nArray14;
                int[] nArray15 = new int[6];
                nArray15[0] = 3;
                nArray15[1] = 4;
                nArray15[2] = 2;
                nArray15[4] = 1;
                nArray15[5] = 5;
                nArray2 = nArray15;
                break;
            }
            case 3: {
                if (nArray3[0] < nArray3[3]) {
                    int[] nArray16 = new int[4];
                    nArray16[1] = 3;
                    nArray16[2] = 1;
                    nArray16[3] = 2;
                    nArray = nArray16;
                    int[] nArray17 = new int[6];
                    nArray17[0] = 5;
                    nArray17[1] = 3;
                    nArray17[2] = 1;
                    nArray17[3] = 2;
                    nArray17[5] = 4;
                    nArray2 = nArray17;
                    break;
                }
                int[] nArray18 = new int[4];
                nArray18[0] = 3;
                nArray18[2] = 2;
                nArray18[3] = 1;
                nArray = nArray18;
                int[] nArray19 = new int[6];
                nArray19[0] = 5;
                nArray19[2] = 4;
                nArray19[3] = 2;
                nArray19[4] = 3;
                nArray19[5] = 1;
                nArray2 = nArray19;
                break;
            }
            case 4: {
                if (nArray3[1] < nArray3[3]) {
                    int[] nArray20 = new int[4];
                    nArray20[0] = 1;
                    nArray20[1] = 3;
                    nArray20[2] = 2;
                    nArray = nArray20;
                    int[] nArray21 = new int[6];
                    nArray21[0] = 1;
                    nArray21[1] = 5;
                    nArray21[2] = 3;
                    nArray21[3] = 4;
                    nArray21[4] = 2;
                    nArray2 = nArray21;
                    break;
                }
                int[] nArray22 = new int[4];
                nArray22[0] = 3;
                nArray22[1] = 1;
                nArray22[3] = 2;
                nArray = nArray22;
                int[] nArray23 = new int[6];
                nArray23[0] = 4;
                nArray23[1] = 5;
                nArray23[3] = 1;
                nArray23[4] = 2;
                nArray23[5] = 3;
                nArray2 = nArray23;
                break;
            }
            case 5: {
                if (nArray3[2] < nArray3[3]) {
                    int[] nArray24 = new int[4];
                    nArray24[0] = 2;
                    nArray24[1] = 3;
                    nArray24[3] = 1;
                    nArray = nArray24;
                    int[] nArray25 = new int[6];
                    nArray25[0] = 3;
                    nArray25[1] = 1;
                    nArray25[2] = 5;
                    nArray25[4] = 4;
                    nArray25[5] = 2;
                    nArray2 = nArray25;
                    break;
                }
                int[] nArray26 = new int[4];
                nArray26[0] = 3;
                nArray26[1] = 2;
                nArray26[2] = 1;
                nArray = nArray26;
                int[] nArray27 = new int[6];
                nArray27[1] = 4;
                nArray27[2] = 5;
                nArray27[3] = 3;
                nArray27[4] = 1;
                nArray27[5] = 2;
                nArray2 = nArray27;
            }
        }
        this.m_tetra[n].m_data = new int[]{nArray3[nArray[0]], nArray3[nArray[1]], nArray3[nArray[2]], nArray3[nArray[3]]};
        nArray3 = this.m_neighbour[n].m_data;
        this.m_neighbour[n].m_data = new int[]{nArray3[nArray[0]], nArray3[nArray[1]], nArray3[nArray[2]], nArray3[nArray[3]]};
        this.m_refinementEdge[n] = 2;
        nArray3 = this.m_refinementEdges[n].m_data;
        this.m_refinementEdges[n].m_data = new int[]{nArray2[nArray3[nArray[0]]], nArray2[nArray3[nArray[1]]], nArray2[nArray3[nArray[2]]], nArray2[nArray3[nArray[3]]]};
        return nArray;
    }

    public void refine(Vector vector) {
        if (vector == null) {
            return;
        }
        if (vector.size() == 0) {
            return;
        }
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<int[][]> vector3 = new Vector<int[][]>();
        int n = 0;
        while (n < this.m_geom.getNumElements()) {
            vector3.addElement(null);
            ++n;
        }
        Vector<Vector> vector4 = new Vector<Vector>();
        int n2 = 0;
        while (n2 < this.m_vertex.length) {
            vector4.addElement(null);
            ++n2;
        }
        n2 = 0;
        while (n2 < vector.size()) {
            int n3 = (Integer)vector.elementAt(n2);
            if (n3 >= this.m_geom.getNumElements()) {
                PsDebug.warning((String)("PgTetraSet.refine(Vector): index " + n3 + " in tetrahedron list is out of bounds"));
            } else if (vector3.elementAt(n3) != null) {
                PsDebug.warning((String)("PgTetraSet.refine(Vector): index " + n3 + " is twice in tetrahedron list"));
            } else {
                vector2.addElement(new Integer(n3));
                vector3.setElementAt(new int[][]{{-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}}, n3);
            }
            ++n2;
        }
        while (vector2.size() > 0) {
            PiVector[] piVectorArray;
            Vector vector5;
            int[] nArray = new int[2];
            nArray[0] = (Integer)vector2.elementAt(0);
            vector2.removeElementAt(0);
            int[][][] nArrayArray = new int[2][][];
            nArrayArray[0] = (int[][])vector3.elementAt(nArray[0]);
            vector3.setElementAt(null, nArray[0]);
            int[] nArray2 = this.makeAdjustment(nArray[0]);
            nArrayArray[0] = new int[][]{nArrayArray[0][nArray2[0]], nArrayArray[0][nArray2[1]], nArrayArray[0][nArray2[2]], nArrayArray[0][nArray2[3]]};
            nArray[1] = this.addElement(PiVector.copyNew((PiVector)this.m_tetra[nArray[0]]));
            this.m_neighbour[nArray[1]] = PiVector.copyNew((PiVector)this.m_neighbour[nArray[0]]);
            this.m_refinementEdges[nArray[1]] = PiVector.copyNew((PiVector)this.m_refinementEdges[nArray[0]]);
            this.m_refinementType[nArray[1]] = this.m_refinementType[nArray[0]];
            vector3.addElement(null);
            nArrayArray[1] = new int[][]{(int[])nArrayArray[0][0].clone(), (int[])nArrayArray[0][1].clone(), (int[])nArrayArray[0][2].clone(), (int[])nArrayArray[0][3].clone()};
            int[] nArray3 = this.m_tetra[nArray[0]].m_data;
            int n4 = -1;
            if (vector4.elementAt(nArray3[0]) == null) {
                vector5 = new Vector();
                vector4.setElementAt(vector5, nArray3[0]);
            } else {
                vector5 = (Vector)vector4.elementAt(nArray3[0]);
                if (vector5.size() > 0) {
                    piVectorArray = vector5.elements();
                    while (piVectorArray.hasMoreElements()) {
                        int[] nArray4 = (int[])piVectorArray.nextElement();
                        if (nArray4[1] != nArray3[1]) continue;
                        n4 = nArray4[0];
                        break;
                    }
                }
            }
            if (n4 == -1) {
                n4 = this.m_geom.addVertex(PdVector.blendNew((double)0.5, (PdVector)this.m_vertex[nArray3[0]], (double)0.5, (PdVector)this.m_vertex[nArray3[1]]));
                this.m_vertex = this.m_geom.getVertices();
                vector5.addElement(new int[]{n4, nArray3[1]});
                vector4.addElement(null);
            }
            this.m_tetra[nArray[0]].m_data[1] = n4;
            this.m_tetra[nArray[1]].m_data[0] = n4;
            piVectorArray = new PiVector[]{this.m_refinementEdges[nArray[0]], this.m_refinementEdges[nArray[1]]};
            int n5 = 0;
            do {
                piVectorArray[n5].m_data[2] = 3 + n5;
                piVectorArray[n5].m_data[3] = 1 - n5;
                switch (this.m_refinementType[nArray[n5]]) {
                    case 0: 
                    case 1: {
                        piVectorArray[n5].m_data[n5] = 5;
                        this.m_refinementEdge[nArray[n5]] = piVectorArray[n5].m_data[1 - n5];
                        int n6 = nArray[n5];
                        this.m_refinementType[n6] = this.m_refinementType[n6] + 1;
                        break;
                    }
                    case 2: {
                        piVectorArray[n5].m_data[n5] = piVectorArray[n5].m_data[1 - n5] + 1 - 2 * (piVectorArray[n5].m_data[1 - n5] % 3);
                        this.m_refinementEdge[nArray[n5]] = piVectorArray[n5].m_data[1 - n5];
                        this.m_refinementType[nArray[n5]] = 0;
                        break;
                    }
                    default: {
                        piVectorArray[n5].m_data[n5] = 5;
                        this.m_refinementEdge[nArray[n5]] = piVectorArray[n5].m_data[1 - n5];
                        this.m_refinementType[nArray[n5]] = 1;
                    }
                }
            } while (++n5 < 2);
            this.m_neighbour[nArray[0]].m_data[0] = nArray[1];
            nArrayArray[0][0] = new int[]{-1, -1, -1};
            this.m_neighbour[nArray[1]].m_data[1] = nArray[0];
            nArrayArray[1][1] = new int[]{-1, -1, -1};
            n5 = 0;
            do {
                int n7;
                int n8;
                if ((n8 = this.m_neighbour[nArray[1 - n5 % 2]].m_data[n5]) == -1) continue;
                Object object = (int[][])vector3.elementAt(n8);
                int n9 = -1;
                int n10 = 0;
                do {
                    if (this.m_neighbour[n8].m_data[n10] != nArray[0] && (object == null || object[n10][0] != nArray[0] && object[n10][1] != nArray[0] && object[n10][2] != nArray[0])) continue;
                    n9 = n10;
                    break;
                } while (++n10 < 4);
                if (n9 == -1) {
                    PsDebug.warning((String)("PgTetraSet.refine(Vector): inconsistent neighbourhood data for " + nArray[0] + " and " + n8 + "."));
                    continue;
                }
                int[] nArray5 = new int[]{-1, -1, -1};
                int n11 = 0;
                block12: do {
                    n7 = nArrayArray[1 - n5 % 2][n5][n11];
                    int n12 = 0;
                    do {
                        if (n7 == -1 || this.m_neighbour[n7].m_data[n12] != nArray[0]) continue;
                        nArray5[n11] = n12;
                        continue block12;
                    } while (++n12 < 4);
                } while (++n11 < 3);
                if (n5 == 0) {
                    if (this.m_neighbour[n8].m_data[n9] == nArray[0]) {
                        this.m_neighbour[n8].m_data[n9] = nArray[1];
                        n11 = 0;
                        do {
                            if ((n7 = nArrayArray[1][0][n11]) == -1) continue;
                            this.m_neighbour[n7].m_data[nArray5[n11]] = nArray[1];
                        } while (++n11 < 3);
                    } else if (object[n9][0] == nArray[0]) {
                        object[n9][0] = nArray[1];
                    } else if (object[n9][1] == nArray[0]) {
                        object[n9][1] = nArray[1];
                    } else {
                        object[n9][2] = nArray[1];
                    }
                } else if (n5 > 1) {
                    if (nArrayArray[0][n5][0] == -1) {
                        if (object == null) {
                            vector2.addElement(new Integer(n8));
                            object = new int[][]{{-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}};
                        }
                        if (object[n9][0] == -1) {
                            object[n9][0] = nArray[1];
                        } else if (this.m_neighbour[n8].m_data[n9] == nArray[0]) {
                            object[n9][1] = nArray[1];
                        } else {
                            object[n9][2] = nArray[1];
                        }
                        vector3.setElementAt((int[][])object, n8);
                    } else if (nArrayArray[0][n5][1] == -1 && nArrayArray[0][n5][2] == -1) {
                        nArrayArray[0][n5][0] = -1;
                        this.m_neighbour[nArrayArray[1][n5][0]].m_data[nArray5[0]] = nArray[1];
                        this.m_neighbour[nArray[1]].m_data[n5] = nArrayArray[1][n5][0];
                        nArrayArray[1][n5][0] = -1;
                    } else {
                        nArrayArray[0][n5][0] = nArrayArray[0][n5][1];
                        this.m_neighbour[nArrayArray[1][n5][0]].m_data[nArray5[0]] = nArray[1];
                        if (nArray5[2] != -1) {
                            this.m_neighbour[nArrayArray[1][n5][2]].m_data[nArray5[2]] = nArray[1];
                        }
                        this.m_neighbour[nArray[1]].m_data[n5] = nArrayArray[1][n5][0];
                        nArrayArray[1][n5][0] = nArrayArray[1][n5][2];
                        nArrayArray[0][n5][1] = -1;
                        nArrayArray[0][n5][2] = -1;
                        nArrayArray[1][n5][1] = -1;
                        nArrayArray[1][n5][2] = -1;
                    }
                }
                n11 = 0;
                do {
                    if (nArrayArray[n11][n5][0] == -1 || vector3.elementAt(nArray[n11]) != null) continue;
                    vector2.addElement(new Integer(nArray[n11]));
                    vector3.setElementAt(nArrayArray[n11], nArray[n11]);
                } while (++n11 < 2);
            } while (++n5 < 4);
        }
        this.m_geom.update((Object)this.m_geom);
    }

    private int findRefinementEdgeInTriangle(int n, int n2, int n3) {
        if (n == n2 || n2 == n3 || n3 == n) {
            return -1;
        }
        double d = Math.abs(PdVector.dist((PdVector)this.m_vertex[n2], (PdVector)this.m_vertex[n3]));
        double d2 = Math.abs(PdVector.dist((PdVector)this.m_vertex[n], (PdVector)this.m_vertex[n3]));
        double d3 = Math.abs(PdVector.dist((PdVector)this.m_vertex[n], (PdVector)this.m_vertex[n2]));
        int n4 = d > d2 ? (d > d3 ? 0 : (d3 > d ? 2 : (n3 < n ? 0 : 2))) : (d2 > d ? (d2 > d3 ? 1 : (d3 > d2 ? 2 : (n3 < n2 ? 1 : 2))) : (d3 > d ? 2 : (d > d3 ? (n2 < n ? 0 : 1) : (n < n3 ? (n2 < n3 ? 2 : 1) : (n < n2 ? 1 : 0)))));
        return n4;
    }
}

