/*
 * Decompiled with CFR 0.152.
 */
package dev.app.vector.vectorfield2;

import java.awt.Button;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.util.Date;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.loader.PjImportModel;
import jv.loader.PjImportModel_IP;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvViewerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnLIC;
import jvx.numeric.PnTranslationRK;
import jvx.numeric.PnVertexRK;

public class PjVectorfield2
extends PjImportModel
implements Runnable,
ActionListener {
    protected PsPanel m_superpanel = null;
    protected PuDouble m_length;
    protected PuInteger m_discr;
    protected PdBaryDir[][] m_altvec = null;
    protected int m_method;
    public static final int PROJECTION = 1;
    public static final int GEODESIC = 2;
    public static final int GEODESIC2 = 3;
    public static final int GEODESIC3 = 4;
    protected PuInteger m_LICSize;
    protected PdBaryDir[] m_origvec;
    protected int[] m_origelem;
    protected int[] m_origlocvertind;
    protected PgPolygon m_poly;
    protected int m_elemInd = 0;
    protected PdBary m_bary = new PdBary(1.0, 0.0, 0.0);
    protected PgVectorField m_vec;
    protected boolean m_curveallreadythere = false;
    protected PuDouble m_angle;
    protected Label m_time;
    protected Thread m_LIC;
    protected Button m_LICButton;
    private static /* synthetic */ Class class$dev$app$vector$vectorfield2$PjVectorfield2;

    public PjVectorfield2() {
        this.m_length = new PuDouble("Length", (PsUpdateIf)this);
        this.m_discr = new PuInteger("Discr", (PsUpdateIf)this);
        this.m_angle = new PuDouble("Angle", (PsUpdateIf)this);
        this.m_vec = new PgVectorField(3);
        this.m_vec.setName("Vector Field");
        this.m_poly = new PgPolygon(3);
        this.m_poly.setName("curve");
        this.m_LICButton = new Button("calculate LIC texture");
        this.m_LICSize = new PuInteger("LIC size", null);
        this.m_time = new Label("LIC time: --");
        if (this.getClass() == (class$dev$app$vector$vectorfield2$PjVectorfield2 != null ? class$dev$app$vector$vectorfield2$PjVectorfield2 : (class$dev$app$vector$vectorfield2$PjVectorfield2 = PjVectorfield2.class$("dev.app.vector.vectorfield2.PjVectorfield2")))) {
            this.init();
        }
    }

    public void setMethod(int n) {
        this.m_method = n;
        this.calculateRepresentations();
        if (this.m_curveallreadythere) {
            this.calculateCurve();
            this.m_poly.update(null);
        }
    }

    public boolean update(Object object) {
        if (object != null && object == this.m_geomList[0]) {
            return true;
        }
        if (object != null && object == this.m_superpanel) {
            return true;
        }
        if (object == this.m_length) {
            this.calculateCurve();
            this.m_poly.update(null);
            return true;
        }
        if (object == this.m_angle) {
            this.calculateVectorfield();
            return true;
        }
        if (object == this.m_discr) {
            this.calculateCurve();
            this.m_poly.update(null);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!(actionEvent.getSource() != this.m_LICButton || this.m_LIC != null && this.m_LIC.isAlive())) {
            this.m_LIC = new Thread(this);
            this.m_LIC.start();
        }
    }

    public boolean load(String string) {
        if (this.m_LIC != null) {
            this.m_LIC.stop();
            this.m_LIC = null;
        }
        boolean bl = super.load(string);
        if (this.m_geomList[0] instanceof PgElementSet) {
            PgElementSet pgElementSet = (PgElementSet)this.m_geomList[0];
            PgElementSet.triangulate((PgElementSet)pgElementSet);
            this.m_vec.setGeometry((PgPointSet)pgElementSet);
            this.calculateVectorfield();
            pgElementSet.addVectorField(this.m_vec);
            pgElementSet.showElements(false);
            pgElementSet.makeElementNormals();
        }
        this.m_curveallreadythere = false;
        this.m_poly.setNumVertices(0);
        this.m_poly.update(null);
        this.removeGeometry((PgGeometryIf)this.m_poly);
        this.addGeometry((PgGeometryIf)this.m_poly);
        this.m_geomList[0].update(null);
        this.selectGeometry((PgGeometryIf)this.m_geomList[0]);
        if (this.getDisplay() != null) {
            this.getDisplay().fit();
        }
        this.update(null);
        return bl;
    }

    public void start() {
    }

    public void calculateVectorfield() {
        if (this.m_geomList[0] == null || !(this.m_geomList[0] instanceof PgElementSet)) {
            PsDebug.warning((String)"No valid geometry.");
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)this.m_geomList[0];
        this.m_origvec = new PdBaryDir[pgElementSet.getNumVertices()];
        this.m_origelem = new int[pgElementSet.getNumVertices()];
        this.m_origlocvertind = new int[pgElementSet.getNumVertices()];
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n = 0;
        while (n < pgElementSet.getNumVertices()) {
            block17: {
                int n2;
                int n3;
                int n4;
                int n5;
                block12: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block11: {
                                        n5 = 0;
                                        n4 = 0;
                                        if (n != 0) break block11;
                                        n5 = 0;
                                        n4 = 1;
                                        this.m_origvec[n] = new PdBaryDir(1.5, -3.0, 1.5);
                                        break block12;
                                    }
                                    if (n != 1) break block13;
                                    n5 = 1;
                                    n4 = 0;
                                    this.m_origvec[n] = new PdBaryDir(-2.0, 2.0, 0.0);
                                    break block12;
                                }
                                if (n != 5) break block14;
                                n5 = 5;
                                n4 = 1;
                                this.m_origvec[n] = new PdBaryDir(0.0, -2.0, 2.0);
                                break block12;
                            }
                            if (n != 7) break block15;
                            n5 = 10;
                            n4 = 2;
                            this.m_origvec[n] = new PdBaryDir(0.0, 2.0, -2.0);
                            break block12;
                        }
                        if (n != 4) break block16;
                        this.m_origvec[n] = new PdBaryDir(0.0, 2.0, -2.0);
                        PdBary pdBary = new PdBary(3);
                        n5 = PwBary.rotateAtVertex((PgElementSet)pgElementSet, (int)4, (int)2, (PdBaryDir)this.m_origvec[4], (PdBaryDir)this.m_origvec[4], (PdBary)pdBary, (double)(Math.PI * 2 * this.m_angle.getValue() / 360.0));
                        n3 = 0;
                        do {
                            if (pdBary.m_data[n3] != 1.0) continue;
                            n4 = n3;
                        } while (++n3 < 3);
                        break block12;
                    }
                    this.m_origvec[n] = new PdBaryDir(3);
                    n2 = 0;
                    while (n2 == 0 && n5 < pgElementSet.getNumElements()) {
                        n3 = 0;
                        do {
                            if (piVectorArray[n5].m_data[n3] != n) continue;
                            n4 = n3;
                            n2 = 1;
                            break;
                        } while (++n3 < 3);
                        ++n5;
                    }
                    if (n2 == 0) break block17;
                    this.m_origvec[n].m_data[(n4 + 1) % 3] = 0.0;
                    this.m_origvec[n].m_data[(n4 + 2) % 3] = 0.0;
                    this.m_origvec[n].m_data[n4] = -(this.m_origvec[n].m_data[(n4 + 1) % 3] + this.m_origvec[n].m_data[(n4 + 2) % 3]);
                }
                this.m_origelem[n] = --n5;
                this.m_origlocvertind[n] = n4;
                PdVector pdVector = new PdVector(0.0, 0.0, 0.0);
                n2 = 0;
                do {
                    n3 = 0;
                    do {
                        int n6 = n2;
                        pdVector.m_data[n6] = pdVector.m_data[n6] + 0.3333333333333333 * this.m_origvec[n].m_data[n3] * pdVectorArray[piVectorArray[n5].m_data[n3]].m_data[n2];
                    } while (++n3 < 3);
                } while (++n2 < 3);
                if (this.m_vec.getNumVectors() <= n) {
                    System.err.println(this.m_vec.getNumVectors());
                }
                this.m_vec.setVector(n, pdVector);
            }
            ++n;
        }
        this.m_vec.update(null);
        pgElementSet.update(null);
        this.calculateRepresentations();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void calculateRepresentations() {
        if (this.m_geomList[0] == null || !(this.m_geomList[0] instanceof PgElementSet)) {
            PsDebug.warning((String)"No valid geometry.");
            return;
        }
        if (this.m_method == 4) {
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)this.m_geomList[0];
        if (pgElementSet.getNumElements() < 1) {
            return;
        }
        this.m_altvec = new PdBaryDir[pgElementSet.getNumElements()][3];
        PiVector piVector = new PiVector();
        PiVector piVector2 = new PiVector();
        int n = 0;
        while (n < pgElementSet.getNumVertices()) {
            PdBaryDir[] pdBaryDirArray = this.m_method == 2 ? PwBary.getGeodRepresentation((PgElementSet)pgElementSet, (int)this.m_origelem[n], (PdBaryDir)this.m_origvec[n], (int)this.m_origlocvertind[n], (PiVector)piVector, (PiVector)piVector2) : (this.m_method == 3 ? PwBary.getTransRepresentation((PgElementSet)pgElementSet, (int)this.m_origelem[n], (PdBaryDir)this.m_origvec[n], (int)this.m_origlocvertind[n], (PiVector)piVector, (PiVector)piVector2) : PwBary.getProjRepresentation((PgElementSet)pgElementSet, (int)this.m_origelem[n], (PdBaryDir)this.m_origvec[n], (int)this.m_origlocvertind[n], (PiVector)piVector, (PiVector)piVector2));
            int n2 = piVector.getSize();
            int n3 = 0;
            while (n3 < n2) {
                this.m_altvec[piVector.m_data[n3]][piVector2.m_data[n3]] = pdBaryDirArray[n3];
                ++n3;
            }
            ++n;
        }
        pgElementSet.update(null);
    }

    public void run() {
        PnTranslationRK pnTranslationRK;
        if (!(this.m_geomList[0] instanceof PgElementSet)) {
            return;
        }
        String string = this.m_LICButton.getLabel();
        this.m_LICButton.setLabel("preparing LIC");
        PgElementSet pgElementSet = (PgElementSet)this.m_geomList[0];
        PgElementSet pgElementSet2 = new PgElementSet(3);
        pgElementSet2.copy((PgGeometry)pgElementSet);
        pgElementSet2.showElements(false);
        pgElementSet2.showBackface(false);
        pgElementSet2.showElementTexture(true);
        PvViewerIf pvViewerIf = this.getViewer();
        String string2 = "";
        switch (this.m_method) {
            case 1: {
                string2 = "Projection";
                break;
            }
            case 2: {
                string2 = "Completion";
                break;
            }
            case 3: {
                string2 = "Translation (half angle)";
                break;
            }
            case 4: {
                string2 = "Translation (continous)";
            }
        }
        PvDisplayIf pvDisplayIf = pvViewerIf.newDisplay(string2);
        if (pvDisplayIf != null) {
            pvDisplayIf.removeGeometries();
            pvDisplayIf.addGeometry((PgGeometryIf)pgElementSet2);
            pvDisplayIf.showDepthcue(false);
            this.addDisplay(pvDisplayIf);
        }
        if (this.m_method == 4) {
            pnTranslationRK = new PnTranslationRK(pgElementSet2);
            pnTranslationRK.setVectorField(this.m_origelem, this.m_origvec, this.m_origlocvertind);
        } else {
            pnTranslationRK = new PnVertexRK(pgElementSet2);
            ((PnVertexRK)pnTranslationRK).setVectorField(this.m_altvec);
        }
        PgTexture pgTexture = new PgTexture();
        Frame frame = PsConfig.getFrame();
        int n = this.m_LICSize.getValue();
        int[] nArray = new int[n * n];
        this.m_LICButton.setLabel("LIC 0.0%");
        PnLIC pnLIC = new PnLIC(pgElementSet2, n, 0.0, (PnGeodesicRK)pnTranslationRK);
        long l = new Date().getTime();
        int n2 = 6;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            int n4 = 2;
            if (n3 == 5) {
                n4 = 11;
            } else if (n3 == 4) {
                n4 = 4;
            } else if (n3 == 3) {
                n4 = 5;
            } else if (n3 == 2) {
                n4 = 10;
            } else if (n3 == 1) {
                n4 = 3;
            }
            pnLIC.makeElement(n4);
            if (n2 >= 10 && n3 % (n2 / 10) == 0) {
                this.m_LICButton.setLabel("LIC " + (100 - (int)((double)n3 / ((double)n2 / 10.0) * 10.0)) + "%");
                pnLIC.getPixArray(nArray);
                pgTexture.setImage(frame.createImage(new MemoryImageSource(n, n, nArray, 0, n)));
                pgElementSet2.setTexture(pgTexture);
                pgElementSet2.showElements(true);
                pgElementSet2.update(null);
            } else if (n2 < 10) {
                this.m_LICButton.setLabel("LIC " + (double)(n2 - n3) * 100.0 / (double)n2 + "%");
                pnLIC.getPixArray(nArray);
                pgTexture.setImage(frame.createImage(new MemoryImageSource(n, n, nArray, 0, n)));
                pgElementSet2.setTexture(pgTexture);
                pgElementSet2.showElements(true);
                pgElementSet2.update(null);
            }
            --n3;
        }
        long l2 = new Date().getTime() - l;
        this.m_LICButton.setLabel(string);
        pnLIC.getPixArray(nArray);
        pgTexture.setImage(frame.createImage(new MemoryImageSource(n, n, nArray, 0, n)));
        pgElementSet2.setTexture(pgTexture);
        pgElementSet2.update(null);
        this.m_time.setText("LIC time: " + l2 + " ms");
        System.gc();
    }

    public void init() {
        super.init();
        this.addGeometry((PgGeometryIf)this.m_poly);
        this.selectGeometry((PgGeometryIf)this.m_geomList[0]);
        this.m_method = 1;
        this.m_length.setDefBounds(0.05, 10.0, 0.5, 1.0);
        this.m_length.setDefValue(2.0);
        this.m_length.init();
        this.m_angle.setDefBounds(0.0, 360.0, 5.0, 10.0);
        this.m_angle.setDefValue(25.0);
        this.m_angle.init();
        this.m_discr.setDefBounds(2, 100, 5, 10);
        this.m_discr.setDefValue(20);
        this.m_discr.init();
        this.m_LICSize.setDefBounds(50, 1000, 20, 100);
        this.m_LICSize.setDefValue(500);
        this.m_LICSize.init();
    }

    public PsPanel getSuperInfoPanel() {
        if (this.m_superpanel == null) {
            this.m_superpanel = new PjImportModel_IP();
            this.m_superpanel.setParent((PsUpdateIf)this);
            this.m_superpanel.update((Object)this);
        }
        return this.m_superpanel;
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (pvPickEvent.getElementInd() < 0) {
            return;
        }
        this.m_bary = pvPickEvent.getBary();
        this.m_elemInd = pvPickEvent.getElementInd();
        this.calculateCurve();
        this.m_poly.update(null);
    }

    public void calculateCurve() {
        PnTranslationRK pnTranslationRK;
        if (this.m_geomList[0] == null || !(this.m_geomList[0] instanceof PgElementSet)) {
            PsDebug.warning((String)"No valid geometry.");
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)this.m_geomList[0];
        this.m_curveallreadythere = true;
        PgPolygonOnElementSet pgPolygonOnElementSet = new PgPolygonOnElementSet(pgElementSet);
        if (this.m_method == 4) {
            pnTranslationRK = new PnTranslationRK(pgElementSet);
            pnTranslationRK.setVectorField(this.m_origelem, this.m_origvec, this.m_origlocvertind);
        } else {
            pnTranslationRK = new PnVertexRK(pgElementSet);
            ((PnVertexRK)pnTranslationRK).setVectorField(this.m_altvec);
        }
        pnTranslationRK.solve(pgPolygonOnElementSet, this.m_elemInd, this.m_bary, this.m_length.getValue() / (double)this.m_discr.getValue(), this.m_discr.getValue());
        pgPolygonOnElementSet.getPolygon(this.m_poly);
    }
}

