/*
 * Decompiled with CFR 0.152.
 */
package jdvi;

import java.awt.Color;
import java.util.StringTokenizer;
import jdvi.JDviContext;

class JDviColor {
    JDviColor() {
    }

    static Color getColor(JDviContext jDviContext, String string, Color color) {
        Color color2;
        String string2 = jDviContext.getProperty("jdvi.color." + string, "xxx");
        try {
            color2 = string2.startsWith("0x") ? new Color(Integer.parseInt(string2.substring(2), 16)) : new Color(Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            color2 = color;
        }
        return color2;
    }

    static Color parseColor(JDviContext jDviContext, StringTokenizer stringTokenizer) {
        Color color = null;
        String string = stringTokenizer.nextToken("\n \t");
        try {
            if (string.startsWith("rgb")) {
                if (stringTokenizer.countTokens() < 3) {
                    System.err.println("not enough tokens");
                    return null;
                }
                float f = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                float f2 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                float f3 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                color = new Color(f, f2, f3);
            } else if (string.startsWith("gray")) {
                if (stringTokenizer.countTokens() < 1) {
                    System.err.println("not enough tokens");
                    return null;
                }
                float f = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                color = new Color(f, f, f);
            } else if (string.startsWith("cmyk")) {
                if (stringTokenizer.countTokens() < 4) {
                    System.err.println("not enough tokens");
                    return null;
                }
                float f = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                float f4 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                float f5 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                float f6 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                float f7 = 1.0f - f6;
                float f8 = (1.0f - f) * f7;
                float f9 = (1.0f - f4) * f7;
                float f10 = (1.0f - f5) * f7;
                color = new Color(f8, f9, f10);
            } else {
                color = JDviColor.getColor(jDviContext, string, Color.black);
                if (color == null) {
                    System.out.println(String.valueOf(string) + " not found...using black");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(String.valueOf(String.valueOf(numberFormatException)) + "while parsing special");
        }
        if (color == null) {
            color = Color.black;
        }
        return color;
    }
}

