/*
 * Decompiled with CFR 0.152.
 */
package jdvi.font;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.StringTokenizer;
import jdvi.font.Glyph;
import jdvi.font.NybbleInputStream;

public final class Font
implements Serializable {
    public String name;
    public double size;
    public Glyph[] chars = new Glyph[256];
    public int ds;
    public int cs;
    public int hppp;
    public int vppp;
    public double conv_fac;

    public Font() {
    }

    public Font(String string, String string2) {
        this();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        NybbleInputStream nybbleInputStream = null;
        while (nybbleInputStream == null & stringTokenizer.hasMoreTokens()) {
            try {
                URL uRL = new URL(String.valueOf(stringTokenizer.nextToken()) + "/");
                uRL = new URL(uRL, string2);
                System.out.println(uRL.toString());
                nybbleInputStream = new NybbleInputStream(uRL.openStream());
                this.parsePkStream(nybbleInputStream);
                nybbleInputStream.close();
                this.name = string2;
            }
            catch (IOException iOException) {}
        }
    }

    public Font(URL uRL) throws IOException {
        this();
        NybbleInputStream nybbleInputStream = new NybbleInputStream(uRL.openStream());
        this.parsePkStream(nybbleInputStream);
        nybbleInputStream.close();
    }

    public void flush() {
        int n = 0;
        while (n < 256) {
            if (this.chars[n] != null) {
                this.chars[n].flush();
            }
            ++n;
        }
    }

    public static Font loadFont(String string, String string2) {
        Font font = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        NybbleInputStream nybbleInputStream = null;
        while (nybbleInputStream == null & stringTokenizer.hasMoreTokens()) {
            try {
                URL uRL = new URL(String.valueOf(stringTokenizer.nextToken()) + "/");
                uRL = new URL(uRL, string2);
                nybbleInputStream = new NybbleInputStream(uRL.openStream());
                if (nybbleInputStream != null) {
                    font = new Font();
                    font.parsePkStream(nybbleInputStream);
                    return font;
                }
                nybbleInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private void parsePkStream(NybbleInputStream nybbleInputStream) throws IOException {
        int n;
        int n2 = nybbleInputStream.read();
        if (n2 != 247 | (n = nybbleInputStream.read()) != 89) {
            System.err.println("this is no pk file!");
            return;
        }
        n = nybbleInputStream.read();
        byte[] byArray = new byte[n];
        nybbleInputStream.read(byArray);
        this.ds = nybbleInputStream.read4();
        this.cs = nybbleInputStream.read4();
        this.hppp = nybbleInputStream.read4();
        this.conv_fac = (double)this.ds / 7.205759403792794E16 * (double)this.hppp;
        this.vppp = nybbleInputStream.read4();
        n2 = nybbleInputStream.read();
        while (n2 != 245) {
            if (n2 < 240) {
                Glyph glyph;
                int n3;
                if ((n2 & 7) > 3) {
                    if ((n2 & 7) > 6) {
                        n3 = nybbleInputStream.readInt();
                        this.chars[glyph.cc] = glyph = Glyph.readGlyph(nybbleInputStream, n2);
                    } else {
                        n3 = n2 % 4 * 65536 + nybbleInputStream.readUnsignedShort();
                        this.chars[glyph.cc] = glyph = Glyph.readGlyph(nybbleInputStream, n2);
                    }
                } else {
                    n3 = n2 % 4 * 256 + nybbleInputStream.read();
                    this.chars[glyph.cc] = glyph = Glyph.readGlyph(nybbleInputStream, n2);
                }
            }
            if (n2 == 240) {
                n = nybbleInputStream.read();
                byArray = new byte[n];
                nybbleInputStream.read(byArray);
            }
            if (n2 == 244) {
                nybbleInputStream.read4();
            }
            n2 = nybbleInputStream.read();
        }
    }
}

