/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdBary;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.numeric.PnElementRK;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnVertexRK;

public class PwIntegralLines
extends PsObject {
    protected PuInteger m_vfIndex = new PuInteger("Selected vf", null);
    protected PuDouble m_stepsize = new PuDouble("Stepsize", null);
    protected PuInteger m_numSteps = new PuInteger("Iterations", null);
    protected PvDisplayIf m_disp = null;
    protected PgPolygonSet m_lines = null;
    protected PgElementSet m_geom = null;
    private static /* synthetic */ Class class$jvx$geom$PwIntegralLines;

    public PgPolygonSet getIntegralLines() {
        return this.m_lines;
    }

    public void close() {
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
        }
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_disp != null && this.m_lines != null) {
            this.m_disp.removeGeometry((PgGeometryIf)this.m_lines);
        }
        this.m_disp = pvDisplayIf;
        if (this.m_disp != null && this.m_lines != null) {
            this.m_disp.addGeometry((PgGeometryIf)this.m_lines);
        }
    }

    public PvDisplayIf getDisplay() {
        return this.m_disp;
    }

    public PwIntegralLines() {
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwIntegralLines != null ? class$jvx$geom$PwIntegralLines : (class$jvx$geom$PwIntegralLines = PwIntegralLines.class$("jvx.geom.PwIntegralLines")))) {
            this.init();
        }
    }

    public void makeIntegralLines() {
        if (this.m_vfIndex.getValue() <= 0 || this.m_vfIndex.getValue() > this.m_geom.getNumVectorFields()) {
            PsDebug.warning((String)"no valid vector field selected");
            return;
        }
        if (this.m_geom == null) {
            PsDebug.warning((String)"no geometry, use setGeometry(...).");
            return;
        }
        boolean bl = this.m_lines == null;
        this.m_lines = PwIntegralLines.makeIntegralLines(this.m_geom, this.m_geom.getVectorField(this.m_vfIndex.getValue() - 1), this.m_lines, this.m_stepsize.getValue(), this.m_numSteps.getValue());
        if (bl && this.m_lines != null && this.m_disp != null) {
            this.m_disp.addGeometry((PgGeometryIf)this.m_lines);
        }
        if (this.m_lines != null) {
            this.m_lines.update(null);
        }
    }

    public void removeIntegralLines() {
        if (this.m_lines != null) {
            if (this.m_disp != null) {
                this.m_disp.removeGeometry((PgGeometryIf)this.m_lines);
            }
            this.m_disp.update(null);
            this.m_lines = null;
        }
    }

    public static PgPolygonSet makeIntegralLines(PgElementSet pgElementSet, PgVectorField pgVectorField, PgPolygonSet pgPolygonSet, double d, int n) {
        PnGeodesicRK pnGeodesicRK;
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing geometry");
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"geometry is not triangulated");
        }
        if (pgVectorField == null) {
            PsDebug.warning((String)"missing vector field");
        }
        int n2 = pgElementSet.getDimOfVertices();
        if (pgPolygonSet == null) {
            pgPolygonSet = new PgPolygonSet(n2);
            pgPolygonSet.setName("Int. Lines to " + pgVectorField.getName());
            pgPolygonSet.setGlobalPolygonSize(1.0);
        }
        pgPolygonSet.setNumVertices(0);
        pgPolygonSet.setNumPolygons(0);
        pgPolygonSet.showVertices(false);
        int n3 = 0;
        int n4 = pgElementSet.getNumElements();
        PgPolygonOnElementSet pgPolygonOnElementSet = new PgPolygonOnElementSet(pgElementSet);
        PgPolygon pgPolygon = new PgPolygon(n2);
        PdBary pdBary = new PdBary(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
        if (pgVectorField.getBasedOn() == 0) {
            pnGeodesicRK = new PnVertexRK(pgElementSet);
            ((PnVertexRK)pnGeodesicRK).setVectorField(pgVectorField);
        } else {
            pnGeodesicRK = new PnElementRK(pgElementSet);
            ((PnElementRK)pnGeodesicRK).setVectorField(pgVectorField);
        }
        int n5 = 0;
        while (n5 < n4) {
            pnGeodesicRK.solve(pgPolygonOnElementSet, n5, pdBary, d, n);
            pgPolygonOnElementSet.getPolygon(pgPolygon);
            int n6 = pgPolygon.getNumVertices();
            PiVector piVector = new PiVector(n6);
            int n7 = 0;
            while (n7 < n6) {
                pgPolygonSet.addVertex(pgPolygon.getVertex(n7));
                piVector.setEntry(n7, n3);
                ++n3;
                ++n7;
            }
            pgPolygonSet.addPolygon(piVector);
            ++n5;
        }
        return pgPolygonSet;
    }

    public boolean update(Object object) {
        if (object == null) {
            return true;
        }
        if (object == this.m_geom) {
            int n = this.m_geom.getNumVectorFields();
            if (n > 0) {
                this.m_vfIndex.setBounds(1, n, 1, 2);
                this.m_vfIndex.update((Object)this.m_vfIndex);
            } else {
                this.m_vfIndex.setBounds(0, 0, 1, 2);
                this.m_vfIndex.setValue(0);
                this.m_vfIndex.update((Object)this.m_vfIndex);
            }
            return super.update(null);
        }
        return false;
    }

    public void setNumSteps(int n) {
        this.m_numSteps.setValue(n);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        if (pgElementSet != null && pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry is not triangulated - aborted.");
            return;
        }
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_geom = pgElementSet;
        if (this.m_geom != null) {
            this.m_geom.addUpdateListener((PsUpdateIf)this);
            this.update(this.m_geom);
        }
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public int getNumSteps() {
        return this.m_numSteps.getValue();
    }

    public void setVectorFieldIndex(int n) {
        this.m_vfIndex.setValue(n + 1);
    }

    public int getVectorFieldIndex() {
        return this.m_vfIndex.getValue() - 1;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setStepSize(double d) {
        this.m_stepsize.setValue(d);
    }

    public double getStepSize() {
        return this.m_stepsize.getValue();
    }

    public void init() {
        this.m_vfIndex.setDefBounds(0, 0, 1, 2);
        this.m_vfIndex.setDefValue(0);
        this.m_vfIndex.init();
        if (this.m_geom != null) {
            this.update(this.m_geom);
        }
        this.m_stepsize.setDefBounds(0.001, 1.0, 0.01, 0.1);
        this.m_stepsize.setDefValue(0.4);
        this.m_stepsize.init();
        this.m_numSteps.setDefBounds(1, 200, 1, 25);
        this.m_numSteps.setDefValue(20);
        this.m_numSteps.init();
        this.removeIntegralLines();
    }
}

