/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDialog;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jvx.geom.PwNoise;

public class PwNoise_Dialog
extends PsDialog {
    private PgPointSet m_pointSetCopy;
    protected Checkbox m_cNormal;
    protected Checkbox m_cTangential;
    protected PuDouble m_eps;
    protected PwNoise m_pwNoise;
    protected Button m_scramble;
    private boolean m_bHasVertexNormals = true;
    private static /* synthetic */ Class class$jvx$geom$PwNoise_Dialog;

    public PwNoise_Dialog(PgPointSet pgPointSet) {
        super(PsConfig.getFrame(), PsConfig.getMessage((String)"PwNoise"), false);
        if (!pgPointSet.hasVertexNormals()) {
            this.m_bHasVertexNormals = pgPointSet.makeVertexNormals();
            if (this.m_bHasVertexNormals) {
                pgPointSet.update((Object)pgPointSet);
            }
        }
        this.m_pwNoise = new PwNoise(pgPointSet);
        this.m_pointSetCopy = new PgPointSet(pgPointSet.getDimOfVertices());
        this.m_pointSetCopy.copy((PgGeometry)pgPointSet);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwNoise_Dialog != null ? class$jvx$geom$PwNoise_Dialog : (class$jvx$geom$PwNoise_Dialog = PwNoise_Dialog.class$("jvx.geom.PwNoise_Dialog")))) {
            this.init();
            ((Component)((Object)this)).setSize(350, 150);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_cNormal || object == this.m_cTangential) {
            this.m_pwNoise.noise(this.m_eps.getValue(), this.m_cNormal.getState(), this.m_cTangential.getState());
        }
    }

    public boolean update(Object object) {
        if (object == this.m_eps) {
            this.m_pwNoise.noise(this.m_eps.getValue(), this.m_cNormal.getState(), this.m_cTangential.getState());
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bOk) {
            this.m_action = 16;
            ((Window)((Object)this)).dispose();
            return;
        }
        if (object == this.m_bCancel) {
            this.m_pwNoise.m_pointSet.copy((PgGeometry)this.m_pointSetCopy);
            this.m_pwNoise.m_pointSet.update((Object)this.m_pwNoise.m_pointSet);
            this.m_action = 16;
            ((Window)((Object)this)).dispose();
            return;
        }
        if (object == this.m_scramble) {
            this.m_pwNoise.newNoise();
            this.m_pwNoise.noise(this.m_eps.getValue(), this.m_cNormal.getState(), this.m_cTangential.getState());
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        Panel panel = new Panel(new GridLayout(2, 1));
        Panel panel2 = new Panel(new GridLayout(1, 2));
        this.m_cNormal = new Checkbox("Normal", true);
        this.m_cNormal.addItemListener((ItemListener)((Object)this));
        panel2.add(this.m_cNormal);
        this.m_cTangential = new Checkbox("Tangential", false);
        this.m_cTangential.addItemListener((ItemListener)((Object)this));
        panel2.add(this.m_cTangential);
        if (!this.m_bHasVertexNormals) {
            this.m_cTangential.setState(true);
            this.m_cTangential.setEnabled(false);
            this.m_cNormal.setEnabled(false);
        }
        panel.add(panel2);
        this.m_eps = new PuDouble("Amplitude", (PsUpdateIf)this);
        double d = this.m_pwNoise.m_pointSet.getDiameter();
        this.m_eps.setDefValue(d / 1000.0);
        this.m_eps.setDefBounds(0.0, d / 10.0, d / 1000.0, d / 100.0);
        this.m_eps.init();
        panel.add((Component)this.m_eps.getInfoPanel());
        ((Container)((Object)this)).add(panel);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1));
        this.m_scramble = new Button("New Noise");
        this.m_scramble.addActionListener((ActionListener)((Object)this));
        panel3.add(this.m_scramble);
        this.m_bOk = new Button(PsConfig.getMessage((String)"bOk"));
        this.m_bOk.addActionListener((ActionListener)((Object)this));
        panel3.add(this.m_bOk);
        this.m_bCancel = new Button(PsConfig.getMessage((String)"bCancel"));
        this.m_bCancel.addActionListener((ActionListener)((Object)this));
        panel3.add(this.m_bCancel);
        ((Container)((Object)this)).setLayout(new FlowLayout());
        ((Container)((Object)this)).add(panel3);
        ((Container)((Object)this)).validate();
        this.m_pwNoise.noise(this.m_eps.getValue(), this.m_cNormal.getState(), this.m_cTangential.getState());
    }
}

