/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;

public class PnVertexRK
extends PnGeodesicRK {
    protected PdBaryDir[][] m_vec = null;

    public PnVertexRK(PgElementSet pgElementSet) {
        super(pgElementSet);
    }

    public void setVectorField(PdBaryDir[][] pdBaryDirArray) {
        this.m_vec = pdBaryDirArray;
    }

    public void setVectorField(PgVectorField pgVectorField) {
        int n = pgVectorField.getNumVectors();
        int n2 = this.m_geom.getNumElements();
        this.m_vec = new PdBaryDir[n2][this.m_geom.getNumVertices()];
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        PiVector[] piVectorArray = this.m_geom.getElements();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = piVectorArray[n3].getSize();
            int n5 = 0;
            while (n5 < n4) {
                int n6 = piVectorArray[n3].getEntry(n5);
                if (n6 < n) {
                    this.m_vec[n3][n5] = new PdBaryDir(3);
                    PwBary.projectOntoElement(this.m_geom, n3, pdVectorArray[n6], this.m_vec[n3][n5]);
                }
                ++n5;
            }
            ++n3;
        }
    }

    public void eval(int n, PdBary pdBary, PdBaryDir pdBaryDir) {
        try {
            pdBaryDir.setSize(3);
            int n2 = 0;
            do {
                pdBaryDir.m_data[n2] = 0.0;
            } while (++n2 < 3);
            int n3 = 0;
            do {
                n2 = 0;
                do {
                    int n4 = n3;
                    pdBaryDir.m_data[n4] = pdBaryDir.m_data[n4] + pdBary.m_data[n2] * this.m_vec[n][n2].m_data[n3];
                } while (++n2 < 3);
            } while (++n3 < 3);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            PsDebug.warning((String)"Invalid vector field", (Object)this.m_vec);
            return;
        }
        catch (NullPointerException nullPointerException) {
            PsDebug.warning((String)"Invalid vector field or missing outdir", (Object)this.m_vec);
            return;
        }
    }
}

