/*
 * Decompiled with CFR 0.152.
 */
package jvx.surface;

import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jvx.surface.PgDomainDescr;

public class PgParmSurface
extends PgGeometry {
    protected static final int m_numVariables = 2;
    protected int m_numFunctions;
    protected PgDomainDescr m_domain;
    protected PuFunction m_function;
    protected PgElementSet m_surface;
    private static /* synthetic */ Class class$jvx$surface$PgParmSurface;

    public boolean setSurface(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing surface");
            return false;
        }
        this.m_surface = pgElementSet;
        return true;
    }

    public boolean setDomain(PgDomainDescr pgDomainDescr) {
        if (pgDomainDescr == null) {
            PsDebug.warning((String)"missing domain");
            return false;
        }
        this.m_domain = pgDomainDescr;
        this.m_domain.setParent((PsUpdateIf)this);
        return true;
    }

    public PgParmSurface(int n) {
        super(n);
        this.m_numFunctions = n;
        if (((Object)((Object)this)).getClass() == (class$jvx$surface$PgParmSurface != null ? class$jvx$surface$PgParmSurface : (class$jvx$surface$PgParmSurface = PgParmSurface.class$("jvx.surface.PgParmSurface")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == this.m_domain) {
            if (this.m_surface != null) {
                this.computeSurface();
            }
            return this.m_surface.update(null);
        }
        if (object == this.m_function) {
            if (this.m_surface != null) {
                this.computeSurface();
            }
            return this.m_surface.update(null);
        }
        return super.update(object);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean setFunction(PuFunction puFunction) {
        if (puFunction == null) {
            PsDebug.warning((String)"missing function");
            return false;
        }
        this.m_function = puFunction;
        this.m_function.setParent((PsUpdateIf)this);
        return true;
    }

    public void init() {
        super.init();
    }

    public boolean computeSurface() {
        int n = this.m_domain.getNumULines();
        int n2 = this.m_domain.getNumVLines();
        this.m_surface.setNumVertices(n * n2);
        this.m_surface.setDimOfElements(4);
        this.m_surface.makeQuadrConn(n, n2);
        this.m_surface.assureVertexNormals();
        double[] dArray = new double[2];
        PdVector pdVector = new PdVector(this.m_numFunctions);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                this.m_domain.eval(dArray, n4, n5);
                this.m_function.eval(pdVector.m_data, dArray);
                this.m_surface.setVertex(n3, pdVector);
                ++n3;
                ++n5;
            }
            ++n4;
        }
        this.m_surface.makeVertexNormals();
        return true;
    }
}

