/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download;

import com.zerog.ia.download.downloaders.BrowserDownloader;
import com.zerog.ia.download.downloaders.FileDownloader;
import com.zerog.ia.download.downloaders.FileExecutor;
import com.zerog.ia.download.downloaders.ZGDownloader;
import com.zerog.ia.download.outputListeners.ContextListener;
import com.zerog.ia.download.outputListeners.GUIContextListener;
import com.zerog.ia.download.outputListeners.GUIDownloadListener;
import com.zerog.ia.download.outputListeners.StdErrContextListener;
import com.zerog.ia.download.outputListeners.TimeoutListener;
import com.zerog.ia.download.shared.DownloadContext;
import com.zerog.ia.download.shared.Platform;
import com.zerog.ia.download.shared.PlatformList;
import com.zerog.ia.download.utility.Gestalt;
import com.zerog.ia.download.utility.GridBagUtilImpl;
import com.zerog.ia.download.utility.Util;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class WebInstallerApplet
extends Applet
implements DownloadContext {
    public static String unknownErrorMessage = "The applet has failed for an unknown reason, possibly because of an incompatibility between this applet and your browser.";
    public PlatformList platforms;
    private boolean wantingToDownloadInstallerWithVM;
    private boolean allowingEmailToBeSent;
    private String productName;
    private Frame parentFrame;
    private Vector contextListenerList = new Vector(3, 1);
    private FileDownloader downloadProcess;
    private Button btnAction;
    private Checkbox chkIncludeVM;
    private Image creditImage;
    private Panel pnlNormalGui;
    private Panel pnlExceptionGui;
    private Panel pnlNoInstallerGui;
    private String troubleEmailAddress;
    private Vector filesToBeDeleted = new Vector(1, 1);
    private boolean immediateInstall = false;
    private boolean optionToDownloadEitherInstaller = true;
    private int timeoutLength = 30000;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() {
        try {
            super.init();
            System.out.println("Platform :  " + Gestalt.getPlatform());
            System.out.println("VM Vendor:  " + Gestalt.getVMVendor());
            System.out.println("VM Version: " + Gestalt.getVMVersion());
            System.out.println("IsSupportedVM:  " + Gestalt.isSupportedVM());
            System.out.println("-----------------------");
            this.addContextListener(new GUIContextListener(this));
            this.addContextListener(new StdErrContextListener(this));
            this.notifySetFriendlyErrorMessage(unknownErrorMessage);
            this.notifyOutputDiagnosticMessage("Java Vendor:  " + System.getProperty("java.vendor"));
            this.notifyOutputDiagnosticMessage("URL:  " + System.getProperty("java.vendor.url"));
            this.notifyOutputDiagnosticMessage("Java Version:  " + System.getProperty("java.version"));
            this.notifyOutputDiagnosticMessage("Java Class Version:  " + System.getProperty("java.class.version"));
            this.notifyOutputDiagnosticMessage("OS Name:  " + System.getProperty("os.name"));
            this.notifyOutputDiagnosticMessage("OS Architecture:  " + System.getProperty("os.arch"));
            this.notifyOutputDiagnosticMessage("OS Version:  " + System.getProperty("os.version"));
            this.notifyOutputDiagnosticMessage("---------------------------------");
            if (!Gestalt.isSupportedVM()) {
                this.handleError();
                return;
            }
            this.loadPlatformData();
            this.platforms.computeRunningOnPlatform();
            if (this.platforms.getRunningOnPlatform() == null) {
                this.handleNoInstallerError();
                return;
            }
            this.optionToDownloadEitherInstaller = true;
            this.setWantingToDownloadInstallerWithVM(true);
            if (this.platforms.getRunningOnPlatform().installerNameVM == null) {
                this.setWantingToDownloadInstallerWithVM(false);
                this.optionToDownloadEitherInstaller = false;
            } else if (this.platforms.getRunningOnPlatform().installerNameNoVM == null) {
                this.setWantingToDownloadInstallerWithVM(true);
                this.optionToDownloadEitherInstaller = false;
            }
            if (this.troubleEmailAddress != null) {
                if (this.troubleEmailAddress.indexOf(64) >= 0) {
                    this.setAllowingEmailToBeSent(true);
                } else {
                    this.setAllowingEmailToBeSent(false);
                }
            } else {
                this.setAllowingEmailToBeSent(false);
            }
            if (this.immediateInstall) {
                this.startDownloadProcess();
                return;
            }
            this.createAppletGui();
            return;
        }
        catch (Throwable throwable) {
            this.notifyErrorOccured(throwable);
            this.handleError();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createAppletGui() throws Exception {
        this.setBackground(Color.white);
        this.pnlExceptionGui = new Panel();
        this.pnlExceptionGui.setLayout(new FlowLayout());
        this.pnlExceptionGui.add(new Label("Please select an installer to download from the list below.", 1));
        this.pnlNormalGui = new Panel();
        this.pnlNoInstallerGui = new Panel();
        this.pnlNoInstallerGui.setLayout(new GridLayout(2, 1));
        this.pnlNoInstallerGui.add(new Label("No installer is available for your system.", 1));
        this.pnlNoInstallerGui.add(new Label("You can download an installer for another platform from the list below.", 1));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.pnlNormalGui.setLayout(gridBagLayout);
        GridBagUtilImpl.setLayoutManager(gridBagLayout);
        Label label = new Label("Recommended Installation for Your Platform:", 1);
        Font font = this.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize() + 2);
        if (!Gestalt.getVMVendor().equals(Gestalt.APPLE_VM)) {
            label.setFont(font2);
        }
        GridBagUtilImpl.add(this.pnlNormalGui, label, 0, 0, 3, 1, 2, 10, 1.0, 0.0);
        this.btnAction = new Button();
        GridBagUtilImpl.add(this.pnlNormalGui, this.btnAction, 0, 1, 2, 1, 2, 11, 2.0, 1.0);
        this.chkIncludeVM = new Checkbox("Include VM in download");
        if (this.optionToDownloadEitherInstaller) {
            GridBagUtilImpl.add(this.pnlNormalGui, this.chkIncludeVM, 2, 1, 1, 1, 2, new Insets(0, 5, 0, 0), 11, 1.0, 1.0);
        }
        this.add(this.pnlNormalGui);
        this.chkIncludeVM.setState(this.isWantingToDownloadInstallerWithVM());
        Font font3 = new Font("Dialog", 0, 11);
        this.btnAction.setFont(font3);
        try {
            this.creditImage = this.getImage(new URL(this.getCodeBase() + "com/zerog/ia/download/credit.gif"));
        }
        catch (Throwable throwable) {
            this.notifyOutputDiagnosticMessage("init: Credits gif couldn't be loaded.");
            this.creditImage = null;
        }
        this.updateActionButtonText();
        this.repaint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleError() {
        try {
            this.remove(this.pnlNormalGui);
        }
        catch (Throwable throwable) {
            System.err.println("WebInstallerApplet:  Unable to remove pnlNormalGui.");
        }
        try {
            this.add(this.pnlExceptionGui);
        }
        catch (Throwable throwable) {
            System.err.println("WebInstallerApplet:  Unable to add pnlExceptionGui.");
        }
        this.repaint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleNoInstallerError() {
        try {
            this.remove(this.pnlNormalGui);
        }
        catch (Throwable throwable) {
            System.err.println("WebInstallerApplet:  Unable to remove pnlNormalGui.");
        }
        try {
            this.add(this.pnlNoInstallerGui);
        }
        catch (Throwable throwable) {
            System.err.println("WebInstallerApplet:  Unable to add pnlNoInstallerGui.");
        }
        this.repaint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        try {
            super.start();
            return;
        }
        catch (Throwable throwable) {
            this.notifyErrorOccured(throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addNotify() {
        try {
            super.addNotify();
            Container container = this;
            while (true) {
                if (container == null) {
                    return;
                }
                System.err.println(container);
                if (container instanceof Frame) {
                    this.parentFrame = (Frame)container;
                }
                container = container.getParent();
            }
        }
        catch (Throwable throwable) {
            this.notifyErrorOccured(throwable);
        }
    }

    public synchronized boolean isWantingToDownloadInstallerWithVM() {
        return this.wantingToDownloadInstallerWithVM;
    }

    public synchronized void setWantingToDownloadInstallerWithVM(boolean bl) {
        this.wantingToDownloadInstallerWithVM = bl;
        this.updateActionButtonText();
    }

    public String getTroubleEmailAddress() {
        return this.troubleEmailAddress;
    }

    public PlatformList getPlatforms() {
        return this.platforms;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadPlatformData() throws Exception {
        this.productName = this.getParameter("ProductName");
        String string = this.getParameter("ImmediateInstall");
        String string2 = this.getParameter("Timeout");
        if (string2 == null || string2.equals("")) {
            this.timeoutLength = 30000;
            this.notifyOutputDiagnosticMessage("Timeout set to :" + this.timeoutLength);
        } else {
            this.timeoutLength = new Integer(this.getParameter("Timeout"));
            this.notifyOutputDiagnosticMessage("Timeout set to :" + this.timeoutLength);
        }
        try {
            this.immediateInstall = string.toLowerCase().equals("yes");
        }
        catch (Exception exception) {
            this.immediateInstall = false;
        }
        this.notifyOutputDiagnosticMessage("immediateInstall:  " + this.immediateInstall);
        this.troubleEmailAddress = this.getParameter("SendTroubleEmailTo");
        this.notifyOutputDiagnosticMessage("Trouble e-mail address:  " + this.troubleEmailAddress);
        this.platforms = new PlatformList();
        int n = 20;
        int n2 = 1;
        while (n2 <= n) {
            try {
                Platform platform = new Platform(this, n2);
                this.platforms.add(platform);
                this.notifyOutputDiagnosticMessage("Reading applet parameters: Reading in data for platform #" + n2 + "; platform name = " + platform.platformName);
            }
            catch (Throwable throwable) {
                this.notifyOutputDiagnosticMessage("Reading applet parameters: Platform #" + n2 + " not found.");
            }
            ++n2;
        }
        Platform platform = this.platforms.getRunningOnPlatform();
        if (platform == null) {
            // empty if block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleEvent(Event event) {
        try {
            if (event.target == this.btnAction && event.id == 1001) {
                this.pnlNormalGui.disable();
                this.startDownloadProcess();
                return true;
            }
            if (event.target == this.chkIncludeVM && event.id == 1001) {
                this.setWantingToDownloadInstallerWithVM(this.chkIncludeVM.getState());
                return true;
            }
            if (event.id == 505) {
                this.getAppletContext().showStatus("");
                return super.handleEvent(event);
            }
            if (this.creditImage == null) {
                this.getAppletContext().showStatus("");
                return super.handleEvent(event);
            }
            if (event.id == 501 && event.y >= this.size().height - this.creditImage.getHeight(this)) {
                try {
                    this.getAppletContext().showDocument(new URL("http://www.InstallAnywhere.com"));
                    return true;
                }
                catch (Throwable throwable) {
                    this.notifyOutputDiagnosticMessage("HandleEvent: User clicked on credit GIF; applet couldn't open www.InstallAnywhere.com.");
                    return true;
                }
            }
            if (event.y < this.size().height - this.creditImage.getHeight(this)) return true;
            this.getAppletContext().showStatus("http://www.InstallAnywhere.com");
            return super.handleEvent(event);
        }
        catch (Throwable throwable) {
            this.notifyErrorOccured(throwable);
            return false;
        }
    }

    void updateActionButtonText() {
        boolean bl;
        if (this.btnAction == null) {
            return;
        }
        String string = this.platforms.getRunningOnPlatform().platformName;
        if (this.isWantingToDownloadInstallerWithVM()) {
            bl = !this.platforms.getRunningOnPlatform().isNotRunnableVM;
        } else {
            boolean bl2 = bl = !this.platforms.getRunningOnPlatform().isNotRunnableNoVM;
        }
        if (Gestalt.isAbleToExecuteFiles() && bl) {
            this.btnAction.setLabel("     Start Installer for " + string + "...     ");
        } else {
            this.btnAction.setLabel("Download Installer for " + string + "...");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        super.paint(graphics);
        try {
            if (this.creditImage == null) return;
            Dimension dimension = this.size();
            graphics.drawImage(this.creditImage, dimension.width - this.creditImage.getWidth(this) >> 1, dimension.height - 1 - this.creditImage.getHeight(this), this);
            return;
        }
        catch (Throwable throwable) {
            this.notifyErrorOccured(throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startDownloadProcess() throws Exception {
        boolean bl;
        URL uRL = null;
        String string = this.isWantingToDownloadInstallerWithVM() ? this.getCodeBase().toString() + this.platforms.getRunningOnPlatform().installerNameVM : this.getCodeBase().toString() + this.platforms.getRunningOnPlatform().installerNameNoVM;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.notifySetFriendlyErrorMessage("Installer '" + string + "' not found.");
            throw malformedURLException;
        }
        this.notifyOutputDiagnosticMessage("Handle Event: File to copy is '" + string + "'.");
        if (this.isWantingToDownloadInstallerWithVM()) {
            System.err.println("1");
            bl = !this.platforms.getRunningOnPlatform().isNotRunnableVM;
        } else {
            System.err.println("2");
            boolean bl2 = bl = !this.platforms.getRunningOnPlatform().isNotRunnableNoVM;
        }
        if (!bl) {
            this.doBrowserDownload(uRL);
            return;
        }
        if (bl && Gestalt.isAbleToExecuteFiles()) {
            this.doZGDownload(uRL);
            return;
        }
        this.doBrowserDownload(uRL);
    }

    public void doZGDownload(URL uRL) {
        String string;
        if (Gestalt.isNetscapeSecurityModelAvailable()) {
            PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_PROPERTY_READ);
        }
        String string2 = this.getIALogFileDirectory();
        if (this.isWantingToDownloadInstallerWithVM()) {
            string = this.platforms.getRunningOnPlatform().installerNameVM;
            string = string.substring(string.lastIndexOf(47) + 1);
        } else {
            string = this.platforms.getRunningOnPlatform().installerNameNoVM;
            string = string.substring(string.lastIndexOf(47) + 1);
        }
        String string3 = this.getProductName().substring(0, Math.min(30, this.getProductName().length()));
        if (Gestalt.isThisPlatformUnix()) {
            string3 = string3.replace(' ', '_');
        }
        File file = new File(Util.prepFileName(string2 + string3 + "/" + string));
        this.notifyOutputDiagnosticMessage("handleEvent: File to write out is '" + file.getAbsolutePath() + "'.");
        this.notifyOutputDiagnosticMessage("handleEvent: Preparing ZGDownloader object.");
        this.downloadProcess = new ZGDownloader(this);
        this.downloadProcess.addDownloadListener(new TimeoutListener(this.downloadProcess, this.timeoutLength));
        this.downloadProcess.addDownloadListener(new GUIDownloadListener((ZGDownloader)this.downloadProcess));
        this.downloadProcess.setFileToDownload(uRL);
        ((ZGDownloader)this.downloadProcess).setFileDestination(file);
        this.notifyOutputDiagnosticMessage("handleEvent: Wants to execute installer; passing in file executor object.");
        FileExecutor fileExecutor = new FileExecutor(file, this.downloadProcess);
        ((ZGDownloader)this.downloadProcess).setExecutorObject(fileExecutor);
        this.downloadProcess.start();
    }

    public void doBrowserDownload(URL uRL) {
        this.notifyOutputDiagnosticMessage("Preparing browser download object.");
        this.downloadProcess = new BrowserDownloader(this);
        this.downloadProcess.setFileToDownload(uRL);
        this.downloadProcess.start();
    }

    public Frame getParentFrame() {
        return this.parentFrame;
    }

    public String getProductName() {
        return this.productName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getCodeBase() {
        String string = super.getCodeBase().toString();
        if (string.substring(string.length() - 2).equals("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.notifyOutputDiagnosticMessage("getCodeBase: Unable to retrieve code base (currently showing up as '" + string + "'.");
            return null;
        }
    }

    public void addContextListener(ContextListener contextListener) {
        this.contextListenerList.addElement(contextListener);
    }

    public void removeContextListener(ContextListener contextListener) {
        this.contextListenerList.removeElement(contextListener);
    }

    public void notifyErrorOccured(Throwable throwable) {
        Enumeration enumeration = this.contextListenerList.elements();
        while (enumeration.hasMoreElements()) {
            ((ContextListener)enumeration.nextElement()).errorOccured(throwable);
        }
        this.notifySetFriendlyErrorMessage(unknownErrorMessage);
    }

    public void notifyOutputDiagnosticMessage(String string) {
        Enumeration enumeration = this.contextListenerList.elements();
        while (enumeration.hasMoreElements()) {
            ((ContextListener)enumeration.nextElement()).outputDiagnosticMessage(string);
        }
    }

    public void notifySetFriendlyErrorMessage(String string) {
        Enumeration enumeration = this.contextListenerList.elements();
        while (enumeration.hasMoreElements()) {
            ((ContextListener)enumeration.nextElement()).setFriendlyErrorMessage(string);
        }
    }

    public FileDownloader getDownloadProcess() {
        return this.downloadProcess;
    }

    public boolean isAllowingEmailToBeSent() {
        return this.allowingEmailToBeSent;
    }

    public void setAllowingEmailToBeSent(boolean bl) {
        this.allowingEmailToBeSent = bl;
    }

    public Vector getContextListenerList() {
        return this.contextListenerList;
    }

    public void downloadStopped() {
        if (this.pnlNormalGui != null) {
            this.pnlNormalGui.enable();
        }
    }

    public String getIALogFileDirectory() {
        String string;
        if (Gestalt.getPlatform().equals(Gestalt.WINDOWS_PLATFORM) || Gestalt.getPlatform().equals(Gestalt.MAC_OS_PLATFORM)) {
            String string2 = Util.prepFileName(System.getProperty("user.home"));
            string = string2.substring(0, string2.indexOf(47));
        } else {
            string = System.getProperty("user.home");
            int n = string.toLowerCase().lastIndexOf(".netscape");
            if (n >= 0) {
                string = string.substring(0, n - 1);
            }
        }
        this.notifyOutputDiagnosticMessage("handleEvent: rootDir = '" + string + "'.");
        return string + "/IA_Installers/";
    }
}

