/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.dialogs;

import com.zerog.ia.download.WebInstallerApplet;
import com.zerog.ia.download.dialogs.ErrorDetailDialog;
import com.zerog.ia.download.dialogs.GUIDialog;
import com.zerog.ia.download.shared.DownloadContext;
import com.zerog.ia.download.utility.Gestalt;
import com.zerog.ia.download.utility.GridBagUtilImpl;
import com.zerog.ia.download.utility.Util;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;

public class ErrorDialog
extends GUIDialog {
    TextArea txtErrorMessage;
    Button btnOk;
    Button btnShowDetail;
    Checkbox chkSendEmail;
    TextField txtEmailAddress;
    Label lblEmailAddress;
    Label lblDetail;
    DownloadContext context;
    String log;
    ErrorDetailDialog edd;
    String errorMessage;

    public boolean handleEvent(Event event) {
        if (event.target == this.btnOk && event.id == 1001) {
            if (this.chkSendEmail.getState()) {
                if (this.txtEmailAddress.getText().indexOf(64) >= 0) {
                    ((Component)this).hide();
                } else {
                    ((TextComponent)this.txtEmailAddress).setText("Not a valid e-mail address");
                    this.calculateEmailGuiState();
                }
            } else {
                ((Component)this).hide();
            }
        } else if (event.target == this.chkSendEmail && event.id == 1001) {
            this.calculateEmailGuiState();
        } else if (event.target == this.btnShowDetail && event.id == 1001) {
            if (this.edd == null) {
                this.edd = new ErrorDetailDialog(this.context.getParentFrame(), this, this.log);
            } else {
                this.edd.show();
            }
        } else {
            return super.handleEvent(event);
        }
        return true;
    }

    void calculateEmailGuiState() {
        if (this.chkSendEmail.getState()) {
            this.txtEmailAddress.setEditable(true);
            this.txtEmailAddress.select(0, this.txtEmailAddress.getText().length());
            this.txtEmailAddress.requestFocus();
            this.lblEmailAddress.enable();
        } else {
            this.txtEmailAddress.setEditable(false);
            this.txtEmailAddress.select(0, 0);
            this.lblEmailAddress.disable();
        }
    }

    public ErrorDialog(Frame frame, String string, String string2, DownloadContext downloadContext) {
        super(frame, "Installation Error Occured", true);
        this.context = downloadContext;
        this.errorMessage = string;
        this.log = string2;
        Font font = new Font("Courier", 0, 12);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagUtilImpl.setLayoutManager(gridBagLayout);
        GridBagUtilImpl.add(this, new Label("The following error occured:"), 0, 0, 3, 1, 0, 18);
        System.err.println("ErrorDialog:  _errorMessage = " + string);
        this.txtErrorMessage = new TextArea(Util.addNewlines(string, 60), 4, 60);
        this.txtErrorMessage.setFont(font);
        this.txtErrorMessage.setEditable(false);
        GridBagUtilImpl.add(this, this.txtErrorMessage, 0, 1, 3, 1, 1, 18, 1.0, 1.0);
        this.btnShowDetail = new Button("Show error detail...");
        GridBagUtilImpl.add(this, this.btnShowDetail, 0, 2, 3, 1, 2, new Insets(2, 0, 0, 0), 17, 0.0, 0.0);
        this.chkSendEmail = new Checkbox("Send an e-mail to '" + this.context.getTroubleEmailAddress() + "' about this problem");
        if (((WebInstallerApplet)this.context).isAllowingEmailToBeSent() && Gestalt.isAbleToSendEmail()) {
            GridBagUtilImpl.add(this, this.chkSendEmail, 0, 3, 3, 1, 2, new Insets(20, 0, 0, 0), 17);
            this.chkSendEmail.setState(false);
            this.lblEmailAddress = new Label("Please enter an e-mail address so we can reply to this problem:");
            GridBagUtilImpl.add(this, this.lblEmailAddress, 1, 4, 1, 1, 2, 13, 0.0, 0.0);
            this.txtEmailAddress = new TextField(25);
            GridBagUtilImpl.add(this, this.txtEmailAddress, 2, 4, 1, 1, 2, 17, 0.0, 0.0);
            this.calculateEmailGuiState();
        }
        this.btnOk = new Button("           OK           ");
        GridBagUtilImpl.add(this, this.btnOk, 0, 5, 3, 1, 0, new Insets(20, 0, 0, 0), 13, 0.0, 0.0);
        this.btnOk.requestFocus();
        this.pack();
        this.center();
        this.show();
    }
}

