/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders;

import com.zerog.ia.download.outputListeners.DownloadListener;
import com.zerog.ia.download.shared.DownloadContext;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class FileDownloader
extends Thread {
    URL fileToDownload;
    DownloadContext context;
    boolean downloadCancelled = false;
    Vector downloadListenerList = new Vector(3, 1);

    public void start() {
        this.setPriority(1);
        super.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        super.run();
        try {
            this.downloadFileNow(this.fileToDownload);
            return;
        }
        catch (Exception exception) {
            this.notifyErrorOccured(exception);
        }
    }

    public void downloadFileNow(URL uRL) throws Exception {
    }

    public void setFileToDownload(URL uRL) {
        this.fileToDownload = uRL;
    }

    public boolean isDownloadCancelled() {
        return this.downloadCancelled;
    }

    public void cancelDownload() {
        this.downloadCancelled = true;
    }

    public void notifyDownloadStarted(String string) {
        Enumeration enumeration = this.downloadListenerList.elements();
        while (enumeration.hasMoreElements()) {
            ((DownloadListener)enumeration.nextElement()).downloadStarted(string);
        }
    }

    public void notifyDownloadCompleted() {
        Enumeration enumeration = this.downloadListenerList.elements();
        while (enumeration.hasMoreElements()) {
            ((DownloadListener)enumeration.nextElement()).downloadCompleted();
        }
        this.context.downloadStopped();
    }

    public void notifyDownloadCancelled() {
        Enumeration enumeration = this.downloadListenerList.elements();
        while (enumeration.hasMoreElements()) {
            DownloadListener downloadListener = (DownloadListener)enumeration.nextElement();
            downloadListener.downloadCancelled();
        }
        this.context.downloadStopped();
    }

    public void notifySetFriendlyErrorMessage(String string) {
        this.getContext().notifySetFriendlyErrorMessage(string);
    }

    public void notifyOutputDiagnosticMessage(String string) {
        this.getContext().notifyOutputDiagnosticMessage(string);
    }

    public void notifyErrorOccured(Throwable throwable) {
        Enumeration enumeration = this.downloadListenerList.elements();
        while (enumeration.hasMoreElements()) {
            DownloadListener downloadListener = (DownloadListener)enumeration.nextElement();
            downloadListener.errorOccured();
            System.err.println("DownloadListener = " + downloadListener);
        }
        this.context.downloadStopped();
        this.getContext().notifyErrorOccured(throwable);
    }

    public void addDownloadListener(DownloadListener downloadListener) {
        this.downloadListenerList.addElement(downloadListener);
    }

    public void removeDownloadListener(DownloadListener downloadListener) {
        this.downloadListenerList.removeElement(downloadListener);
    }

    public Vector getDownloadListenerList() {
        return this.downloadListenerList;
    }

    public DownloadContext getContext() {
        return this.context;
    }

    public FileDownloader(DownloadContext downloadContext) {
        this.context = downloadContext;
    }
}

