/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.utility;

import netscape.security.PrivilegeManager;

public class Gestalt {
    public static String NETSCAPE_VM = "netscape";
    public static String MICROSOFT_VM = "microsoft";
    public static String SUN_VM = "sun";
    public static String APPLE_VM = "apple";
    public static String IBM_VM = "ibm";
    public static String WINDOWS_PLATFORM = "windows";
    public static String MAC_OS_PLATFORM = "mac os";
    public static String SOLARIS_PLATFORM = "solaris";
    public static String HPUX_PLATFORM = "hp-ux";
    public static String LINUX_PLATFORM = "linux";
    public static String DGUX_PLATFORM = "dg-ux";
    public static String IRIX_PLATFORM = "irix";
    public static String AIX_PLATFORM = "aix";
    public static String OS2_PLATFORM = "os/2";
    public static String NETSCAPE_FILE_ACCESS = "UniversalFileAccess";
    public static String NETSCAPE_EXEC_ACCESS = "UniversalExecAccess";
    public static String NETSCAPE_PROPERTY_READ = "UniversalPropertyRead";
    private static String vmVendor;
    private static String platform;
    private static String vmVersion;
    private static boolean determinedAbleToCreateFiles;
    private static boolean determinedAbleToExecuteFiles;
    private static boolean determinedAbleToReadSystemProperties;
    private static boolean ableToCreateFiles;
    private static boolean ableToExecuteFiles;
    private static boolean ableToReadSystemProperties;

    public static String getVMVendor() {
        if (vmVendor == null) {
            String string = System.getProperty("java.vendor").toLowerCase();
            vmVendor = string.indexOf("netscape") >= 0 ? NETSCAPE_VM : (string.indexOf("microsoft") >= 0 ? MICROSOFT_VM : (string.indexOf("sun") >= 0 || string.indexOf("java") >= 0 ? SUN_VM : (string.indexOf("apple") >= 0 || string.indexOf("mac") >= 0 ? APPLE_VM : (string.indexOf("ibm") >= 0 ? IBM_VM : string.toLowerCase()))));
        }
        return vmVendor;
    }

    public static String getVMVersion() {
        if (vmVersion == null) {
            vmVersion = System.getProperty("java.version").toLowerCase();
        }
        return vmVersion;
    }

    public static String getPlatform() {
        if (platform == null) {
            String string = System.getProperty("os.name").toLowerCase();
            platform = string.indexOf("win") >= 0 ? WINDOWS_PLATFORM : (string.indexOf("apple") >= 0 || string.indexOf("mac") >= 0 ? MAC_OS_PLATFORM : (string.indexOf("sun") >= 0 || string.indexOf("solaris") >= 0 ? SOLARIS_PLATFORM : (string.indexOf("hp") >= 0 ? HPUX_PLATFORM : (string.indexOf("os/2") >= 0 ? OS2_PLATFORM : string.toLowerCase()))));
        }
        return platform;
    }

    public static boolean isThisPlatformUnix() {
        if (Gestalt.getPlatform().equals(SOLARIS_PLATFORM)) {
            return true;
        }
        if (Gestalt.getPlatform().equals(HPUX_PLATFORM)) {
            return true;
        }
        if (Gestalt.getPlatform().equals(LINUX_PLATFORM)) {
            return true;
        }
        if (Gestalt.getPlatform().equals(IRIX_PLATFORM)) {
            return true;
        }
        if (Gestalt.getPlatform().equals(AIX_PLATFORM)) {
            return true;
        }
        if (Gestalt.getPlatform().equals(DGUX_PLATFORM)) {
            return true;
        }
        return Gestalt.getPlatform().indexOf("unix") >= 0;
    }

    public static boolean isSupportedVM() {
        return !(Gestalt.getPlatform().equals(MAC_OS_PLATFORM) ? Gestalt.getVMVendor().equals(MICROSOFT_VM) && Gestalt.getVMVersion().equals("1.1.4") : (Gestalt.getPlatform().equals(SOLARIS_PLATFORM) ? Gestalt.getVMVendor().equals(NETSCAPE_VM) && Gestalt.getVMVersion().equals("1.02") : Gestalt.getPlatform().equals(OS2_PLATFORM) && Gestalt.getVMVendor().equals(IBM_VM) && Gestalt.getVMVersion().equals("1.1.6")));
    }

    public static boolean isNetscapeSecurityModelAvailable() {
        if (Gestalt.getVMVendor().equals(NETSCAPE_VM)) {
            return !Gestalt.getPlatform().equals(MAC_OS_PLATFORM);
        }
        return false;
    }

    public static boolean vmCanSupportUnsecureActivities() {
        if (Gestalt.getVMVendor().equals(MICROSOFT_VM)) {
            return Gestalt.getPlatform().equals(WINDOWS_PLATFORM) || Gestalt.getPlatform().equals(MAC_OS_PLATFORM);
        }
        if (Gestalt.getVMVendor().equals(NETSCAPE_VM)) {
            if (Gestalt.getPlatform().equals(WINDOWS_PLATFORM)) {
                return true;
            }
            if (Gestalt.getPlatform().equals(SOLARIS_PLATFORM)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAbleToReadSystemProperties() {
        if (!determinedAbleToReadSystemProperties) {
            if (Gestalt.isNetscapeSecurityModelAvailable()) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalPropertyAccess");
                    ableToReadSystemProperties = true;
                }
                catch (Exception exception) {
                    ableToReadSystemProperties = false;
                }
            } else if (Gestalt.getVMVendor().equals(MICROSOFT_VM)) {
                try {
                    String string = System.getProperty("user.home");
                    ableToReadSystemProperties = true;
                }
                catch (Throwable throwable) {
                    ableToReadSystemProperties = false;
                }
            }
            determinedAbleToReadSystemProperties = true;
        }
        return ableToReadSystemProperties;
    }

    public static boolean isAbleToSendEmail() {
        return Gestalt.getVMVendor() != NETSCAPE_VM;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAbleToCreateFiles() {
        if (!determinedAbleToCreateFiles) {
            if (Gestalt.isNetscapeSecurityModelAvailable()) {
                try {
                    PrivilegeManager.enablePrivilege((String)NETSCAPE_FILE_ACCESS);
                    ableToCreateFiles = true;
                }
                catch (Exception exception) {
                    ableToCreateFiles = false;
                }
            } else if (Gestalt.getVMVendor().equals(MICROSOFT_VM)) {
                try {
                    String string = System.getProperty("user.home");
                    ableToCreateFiles = true;
                }
                catch (Throwable throwable) {
                    ableToCreateFiles = false;
                }
            }
            determinedAbleToCreateFiles = true;
        }
        return ableToCreateFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAbleToExecuteFiles() {
        if (!determinedAbleToExecuteFiles) {
            if (Gestalt.isNetscapeSecurityModelAvailable()) {
                try {
                    System.err.println("************\nAbout to try 'enablePrivilege(" + NETSCAPE_EXEC_ACCESS);
                    PrivilegeManager.enablePrivilege((String)NETSCAPE_EXEC_ACCESS);
                    System.err.println("Made it!!");
                    ableToExecuteFiles = true;
                }
                catch (Exception exception) {
                    ableToExecuteFiles = false;
                }
            } else if (Gestalt.getVMVendor().equals(MICROSOFT_VM)) {
                try {
                    String string = System.getProperty("user.home");
                    ableToExecuteFiles = true;
                }
                catch (Throwable throwable) {
                    ableToExecuteFiles = false;
                }
            }
            determinedAbleToExecuteFiles = true;
        }
        return ableToExecuteFiles;
    }

    static {
        determinedAbleToCreateFiles = false;
        determinedAbleToExecuteFiles = false;
        determinedAbleToReadSystemProperties = false;
        ableToCreateFiles = false;
        ableToExecuteFiles = false;
        ableToReadSystemProperties = false;
        if (Gestalt.isNetscapeSecurityModelAvailable()) {
            Gestalt.isAbleToExecuteFiles();
            Gestalt.isAbleToCreateFiles();
            Gestalt.isAbleToReadSystemProperties();
        }
    }
}

