/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;
import jv.geom.PgPolygon;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuVectorGeom;

public class PgPointSet
extends PgGeometry {
    protected boolean m_bDefaultLabelEnabled;
    protected boolean m_bShowIndices;
    protected boolean m_bShowVertexLabels;
    protected int m_numVertices;
    protected int m_maxNumVertices;
    protected int m_dimOfColors;
    protected PgTexture m_texture;
    protected int m_dimOfTextures;
    protected boolean m_bShowVertexTexture;
    protected PdVector[] m_vertexTexture;
    protected PuDouble m_transparency;
    protected boolean m_bShowTransparency;
    protected PdVector[] m_vertex;
    protected Color[] m_vertexColor;
    protected PdVector[] m_vertexNormal;
    protected int m_dimOfVectors;
    protected int m_numVectorFields;
    protected Vector m_vectorField;
    protected boolean m_bShowVectorFields;
    protected boolean m_bShowVectorArrows;
    protected PdColor m_globalVectorColor;
    protected PuDouble m_globalVectorLength;
    protected PuDouble m_globalVectorSize;
    protected boolean m_bShowVectorColors;
    protected boolean m_bShowVertices;
    protected boolean m_bShowTaggedVertices;
    protected PuInteger m_globalVertexSize;
    protected boolean m_bShowVertexColors;
    protected PdColor m_globalVertexColor;
    protected PdColor m_globalVertexTagColor;
    protected boolean m_bShowVertexNormals;
    protected boolean m_bShowVertexNormalArrow;
    protected PuDouble m_globalVertexNormalLength;
    protected PuDouble m_globalVertexNormalSize;
    protected PdColor m_globalVertexNormalColor;
    private static /* synthetic */ Class class$jv$geom$PgPointSet;

    public Image getTextureImage() {
        if (this.m_texture == null) {
            return null;
        }
        return this.m_texture.getImage();
    }

    public void setTextureImage(Image image) {
        if (image == null) {
            PsDebug.warning("missing texture image");
            return;
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
        this.m_texture.setImage(image);
    }

    public void setState(int n, boolean bl) {
        switch (n) {
            case 50: {
                this.showVertices(bl);
                return;
            }
        }
        super.setState(n, bl);
    }

    public void computePlane(int n, int n2, double d, double d2, double d3, double d4) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        double d5 = (d3 - d) / (-1.0 + (double)n);
        double d6 = (d4 - d2) / (-1.0 + (double)n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d7 = d5 * (double)n4;
            int n5 = 0;
            while (n5 < n2) {
                double d8 = d6 * (double)n5;
                if (this.m_dim > 2) {
                    this.m_vertex[n3].setConstant(0.0);
                }
                this.m_vertex[n3].m_data[0] = d + d7;
                this.m_vertex[n3].m_data[1] = d2 + d8;
                ++n3;
                ++n5;
            }
            ++n4;
        }
        if (this.m_dim == 3) {
            this.assureVertexNormals();
            PdVector.setConstant(this.m_vertexNormal, new PdVector(0.0, 0.0, 1.0));
            return;
        }
        this.setVertexNormals(null);
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        int n = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        PdVector pdVector3 = new PdVector(3);
        pdVector2.normalize();
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (this.m_dim != 3) {
                pdVector3.copyArray(this.m_vertex[n2]);
            } else {
                pdVector3 = this.m_vertex[n2];
            }
            d = PuVectorGeom.distOfPointToLine(pdVector3, pdVector, pdVector2);
            if (!(d >= d2) && !(d > 0.1)) {
                d2 = d;
                n = n2;
            }
            ++n2;
        }
        if (n == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setVertex(this.m_vertex[n]);
        pvPickEvent.setDistance(d2);
        pvPickEvent.setVertexInd(n);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        return pvPickEvent;
    }

    public boolean makeVertexNormals() {
        return false;
    }

    public boolean hasVertexNormals() {
        return this.m_vertexNormal != null && this.m_vertexNormal.length == this.m_maxNumVertices;
    }

    public Color getGlobalVectorColor() {
        return this.m_globalVectorColor.getColor();
    }

    public void setGlobalVectorColor(Color color) {
        this.m_globalVectorColor.setColor(color);
    }

    public void computeSphere(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d2 = 0.0;
        double d3 = 0.0;
        if (n > 1) {
            d2 = Math.PI * 2 / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d3 = Math.PI / (-1.0 + (double)n2);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d4 = d2 * (double)n4;
            double d5 = Math.sin(d4);
            double d6 = Math.cos(d4);
            int n5 = 0;
            while (n5 < n2) {
                double d7 = -1.5707963267948966 + d3 * (double)n5;
                double d8 = Math.sin(d7);
                double d9 = Math.cos(d7);
                this.m_vertex[n3].m_data[0] = d * d6 * d9;
                this.m_vertex[n3].m_data[1] = d * d5 * d9;
                this.m_vertex[n3].m_data[2] = d * d8;
                this.m_vertexNormal[n3].m_data[0] = d6 * d9;
                this.m_vertexNormal[n3].m_data[1] = d5 * d9;
                this.m_vertexNormal[n3].m_data[2] = d8;
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    public boolean hasTagVertex(int n, int n2) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        return this.m_vertex[n].hasTag(n2);
    }

    public int addVertex(PdVector pdVector) {
        this.setVertex(this.m_numVertices, pdVector);
        return this.m_numVertices - 1;
    }

    public Object clone() {
        PgPointSet pgPointSet = (PgPointSet)super.clone();
        if (pgPointSet == null) {
            return null;
        }
        pgPointSet.m_globalVertexSize = (PuInteger)this.m_globalVertexSize.clone();
        pgPointSet.m_globalVertexColor = (PdColor)this.m_globalVertexColor.clone();
        pgPointSet.m_globalVertexTagColor = (PdColor)this.m_globalVertexTagColor.clone();
        pgPointSet.m_globalVertexSize.setParent(pgPointSet);
        pgPointSet.m_globalVertexColor.setParent(pgPointSet);
        pgPointSet.m_globalVertexTagColor.setParent(pgPointSet);
        pgPointSet.m_globalVertexNormalLength = (PuDouble)this.m_globalVertexNormalLength.clone();
        pgPointSet.m_globalVertexNormalSize = (PuDouble)this.m_globalVertexNormalSize.clone();
        pgPointSet.m_globalVertexNormalColor = (PdColor)this.m_globalVertexNormalColor.clone();
        pgPointSet.m_globalVertexNormalLength.setParent(pgPointSet);
        pgPointSet.m_globalVertexNormalSize.setParent(pgPointSet);
        pgPointSet.m_globalVertexNormalColor.setParent(pgPointSet);
        pgPointSet.m_globalVectorSize = (PuDouble)this.m_globalVectorSize.clone();
        pgPointSet.m_globalVectorLength = (PuDouble)this.m_globalVectorLength.clone();
        pgPointSet.m_globalVectorColor = (PdColor)this.m_globalVectorColor.clone();
        pgPointSet.m_globalVectorSize.setParent(pgPointSet);
        pgPointSet.m_globalVectorLength.setParent(pgPointSet);
        pgPointSet.m_globalVectorColor.setParent(pgPointSet);
        pgPointSet.m_transparency = (PuDouble)this.m_transparency.clone();
        if (this.m_texture != null) {
            pgPointSet.m_texture = (PgTexture)this.m_texture.clone();
        }
        if (this.m_vertexTexture != null) {
            pgPointSet.m_vertexTexture = (PdVector[])P_Vector.clone(this.m_vertexTexture);
        }
        if (this.m_vertex != null) {
            pgPointSet.m_vertex = (PdVector[])P_Vector.clone(this.m_vertex);
        }
        if (this.m_vertexColor != null) {
            pgPointSet.m_vertexColor = (Color[])this.m_vertexColor.clone();
        }
        if (this.m_vertexNormal != null) {
            pgPointSet.m_vertexNormal = (PdVector[])P_Vector.clone(this.m_vertexNormal);
        }
        if (this.m_vectorField != null) {
            pgPointSet.m_vectorField = null;
            pgPointSet.m_numVectorFields = 0;
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (pgVectorField != null) {
                    PgVectorField pgVectorField2 = (PgVectorField)pgVectorField.clone();
                    pgPointSet.addVectorField(pgVectorField2);
                    pgVectorField2.setGeometry(pgPointSet);
                    continue;
                }
                PsDebug.warning("missing vector field encountered during cloneing.");
            }
        }
        return pgPointSet;
    }

    public int addVectorField(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            PsDebug.warning("missing argument");
            return -1;
        }
        if (this.m_vectorField == null) {
            this.m_vectorField = new Vector();
            this.m_numVectorFields = 0;
        }
        this.m_bShowVectorFields = true;
        if (this.m_vectorField.contains(pgVectorField)) {
            return this.m_vectorField.indexOf(pgVectorField);
        }
        this.m_vectorField.addElement(pgVectorField);
        return this.m_numVectorFields++;
    }

    public final int getNumVertices() {
        return this.m_numVertices;
    }

    public boolean isShowingTaggedVertices() {
        return this.m_bShowTaggedVertices;
    }

    public void showTaggedVertices(boolean bl) {
        this.m_bShowTaggedVertices = bl;
    }

    public void setNumVertices(int n) {
        if (n > this.m_maxNumVertices) {
            this.setMaxNumVertices(n);
        }
        this.m_numVertices = n;
    }

    public void setDefaultLabelEnabled(boolean bl) {
        this.m_bDefaultLabelEnabled = bl;
    }

    public PdVector[] getAmbientBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] pdVectorArray = super.getAmbientBounds();
        PdVector.min(pdVectorArray[0], this.m_vertex, this.m_numVertices);
        PdVector.max(pdVectorArray[1], this.m_vertex, this.m_numVertices);
        return pdVectorArray;
    }

    public void computeSnail(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        double d2 = 0.0;
        double d3 = 0.0;
        if (n > 1) {
            d2 = (1.0 + d * Math.PI) / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d3 = Math.PI / (-1.0 + (double)n2);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d4 = 2.141592653589793 + d2 * (double)n4;
            double d5 = Math.sin(d4);
            double d6 = Math.cos(d4);
            int n5 = 0;
            while (n5 < n2) {
                double d7 = d3 * (double)n5;
                double d8 = Math.sin(d7);
                double d9 = Math.cos(d7);
                double d10 = Math.exp(d4 * Math.log(1.3)) * d8;
                this.m_vertex[n3].m_data[0] = d10 * d6 * d8;
                this.m_vertex[n3].m_data[1] = d10 * d5 * d8;
                this.m_vertex[n3].m_data[2] = d10 * d9;
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        if (pdMatrix == null || pdMatrix.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + pdMatrix);
            return null;
        }
        PgPointSet pgPointSet = (PgPointSet)super.reflect(pdMatrix, bl, bl2);
        PdVector[] pdVectorArray = this.getVertices();
        PdVector[] pdVectorArray2 = pgPointSet.getVertices();
        int n = 0;
        while (n < this.m_numVertices) {
            pdVectorArray2[n].leftMultAffin(pdMatrix, pdVectorArray[n], true);
            ++n;
        }
        if (this.hasVertexNormals()) {
            PdVector[] pdVectorArray3 = this.getVertexNormals();
            PdVector[] pdVectorArray4 = pgPointSet.getVertexNormals();
            int n2 = 0;
            while (n2 < this.m_numVertices) {
                pdVectorArray4[n2].leftMultAffin(pdMatrix, pdVectorArray3[n2], false);
                if (!bl2) {
                    pdVectorArray4[n2].multScalar(-1.0);
                }
                pdVectorArray4[n2].normalize();
                ++n2;
            }
        }
        return pgPointSet;
    }

    public boolean hasVertexTextures() {
        return this.m_vertexTexture != null && this.m_vertexTexture.length == this.m_maxNumVertices;
    }

    public Color[] getVertexColors() {
        return this.m_vertexColor;
    }

    public void init() {
        super.init();
        this.m_dimOfColors = 3;
        this.m_vertexColor = null;
        this.m_bShowVertexColors = false;
        this.m_vertexNormal = null;
        this.m_vertexTexture = null;
        this.m_texture = null;
        this.m_bDefaultLabelEnabled = true;
        this.m_bShowIndices = false;
        this.m_bShowVertexLabels = false;
        this.setMaxNumVertices(0);
        this.m_bShowVertices = true;
        this.m_bShowTaggedVertices = true;
        this.m_globalVertexSize.setDefBounds(0, 50, 1, 5);
        this.m_globalVertexSize.setDefValue(2);
        this.m_globalVertexSize.init();
        this.m_globalVertexColor.setColor(Color.red);
        this.m_globalVertexTagColor.setColor(Color.magenta);
        this.m_bShowVertexNormals = false;
        this.m_bShowVertexNormalArrow = false;
        this.m_globalVertexNormalSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalVertexNormalSize.setDefValue(1.0);
        this.m_globalVertexNormalSize.init();
        this.m_globalVertexNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalVertexNormalLength.setDefValue(0.5);
        this.m_globalVertexNormalLength.init();
        this.m_globalVertexNormalColor.setColor(Color.yellow);
        this.m_transparency.setDefBounds(0.0, 1.0, 0.01, 0.05);
        this.m_transparency.setDefValue(0.0);
        this.m_transparency.init();
        this.m_bShowTransparency = false;
        this.m_numVectorFields = 0;
        this.m_vectorField = null;
        this.m_bShowVectorFields = false;
        this.m_bShowVectorArrows = false;
        this.m_globalVectorSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalVectorSize.setDefValue(1.0);
        this.m_globalVectorSize.init();
        this.m_globalVectorLength.setDefValue(1.0);
        this.m_globalVectorLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalVectorLength.init();
        this.m_globalVectorColor.setColor(Color.yellow);
        this.m_bShowVertexTexture = false;
        this.m_dimOfTextures = 2;
    }

    public boolean isShowingVertexColors() {
        return this.m_bShowVertexColors;
    }

    public void showVertexColors(boolean bl) {
        this.m_bShowVertexColors = bl;
    }

    public int getDimOfColors() {
        return this.m_dimOfColors;
    }

    public void setDimOfColors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        if (this.m_dimOfColors == n) {
            return;
        }
        this.m_dimOfColors = n;
    }

    public int getDimOfVectors() {
        return this.m_dimOfVectors;
    }

    public void setDimOfVectors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        this.m_dimOfVectors = n;
        if (this.m_vertexNormal != null) {
            int n2 = 0;
            while (n2 < this.m_maxNumVertices) {
                this.m_vertexNormal[n2].setSize(n);
                ++n2;
            }
        }
    }

    public void assureVertexColors() {
        if (this.m_vertexColor == null || this.m_vertexColor.length != this.m_maxNumVertices) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, this.m_maxNumVertices);
        }
    }

    public void setVertexColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_vertexColor = null;
            return;
        }
        if (colorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexColors();
        PdColor.copy(this.m_vertexColor, 0, colorArray, 0, this.m_numVertices);
    }

    public boolean isShowingVertexTexture() {
        return this.m_bShowVertexTexture;
    }

    public PgTexture getTexture() {
        return this.m_texture;
    }

    public void setTexture(PgTexture pgTexture) {
        if (pgTexture == null) {
            this.m_texture = null;
            return;
        }
        if (this.m_texture == null) {
            this.m_texture = new PgTexture();
            this.m_texture.setName("Texture of " + this.getName());
            this.m_texture.setParent(this);
        }
        this.m_texture.copy(pgTexture);
    }

    public void showVertexTexture(boolean bl) {
        this.m_bShowVertexTexture = bl;
    }

    public double getGlobalVectorSize() {
        return this.m_globalVectorSize.getValue();
    }

    public void setGlobalVectorSize(double d) {
        this.m_globalVectorSize.setValue(d);
    }

    public boolean isShowingVectorArrow() {
        return this.m_bShowVectorArrows;
    }

    public void showVectorFields(boolean bl) {
        this.m_bShowVectorFields = bl;
    }

    public void showVectorArrow(boolean bl) {
        this.m_bShowVectorArrows = bl;
    }

    public void removeAllVectorFields() {
        if (this.m_vectorField == null) {
            return;
        }
        this.m_vectorField.removeAllElements();
        this.m_vectorField = null;
        this.m_numVectorFields = 0;
        this.m_bShowVectorFields = false;
    }

    public boolean isDefaultLabelEnabled() {
        return this.m_bDefaultLabelEnabled;
    }

    public double getGlobalVertexNormalLength() {
        return this.m_globalVertexNormalLength.getValue();
    }

    public void setGlobalVertexNormalLength(double d) {
        this.m_globalVertexNormalLength.setValue(d);
    }

    public boolean makeColorFromVectorLength() {
        this.makeVertexNormals();
        PgVectorField pgVectorField = this.getVectorField(0);
        if (pgVectorField == null) {
            PsDebug.warning("missing vector field.");
            return false;
        }
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        if (pdVectorArray == null || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("missing vectors.");
            return false;
        }
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        PdVector pdVector = new PdVector(this.m_numVertices);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector.m_data[n] = PdVector.dot(pdVectorArray[n], this.m_vertexNormal[n]);
            ++n;
        }
        n = 0;
        while (n < this.m_numVertices) {
            colorArray[n] = pdVector.m_data[n] < 0.0 ? new Color(0, 255, 255) : new Color(255, 0, 255);
            ++n;
        }
        this.setVertexColors(colorArray);
        return true;
    }

    public PdVector[] getVertexNormals() {
        return this.m_vertexNormal;
    }

    public boolean isShowingVertexNormals() {
        return this.m_bShowVertexNormals;
    }

    public void showVertexNormals(boolean bl) {
        this.m_bShowVertexNormals = bl;
    }

    public void assureVertexNormals() {
        if (this.m_vertexNormal == null || this.m_vertexNormal.length != this.m_maxNumVertices) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, this.m_maxNumVertices, this.m_dim);
        }
    }

    public void setVertexNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_vertexNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexNormals();
        PdVector.copy(this.m_vertexNormal, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public PgPointSet() {
        this(3);
    }

    public PgPointSet(int n) {
        super(n);
        this.setTag(4);
        this.setTag(5);
        this.m_dimOfSimplex = 0;
        this.m_dimOfVectors = n;
        this.m_vertex = new PdVector[0];
        this.m_globalVertexSize = new PuInteger(PsConfig.getMessage("globalVertexSize"), this);
        this.m_globalVertexColor = new PdColor(PsConfig.getMessage("globalVertexColor"), this);
        this.m_globalVertexTagColor = new PdColor(PsConfig.getMessage("globalVertexTagColor"), this);
        this.m_globalVertexNormalLength = new PuDouble(PsConfig.getMessage("globalVertexNormalLength"), this);
        this.m_globalVertexNormalSize = new PuDouble(PsConfig.getMessage("globalVertexNormalSize"), this);
        this.m_globalVertexNormalColor = new PdColor(PsConfig.getMessage("globalVertexNormalColor"), this);
        this.m_globalVectorSize = new PuDouble(PsConfig.getMessage("globalVectorSize"), this);
        this.m_globalVectorLength = new PuDouble(PsConfig.getMessage("globalVectorLength"), this);
        this.m_globalVectorColor = new PdColor(PsConfig.getMessage("globalVectorColor"), this);
        this.m_transparency = new PuDouble(PsConfig.getMessage("cTransparency"), this);
        this.m_bShowVectorColors = false;
        if (this.getClass() == (class$jv$geom$PgPointSet != null ? class$jv$geom$PgPointSet : (class$jv$geom$PgPointSet = PgPointSet.class$("jv.geom.PgPointSet")))) {
            this.init();
        }
    }

    public Color getVertexColor(int n) {
        if (n < 0 || n >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexColor[n];
    }

    public PdVector getVertex(int n) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index out of range");
            return null;
        }
        return this.m_vertex[n];
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(80, this.isShowingIndices());
        pvGeometryIf.setState(81, this.isShowingVertexLabels());
        pvGeometryIf.setState(85, this.isDefaultLabelEnabled());
        pvGeometryIf.setState(50, this.m_bShowVertices);
        pvGeometryIf.setState(51, this.m_bShowTaggedVertices);
        if (this.m_globalVertexSize != null) {
            pvGeometryIf.setGlobalVertexSize(this.m_globalVertexSize.getValue());
        }
        if (this.m_globalVertexColor != null) {
            pvGeometryIf.setGlobalVertexColor(this.m_globalVertexColor.getColor());
        }
        if (this.m_globalVertexTagColor != null) {
            pvGeometryIf.setGlobalVertexTagColor(this.m_globalVertexTagColor.getColor());
        }
        pvGeometryIf.setNumVertices(this.m_numVertices);
        pvGeometryIf.setVertices(this.m_vertex);
        pvGeometryIf.setState(90, this.m_bShowVertexColors);
        pvGeometryIf.setVertexColors(this.m_vertexColor);
        pvGeometryIf.setState(60, this.m_bShowVertexNormals);
        pvGeometryIf.setState(61, this.m_bShowVertexNormalArrow);
        pvGeometryIf.setVertexNormals(this.m_vertexNormal);
        if (this.m_globalVertexNormalSize != null) {
            pvGeometryIf.setGlobalVertexNormalSize(this.m_globalVertexNormalSize.getValue());
        }
        if (this.m_globalVertexNormalLength != null) {
            pvGeometryIf.setGlobalVertexNormalLength(this.m_globalVertexNormalLength.getValue());
        }
        if (this.m_globalVertexNormalColor != null) {
            pvGeometryIf.setGlobalVertexNormalColor(this.m_globalVertexNormalColor.getColor());
        }
        pvGeometryIf.setState(71, this.m_bShowVertexTexture);
        if (this.m_bShowVertexTexture) {
            if (this.m_texture != null) {
                pvGeometryIf.setTexture(PsImage.getPixels(this.m_texture.getImage(), this.m_texture.getUMin(), this.m_texture.getVMin(), this.m_texture.getWidth(), this.m_texture.getHeight(), null, 0, this.m_texture.getWidth()), this.m_texture.getWidth(), this.m_texture.getHeight());
            }
            pvGeometryIf.setVertexTextures(this.m_vertexTexture);
        }
        pvGeometryIf.setState(73, this.m_bShowTransparency);
        pvGeometryIf.setTransparency(this.m_transparency.getValue());
        pvGeometryIf.setNumVectorFields(this.m_numVectorFields);
        int n = 0;
        while (n < this.m_numVectorFields) {
            PgVectorField pgVectorField = this.getVectorField(n);
            pgVectorField.setIndex(n);
            pgVectorField.paint(pvGeometryIf);
            pvGeometryIf.showVectorField(n, this.m_bShowVectorFields);
            pvGeometryIf.showVectorArrows(n, this.m_bShowVectorArrows);
            pvGeometryIf.showVectorColors(n, this.m_bShowVectorColors);
            pvGeometryIf.setGlobalVectorColor(n, this.m_globalVectorColor.getColor());
            pvGeometryIf.setGlobalVectorLength(n, this.m_globalVectorLength.getValue());
            pvGeometryIf.setGlobalVectorSize(n, this.m_globalVectorSize.getValue());
            ++n;
        }
    }

    public void clearTagVertex(int n, int n2) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vertex[n].clearTag(n2);
    }

    public void setTransparency(double d) {
        this.m_transparency.setValue(d);
    }

    public boolean isShowingVectorField() {
        return this.m_bShowVectorFields;
    }

    public void showVectorField(boolean bl) {
        this.m_bShowVectorFields = bl;
    }

    public boolean setVertex(int n, PdVector pdVector) {
        if (n < 0) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (n >= this.m_numVertices) {
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].copy(pdVector);
        return true;
    }

    public void setVertex(int n, double d) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 1) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].set(d);
    }

    public void setVertex(int n, double d, double d2) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 2) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].set(d, d2);
    }

    public void setVertex(int n, double d, double d2, double d3) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 3) {
            PsDebug.warning("wrong vertex dimension");
            return;
        }
        if (n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " > " + this.m_numVertices + "=m_numVertices, bad programming style", this);
            this.setNumVertices(n + 1);
        }
        this.m_vertex[n].set(d, d2, d3);
    }

    public void setVertexColor(int n, Color color) {
        if (n < 0 || color == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexColor == null || n >= this.m_vertexColor.length) {
            this.assureVertexColors();
        }
        this.m_vertexColor[n] = color;
    }

    public boolean isShowingVertexNormalArrow() {
        return this.m_bShowVertexNormalArrow;
    }

    public void showVertexNormalArrow(boolean bl) {
        this.m_bShowVertexNormalArrow = bl;
    }

    public int getIndexOfVectorField(PgVectorField pgVectorField) {
        return this.m_vectorField.indexOf(pgVectorField);
    }

    public PgVectorField getVectorField(String string) {
        if (this.m_vectorField != null) {
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (!string.equals(pgVectorField.getName())) continue;
                return pgVectorField;
            }
        }
        return null;
    }

    public PgVectorField getVectorField(int n) {
        if (this.m_vectorField == null || n >= this.m_numVectorFields) {
            return null;
        }
        return (PgVectorField)this.m_vectorField.elementAt(n);
    }

    public PdVector getVertexNormal(int n) {
        if (n < 0 || n >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexNormal[n];
    }

    public void setVertexNormal(int n, PdVector pdVector) {
        if (n < 0 || pdVector == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexNormal == null || n >= this.m_vertexNormal.length) {
            this.assureVertexNormals();
        }
        this.m_vertexNormal[n].copy(pdVector);
    }

    protected Vector getVectorField() {
        return this.m_vectorField;
    }

    public boolean isShowingIndices() {
        return this.m_bShowIndices;
    }

    public void showIndices(boolean bl) {
        this.m_bShowIndices = bl;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setType(30);
        pgJvxSrc.showIndices(this.isShowingIndices());
        pgJvxSrc.showVertexLabels(this.isShowingVertexLabels());
        pgJvxSrc.showVertices(this.isShowingVertices());
        pgJvxSrc.setDimOfVertices(this.getDimOfVertices());
        pgJvxSrc.setNumVertices(this.getNumVertices());
        pgJvxSrc.setVertices(this.getVertices());
        pgJvxSrc.setGlobalVertexColor(this.getGlobalVertexColor());
        pgJvxSrc.setGlobalVertexTagColor(this.getGlobalVertexTagColor());
        pgJvxSrc.setGlobalVertexSize(this.getGlobalVertexSize());
        if (this.hasVertexColors()) {
            pgJvxSrc.showVertexColors(this.isShowingVertexColors());
            pgJvxSrc.setVertexColors(this.getVertexColors());
        } else {
            pgJvxSrc.showVertexColors(false);
        }
        if (this.hasVertexNormals()) {
            pgJvxSrc.showVertexNormals(this.isShowingVertexNormals());
            pgJvxSrc.setVertexNormals(this.getVertexNormals());
        } else {
            pgJvxSrc.showVertexNormals(false);
        }
        pgJvxSrc.showVertexNormalArrow(this.isShowingVertexNormalArrow());
        pgJvxSrc.setGlobalVertexNormalColor(this.getGlobalVertexNormalColor());
        pgJvxSrc.setGlobalVertexNormalLength(this.getGlobalVertexNormalLength());
        pgJvxSrc.setGlobalVertexNormalSize(this.getGlobalVertexNormalSize());
        if (this.m_texture != null) {
            pgJvxSrc.setTextureImage(this.m_texture.getImage());
            pgJvxSrc.setTextureImageName(this.m_texture.getImageName());
        }
        if (this.hasVertexTextures()) {
            pgJvxSrc.showVertexTexture(this.isShowingVertexTexture());
            pgJvxSrc.setVertexTextures(this.getVertexTextures());
        } else {
            pgJvxSrc.showVertexTexture(false);
        }
        if (this.getVectorField() != null) {
            int n = this.getNumVectorFields();
            pgJvxSrc.setNumVectorFields(n);
            int n2 = 0;
            while (n2 < n) {
                PgVectorField pgVectorField = this.getVectorField(n2);
                pgJvxSrc.setVectorFieldName(n2, pgVectorField.getName());
                if (pgVectorField.getBasedOn() == 0) {
                    pgJvxSrc.setVectorElementBased(n2, false);
                } else {
                    pgJvxSrc.setVectorElementBased(n2, true);
                }
                pgJvxSrc.showVectorArrows(n2, this.isShowingVectorArrows());
                pgJvxSrc.setNumVectors(n2, pgVectorField.getNumVectors(), pgVectorField.getDimOfVertices());
                pgJvxSrc.setVectors(n2, pgVectorField.getVectors());
                pgJvxSrc.setVectorColors(n2, pgVectorField.getVectorColors());
                pgJvxSrc.setGlobalVectorSize(n2, this.getGlobalVectorSize());
                pgJvxSrc.setGlobalVectorLength(n2, this.getGlobalVectorLength());
                pgJvxSrc.setGlobalVectorColor(n2, this.getGlobalVectorColor());
                ++n2;
            }
        }
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showIndices(pgJvxSrc.isShowingIndices());
        this.showVertexLabels(pgJvxSrc.isShowingVertexLabels());
        this.showVertices(pgJvxSrc.isShowingVertices());
        this.setNumVertices(pgJvxSrc.getNumVertices());
        this.setVertices(pgJvxSrc.getVertices());
        if (pgJvxSrc.getGlobalVertexColor() != null) {
            this.setGlobalVertexColor(pgJvxSrc.getGlobalVertexColor());
        }
        if (pgJvxSrc.getGlobalVertexTagColor() != null) {
            this.setGlobalVertexTagColor(pgJvxSrc.getGlobalVertexTagColor());
        }
        this.setGlobalVertexSize((int)pgJvxSrc.getGlobalVertexSize());
        this.setVertexColors(pgJvxSrc.getVertexColors());
        this.showVertexColors(pgJvxSrc.isShowingVertexColors());
        this.showVertexNormals(pgJvxSrc.isShowingVertexNormals());
        this.showVertexNormalArrow(pgJvxSrc.isShowingVertexNormalArrow());
        if (pgJvxSrc.getVertexNormals() != null) {
            this.setVertexNormals(pgJvxSrc.getVertexNormals());
        } else {
            this.makeVertexNormals();
        }
        if (pgJvxSrc.getGlobalVertexNormalColor() != null) {
            this.setGlobalVertexNormalColor(pgJvxSrc.getGlobalVertexNormalColor());
        }
        if (pgJvxSrc.getGlobalVertexNormalLength() != 0.0) {
            this.setGlobalVertexNormalLength(pgJvxSrc.getGlobalVertexNormalLength());
        }
        if (pgJvxSrc.getGlobalVertexNormalSize() != 0.0) {
            this.setGlobalVertexNormalSize(pgJvxSrc.getGlobalVertexNormalSize());
        }
        if (pgJvxSrc.getTextureImage() != null) {
            this.setTextureImage(pgJvxSrc.getTextureImage());
        }
        if (pgJvxSrc.getTextureImageName() != null) {
            this.setTextureImageName(pgJvxSrc.getTextureImageName());
        }
        if (pgJvxSrc.getVertexTextures() != null) {
            this.assureVertexTextures();
        }
        this.setVertexTextures(pgJvxSrc.getVertexTextures());
        this.showVertexTexture(pgJvxSrc.isShowingVertexTexture());
        if (pgJvxSrc.getNumVectorFields() > 0) {
            this.removeAllVectorFields();
            int n = pgJvxSrc.getNumVectorFields();
            int n2 = 0;
            while (n2 < n) {
                PdVector[] pdVectorArray;
                if (!pgJvxSrc.isVectorElementBased(n2) && (pdVectorArray = pgJvxSrc.getVectors(n2)) != null && pdVectorArray.length != 0) {
                    int n3 = pdVectorArray.length;
                    PgVectorField pgVectorField = new PgVectorField(pgJvxSrc.getDimOfVectors(n2));
                    pgVectorField.setGeometry(this);
                    pgVectorField.setBasedOn(0);
                    pgVectorField.setNumVectors(n3);
                    if (pgVectorField.setVectors(pdVectorArray)) {
                        this.addVectorField(pgVectorField);
                    }
                    this.showVectorArrows(pgJvxSrc.isShowingVectorArrows(n2));
                    if (pgJvxSrc.getGlobalVectorSize(n2) != 0.0) {
                        this.setGlobalVectorSize(pgJvxSrc.getGlobalVectorSize(n2));
                    }
                    if (pgJvxSrc.getGlobalVectorLength(n2) != 0.0) {
                        this.setGlobalVectorLength(pgJvxSrc.getGlobalVectorLength(n2));
                    }
                    if (pgJvxSrc.getGlobalVectorColor(n2) != null) {
                        this.setGlobalVectorColor(pgJvxSrc.getGlobalVectorColor(n2));
                    }
                }
                ++n2;
            }
        }
    }

    public PdVector getCenterOfBndBox() {
        PdVector pdVector = new PdVector(this.m_dim);
        if (this.m_numVertices == 0) {
            return pdVector;
        }
        PdVector[] pdVectorArray = this.getBounds();
        if (pdVectorArray == null || pdVectorArray.length < 2) {
            return pdVector;
        }
        pdVector.blend(0.5, pdVectorArray[0], 0.5, pdVectorArray[1]);
        return pdVector;
    }

    public void setCenterOfBndBox(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        PdVector pdVector2 = this.getCenterOfBndBox();
        if (pdVector2 == null) {
            PsDebug.warning("missing current center");
            return;
        }
        PdVector pdVector3 = PdVector.subNew(pdVector, pdVector2);
        this.translate(pdVector3);
    }

    public boolean makeVertexTextureFromBndBox(int n, int n2) {
        if (this.m_dim < 2) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        int n3 = 2;
        if (n >= this.m_dim) {
            n = this.m_dim - 1;
        }
        if (n2 >= this.m_dim) {
            n2 = this.m_dim - 1;
        }
        int n4 = Math.min(this.m_dim, n3);
        n4 = Math.min(this.m_dim, 3);
        this.assureVertexTextures();
        PdVector[] pdVectorArray = this.getVertexTextures();
        PdVector[] pdVectorArray2 = this.getBounds();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray2[1], (PdVector)pdVectorArray2[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        int n5 = 0;
        while (n5 < this.m_numVertices) {
            int n6 = 0;
            while (n6 < n4) {
                pdVector.m_data[n6] = this.m_vertex[n5].m_data[n6] - pdVectorArray2[0].m_data[n6];
                ++n6;
            }
            pdVectorArray[n5].m_data[0] = pdVector.m_data[n] / dArray[n];
            pdVectorArray[n5].m_data[1] = pdVector.m_data[n2] / dArray[n2];
            ++n5;
        }
        return true;
    }

    public boolean isShowingVertexLabels() {
        return this.m_bShowVertexLabels;
    }

    public boolean isShowingVectorColors() {
        return this.m_bShowVectorColors;
    }

    public void showVertexLabels(boolean bl) {
        this.m_bShowVertexLabels = bl;
    }

    public void showVectorColors(boolean bl) {
        this.m_bShowVectorColors = bl;
    }

    public Color getGlobalVertexColor() {
        return this.m_globalVertexColor.getColor();
    }

    public Color getGlobalVertexNormalColor() {
        return this.m_globalVertexNormalColor.getColor();
    }

    public void setGlobalVertexColor(Color color) {
        this.m_globalVertexColor.setColor(color);
    }

    public void setGlobalVertexNormalColor(Color color) {
        this.m_globalVertexNormalColor.setColor(color);
    }

    public boolean removeVectorField(PgGeometryIf pgGeometryIf) {
        if (this.m_vectorField == null) {
            return true;
        }
        if (this.m_vectorField.removeElement(pgGeometryIf)) {
            if ((this.m_numVectorFields += -1) == 0) {
                this.m_vectorField = null;
                this.m_bShowVectorFields = false;
            }
            return true;
        }
        return false;
    }

    public PdVector[] getVertexTextures() {
        return this.m_vertexTexture;
    }

    public int getDimOfTextures() {
        return this.m_dimOfTextures;
    }

    public void setDimOfTextures(int n) {
        if (n == this.m_dimOfTextures) {
            return;
        }
        this.m_dimOfTextures = n;
        this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_maxNumVertices, this.m_dimOfTextures);
    }

    public void assureVertexTextures() {
        if (this.m_vertexTexture == null || this.m_vertexTexture.length != this.m_maxNumVertices) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_maxNumVertices, this.m_dimOfTextures);
        }
    }

    public void setVertexTextures(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_vertexTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexTextures();
        PdVector.copy(this.m_vertexTexture, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public int getNumVectorFields() {
        return this.m_numVectorFields;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgPointSet ***********\n");
        stringBuffer.append("\t m_numVertices = " + this.m_numVertices + "\n");
        stringBuffer.append("\t ******* m_vertex *******\n");
        if (this.m_vertex != null && this.m_numVertices > 0) {
            n = 0;
            while (n < this.m_numVertices) {
                stringBuffer.append("\t [" + n + "] = " + this.m_vertex[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_vertex = null\n");
        }
        stringBuffer.append("\t ******* m_vertexNormal *******\n");
        if (this.m_vertexNormal != null && this.m_numVertices > 0) {
            n = 0;
            while (n < this.m_numVertices) {
                stringBuffer.append("\t [" + n + "] = " + this.m_vertexNormal[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_vertexNormal = null\n");
        }
        stringBuffer.append("\t ******* m_vertexTexture *******\n");
        if (this.m_vertexTexture != null && this.m_numVertices > 0) {
            n = 0;
            while (n < this.m_numVertices) {
                stringBuffer.append("\t [" + n + "] = " + this.m_vertexTexture[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_vertexTexture = null\n");
        }
        return stringBuffer.toString();
    }

    public void translate(PdVector pdVector) {
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vertex[n].add(pdVector);
            ++n;
        }
        if (this.m_center != null) {
            this.m_center.add(pdVector);
        }
    }

    public boolean isShowingVectorArrows() {
        return this.m_bShowVectorArrows;
    }

    public void showVectorArrows(boolean bl) {
        this.m_bShowVectorArrows = bl;
    }

    public void computeTorus(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d3 = 0.0;
        double d4 = 0.0;
        if (n > 1) {
            d3 = Math.PI * 2 / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d4 = Math.PI * 2 / (-1.0 + (double)n2);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d5 = d3 * (double)n4;
            double d6 = Math.sin(d5);
            double d7 = Math.cos(d5);
            int n5 = 0;
            while (n5 < n2) {
                double d8 = Math.PI + d4 * (double)n5;
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                this.m_vertex[n3].m_data[0] = d7 * (d2 * d10 + d);
                this.m_vertex[n3].m_data[1] = d6 * (d2 * d10 + d);
                this.m_vertex[n3].m_data[2] = d2 * d9;
                this.m_vertexNormal[n3].m_data[0] = d7 * d10;
                this.m_vertexNormal[n3].m_data[1] = d6 * d10;
                this.m_vertexNormal[n3].m_data[2] = d9;
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    public String getTextureImageName() {
        if (this.m_texture == null) {
            return null;
        }
        return this.m_texture.getImageName();
    }

    public void setTextureImageName(String string) {
        if (string == null) {
            PsDebug.warning("missing texture file name");
            return;
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
        this.m_texture.setImageName(string);
    }

    public void copy(PgGeometry pgGeometry) {
        super.copy(pgGeometry);
        if (!(pgGeometry instanceof PgPointSet)) {
            return;
        }
        PgPointSet pgPointSet = (PgPointSet)pgGeometry;
        this.setNumVertices(pgPointSet.getNumVertices());
        if (this.m_dim == pgPointSet.getDimOfVertices()) {
            PdVector.copy(this.m_vertex, 0, pgPointSet.getVertices(), 0, this.m_numVertices);
        }
        if (pgPointSet.m_vertexColor != null) {
            this.assureVertexColors();
            PdColor.copy(this.m_vertexColor, 0, pgPointSet.getVertexColors(), 0, this.m_numVertices);
        } else {
            this.m_vertexColor = null;
        }
        if (pgPointSet.m_vertexNormal != null) {
            this.assureVertexNormals();
            PdVector.copy(this.m_vertexNormal, 0, pgPointSet.getVertexNormals(), 0, this.m_numVertices);
        } else {
            this.m_vertexNormal = null;
        }
        if (pgPointSet.m_vertexTexture != null) {
            this.assureVertexTextures();
            PdVector.copy(this.m_vertexTexture, 0, pgPointSet.getVertexTextures(), 0, this.m_numVertices);
        } else {
            this.m_vertexTexture = null;
        }
        this.setTexture(pgPointSet.m_texture);
        this.setDimOfVectors(pgPointSet.getDimOfVectors());
    }

    public void computeCylinder(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d3 = 0.0;
        double d4 = 0.0;
        if (n > 1) {
            d3 = Math.PI * 2 / (-1.0 + (double)n);
        }
        if (n2 > 1) {
            d4 = d2 / (-1.0 + (double)n2);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d5 = d3 * (double)n4;
            double d6 = Math.sin(d5);
            double d7 = Math.cos(d5);
            int n5 = 0;
            while (n5 < n2) {
                double d8 = -1.0 + d4 * (double)n5;
                this.m_vertex[n3].m_data[0] = d * d7;
                this.m_vertex[n3].m_data[1] = d * d6;
                this.m_vertex[n3].m_data[2] = d * d8;
                this.m_vertexNormal[n3].m_data[0] = d7;
                this.m_vertexNormal[n3].m_data[1] = d6;
                this.m_vertexNormal[n3].m_data[2] = 0.0;
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void flipOrientation() {
        if (this.m_vertexNormal != null) {
            int n = 0;
            while (n < this.m_numVertices) {
                this.m_vertexNormal[n].multScalar(-1.0);
                ++n;
            }
        }
    }

    public Color getGlobalVertexTagColor() {
        return this.m_globalVertexTagColor.getColor();
    }

    public void setGlobalVertexTagColor(Color color) {
        this.m_globalVertexTagColor.setColor(color);
    }

    public void projectToSphere(PdVector pdVector, double d) {
        if (pdVector == null) {
            PsDebug.warning("missing center");
            return;
        }
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector2.sub(this.m_vertex[n], pdVector);
            pdVector2.setLength(d);
            this.m_vertex[n].add(pdVector, pdVector2);
            ++n;
        }
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgPointSet)) {
            return false;
        }
        PgPointSet pgPointSet = (PgPointSet)pgGeometryIf;
        int n = this.m_numVertices;
        int n2 = this.m_numVertices + pgPointSet.m_numVertices;
        this.setNumVertices(n2);
        PdVector.copy(this.m_vertex, n, pgPointSet.m_vertex, 0, pgPointSet.m_numVertices);
        if (pgPointSet.m_vertexColor != null) {
            this.assureVertexColors();
            PdColor.copy(this.m_vertexColor, n, pgPointSet.m_vertexColor, 0, pgPointSet.m_numVertices);
        }
        if (pgPointSet.m_vertexNormal != null) {
            this.assureVertexNormals();
            PdVector.copy(this.m_vertexNormal, n, pgPointSet.m_vertexNormal, 0, pgPointSet.m_numVertices);
        }
        if (pgPointSet.m_vertexTexture != null) {
            this.assureVertexTextures();
            PdVector.copy(this.m_vertexTexture, n, pgPointSet.m_vertexTexture, 0, pgPointSet.m_numVertices);
        }
        return true;
    }

    public PdVector getCenterOfGravity() {
        if (this.m_dim < 0) {
            return null;
        }
        if (this.m_center == null) {
            this.m_center = new PdVector(this.m_dim);
        }
        this.m_center.setConstant(0.0);
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_center.add(this.m_vertex[n]);
            ++n;
        }
        this.m_center.multScalar(1.0 / (double)this.m_numVertices);
        return this.m_center;
    }

    public void computeDisk(int n, int n2, double d) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        this.setNumVertices(n * n2);
        double d2 = d / (-1.0 + (double)n);
        double d3 = Math.PI * 2 / (-1.0 + (double)n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d4 = d2 * (double)n4;
            int n5 = 0;
            while (n5 < n2) {
                double d5 = d3 * (double)n5;
                if (this.m_dim > 2) {
                    this.m_vertex[n3].setConstant(0.0);
                }
                this.m_vertex[n3].m_data[0] = d4 * Math.cos(d5);
                this.m_vertex[n3].m_data[1] = d4 * Math.sin(d5);
                ++n3;
                ++n5;
            }
            ++n4;
        }
        if (this.m_dim == 3) {
            this.assureVertexNormals();
            PdVector.setConstant(this.m_vertexNormal, new PdVector(0.0, 0.0, 1.0));
            return;
        }
        this.setVertexNormals(null);
    }

    public double getGlobalVectorLength() {
        return this.m_globalVectorLength.getValue();
    }

    public void setGlobalVectorLength(double d) {
        this.m_globalVectorLength.setValue(d);
    }

    public boolean makeVertexTextureFromSphere(PdVector pdVector) {
        if (this.m_dim < 3) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        if (pdVector == null || pdVector.getSize() != this.m_dim) {
            PsDebug.warning("Missing center or wrong dimension.");
            return false;
        }
        this.assureVertexTextures();
        PdVector[] pdVectorArray = this.getVertexTextures();
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector2.sub(this.m_vertex[n], pdVector);
            pdVector2.normalize();
            double[] dArray = pdVector2.m_data;
            double d = 0.0;
            double d2 = 0.0;
            if (dArray[0] > 1.0E-10) {
                d = Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[0] < -1.0E-10) {
                d = Math.PI + Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[1] > 1.0E-10) {
                d = 1.5707963267948966;
            } else if (dArray[1] < -1.0E-10) {
                d = -1.5707963267948966;
            }
            d2 = Math.asin(dArray[2]);
            pdVectorArray[n].set(0.25 + d / 2.0 / Math.PI, 0.5 + d2 / Math.PI);
            ++n;
        }
        return true;
    }

    protected void setDimOfVertices(int n) {
        if (this.m_center != null) {
            this.m_center.setSize(n);
        }
        int n2 = 0;
        while (n2 < this.m_maxNumVertices) {
            this.m_vertex[n2].setSize(n);
            ++n2;
        }
        this.setDimOfVectors(n);
        super.setDimOfVertices(n);
    }

    public final int getMaxNumVertices() {
        return this.m_maxNumVertices;
    }

    public PdVector[] getVertices() {
        return this.m_vertex;
    }

    public boolean isShowingVertices() {
        return this.m_bShowVertices;
    }

    public void showVertices(boolean bl) {
        this.m_bShowVertices = bl;
    }

    protected void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        this.m_vertex = PdVector.realloc(this.m_vertex, n, this.m_dim);
        int n2 = 0;
        while (n2 < n) {
            this.m_vertex[n2].clearTag(2);
            ++n2;
        }
        if (this.m_vertexNormal != null) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, n, this.m_dim);
        }
        if (this.m_vertexColor != null) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, n);
        }
        if (this.m_vertexTexture != null) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, n, this.m_dimOfTextures);
        }
        this.m_maxNumVertices = n;
        if (this.m_maxNumVertices < this.m_numVertices) {
            this.m_numVertices = this.m_maxNumVertices;
        }
    }

    public void setVertices(PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("void length of argument vertex array");
            return;
        }
        int n = pdVectorArray[0].getSize();
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            int n3 = pdVectorArray[n2].getSize();
            this.m_vertex[n2].setSize(n3);
            if (n != -1 && n3 != n) {
                n = -1;
            }
            ++n2;
        }
        this.m_dim = n;
        PdVector.copy(this.m_vertex, 0, pdVectorArray, 0, this.m_numVertices);
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalVertexSize) {
            return super.update(null);
        }
        if (object == this.m_globalVertexColor) {
            return super.update(null);
        }
        if (object == this.m_globalVertexTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalColor) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalLength) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalSize) {
            return super.update(null);
        }
        if (object == this.m_globalVectorColor) {
            return super.update(null);
        }
        if (object == this.m_globalVectorLength) {
            return super.update(null);
        }
        if (object == this.m_globalVectorSize) {
            return super.update(null);
        }
        if (object == this.m_transparency) {
            return super.update(null);
        }
        if (object == this.m_texture) {
            return super.update(null);
        }
        if (object == this) {
            if (this.m_vectorField != null) {
                Enumeration enumeration = this.m_vectorField.elements();
                while (enumeration.hasMoreElements()) {
                    PgGeometryIf pgGeometryIf = (PgGeometryIf)enumeration.nextElement();
                    pgGeometryIf.update(this);
                }
            }
            return super.update(this);
        }
        return super.update(object);
    }

    public int[] removeMarkedVertices() {
        int n = 1;
        int n2 = -1;
        int n3 = 0;
        int[] nArray = new int[this.m_numVertices];
        int n4 = 0;
        while (n4 < this.m_numVertices) {
            nArray[n4] = this.m_vertex[n4].hasTag(2) ? n2 : n;
            ++n4;
        }
        n3 = 0;
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] == n) {
                nArray[n4] = n3++;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] != n2 && nArray[n4] < n4) {
                this.m_vertex[nArray[n4]].setSize(this.m_vertex[n4].getSize());
                this.m_vertex[nArray[n4]].copy(this.m_vertex[n4]);
            }
            ++n4;
        }
        if (this.m_vertexNormal != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n2 && nArray[n4] < n4) {
                    this.m_vertexNormal[nArray[n4]].setSize(this.m_vertexNormal[n4].getSize());
                    this.m_vertexNormal[nArray[n4]].copy(this.m_vertexNormal[n4]);
                }
                ++n4;
            }
        }
        if (this.m_vertexColor != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n2 && nArray[n4] < n4) {
                    this.m_vertexColor[nArray[n4]] = this.m_vertexColor[n4];
                }
                ++n4;
            }
        }
        if (this.m_vertexTexture != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n2 && nArray[n4] < n4) {
                    this.m_vertexTexture[nArray[n4]] = PdVector.copyNew(this.m_vertexTexture[n4]);
                }
                ++n4;
            }
        }
        int n5 = this.getNumVectorFields();
        n4 = 0;
        while (n4 < n5) {
            PgVectorField pgVectorField = this.getVectorField(n4);
            if (pgVectorField.getBasedOn() != 1) {
                int n6 = 0;
                while (n6 < this.m_numVertices) {
                    if (nArray[n6] != n2 && nArray[n6] < n6) {
                        pgVectorField.setVector(nArray[n6], pgVectorField.getVector(n6));
                    }
                    ++n6;
                }
                pgVectorField.setNumVectors(n3);
            }
            ++n4;
        }
        this.setNumVertices(n3);
        this.setMaxNumVertices(n3);
        return nArray;
    }

    public boolean makeVertexColorsFromXYZ() {
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        PdVector[] pdVectorArray = this.getBounds();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector.sub(this.m_vertex[n], pdVectorArray[0]);
            if (this.m_dim == 1) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), 0.0f, 0.0f);
            } else if (this.m_dim == 2) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), (float)(pdVector.m_data[1] / dArray[1]), 0.0f);
            } else if (this.m_dim >= 3) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), (float)(pdVector.m_data[1] / dArray[1]), (float)(pdVector.m_data[2] / dArray[2]));
            }
            ++n;
        }
        return true;
    }

    public PdVector[] getBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] pdVectorArray = super.getBounds();
        PdVector.min(pdVectorArray[0], this.m_vertex, this.m_numVertices);
        PdVector.max(pdVectorArray[1], this.m_vertex, this.m_numVertices);
        int n = this.m_dim;
        while (n < 3) {
            pdVectorArray[0].m_data[n] = 0.0;
            pdVectorArray[1].m_data[n] = 0.0;
            ++n;
        }
        return pdVectorArray;
    }

    public boolean hasVertexColors() {
        return this.m_vertexColor != null && this.m_vertexColor.length == this.m_maxNumVertices;
    }

    public boolean makeVertexColorsFromZ() {
        if (this.m_dim == 0) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        PdVector[] pdVectorArray = this.getBounds();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            pdVector.sub(this.m_vertex[n2], pdVectorArray[0]);
            float f = (float)(pdVector.m_data[n] / dArray[n]);
            colorArray[n2] = new Color((float)(1.0 - (double)f), 0.0f, f);
            ++n2;
        }
        return true;
    }

    public void scale(double d) {
        if (this.m_center != null) {
            int n = 0;
            while (n < this.m_numVertices) {
                this.m_vertex[n].blend(1.0 - d, this.m_center, d, this.m_vertex[n]);
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vertex[n].multScalar(d);
            ++n;
        }
    }

    public void scale(double d, PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing center");
            return;
        }
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector2.sub(this.m_vertex[n], pdVector);
            this.m_vertex[n].blendBase(pdVector, d, pdVector2);
            ++n;
        }
    }

    public boolean makeVertexTextureFromCylinder(PdVector pdVector, PdVector pdVector2) {
        double d;
        if (this.m_dim < 3) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        if (pdVector == null || pdVector.getSize() != this.m_dim) {
            PsDebug.warning("Missing center or wrong dimension.");
            return false;
        }
        if (pdVector2 == null || pdVector2.getSize() != this.m_dim) {
            PsDebug.warning("Missing axis or wrong dimension.");
            return false;
        }
        if (Math.abs(pdVector2.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("Axis direction does not have unit length.");
            return false;
        }
        this.assureVertexTextures();
        PdVector[] pdVectorArray = this.getVertexTextures();
        PdVector pdVector3 = new PdVector(this.m_dim);
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        int n = 0;
        while (n < this.m_numVertices) {
            pdVector3.sub(this.m_vertex[n], pdVector);
            d = PdVector.dot(pdVector2, pdVector3);
            if (d < d2) {
                d2 = d;
            }
            if (d > d3) {
                d3 = d;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_numVertices) {
            pdVector3.sub(this.m_vertex[n], pdVector);
            d = PdVector.dot(pdVector2, pdVector3);
            double[] dArray = pdVector3.m_data;
            double d4 = 0.0;
            if (dArray[0] > 1.0E-10) {
                d4 = Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[0] < -1.0E-10) {
                d4 = Math.PI + Math.atan(dArray[1] / dArray[0]);
            } else if (dArray[1] > 1.0E-10) {
                d4 = 1.5707963267948966;
            } else if (dArray[1] < -1.0E-10) {
                d4 = -1.5707963267948966;
            }
            pdVectorArray[n].set(0.25 + d4 / 2.0 / Math.PI, (d - d2) / (d3 - d2));
            ++n;
        }
        return true;
    }

    public void computeRotation(PgPolygon pgPolygon, int n) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        int n2 = pgPolygon.getNumVertices();
        this.setNumVertices(n * n2);
        this.assureVertexNormals();
        double d = 0.0;
        if (n > 1) {
            d = Math.PI * 2 / (-1.0 + (double)n);
        }
        int n3 = 0;
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        int n4 = 0;
        while (n4 < n) {
            double d2 = d * (double)n4;
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            int n5 = 0;
            while (n5 < n2) {
                this.m_vertex[n3].m_data[0] = pdVectorArray[n5].m_data[0];
                this.m_vertex[n3].m_data[1] = d4 * pdVectorArray[n5].m_data[1];
                this.m_vertex[n3].m_data[2] = d3 * pdVectorArray[n5].m_data[1];
                ++n3;
                ++n5;
            }
            ++n4;
        }
        if (pgPolygon.hasVertexNormals()) {
            PdVector[] pdVectorArray2 = pgPolygon.getVertexNormals();
            n3 = 0;
            int n6 = 0;
            while (n6 < n) {
                double d5 = d * (double)n6;
                double d6 = Math.sin(d5);
                double d7 = Math.cos(d5);
                int n7 = 0;
                while (n7 < n2) {
                    this.m_vertexNormal[n3].m_data[0] = pdVectorArray2[n7].m_data[0];
                    this.m_vertexNormal[n3].m_data[1] = d7 * pdVectorArray2[n7].m_data[1];
                    this.m_vertexNormal[n3].m_data[2] = d6 * pdVectorArray2[n7].m_data[1];
                    ++n3;
                    ++n7;
                }
                ++n6;
            }
        }
    }

    public boolean makeVertexColorsFromZHue() {
        if (this.m_dim == 0) {
            PsDebug.warning("dimension of vertices too small, dim =" + this.m_dim);
            return false;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureVertexColors();
        Color[] colorArray = this.getVertexColors();
        PdVector[] pdVectorArray = this.getBounds();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            pdVector.sub(this.m_vertex[n2], pdVectorArray[0]);
            float f = (float)(pdVector.m_data[n] / dArray[n]);
            colorArray[n2] = new Color(Color.HSBtoRGB((float)(1.0 - (double)f), 1.0f, 1.0f));
            ++n2;
        }
        return true;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        int n;
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPointSet)) {
            return false;
        }
        PgPointSet pgPointSet = (PgPointSet)pgGeometry;
        PgPointSet pgPointSet2 = (PgPointSet)pgGeometry2;
        if (pgPointSet.m_numVertices == 0) {
            PsDebug.warning("missing vertices of first argument");
            return false;
        }
        if (pgPointSet.m_numVertices != pgPointSet2.m_numVertices) {
            PsDebug.warning("unequal number of vertices of a and b");
            return false;
        }
        this.m_dimOfVectors = pgPointSet.m_dimOfVectors;
        this.m_dimOfColors = pgPointSet.m_dimOfColors;
        this.m_dimOfTextures = pgPointSet.m_dimOfTextures;
        this.setNumVertices(pgPointSet.m_numVertices);
        if (pgPointSet.m_vertex != null && pgPointSet2.m_vertex != null) {
            n = 0;
            while (n < this.m_numVertices) {
                this.m_vertex[n].blend(d, pgPointSet.m_vertex[n], d2, pgPointSet2.m_vertex[n]);
                ++n;
            }
        }
        if (pgPointSet.m_vertexColor != null && pgPointSet2.m_vertexColor != null) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, this.m_numVertices);
            n = 0;
            while (n < this.m_numVertices) {
                this.m_vertexColor[n] = PdColor.blend(d, pgPointSet.m_vertexColor[n], d2, pgPointSet2.m_vertexColor[n]);
                ++n;
            }
        }
        if (pgPointSet.m_vertexNormal != null && pgPointSet2.m_vertexNormal != null) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, this.m_numVertices, this.m_dim);
            n = 0;
            while (n < this.m_numVertices) {
                this.m_vertexNormal[n].blend(d, pgPointSet.m_vertexNormal[n], d2, pgPointSet2.m_vertexNormal[n]);
                this.m_vertexNormal[n].normalize();
                ++n;
            }
        }
        if (pgPointSet.m_vertexTexture != null && pgPointSet2.m_vertexTexture != null) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_numVertices, this.m_dimOfTextures);
            n = 0;
            while (n < this.m_numVertices) {
                this.m_vertexTexture[n].blend(d, pgPointSet.m_vertexTexture[n], d2, pgPointSet2.m_vertexTexture[n]);
                ++n;
            }
        }
        return true;
    }

    public int getGlobalVertexSize() {
        return this.m_globalVertexSize.getValue();
    }

    public double getGlobalVertexNormalSize() {
        return this.m_globalVertexNormalSize.getValue();
    }

    public void setGlobalVertexSize(int n) {
        this.m_globalVertexSize.setValue(n);
    }

    public void setGlobalVertexNormalSize(double d) {
        this.m_globalVertexNormalSize.setValue(d);
    }

    public void setTagVertex(int n, int n2) {
        if (n < 0 || n >= this.m_numVertices) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vertex[n].setTag(n2);
    }

    public int hasVertex(PdVector pdVector, double d) {
        int n = 0;
        while (n < this.m_numVertices) {
            if (this.m_vertex[n].equals(pdVector, d)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int hasVertex(PdVector pdVector) {
        int n = 0;
        while (n < this.m_numVertices) {
            if (this.m_vertex[n].equals(pdVector)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int[] removeVertex(int n) {
        this.m_vertex[n].setTag(2);
        return this.removeMarkedVertices();
    }
}

