/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jv.geom.PgPointSet;
import jv.number.PdArray_IP;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;

public class PgPointSet_IP
extends PsPanel
implements ActionListener,
TextListener {
    protected PgPointSet m_pointSet;
    protected TextField m_tName;
    protected TextField m_tNumVertices;
    protected PdArray_IP m_vertexPanel;
    private int m_maxVisibleVectors = 5;
    private int m_maxVisibleDim = 5;
    private static String[] m_header = new String[]{"X", "Y", "Z", "W", "V"};
    protected boolean m_bInteractive = true;
    private static /* synthetic */ Class class$jv$geom$PgPointSet_IP;

    public PgPointSet_IP() {
        if (this.getClass() == (class$jv$geom$PgPointSet_IP != null ? class$jv$geom$PgPointSet_IP : (class$jv$geom$PgPointSet_IP = PgPointSet_IP.class$("jv.geom.PgPointSet_IP")))) {
            this.init();
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_pointSet = (PgPointSet)psUpdateIf;
    }

    public boolean update(Object object) {
        if (this.m_pointSet == null) {
            PsDebug.warning("missing pointSet");
            return true;
        }
        if (object == this.m_pointSet) {
            ((TextComponent)this.m_tName).setText(this.m_pointSet.getName());
            this.m_bInteractive = false;
            ((TextComponent)this.m_tNumVertices).setText(String.valueOf(this.m_pointSet.getNumVertices()));
            this.m_bInteractive = true;
            this.m_vertexPanel.setVector(this.m_pointSet.getVertices(), m_header, this.m_pointSet.getNumVertices(), this.m_pointSet.getDimOfVertices());
            return true;
        }
        if (object == this.m_vertexPanel) {
            this.m_pointSet.update(this);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_tNumVertices) {
            String string = this.m_tNumVertices.getText();
            if (string == null || string.equals("")) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if (n != this.m_pointSet.getNumVertices()) {
                    this.m_pointSet.setNumVertices(n);
                    this.m_vertexPanel.setVector(this.m_pointSet.getVertices(), m_header, n, this.m_pointSet.getDimOfVertices());
                }
                this.m_pointSet.update(this);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("wrong format = " + string, this);
                return;
            }
        }
        if (object == this.m_tName) {
            this.m_pointSet.setName(this.m_tName.getText());
            this.m_pointSet.update(this);
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setBorderType(3);
        this.addTitle(PsConfig.getMessage("mInspector"));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        Component component = new Label(PsConfig.getMessage("lName"));
        panel.add(component);
        this.m_tName = new TextField("", 7);
        this.m_tName.addActionListener(this);
        panel.add(this.m_tName);
        this.add(panel);
        this.addLine(1);
        component = new Panel();
        ((Container)component).setLayout(new GridLayout(1, 2));
        this.add(component);
        Label label = new Label(PsConfig.getMessage("lNumVertices"));
        ((Container)component).add(label);
        this.m_tNumVertices = new TextField("0", 7);
        this.m_tNumVertices.addTextListener(this);
        this.m_tNumVertices.addActionListener(this);
        ((Container)component).add(this.m_tNumVertices);
        this.m_vertexPanel = new PdArray_IP(this.m_maxVisibleVectors, this.m_maxVisibleDim);
        this.m_vertexPanel.setParent(this);
        this.add(this.m_vertexPanel);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.m_bInteractive) {
            return;
        }
        Object object = textEvent.getSource();
        if (object == this.m_tNumVertices) {
            try {
                int n = Integer.parseInt(this.m_tNumVertices.getText());
                if (n != this.m_pointSet.getNumVertices()) {
                    this.m_pointSet.setNumVertices(n);
                    this.m_vertexPanel.setVector(this.m_pointSet.getVertices(), m_header, n, this.m_pointSet.getDimOfVertices());
                }
                this.m_pointSet.update(this);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("wrong format = " + this.m_tNumVertices.getText(), this);
                return;
            }
        }
    }
}

