/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import jv.loader.PgLoaderIf;
import jv.loader.PsXmlLoader;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;

public class PgJvxLoader
implements PgLoaderIf {
    protected boolean m_bIsAnimation = false;
    protected static boolean m_bIsEnabledSmallSize = false;
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    protected static void setEnabledSmallSize(boolean bl) {
        m_bIsEnabledSmallSize = bl;
    }

    protected static PgJvxSrc[] parseRsrcTree(PsXmlSrc psXmlSrc) {
        String string = null;
        String string2 = null;
        String string3 = null;
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning("missing root node.");
            return null;
        }
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, "version");
        if (psXmlNode2 == null) {
            PsDebug.warning("missing version information, using default.");
            string = "0.0";
            string2 = "dump";
        } else {
            string = psXmlNode2.getContent();
            string2 = psXmlNode2.getAttribute("type");
        }
        string3 = PsXmlSrc.getRsrc(psXmlNode, "title");
        PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode, "authors");
        PsAuthorInfo psAuthorInfo = null;
        if (psXmlNode3 != null) {
            psAuthorInfo = new PsAuthorInfo();
            psAuthorInfo.setXmlNode(psXmlNode3);
        }
        PsXmlNode psXmlNode4 = PsXmlSrc.getRsrcNode(psXmlNode, "description");
        PsGeometryInfo psGeometryInfo = null;
        if (psXmlNode4 != null) {
            psGeometryInfo = new PsGeometryInfo();
            psGeometryInfo.setXmlNode(psXmlNode4, null);
        }
        PgJvxSrc[] pgJvxSrcArray = null;
        String[] stringArray = new String[]{"tag", "name"};
        PsXmlNode psXmlNode5 = PsXmlSrc.getRsrcNode(psXmlNode, "geometries");
        if (psXmlNode5 != null) {
            PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode5, "geometry");
            if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
                return null;
            }
            pgJvxSrcArray = new PgJvxSrc[psXmlNodeArray.length];
            int n = 0;
            while (n < psXmlNodeArray.length) {
                Object object;
                PsXmlNode psXmlNode6;
                String string4;
                PiVector[] piVectorArray;
                PiVector[] piVectorArray2;
                PdVector[] pdVectorArray;
                Color[] colorArray;
                Object object2;
                Object object3;
                PsXmlNode psXmlNode7;
                Object object4;
                PiVector piVector;
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                if (psAuthorInfo != null) {
                    pgJvxSrc.setAuthorInfo(psAuthorInfo);
                }
                if (psGeometryInfo != null) {
                    pgJvxSrc.setGeometryInfo(psGeometryInfo);
                }
                pgJvxSrcArray[n] = pgJvxSrc;
                pgJvxSrc.setVersion(string);
                pgJvxSrc.setVersionType(string2);
                pgJvxSrc.setTitle(string3);
                pgJvxSrc.setName(psXmlNodeArray[n].getAttribute("name"));
                pgJvxSrc.setVisible(PgJvxLoader.parseVisibility(psXmlNodeArray[n].getAttribute("visible")) != 0);
                PsXmlNode[] psXmlNodeArray2 = psXmlNodeArray[n].getChildren("labelAtt");
                if (psXmlNodeArray2 != null && psXmlNodeArray2.length > 0 && psXmlNodeArray2[0] != null && (piVector = PgJvxLoader.parseLabelAtt(psXmlNodeArray2[0])) != null) {
                    pgJvxSrc.setLabelAttribute(5, piVector);
                    pgJvxSrc.showTitle(piVector.getEntry(5) == 1);
                }
                Color color = null;
                double d = 0.0;
                PsXmlNode psXmlNode8 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "pointSet");
                if (psXmlNode8 != null) {
                    object4 = psXmlNode8.getAttribute("dim");
                    if (object4 == null) {
                        PsDebug.warning("missing dimension of geometry[" + n + "]");
                        return null;
                    }
                    pgJvxSrc.setDimOfVertices(Integer.parseInt((String)object4));
                    pgJvxSrc.showVertices(PgJvxLoader.parseVisibility(psXmlNode8.getAttribute("point")) != 0);
                    pgJvxSrc.showVertexNormals(PgJvxLoader.parseVisibility(psXmlNode8.getAttribute("normal")) == 1);
                    pgJvxSrc.showVertexNormalArrow(PgJvxLoader.parseVisibility(psXmlNode8.getAttribute("normalArrow")) == 1);
                    pgJvxSrc.showVertexColors(PgJvxLoader.parseVisibility(psXmlNode8.getAttribute("color")) == 1);
                    pgJvxSrc.setType(30);
                    psXmlNode7 = PsXmlSrc.getRsrcNode(psXmlNode8, "points");
                    if (psXmlNode7 != null) {
                        object3 = PsXmlLoader.parseDoubleList(psXmlNode7, "p", stringArray);
                        if (object3 != null) {
                            pgJvxSrc.setDimOfVertices(((PdVector)((Object)object3[0])).getSize());
                            pgJvxSrc.setNumVertices(((PsXmlNode[])object3).length);
                            pgJvxSrc.setVertices((PdVector[])object3);
                        } else {
                            object2 = PgJvxLoader.parseFunList(psXmlNode7, "pf", stringArray);
                            if (object2 != null) {
                                pgJvxSrc.setDimOfVertices(object2[0].length);
                                pgJvxSrc.setNumVertices(((String[][])object2).length);
                                pgJvxSrc.setVertexFunctions((String[][])object2);
                            }
                        }
                        d = PsXmlSrc.getRsrcAsDouble(psXmlNode7, "thickness");
                        if (d != 0.0) {
                            pgJvxSrc.setGlobalVertexSize(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB(psXmlNode7, "color")) != null) {
                            pgJvxSrc.setGlobalVertexColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB(psXmlNode7, "colorTag")) != null) {
                            pgJvxSrc.setGlobalVertexTagColor(color);
                        }
                        if ((piVector = PgJvxLoader.parseLabelAtt(PsXmlSrc.getRsrcNode(psXmlNode7, "labelAtt"))) != null) {
                            pgJvxSrc.setLabelAttribute(0, piVector);
                            pgJvxSrc.showVertexLabels(piVector.getEntry(5) == 1);
                        }
                    }
                    if ((object3 = PsXmlSrc.getRsrcNode(psXmlNode8, "colors")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)object3, "c")) != null) {
                        pgJvxSrc.setVertexColors(colorArray);
                    }
                    if ((object2 = PsXmlSrc.getRsrcNode(psXmlNode8, "normals")) != null) {
                        pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)object2, "n", null);
                        if (pdVectorArray != null) {
                            pgJvxSrc.setVertexNormals(pdVectorArray);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object2, "thickness")) != 0.0) {
                            pgJvxSrc.setGlobalVertexNormalSize(d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object2, "length")) != 0.0) {
                            pgJvxSrc.setGlobalVertexNormalLength(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object2, "color")) != null) {
                            pgJvxSrc.setGlobalVertexNormalColor(color);
                        }
                    }
                    if ((piVectorArray2 = PsXmlSrc.getRsrcNode(psXmlNode8, "textures")) != null) {
                        pgJvxSrc.showVertexTexture(PgJvxLoader.parseVisibility(psXmlNode8.getAttribute("texture")) == 1);
                        piVectorArray = piVectorArray2.getAttribute("type");
                        if (piVectorArray == null || piVectorArray.equals("image")) {
                            // empty if block
                        }
                        if ((pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)piVectorArray2, "t", null)) != null) {
                            pgJvxSrc.setVertexTextures(pdVectorArray);
                        }
                        if ((string4 = (psXmlNode6 = PsXmlSrc.getRsrcNode((PsXmlNode)piVectorArray2, "image")).getContent()) != null) {
                            object = psXmlNode6.getAttribute("repeat");
                            if (object != null && !"no".equals(object)) {
                                PsDebug.warning("repeat mode in images not supported yet.");
                            }
                            pgJvxSrc.setTextureImageName(string4);
                        }
                    }
                }
                if ((object4 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "lineSet")) != null) {
                    pgJvxSrc.showPolygonStartArrow(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("startArrow")) == 1);
                    pgJvxSrc.showPolygonEndArrow(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("arrow")) == 1);
                    pgJvxSrc.showPolygons(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("line")) != 0);
                    pgJvxSrc.showPolygonNormals(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("normal")) == 1);
                    pgJvxSrc.showPolygonNormalArrow(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("normalArrow")) == 1);
                    pgJvxSrc.showPolygonColors(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("color")) == 1);
                    pgJvxSrc.setType(32);
                    psXmlNode7 = PsXmlSrc.getRsrcNode((PsXmlNode)object4, "lines");
                    if (psXmlNode7 != null) {
                        object3 = PsXmlLoader.parseIntegerList(psXmlNode7, "l", stringArray);
                        if (object3 != null) {
                            pgJvxSrc.setDimOfPolygons(-1);
                            pgJvxSrc.setNumPolygons(((PsXmlNode[])object3).length);
                            pgJvxSrc.setPolygons((PiVector[])object3);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble(psXmlNode7, "thickness")) != 0.0) {
                            pgJvxSrc.setGlobalPolygonSize(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB(psXmlNode7, "color")) != null) {
                            pgJvxSrc.setGlobalPolygonColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB(psXmlNode7, "colorTag")) != null) {
                            pgJvxSrc.setGlobalPolygonTagColor(color);
                        }
                        if ((piVector = PgJvxLoader.parseLabelAtt(PsXmlSrc.getRsrcNode(psXmlNode7, "labelAtt"))) != null) {
                            pgJvxSrc.setLabelAttribute(2, piVector);
                            pgJvxSrc.showPolygonLabels(piVector.getEntry(5) == 1);
                        }
                    }
                    if ((object3 = PsXmlSrc.getRsrcNode((PsXmlNode)object4, "colors")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)object3, "c")) != null) {
                        pgJvxSrc.setPolygonColors(colorArray);
                    }
                    if ((object2 = PsXmlSrc.getRsrcNode((PsXmlNode)object4, "normals")) != null) {
                        pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)object2, "n", null);
                        if (pdVectorArray != null) {
                            pgJvxSrc.setPolygonNormals(pdVectorArray);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object2, "thickness")) != 0.0) {
                            pgJvxSrc.setGlobalPolygonNormalSize(d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object2, "length")) != 0.0) {
                            pgJvxSrc.setGlobalPolygonNormalLength(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object2, "color")) != null) {
                            pgJvxSrc.setGlobalPolygonNormalColor(color);
                        }
                    }
                }
                if ((psXmlNode7 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "faceSet")) != null) {
                    Object object5;
                    PsXmlNode psXmlNode9;
                    PsXmlNode psXmlNode10;
                    pgJvxSrc.showElements(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("face")) != 0);
                    pgJvxSrc.showEdges(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("edge")) != 0);
                    pgJvxSrc.showElementNormals(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("normal")) == 1);
                    pgJvxSrc.showElementNormalArrow(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("normalArrow")) == 1);
                    pgJvxSrc.showElementColors(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("color")) == 1);
                    pgJvxSrc.showElementBackColor(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("colorBackGlobal")) == 1);
                    pgJvxSrc.showElementBackColors(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("colorBackLocal")) == 1);
                    pgJvxSrc.showVertexTexture(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("texture")) == 1);
                    pgJvxSrc.showElementTexture(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("texture")) == 1);
                    boolean bl = PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("backface")) != 0;
                    pgJvxSrc.showBackface(bl);
                    pgJvxSrc.showBoundaries(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("boundary")) == 1);
                    pgJvxSrc.showOutline(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("outline")) == 1);
                    pgJvxSrc.setType(33);
                    object2 = PsXmlSrc.getRsrcNode(psXmlNode7, "faces");
                    if (object2 != null) {
                        piVectorArray2 = PsXmlLoader.parseIntegerList((PsXmlNode)object2, "f", stringArray);
                        if (piVectorArray2 != null) {
                            pgJvxSrc.setDimOfElements(-1);
                            pgJvxSrc.setNumElements(piVectorArray2.length);
                            pgJvxSrc.setElements(piVectorArray2);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object2, "color")) != null) {
                            pgJvxSrc.setGlobalElementColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object2, "colorBack")) != null) {
                            pgJvxSrc.setGlobalElementBackColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object2, "colorTag")) != null) {
                            pgJvxSrc.setGlobalElementTagColor(color);
                        }
                        if ((piVector = PgJvxLoader.parseLabelAtt(PsXmlSrc.getRsrcNode((PsXmlNode)object2, "labelAtt"))) != null) {
                            pgJvxSrc.setLabelAttribute(3, piVector);
                            pgJvxSrc.showElementLabels(piVector.getEntry(5) == 1);
                        }
                    }
                    if ((piVectorArray2 = PsXmlSrc.getRsrcNode(psXmlNode7, "neighbours")) != null && (piVectorArray = PsXmlLoader.parseIntegerList((PsXmlNode)piVectorArray2, "nb", null)) != null) {
                        pgJvxSrc.setNeighbours(piVectorArray);
                    }
                    if ((piVectorArray = PsXmlSrc.getRsrcNode(psXmlNode7, "edges")) != null) {
                        PiVector[] piVectorArray3 = PsXmlLoader.parseIntegerList((PsXmlNode)piVectorArray, "e", null);
                        if (piVectorArray3 != null) {
                            pgJvxSrc.setEdges(piVectorArray3);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)piVectorArray, "thickness")) != 0.0) {
                            pgJvxSrc.setGlobalEdgeSize(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)piVectorArray, "color")) != null) {
                            pgJvxSrc.setGlobalEdgeColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)piVectorArray, "colorTag")) != null) {
                            pgJvxSrc.setGlobalEdgeTagColor(color);
                        }
                        if ((piVector = PgJvxLoader.parseLabelAtt(PsXmlSrc.getRsrcNode((PsXmlNode)piVectorArray, "labelAtt"))) != null) {
                            pgJvxSrc.setLabelAttribute(1, piVector);
                            pgJvxSrc.showEdgeLabels(piVector.getEntry(5) == 1);
                        }
                    }
                    if ((psXmlNode6 = PsXmlSrc.getRsrcNode(psXmlNode7, "colors")) != null && (colorArray = PsXmlLoader.parseColorList(psXmlNode6, "c")) != null) {
                        pgJvxSrc.setElementColors(colorArray);
                    }
                    if ((object = PsXmlSrc.getRsrcNode(psXmlNode7, "colorsBack")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)object, "c")) != null) {
                        pgJvxSrc.setElementBackColors(colorArray);
                    }
                    if ((psXmlNode10 = PsXmlSrc.getRsrcNode(psXmlNode7, "normals")) != null) {
                        pdVectorArray = PsXmlLoader.parseDoubleList(psXmlNode10, "n", null);
                        if (pdVectorArray != null) {
                            pgJvxSrc.setElementNormals(pdVectorArray);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble(psXmlNode10, "thickness")) != 0.0) {
                            pgJvxSrc.setGlobalElementNormalSize(d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble(psXmlNode10, "length")) != 0.0) {
                            pgJvxSrc.setGlobalElementNormalLength(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB(psXmlNode10, "color")) != null) {
                            pgJvxSrc.setGlobalElementNormalColor(color);
                        }
                    } else if (!bl || pgJvxSrc.isShowingElementNormals()) {
                        pgJvxSrc.makeElementNormals();
                    }
                    if ((psXmlNode9 = PsXmlSrc.getRsrcNode(psXmlNode7, "textures")) != null) {
                        PdVector[][] pdVectorArray2;
                        object5 = psXmlNode9.getAttribute("type");
                        if (object5 == null || ((String)object5).equals("image")) {
                            // empty if block
                        }
                        PdVector[] pdVectorArray3 = PsXmlLoader.parseDoubleList(psXmlNode9, "t", null);
                        int n2 = pgJvxSrc.getNumElements();
                        if (pdVectorArray3 != null && n2 > 0) {
                            pgJvxSrc.assureElementTextures();
                            pdVectorArray2 = pgJvxSrc.getElementTextures();
                            int n3 = 0;
                            PiVector[] piVectorArray4 = pgJvxSrc.getElements();
                            int n4 = 0;
                            while (n4 < n2) {
                                int n5 = piVectorArray4[n4].getSize();
                                int n6 = 0;
                                while (n6 < n5) {
                                    pdVectorArray2[n4][n6].copy(pdVectorArray3[n3++]);
                                    ++n6;
                                }
                                ++n4;
                            }
                            if (n3 != pdVectorArray3.length) {
                                PsDebug.warning("element texture coordinates do not match elements.");
                                pgJvxSrc.setElementTextures(null);
                            }
                        }
                        if ((string4 = (pdVectorArray2 = PsXmlSrc.getRsrcNode(psXmlNode9, "image")).getContent()) != null) {
                            String string5 = pdVectorArray2.getAttribute("repeat");
                            if (string5 != null && !"no".equals(string5)) {
                                PsDebug.warning("repeat mode in images not supported yet.");
                            }
                            pgJvxSrc.setTextureImageName(string4);
                        }
                    }
                    if ((object5 = PsXmlSrc.getRsrcNode(psXmlNode7, "boundaries")) != null) {
                        d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5, "thickness");
                        if (d != 0.0) {
                            pgJvxSrc.setGlobalBndSize(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object5, "color")) != null) {
                            pgJvxSrc.setGlobalBndColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object5, "colorTag")) != null) {
                            pgJvxSrc.setGlobalBndTagColor(color);
                        }
                    }
                }
                if ((object3 = PsXmlSrc.getRsrcNodes(psXmlNodeArray[n], "vectorField")) != null && ((PsXmlNode[])object3).length > 0) {
                    pgJvxSrc.setNumVectorFields(((PsXmlNode[])object3).length);
                    int n7 = 0;
                    while (n7 < ((PsXmlNode[])object3).length) {
                        pgJvxSrc.setVectorFieldName(n7, object3[n7].getAttribute("name"));
                        object2 = object3[n7].getAttribute("base");
                        if (object2 != null) {
                            if (object2.equals("vertex")) {
                                pgJvxSrc.setVectorElementBased(n7, false);
                            } else if (object2.equals("element")) {
                                pgJvxSrc.setVectorElementBased(n7, true);
                            }
                        }
                        pgJvxSrc.showVectorArrows(n7, PgJvxLoader.parseVisibility(object3[n7].getAttribute("arrow")) == 1);
                        piVectorArray2 = PsXmlSrc.getRsrcNode(object3[n7], "vectors");
                        if (piVectorArray2 != null) {
                            int n8;
                            pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)piVectorArray2, "v", null);
                            if (pdVectorArray != null && (n8 = pdVectorArray.length) > 0) {
                                pgJvxSrc.setNumVectors(n7, n8, pdVectorArray[0].getSize());
                                pgJvxSrc.setVectors(n7, pdVectorArray);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)piVectorArray2, "thickness")) != 0.0) {
                                pgJvxSrc.setGlobalVectorSize(n7, d);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)piVectorArray2, "length")) != 0.0) {
                                pgJvxSrc.setGlobalVectorLength(n7, d);
                            }
                            if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)piVectorArray2, "color")) != null) {
                                pgJvxSrc.setGlobalVectorColor(n7, color);
                            }
                        }
                        if ((piVectorArray = PsXmlSrc.getRsrcNode(object3[n7], "colors")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)piVectorArray, "c")) != null) {
                            pgJvxSrc.setVectorColors(n7, colorArray);
                        }
                        ++n7;
                    }
                }
                ++n;
            }
        } else {
            PsDebug.warning("missing references node.");
        }
        return pgJvxSrcArray;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(bufferedReader);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to parse XML stream");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = PgJvxLoader.parseRsrcTree(psXmlSrc);
        if (pgJvxSrcArray == null) {
            PsDebug.warning("failed to interpret JVX tree");
            return null;
        }
        return pgJvxSrcArray;
    }

    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PgJvxLoader pgJvxLoader = new PgJvxLoader();
        PgJvxSrc[] pgJvxSrcArray = pgJvxLoader.read(bufferedReader);
        if (pgJvxSrcArray != null) {
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                if (pgJvxSrcArray[n] != null && (pgJvxSrcArray[n].getName() == null || pgJvxSrcArray[n].getName().startsWith("object_"))) {
                    if (n == 0) {
                        pgJvxSrcArray[n].setName(PsUtil.getFileBaseName(string));
                    } else {
                        pgJvxSrcArray[n].setName(PsUtil.getFileBaseName(string) + "[" + n + "]");
                    }
                }
                ++n;
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return pgJvxSrcArray;
    }

    private static boolean hasAttribute(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2);
    }

    protected static PsXmlNode fillLabelAttr(boolean bl) {
        PsXmlNode psXmlNode = new PsXmlNode("labelAtt");
        psXmlNode.addAttribute("visible", PgJvxLoader.fillVisibility(bl));
        return psXmlNode;
    }

    protected static PsXmlNode fillLabelAttr(boolean bl, int n, int n2, int n3, int n4, int n5) {
        PsXmlNode psXmlNode = new PsXmlNode("labelAtt");
        psXmlNode.addAttribute("visible", PgJvxLoader.fillVisibility(bl));
        switch (n) {
            case 0: {
                psXmlNode.addAttribute("horAlign", "head");
                break;
            }
            case 1: {
                psXmlNode.addAttribute("horAlign", "center");
                break;
            }
            case 2: {
                psXmlNode.addAttribute("horAlign", "tail");
            }
        }
        switch (n2) {
            case 0: {
                psXmlNode.addAttribute("verAlign", "head");
                break;
            }
            case 1: {
                psXmlNode.addAttribute("verAlign", "center");
                break;
            }
            case 2: {
                psXmlNode.addAttribute("verAlign", "tail");
            }
        }
        switch (n3) {
            case 0: {
                psXmlNode.addAttribute("font", "text");
                break;
            }
            case 1: {
                psXmlNode.addAttribute("font", "fixed");
                break;
            }
            case 3: {
                psXmlNode.addAttribute("font", "header2");
                break;
            }
            case 4: {
                psXmlNode.addAttribute("font", "header4");
                break;
            }
            case 2: {
                psXmlNode.addAttribute("font", "menu");
            }
        }
        psXmlNode.addAttribute("xOffset", String.valueOf(n4));
        psXmlNode.addAttribute("yOffset", String.valueOf(n5));
        return psXmlNode;
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    protected static boolean isEnabledSmallSize() {
        return m_bIsEnabledSmallSize;
    }

    protected static int parseVisibility(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("show")) {
            return 1;
        }
        return 0;
    }

    public static String[][] parseFunList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        String[][] stringArray2 = new String[psXmlNodeArray.length][];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            String string2 = psXmlNodeArray[n].getContent();
            if (string2 != null) {
                String[] stringArray3 = PuString.splitString(string2, ' ');
                stringArray2[n] = new String[stringArray3.length];
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    stringArray2[n][n2] = stringArray3[n2];
                    ++n2;
                }
            }
            ++n;
        }
        return stringArray2;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometries.");
            return false;
        }
        PsXmlSrc psXmlSrc = PgJvxLoader.fillRsrcTree(null, pgJvxSrcArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return false;
        }
        try {
            return PsXmlSrc.write(writer, psXmlSrc);
        }
        catch (IOException iOException) {
            PsDebug.warning("failed to generate XML tree", iOException);
            return false;
        }
    }

    public static String write(PgJvxSrc[] pgJvxSrcArray) {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometries.");
            return null;
        }
        PsXmlSrc psXmlSrc = PgJvxLoader.fillRsrcTree(null, pgJvxSrcArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write(psXmlSrc);
    }

    protected static PiVector parseLabelAtt(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            return null;
        }
        PiVector piVector = new PiVector(6);
        String string = psXmlNode.getAttribute("visible");
        if (string != null && "hide".equalsIgnoreCase(string)) {
            piVector.setEntry(5, 0);
        } else {
            piVector.setEntry(5, 1);
        }
        String string2 = psXmlNode.getAttribute("horAlign");
        if (string2 == null || "head".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 0);
        } else if ("center".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 1);
        } else if ("tail".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 2);
        }
        String string3 = psXmlNode.getAttribute("verAlign");
        if (string3 == null || "base".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 0);
        } else if ("middle".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 1);
        } else if ("top".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 2);
        }
        String string4 = psXmlNode.getAttribute("font");
        if (string4 == null || "text".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 0);
        } else if ("fixed".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 1);
        } else if ("header2".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 3);
        } else if ("header4".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 4);
        } else if ("menu".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 2);
        } else if (string4 == null) {
            piVector.setEntry(4, 0);
        }
        try {
            PsXmlNode psXmlNode2;
            PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode, "xOffset");
            if (psXmlNode3 != null) {
                piVector.setEntry(0, Integer.parseInt(psXmlNode3.getContent()));
            }
            if ((psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, "yOffset")) != null) {
                piVector.setEntry(1, Integer.parseInt(psXmlNode2.getContent()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format parsing offset");
            return null;
        }
        return piVector;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    protected static PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PgJvxSrc[] pgJvxSrcArray) {
        PsXmlNode psXmlNode;
        Serializable serializable;
        PsXmlNode psXmlNode2;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            return null;
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode2 = psXmlSrc.getRootNode()) == null) {
            psXmlNode2 = new PsXmlNode("jvx-model");
            psXmlSrc.setRootNode(psXmlNode2);
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        psXmlSrc.setDocName("jvx-model");
        PsXmlNode[] psXmlNodeArray = new PsXmlNode[2];
        psXmlNodeArray[0] = psXmlNode2.addChild("meta");
        psXmlNodeArray[0].addAttribute("generator", PsConfig.getProgram() + " v." + PsConfig.getVersion());
        psXmlNodeArray[1] = psXmlNode2.addChild("meta");
        psXmlNodeArray[1].addAttribute("date", new Date().toString());
        PsXmlNode psXmlNode3 = psXmlNode2.addChild("version", pgJvxSrc.getVersion());
        psXmlNode3.addAttribute("type", pgJvxSrc.getVersionType());
        if (pgJvxSrc.getTitle() != null) {
            psXmlNode2.addChild("title", pgJvxSrc.getTitle());
        } else {
            psXmlNode2.addChild("title", pgJvxSrc.getName());
        }
        PsAuthorInfo psAuthorInfo = pgJvxSrc.getAuthors();
        if (psAuthorInfo != null && (serializable = psAuthorInfo.getXmlNode()) != null) {
            psXmlNode2.addChild((PsXmlNode)serializable);
        }
        if ((serializable = pgJvxSrc.getGeometryInfo()) != null && (psXmlNode = ((PsGeometryInfo)serializable).getXmlNode()) != null) {
            psXmlNode2.addChild(psXmlNode);
        }
        PsXmlNode psXmlNode4 = psXmlNode2.addChild("geometries");
        if (pgJvxSrcArray != null) {
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                PsXmlNode psXmlNode5;
                Object object;
                Object object2;
                PsXmlNode psXmlNode6;
                Serializable serializable2;
                PdVector[] pdVectorArray;
                pgJvxSrc = pgJvxSrcArray[n];
                PsXmlNode psXmlNode7 = psXmlNode4.addChild("geometry");
                psXmlNode7.addAttribute("name", pgJvxSrc.getName());
                if (!pgJvxSrc.isVisible()) {
                    psXmlNode7.addAttribute("visible", "hide");
                }
                if (pgJvxSrc.getType() == 30 || pgJvxSrc.getType() == 31 || pgJvxSrc.getType() == 32 || pgJvxSrc.getType() == 33) {
                    pdVectorArray = psXmlNode7.addChild("pointSet");
                    pdVectorArray.addAttribute("dim", String.valueOf(pgJvxSrc.getDimOfVertices()));
                    if (pgJvxSrc.isShowingVertices()) {
                        pdVectorArray.addAttribute("point", "show");
                    } else if (!pgJvxSrc.isShowingVertices()) {
                        pdVectorArray.addAttribute("point", "hide");
                    }
                    if (pgJvxSrc.isShowingVertexColors() && pgJvxSrc.getVertexColors() != null) {
                        pdVectorArray.addAttribute("color", "show");
                    }
                    if (pgJvxSrc.isShowingVertexNormals() && pgJvxSrc.getVertexNormals() != null) {
                        pdVectorArray.addAttribute("normal", "show");
                    }
                    if (pgJvxSrc.isShowingVertexNormalArrow() && pgJvxSrc.getVertexNormals() != null) {
                        pdVectorArray.addAttribute("normalArrow", "show");
                    }
                    serializable2 = pdVectorArray.addChild("points");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "p", pgJvxSrc.getVertices(), pgJvxSrc.getNumVertices());
                    if (pgJvxSrc.getGlobalVertexSize() != 0.0) {
                        ((PsXmlNode)serializable2).addChild("thickness", pgJvxSrc.getGlobalVertexSize());
                    }
                    if (pgJvxSrc.getGlobalVertexColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable2, "color", pgJvxSrc.getGlobalVertexColor());
                    }
                    if (pgJvxSrc.getGlobalVertexTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable2, "colorTag", pgJvxSrc.getGlobalVertexTagColor());
                    }
                    if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingVertexLabels()) {
                        ((PsXmlNode)serializable2).addChild(PgJvxLoader.fillLabelAttr(pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingVertexLabels()));
                    }
                    if (pgJvxSrc.getVertexColors() != null && (!m_bIsEnabledSmallSize || pgJvxSrc.isShowingVertices() && pgJvxSrc.isShowingVertexColors())) {
                        psXmlNode6 = pdVectorArray.addChild("colors");
                        psXmlNode6.addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList(psXmlNode6, "c", pgJvxSrc.getVertexColors(), pgJvxSrc.getNumVertices());
                    }
                    if (pgJvxSrc.getVertexNormals() != null && (!m_bIsEnabledSmallSize || pgJvxSrc.isShowingVertexNormals())) {
                        psXmlNode6 = pdVectorArray.addChild("normals");
                        PsXmlLoader.addVectorList(psXmlNode6, "n", pgJvxSrc.getVertexNormals(), pgJvxSrc.getNumVertices());
                        if (pgJvxSrc.getGlobalVertexNormalSize() != 0.0) {
                            psXmlNode6.addChild("thickness", pgJvxSrc.getGlobalVertexNormalSize());
                        }
                        if (pgJvxSrc.getGlobalVertexNormalLength() != 0.0) {
                            psXmlNode6.addChild("length", pgJvxSrc.getGlobalVertexNormalLength());
                        }
                        if (pgJvxSrc.getGlobalVertexNormalColor() != null) {
                            PsXmlLoader.addColor(psXmlNode6, "color", pgJvxSrc.getGlobalVertexNormalColor());
                        }
                    }
                    if (pgJvxSrc.getVertexTextures() != null && (!m_bIsEnabledSmallSize || pgJvxSrc.isShowingVertexTexture())) {
                        psXmlNode6 = pdVectorArray.addChild("textures");
                        psXmlNode6.addAttribute("dim", String.valueOf(2));
                        PsXmlLoader.addVectorList(psXmlNode6, "t", pgJvxSrc.getVertexTextures(), pgJvxSrc.getNumVertices());
                        if (pgJvxSrc.getTextureImage() != null) {
                            psXmlNode6.addAttribute("type", "image");
                            object2 = pgJvxSrc.getTextureImageName();
                            if (object2 == null) {
                                object2 = pgJvxSrc.getName() + "_texture.gif";
                            }
                            object = psXmlNode6.addChild("image", (String)object2);
                            ((PsXmlNode)object).addAttribute("repeat", "no");
                        }
                    }
                }
                if (pgJvxSrc.getType() == 31 || pgJvxSrc.getType() == 32) {
                    pdVectorArray = psXmlNode7.addChild("lineSet");
                    if (pgJvxSrc.isShowingPolygons()) {
                        pdVectorArray.addAttribute("line", "show");
                    } else if (!pgJvxSrc.isShowingPolygons()) {
                        pdVectorArray.addAttribute("line", "hide");
                    }
                    if (pgJvxSrc.isShowingPolygonStartArrow()) {
                        pdVectorArray.addAttribute("arrowStart", "show");
                    }
                    if (pgJvxSrc.isShowingPolygonEndArrow()) {
                        pdVectorArray.addAttribute("arrow", "show");
                    }
                    if (pgJvxSrc.isShowingPolygonColors()) {
                        pdVectorArray.addAttribute("color", "show");
                    }
                    if (pgJvxSrc.isShowingPolygonNormals()) {
                        pdVectorArray.addAttribute("normal", "show");
                    }
                    if (pgJvxSrc.isShowingPolygonNormalArrow()) {
                        pdVectorArray.addAttribute("normalArrow", "show");
                    }
                    serializable2 = pdVectorArray.addChild("lines");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "l", pgJvxSrc.getPolygons(), pgJvxSrc.getNumPolygons());
                    if (pgJvxSrc.getGlobalPolygonSize() != 0.0) {
                        ((PsXmlNode)serializable2).addChild("thickness", pgJvxSrc.getGlobalPolygonSize());
                    }
                    if (pgJvxSrc.getGlobalPolygonColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable2, "color", pgJvxSrc.getGlobalPolygonColor());
                    }
                    if (pgJvxSrc.getGlobalPolygonTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable2, "colorTag", pgJvxSrc.getGlobalPolygonTagColor());
                    }
                    if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingPolygonLabels()) {
                        ((PsXmlNode)serializable2).addChild(PgJvxLoader.fillLabelAttr(pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingPolygonLabels()));
                    }
                    if (pgJvxSrc.getPolygonColors() != null && (!m_bIsEnabledSmallSize || pgJvxSrc.isShowingPolygonColors())) {
                        psXmlNode6 = pdVectorArray.addChild("colors");
                        psXmlNode6.addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList(psXmlNode6, "c", pgJvxSrc.getPolygonColors(), pgJvxSrc.getNumPolygons());
                    }
                    if (pgJvxSrc.getPolygonNormals() != null && (!m_bIsEnabledSmallSize || pgJvxSrc.isShowingPolygonNormals())) {
                        psXmlNode6 = pdVectorArray.addChild("normals");
                        PsXmlLoader.addVectorList(psXmlNode6, "n", pgJvxSrc.getPolygonNormals(), pgJvxSrc.getNumPolygons());
                        if (pgJvxSrc.getGlobalPolygonNormalSize() != 0.0) {
                            psXmlNode6.addChild("thickness", pgJvxSrc.getGlobalPolygonNormalSize());
                        }
                        if (pgJvxSrc.getGlobalPolygonNormalLength() != 0.0) {
                            psXmlNode6.addChild("length", pgJvxSrc.getGlobalPolygonNormalLength());
                        }
                        if (pgJvxSrc.getGlobalPolygonNormalColor() != null) {
                            PsXmlLoader.addColor(psXmlNode6, "color", pgJvxSrc.getGlobalPolygonNormalColor());
                        }
                    }
                }
                if (pgJvxSrc.getType() == 33) {
                    pdVectorArray = psXmlNode7.addChild("faceSet");
                    if (pgJvxSrc.isShowingEdges()) {
                        pdVectorArray.addAttribute("edge", "show");
                    } else {
                        pdVectorArray.addAttribute("edge", "hide");
                    }
                    if (pgJvxSrc.isShowingElements()) {
                        pdVectorArray.addAttribute("face", "show");
                    } else {
                        pdVectorArray.addAttribute("face", "hide");
                    }
                    if (pgJvxSrc.isShowingElementColors() && pgJvxSrc.getElementColors() != null) {
                        pdVectorArray.addAttribute("color", "show");
                    }
                    if (pgJvxSrc.isShowingElementBackColor()) {
                        pdVectorArray.addAttribute("colorBackGlobal", "show");
                    }
                    if (pgJvxSrc.isShowingElementBackColors() && pgJvxSrc.getElementBackColors() != null) {
                        pdVectorArray.addAttribute("colorBackLocal", "show");
                    }
                    if (pgJvxSrc.isShowingElementNormals() && pgJvxSrc.getElementNormals() != null) {
                        pdVectorArray.addAttribute("normal", "show");
                    }
                    if (pgJvxSrc.isShowingElementNormalArrow() && pgJvxSrc.getElementNormals() != null) {
                        pdVectorArray.addAttribute("normalArrow", "show");
                    }
                    if (pgJvxSrc.isShowingVertexTexture() && pgJvxSrc.getVertexTextures() != null || pgJvxSrc.isShowingElementTexture() && pgJvxSrc.getElementTextures() != null) {
                        pdVectorArray.addAttribute("texture", "show");
                    }
                    if (!pgJvxSrc.isShowingBackface()) {
                        pdVectorArray.addAttribute("backface", "hide");
                    }
                    if (pgJvxSrc.isShowingBoundaries()) {
                        pdVectorArray.addAttribute("boundary", "show");
                    }
                    serializable2 = pdVectorArray.addChild("faces");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable2, "f", pgJvxSrc.getElements(), pgJvxSrc.getNumElements());
                    if (pgJvxSrc.getGlobalElementColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable2, "color", pgJvxSrc.getGlobalElementColor());
                    }
                    if (pgJvxSrc.isShowingElementBackColor()) {
                        PsXmlLoader.addColor((PsXmlNode)serializable2, "colorBack", pgJvxSrc.getGlobalElementBackColor());
                    }
                    if (pgJvxSrc.getGlobalElementTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable2, "colorTag", pgJvxSrc.getGlobalElementTagColor());
                    }
                    if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingElementLabels()) {
                        ((PsXmlNode)serializable2).addChild(PgJvxLoader.fillLabelAttr(pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingElementLabels()));
                    }
                    if (pgJvxSrc.getNeighbours() != null && !m_bIsEnabledSmallSize) {
                        psXmlNode6 = pdVectorArray.addChild("neighbours");
                        PsXmlLoader.addVectorList(psXmlNode6, "nb", pgJvxSrc.getNeighbours(), pgJvxSrc.getNumElements());
                    }
                    psXmlNode6 = pdVectorArray.addChild("edges");
                    if (pgJvxSrc.getNumEdges() > 0) {
                        PsXmlLoader.addVectorList(psXmlNode6, "e", pgJvxSrc.getEdges(), pgJvxSrc.getNumEdges());
                    }
                    if (pgJvxSrc.getGlobalEdgeSize() != 0.0) {
                        psXmlNode6.addChild("thickness", pgJvxSrc.getGlobalEdgeSize());
                    }
                    if (pgJvxSrc.getGlobalEdgeColor() != null) {
                        PsXmlLoader.addColor(psXmlNode6, "color", pgJvxSrc.getGlobalEdgeColor());
                    }
                    if (pgJvxSrc.getGlobalEdgeTagColor() != null) {
                        PsXmlLoader.addColor(psXmlNode6, "colorTag", pgJvxSrc.getGlobalEdgeTagColor());
                    }
                    if (pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingEdgeLabels()) {
                        psXmlNode6.addChild(PgJvxLoader.fillLabelAttr(pgJvxSrc.isShowingIndices() || pgJvxSrc.isShowingEdgeLabels()));
                    }
                    if (pgJvxSrc.getElementColors() != null && (!m_bIsEnabledSmallSize || pgJvxSrc.isShowingElements() && pgJvxSrc.isShowingElementColors())) {
                        object2 = pdVectorArray.addChild("colors");
                        ((PsXmlNode)object2).addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList((PsXmlNode)object2, "c", pgJvxSrc.getElementColors(), pgJvxSrc.getNumElements());
                    }
                    if (pgJvxSrc.getElementBackColors() != null && (!m_bIsEnabledSmallSize || pgJvxSrc.isShowingElements() && pgJvxSrc.isShowingElementBackColors())) {
                        object2 = pdVectorArray.addChild("colorsBack");
                        ((PsXmlNode)object2).addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList((PsXmlNode)object2, "c", pgJvxSrc.getElementBackColors(), pgJvxSrc.getNumElements());
                    }
                    if (pgJvxSrc.getElementNormals() != null && (!m_bIsEnabledSmallSize || pgJvxSrc.isShowingElementNormals())) {
                        object2 = pdVectorArray.addChild("normals");
                        PsXmlLoader.addVectorList((PsXmlNode)object2, "n", pgJvxSrc.getElementNormals(), pgJvxSrc.getNumElements());
                        if (pgJvxSrc.getGlobalElementNormalSize() != 0.0) {
                            ((PsXmlNode)object2).addChild("thickness", pgJvxSrc.getGlobalElementNormalSize());
                        }
                        if (pgJvxSrc.getGlobalElementNormalLength() != 0.0) {
                            ((PsXmlNode)object2).addChild("length", pgJvxSrc.getGlobalElementNormalLength());
                        }
                        if (pgJvxSrc.getGlobalElementNormalColor() != null) {
                            PsXmlLoader.addColor((PsXmlNode)object2, "color", pgJvxSrc.getGlobalElementNormalColor());
                        }
                    }
                    if (pgJvxSrc.getElementTextures() != null && (!m_bIsEnabledSmallSize || pgJvxSrc.isShowingElementTexture())) {
                        object2 = pdVectorArray.addChild("textures");
                        ((PsXmlNode)object2).addAttribute("dim", String.valueOf(2));
                        PsXmlLoader.addVectorList((PsXmlNode)object2, "t", pgJvxSrc.getElementTextures(), pgJvxSrc.getNumElements());
                        if (pgJvxSrc.getTextureImage() != null) {
                            ((PsXmlNode)object2).addAttribute("type", "image");
                            object = pgJvxSrc.getTextureImageName();
                            if (object == null) {
                                object = pgJvxSrc.getName() + "_texture.gif";
                            }
                            psXmlNode5 = ((PsXmlNode)object2).addChild("image", (String)object);
                            psXmlNode5.addAttribute("repeat", "no");
                        }
                    }
                    if (pgJvxSrc.isShowingBoundaries()) {
                        object2 = pdVectorArray.addChild("boundaries");
                        if (pgJvxSrc.getGlobalBndSize() != 0.0) {
                            ((PsXmlNode)object2).addChild("thickness", pgJvxSrc.getGlobalBndSize());
                        }
                        if (pgJvxSrc.getGlobalBndColor() != null) {
                            PsXmlLoader.addColor((PsXmlNode)object2, "color", pgJvxSrc.getGlobalBndColor());
                        }
                        if (pgJvxSrc.getGlobalBndTagColor() != null) {
                            PsXmlLoader.addColor((PsXmlNode)object2, "colorTag", pgJvxSrc.getGlobalBndTagColor());
                        }
                    }
                }
                if (pgJvxSrc.getNumVectorFields() != 0) {
                    int n2 = pgJvxSrc.getNumVectorFields();
                    int n3 = 0;
                    while (n3 < n2) {
                        psXmlNode6 = psXmlNode7.addChild("vectorField");
                        if (pgJvxSrc.getVectorFieldName(n3) != null) {
                            psXmlNode6.addAttribute("name", pgJvxSrc.getVectorFieldName(n3));
                        }
                        if (pgJvxSrc.isShowingVectorArrows(n3)) {
                            psXmlNode6.addAttribute("arrow", "show");
                        } else {
                            psXmlNode6.addAttribute("arrow", "hide");
                        }
                        if (pgJvxSrc.isVectorElementBased(n3)) {
                            psXmlNode6.addAttribute("base", "element");
                        } else {
                            psXmlNode6.addAttribute("base", "vertex");
                        }
                        object2 = pgJvxSrc.getVectors(n3);
                        if (object2 == null || ((PdVector[])object2).length == 0) {
                            PsDebug.warning("missing vectors of vector field[" + n3 + "]");
                        } else {
                            object = psXmlNode6.addChild("vectors");
                            PsXmlLoader.addVectorList((PsXmlNode)object, "v", (PdVector[])object2, ((PdVector[])object2).length);
                            if (pgJvxSrc.getGlobalVectorSize(n3) != 0.0) {
                                ((PsXmlNode)object).addChild("thickness", pgJvxSrc.getGlobalVectorSize(n3));
                            }
                            if (pgJvxSrc.getGlobalVectorLength(n3) != 0.0) {
                                ((PsXmlNode)object).addChild("length", pgJvxSrc.getGlobalVectorLength(n3));
                            }
                            if (pgJvxSrc.getGlobalVectorColor(n3) != null) {
                                PsXmlLoader.addColor((PsXmlNode)object, "color", pgJvxSrc.getGlobalVectorColor(n3));
                            }
                            if (pgJvxSrc.getVectorFieldColors(n3) != null) {
                                psXmlNode5 = psXmlNode6.addChild("colors");
                                psXmlNode5.addAttribute("type", "rgb");
                                PsXmlLoader.addVectorList(psXmlNode5, "c", pgJvxSrc.getVectorFieldColors(n3), ((PdVector[])object2).length);
                            }
                        }
                        ++n3;
                    }
                }
                if ((pdVectorArray = pgJvxSrc.getBounds()) != null && pdVectorArray.length == 2) {
                    PsXmlNode psXmlNode8 = psXmlNode7.addChild("bndbox");
                    if (pgJvxSrc.isShowingBndBox()) {
                        psXmlNode8.addAttribute("visible", "show");
                    } else {
                        psXmlNode8.addAttribute("visible", "hide");
                    }
                    psXmlNode8.addChild("p", PuData.toString(pdVectorArray[0].getEntries()));
                    psXmlNode8.addChild("p", PuData.toString(pdVectorArray[1].getEntries()));
                }
                if ((serializable2 = pgJvxSrc.getCenter()) != null) {
                    psXmlNode6 = psXmlNode7.addChild("center");
                    if (pgJvxSrc.isShowingCenter()) {
                        psXmlNode6.addAttribute("visible", "show");
                    } else {
                        psXmlNode6.addAttribute("visible", "hide");
                    }
                    psXmlNode6.addChild("p", PuData.toString(((PdVector)serializable2).getEntries()));
                }
                if (pgJvxSrc.isShowingTitle()) {
                    psXmlNode7.addChild(PgJvxLoader.fillLabelAttr(pgJvxSrc.isShowingTitle()));
                }
                ++n;
            }
        }
        return psXmlSrc;
    }

    protected static String fillVisibility(boolean bl) {
        if (bl) {
            return "show";
        }
        return "hide";
    }
}

