/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.loader.PgLoaderIf;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgObjLoader
implements PgLoaderIf {
    protected int m_numVertices = 0;
    protected int m_numVertexNormals = 0;
    protected int m_numVertexTextures = 0;
    protected int m_numVertexVectors = 0;
    protected int m_numPolygons = 0;
    protected int m_numElements = 0;
    protected int m_numMeshType = 0;
    protected Vector m_vVertex;
    protected Vector m_vVertexColor;
    protected PiVector m_vVertexColorInd;
    protected Vector m_vVertexNormal;
    protected Vector m_vVertexTexture;
    protected Vector m_vVertexVector;
    protected int[] m_meshType;
    protected int m_dimOfElements = -1;
    protected Vector m_vElement;
    protected Vector m_vElementColor;
    protected PiVector m_vElementColorInd;
    protected Vector m_vElementNormal;
    protected int m_dimOfPolygons = -1;
    protected Vector m_vPolygon;
    protected Vector m_vPolygonColor;
    protected PiVector m_vPolygonColorInd;
    protected boolean m_bIsAnimation = false;
    private static final String StrNL = "\n";
    protected static boolean m_bVertexNormals = false;
    protected static boolean m_bVertexTextures = false;
    protected static boolean m_bVertexVector = false;
    protected static boolean m_bElements = false;
    protected static boolean m_bPolygons = false;
    protected static boolean m_bPolygonColors = false;
    protected static boolean m_bPolygonNormals = false;

    protected static String writePolygons(int n, PiVector[] piVectorArray) {
        if (n <= 0 || piVectorArray == null || n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# Polygon List\n");
        stringBuffer.append("# Number of Polygons = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("l  ");
            if (piVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                int n4 = piVectorArray[n2].m_data[n3] + 1;
                stringBuffer.append(n4);
                if (m_bPolygonNormals) {
                    stringBuffer.append("/" + n4);
                }
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean parse(BufferedReader var1_1) throws IOException {
        block64: {
            block63: {
                var2_2 = 3;
                var3_3 = 200;
                var4_4 = 4;
                var5_5 = 5;
                var6_6 = new float[var2_2];
                var7_7 = new double[var4_4];
                var8_8 = new double[var4_4];
                var9_9 = new double[var4_4];
                var10_10 = new double[var4_4];
                var11_11 = new int[var3_3];
                var12_12 = new int[var3_3];
                var13_13 = new int[var3_3];
                var14_14 = new int[var3_3];
                this.m_vVertex = new Vector<E>();
                this.m_vVertexColor = new Vector<E>();
                this.m_vVertexColorInd = new PiVector();
                this.m_vVertexNormal = new Vector<E>();
                this.m_vVertexTexture = new Vector<E>();
                this.m_vVertexVector = new Vector<E>();
                this.m_vElement = new Vector<E>();
                this.m_vElementColor = new Vector<E>();
                this.m_vElementColorInd = new PiVector();
                this.m_vElementNormal = new Vector<E>();
                this.m_vPolygon = new Vector<E>();
                this.m_vPolygonColor = new Vector<E>();
                this.m_vPolygonColorInd = new PiVector();
                var15_15 = new StreamTokenizer(var1_1);
                var15_15.eolIsSignificant(true);
                var15_15.ordinaryChars(47, 47);
                var15_15.commentChar(35);
                var15_15.commentChar(36);
                this.m_numVertices = 0;
                this.m_numVertexNormals = 0;
                this.m_numVertexTextures = 0;
                this.m_numElements = 0;
                try {
                    block7: while (true) {
                        cfr_temp_0 = 0;
                        block8: do {
                            switch (cfr_temp_0 == 0 ? var15_15.nextToken() : cfr_temp_0) {
                                default: {
                                    PsDebug.warning("parsing broke abnormally in line=" + var15_15.lineno() + " reading st.sval=" + var15_15.sval + ", st.ttype=" + var15_15.ttype);
                                    return false;
                                }
                                case -3: {
                                    if (!"mt".equals(var15_15.sval)) ** GOTO lbl53
                                    this.m_numMeshType = 0;
                                    this.m_meshType = new int[var5_5];
                                    while (var15_15.nextToken() == -2) {
                                        this.m_meshType[this.m_numMeshType] = (int)var15_15.nval;
                                        ++this.m_numMeshType;
                                    }
                                    ** GOTO lbl158
lbl53:
                                    // 1 sources

                                    if (!"v".equals(var15_15.sval)) ** GOTO lbl68
                                    var16_16 = 0;
                                    while (var15_15.nextToken() == -2) {
                                        var15_15.pushBack();
                                        var7_7[var16_16] = PgLoader.parseDouble(var15_15);
                                        ++var16_16;
                                    }
                                    if (var16_16 > 0) {
                                        ++this.m_numVertices;
                                        var17_17 = new PdVector(var16_16);
                                        var17_17.copy(var7_7, var16_16);
                                        this.m_vVertex.addElement(var17_17);
                                    } else {
                                        PsDebug.warning("vertex with no coords in line=" + var15_15.lineno());
                                    }
                                    ** GOTO lbl158
lbl68:
                                    // 1 sources

                                    if (!"vc".equals(var15_15.sval)) ** GOTO lbl85
                                    var16_16 = 0;
                                    while (var15_15.nextToken() == -2) {
                                        var15_15.pushBack();
                                        var6_6[var16_16] = (float)PgLoader.parseDouble(var15_15);
                                        ++var16_16;
                                    }
                                    if (var16_16 == 3) {
                                        var17_17 = new Color(var6_6[0], var6_6[1], var6_6[2]);
                                        if (this.m_vVertexColorInd.getSize() <= this.m_vVertexColor.size() + 1) {
                                            this.m_vVertexColorInd.setSize(this.m_vVertexColor.size() + 1000);
                                        }
                                        this.m_vVertexColorInd.setEntry(this.m_vVertexColor.size(), this.m_numVertices);
                                        this.m_vVertexColor.addElement(var17_17);
                                    } else {
                                        PsDebug.warning("vertex color with wrong num coords in line=" + var15_15.lineno());
                                    }
                                    ** GOTO lbl158
lbl85:
                                    // 1 sources

                                    if (!"vn".equals(var15_15.sval)) ** GOTO lbl100
                                    var16_16 = 0;
                                    while (var15_15.nextToken() == -2) {
                                        var15_15.pushBack();
                                        var8_8[var16_16] = PgLoader.parseDouble(var15_15);
                                        ++var16_16;
                                    }
                                    if (var16_16 > 0) {
                                        ++this.m_numVertexNormals;
                                        var17_17 = new PdVector(var16_16);
                                        var17_17.copy(var8_8, var16_16);
                                        this.m_vVertexNormal.addElement(var17_17);
                                    } else {
                                        PsDebug.warning("vertex normal with no coords in line=" + var15_15.lineno());
                                    }
                                    ** GOTO lbl158
lbl100:
                                    // 1 sources

                                    if (!"vt".equals(var15_15.sval)) ** GOTO lbl114
                                    var16_16 = 0;
                                    while (var15_15.nextToken() == -2) {
                                        var15_15.pushBack();
                                        var9_9[var16_16++] = PgLoader.parseDouble(var15_15);
                                    }
                                    if (var16_16 > 0) {
                                        ++this.m_numVertexTextures;
                                        var17_17 = new PdVector(var16_16);
                                        var17_17.copy(var9_9, var16_16);
                                        this.m_vVertexTexture.addElement(var17_17);
                                    } else {
                                        PsDebug.warning("vertex texture with no coords in line=" + var15_15.lineno());
                                    }
                                    ** GOTO lbl158
lbl114:
                                    // 1 sources

                                    if (!"vd".equals(var15_15.sval)) ** GOTO lbl128
                                    var16_16 = 0;
                                    while (var15_15.nextToken() == -2) {
                                        var15_15.pushBack();
                                        var10_10[var16_16++] = PgLoader.parseDouble(var15_15);
                                    }
                                    if (var16_16 > 0) {
                                        ++this.m_numVertexVectors;
                                        var17_17 = new PdVector(var16_16);
                                        var17_17.copy(var10_10, var16_16);
                                        this.m_vVertexVector.addElement(var17_17);
                                    } else {
                                        PsDebug.warning("vertex user data with no values in line=" + var15_15.lineno());
                                    }
                                    ** GOTO lbl158
lbl128:
                                    // 1 sources

                                    if ("f".equals(var15_15.sval) || "fo".equals(var15_15.sval)) {
                                        if (var15_15.nextToken() == 92) {
                                            var15_15.nextToken();
                                        } else {
                                            var15_15.pushBack();
                                        }
                                        var16_16 = 0;
                                        break block63;
                                    }
                                    if ("l".equals(var15_15.sval) || "lo".equals(var15_15.sval)) {
                                        var16_16 = 0;
                                        break block64;
                                    }
                                    if (!"lc".equals(var15_15.sval)) ** GOTO lbl156
                                    var16_16 = 0;
                                    while (var15_15.nextToken() == -2) {
                                        var15_15.pushBack();
                                        var6_6[var16_16] = (float)PgLoader.parseDouble(var15_15);
                                        ++var16_16;
                                    }
                                    if (var16_16 == 3) {
                                        var17_17 = new Color(var6_6[0], var6_6[1], var6_6[2]);
                                        if (this.m_vPolygonColorInd.getSize() <= this.m_vPolygonColor.size() + 1) {
                                            this.m_vPolygonColorInd.setSize(this.m_vPolygonColor.size() + 1000);
                                        }
                                        this.m_vPolygonColorInd.setEntry(this.m_vPolygonColor.size(), this.m_numPolygons);
                                        this.m_vPolygonColor.addElement(var17_17);
                                    } else {
                                        PsDebug.warning("polygon color with wrong num coords in line=" + var15_15.lineno());
                                    }
                                    ** GOTO lbl158
lbl156:
                                    // 1 sources

                                    if ("g".equals(var15_15.sval)) {
                                        // empty if block
                                    }
lbl158:
                                    // 18 sources

                                    while (true) {
                                        cfr_temp_0 = 10;
                                        if (var15_15.ttype == 10) continue block8;
                                        if (var15_15.ttype == -1) continue block7;
                                        var15_15.nextToken();
                                        continue;
                                        break;
                                    }
                                }
                                case -1: {
                                    if (this.m_vVertexColorInd.getSize() > 0) {
                                        this.m_vVertexColorInd.setEntry(this.m_vVertexColor.size(), this.m_numVertices);
                                    }
                                    if (this.m_vElementColorInd.getSize() > 0) {
                                        this.m_vElementColorInd.setEntry(this.m_vElementColor.size(), this.m_numElements);
                                    }
                                    if (this.m_vPolygonColorInd.getSize() > 0) {
                                        this.m_vPolygonColorInd.setEntry(this.m_vPolygonColor.size(), this.m_numPolygons);
                                    }
                                    return true;
                                }
                                case 10: {
                                    break;
                                }
                            }
                            continue block7;
                        } while (true);
                    }
                }
                catch (Exception var17_18) {
                    PsDebug.warning("Exception thrown in line=" + var15_15.lineno() + ", Exception = " + var17_18);
                    return false;
                }
            }
            while (var15_15.nextToken() == -2) {
                block65: {
                    block67: {
                        var11_11[var16_16] = (int)var15_15.nval - 1;
                        var15_15.nextToken();
                        if (var15_15.ttype != 47) break block67;
                        if (var15_15.nextToken() == -2) {
                            var13_13[var16_16] = (int)var15_15.nval - 1;
                            var15_15.nextToken();
                            if (var15_15.ttype == 47) {
                                if (var15_15.nextToken() == -2) {
                                    var12_12[var16_16] = (int)var15_15.nval - 1;
                                    break block65;
                                } else {
                                    PsDebug.warning("parse error of face in line=" + var15_15.lineno());
                                    break;
                                }
                            }
                            var15_15.pushBack();
                            break block65;
                        } else {
                            if (var15_15.ttype == 47) {
                                if (var15_15.nextToken() == -2) {
                                    var12_12[var16_16] = (int)var15_15.nval - 1;
                                    break block65;
                                } else {
                                    PsDebug.warning("parse error of face in line=" + var15_15.lineno());
                                    break;
                                }
                            }
                            PsDebug.warning("parse error in face/ = " + this.m_numElements + "/" + var16_16);
                            break;
                        }
                    }
                    var15_15.pushBack();
                }
                ++var16_16;
            }
            if (var16_16 > 0) {
                ++this.m_numElements;
                var17_17 = new PiVector(var16_16);
                var17_17.copy(var11_11, var16_16);
                this.m_vElement.addElement(var17_17);
            } else {
                PsDebug.warning("face with no vertex in line=" + var15_15.lineno());
            }
            while (true) {
                if (var15_15.ttype == 10 || var15_15.ttype == -1) ** GOTO lbl158
                var15_15.nextToken();
            }
        }
        while (var15_15.nextToken() == -2) {
            block66: {
                block68: {
                    var14_14[var16_16] = (int)var15_15.nval - 1;
                    var15_15.nextToken();
                    if (var15_15.ttype != 47) break block68;
                    if (var15_15.nextToken() == -2) {
                        var13_13[var16_16] = (int)var15_15.nval - 1;
                        var15_15.nextToken();
                        if (var15_15.ttype == 47) {
                            if (var15_15.nextToken() == -2) {
                                var12_12[var16_16] = (int)var15_15.nval - 1;
                                break block66;
                            } else {
                                PsDebug.warning("parse error of polygon in line=" + var15_15.lineno());
                                break;
                            }
                        }
                        var15_15.pushBack();
                        break block66;
                    } else {
                        if (var15_15.ttype == 47) {
                            if (var15_15.nextToken() == -2) {
                                var12_12[var16_16] = (int)var15_15.nval - 1;
                                break block66;
                            } else {
                                PsDebug.warning("parse error of polygon in line=" + var15_15.lineno());
                                break;
                            }
                        }
                        PsDebug.warning("parse error in polygon/ = " + this.m_numPolygons + "/" + var16_16);
                        break;
                    }
                }
                var15_15.pushBack();
            }
            ++var16_16;
        }
        if (var16_16 > 0) {
            ++this.m_numPolygons;
            var17_17 = new PiVector(var16_16);
            var17_17.copy(var14_14, var16_16);
            this.m_vPolygon.addElement(var17_17);
        } else {
            PsDebug.warning("polygon with no vertex in line=" + var15_15.lineno());
        }
        while (true) {
            if (var15_15.ttype != 10 && var15_15.ttype != -1) ** break;
            ** continue;
            var15_15.nextToken();
        }
    }

    protected static String writePdVectors(String string, String string2, int n, PdVector[] pdVectorArray) {
        if (n <= 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# " + string + " List\n");
        stringBuffer.append("# Number of " + string + "s = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string2 + " ");
            if (pdVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < pdVectorArray[n2].m_data.length) {
                if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                    stringBuffer.append((float)pdVectorArray[n2].m_data[n3]);
                } else {
                    stringBuffer.append(0.0f);
                }
                if (n3 < pdVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        int n;
        Enumeration enumeration;
        int n2;
        Object object;
        PdVector[] pdVectorArray;
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        try {
            boolean bl = this.parse(bufferedReader);
            if (!bl) {
                PsDebug.warning("error during parsing of reader");
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("exception during parsing of reader");
            iOException.printStackTrace();
            return null;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        if (this.m_numMeshType > 0 && this.m_meshType[0] == 1) {
            switch (this.m_meshType[1]) {
                case 1: {
                    pgJvxSrc.setType(32);
                    break;
                }
                case 2: {
                    pgJvxSrc.setType(33);
                    break;
                }
                case 3: {
                    pgJvxSrc.setType(34);
                    break;
                }
                default: {
                    pgJvxSrc.setType(30);
                    break;
                }
            }
        } else if (this.m_numElements > 0) {
            pgJvxSrc.setType(33);
        } else if (this.m_numPolygons > 0) {
            pgJvxSrc.setType(32);
        } else {
            pgJvxSrc.setType(30);
        }
        if (this.m_numVertices > 0) {
            pdVectorArray = (PdVector[])this.m_vVertex.elementAt(0);
            pgJvxSrc.setDimOfVertices(pdVectorArray.getSize());
            pgJvxSrc.setNumVertices(this.m_numVertices);
            object = pgJvxSrc.getVertices();
            n2 = 0;
            enumeration = this.m_vVertex.elements();
            while (enumeration.hasMoreElements()) {
                ((PdVector)object[n2++]).copy((PdVector)enumeration.nextElement());
            }
        }
        if (this.m_numVertexNormals > 0) {
            if (this.m_numVertexNormals == this.m_numVertices) {
                pgJvxSrc.assureVertexNormals();
                pdVectorArray = pgJvxSrc.getVertexNormals();
                n2 = 0;
                object = this.m_vVertexNormal.elements();
                while (object.hasMoreElements()) {
                    pdVectorArray[n2++].copy((PdVector)object.nextElement());
                }
            } else {
                PsDebug.warning("0!=numVertexNormals=" + this.m_numVertexNormals + " != " + this.m_numVertices + "=numVertices");
            }
        }
        if (this.m_numVertexTextures > 0) {
            if (this.m_numVertexTextures == this.m_numVertices) {
                pgJvxSrc.assureVertexTextures();
                pdVectorArray = pgJvxSrc.getVertexTextures();
                n2 = 0;
                object = this.m_vVertexTexture.elements();
                while (object.hasMoreElements()) {
                    pdVectorArray[n2++].copy((PdVector)object.nextElement());
                }
            } else {
                PsDebug.warning("0!=numVertexTextures != numVertices");
            }
        }
        if (this.m_numVertexVectors > 0) {
            if (this.m_numVertexVectors % this.m_numVertices == 0) {
                int n3 = this.m_numVertexVectors / this.m_numVertices;
                pgJvxSrc.setNumVectorFields(n3);
                object = this.m_vVertexVector.elements();
                int n4 = 0;
                while (n4 < n3) {
                    PdVector pdVector = (PdVector)this.m_vVertexVector.elementAt(n4 * this.m_numVertices);
                    pgJvxSrc.setNumVectors(n4, this.m_numVertices, pdVector.getSize());
                    PdVector[] pdVectorArray2 = pgJvxSrc.getVectors(n4);
                    n2 = 0;
                    n = 0;
                    while (n < this.m_numVertices) {
                        pdVectorArray2[n2++] = (PdVector)object.nextElement();
                        ++n;
                    }
                    ++n4;
                }
            } else {
                PsDebug.warning("numVertexVectors%numVertices!=0");
            }
        }
        if (this.m_numElements > 0) {
            pgJvxSrc.setDimOfElements(this.m_dimOfElements);
            pgJvxSrc.setNumElements(this.m_numElements);
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            n2 = 0;
            object = this.m_vElement.elements();
            while (object.hasMoreElements()) {
                piVectorArray[n2++].copy((PiVector)object.nextElement());
            }
        }
        if (this.m_numPolygons > 0) {
            pgJvxSrc.setDimOfPolygons(this.m_dimOfPolygons);
            pgJvxSrc.setNumPolygons(this.m_numPolygons);
            PiVector[] piVectorArray = pgJvxSrc.getPolygons();
            n2 = 0;
            object = this.m_vPolygon.elements();
            while (object.hasMoreElements()) {
                piVectorArray[n2++].copy((PiVector)object.nextElement());
            }
        }
        if (this.m_vPolygonColor != null && this.m_vPolygonColor.size() > 0) {
            pgJvxSrc.assurePolygonColors();
            Color[] colorArray = pgJvxSrc.getPolygonColors();
            n2 = 0;
            object = (Color)this.m_vPolygonColor.firstElement();
            n = 0;
            while (n < this.m_vPolygonColorInd.getEntry(0)) {
                colorArray[n] = object;
                ++n;
            }
            enumeration = this.m_vPolygonColor.elements();
            while (enumeration.hasMoreElements()) {
                object = (Color)enumeration.nextElement();
                n = this.m_vPolygonColorInd.getEntry(n2);
                while (n < this.m_vPolygonColorInd.getEntry(n2 + 1)) {
                    colorArray[n] = object;
                    ++n;
                }
                ++n2;
            }
        }
        PgObjLoader.geomInitType(pgJvxSrc);
        return new PgJvxSrc[]{pgJvxSrc};
    }

    public PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PgObjLoader pgObjLoader = new PgObjLoader();
        PgJvxSrc[] pgJvxSrcArray = pgObjLoader.read(bufferedReader);
        if (pgJvxSrcArray != null && pgJvxSrcArray.length > 0 && pgJvxSrcArray[0] != null) {
            pgJvxSrcArray[0].setName(PsUtil.getFileBaseName(string));
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return pgJvxSrcArray;
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        String string;
        int n;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + StrNL);
        writer.write("#     File Format = Wavefront OBJ\n");
        writer.write("#     Geometry    = " + pgJvxSrc.getName() + StrNL);
        writer.write("#     Date        = " + new Date().toString() + "\n#\n");
        int n2 = pgJvxSrc.getNumVertices();
        writer.write("#     Number of Vertices = " + n2 + StrNL);
        int n3 = pgJvxSrc.getNumElements();
        if (n3 > 0) {
            writer.write("#     Number of Elements = " + n3 + StrNL);
        }
        if ((n = pgJvxSrc.getNumPolygons()) > 0) {
            writer.write("#     Number of Polygons = " + n + StrNL);
        }
        if (pgJvxSrc.getVertexNormals() != null) {
            writer.write("#     Additional: Vertex Normals\n");
        }
        if (pgJvxSrc.getVertexTextures() != null) {
            writer.write("#     Additional: Vertex Texture Coordinates\n");
        }
        writer.write("#\n# End of Header\n");
        writer.write(PgObjLoader.writePdVectors("Vertex", "v", n2, pgJvxSrc.getVertices()));
        m_bVertexNormals = false;
        if (pgJvxSrc.getVertexNormals() != null && (string = PgObjLoader.writePdVectors("Vertex Normal", "vn", n2, pgJvxSrc.getVertexNormals())) != null) {
            writer.write(string);
            m_bVertexNormals = true;
        }
        m_bVertexTextures = false;
        if (pgJvxSrc.getVertexTextures() != null && (string = PgObjLoader.writePdVectors("Vertex Texture", "vt", n2, pgJvxSrc.getVertexTextures())) != null) {
            writer.write(string);
            m_bVertexTextures = true;
        }
        m_bElements = false;
        if (pgJvxSrc.getElements() != null && (string = PgObjLoader.writeElements(n3, pgJvxSrc.getElements())) != null) {
            writer.write(string);
            m_bElements = true;
        }
        m_bPolygonNormals = false;
        if (pgJvxSrc.getPolygonNormals() != null && (string = PgObjLoader.writePdVectors("Polygon Normal", "ln", n, pgJvxSrc.getPolygonNormals())) != null) {
            writer.write(string);
            m_bPolygonNormals = true;
        }
        m_bPolygons = false;
        if (pgJvxSrc.getPolygons() != null && (string = PgObjLoader.writePolygons(n, pgJvxSrc.getPolygons())) != null) {
            writer.write(string);
            m_bPolygons = true;
        }
        return true;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    protected static String writeElements(int n, PiVector[] piVectorArray) {
        if (n <= 0 || piVectorArray == null || n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# Face List\n");
        stringBuffer.append("# Number of Faces = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("f  ");
            if (piVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                int n4 = piVectorArray[n2].m_data[n3] + 1;
                stringBuffer.append(n4);
                if (m_bVertexNormals) {
                    stringBuffer.append("/" + n4);
                    if (m_bVertexTextures) {
                        stringBuffer.append("/" + n4);
                    }
                } else if (!m_bVertexNormals && m_bVertexTextures) {
                    stringBuffer.append("//" + n4);
                }
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

