/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import jv.object.PsConfig;
import jv.object.PsConsole;

public final class PsDebug {
    public static final boolean NOTIFY = false;
    public static final boolean WARNING = true;
    protected static PsConsole m_console;
    protected static Rectangle m_consoleSize;
    protected static boolean m_bMessage;
    protected static boolean m_bNotify;
    protected static boolean m_bWarning;
    protected static boolean m_bError;
    protected static final boolean m_bTrace = false;
    private static long m_lastCall;
    private static StringBuffer m_messageBuffer;
    private static long m_flushInterval;
    private static transient Thread m_thread;
    private static final int MSG_MESSAGE = 1;
    private static final int MSG_NOTIFY = 2;
    private static final int MSG_WARNING = 3;
    private static final int MSG_ERROR = 4;
    private static int m_numBeeps;
    private static int m_maxNumBeeps;

    public static final synchronized void error(String string) {
        if (!m_bError) {
            return;
        }
        PsDebug.error(PsConfig.getMessage("Error") + ": " + string + "\n\t" + PsDebug.getMethodName(null, 4), null);
    }

    public static final synchronized void error(String string, Object object) {
        if (!m_bError) {
            return;
        }
        if (string == null) {
            return;
        }
        if (object != null) {
            string = PsConfig.getMessage("Error") + ": " + string + "\n\t" + PsDebug.getMethodName(null, 4);
        }
        PsDebug.beep(string);
        PsDebug.append(string);
        if (object != null) {
            PsDebug.append("\n\tObject = " + object.toString());
        }
    }

    public static final synchronized void message(String string) {
        PsDebug.message(string, true);
    }

    public static final synchronized void message(String string, boolean bl) {
        if (!m_bMessage) {
            return;
        }
        if (string == null) {
            return;
        }
        if (!PsDebug.hasConsole()) {
            if (PsDebug.getConsole() == null) {
                System.out.println("PsDebug.error: " + PsConfig.getMessage("couldNotCreateJavaViewConsole"));
                System.out.println("\t" + PsConfig.getMessage("ErrorMessage") + ": " + string);
                new Throwable().printStackTrace();
                return;
            }
            ((Component)m_console).setBounds(m_consoleSize);
        }
        if (bl && !m_console.isShowing()) {
            ((Component)m_console).setVisible(true);
        }
        PsDebug.append(string);
    }

    public static final synchronized void warning(String string) {
        if (!m_bWarning) {
            return;
        }
        PsDebug.warning(PsConfig.getMessage("Warning") + ": " + string + "\n\t" + PsDebug.getMethodName(null, 3), null);
    }

    public static final synchronized void warning(Exception exception, String string) {
        if (!m_bWarning) {
            return;
        }
        PsDebug.warning(PsConfig.getMessage("Warning") + ": " + string + "\n\t" + PsDebug.getMethodName(exception, 3), null);
    }

    public static final synchronized void warning(String string, Object object) {
        if (!m_bWarning) {
            return;
        }
        if (string == null) {
            return;
        }
        if (object != null) {
            string = PsConfig.getMessage("Warning") + ": " + string + "\n\t" + PsDebug.getMethodName(null, 3);
        }
        PsDebug.beep(string);
        PsDebug.append(string);
        if (object != null) {
            PsDebug.append("\n\tObject = " + object.toString());
        }
    }

    public static boolean isError() {
        return m_bError;
    }

    public static synchronized void setWarning(boolean bl) {
        m_bWarning = bl;
        if (PsDebug.hasConsole()) {
            PsDebug.getConsole().update();
        }
    }

    public static PsConsole getConsole() {
        if (m_console == null && PsConfig.getFrame() != null) {
            m_console = new PsConsole(PsConfig.getFrame());
            m_lastCall = new Date().getTime();
            PsDebug.flushMessages();
        }
        return m_console;
    }

    public static void setConsole(PsConsole psConsole) {
        m_console = psConsole;
    }

    public static void setMessage(boolean bl) {
        m_bMessage = bl;
    }

    public static boolean isMessage() {
        return m_bMessage;
    }

    public static void beep(String string) {
        if (m_numBeeps++ >= m_maxNumBeeps) {
            return;
        }
        System.out.println(string);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit != null) {
            toolkit.beep();
        }
    }

    public static boolean isWarning() {
        return m_bWarning;
    }

    public static int getMaxNumBeeps() {
        return m_maxNumBeeps;
    }

    public static synchronized void setNotify(boolean bl) {
        m_bNotify = bl;
        if (PsDebug.hasConsole()) {
            PsDebug.getConsole().update();
        }
    }

    public static void setMaxNumBeeps(int n) {
        m_maxNumBeeps = n;
    }

    static {
        m_consoleSize = new Rectangle(10, 10, 500, 350);
        m_bMessage = true;
        m_bNotify = false;
        m_bWarning = true;
        m_bError = true;
        m_messageBuffer = null;
        m_flushInterval = 500L;
        m_thread = null;
        m_numBeeps = 0;
        m_maxNumBeeps = 10;
    }

    public static boolean hasConsole() {
        return m_console != null;
    }

    public static boolean hasMessages() {
        return m_messageBuffer != null;
    }

    public static Rectangle getConsoleSize() {
        return m_consoleSize;
    }

    public static final synchronized void flushMessages() {
        m_thread = null;
        if (m_messageBuffer == null) {
            return;
        }
        long l = new Date().getTime();
        if (PsDebug.hasConsole()) {
            m_console.append(m_messageBuffer);
            m_messageBuffer = null;
            m_lastCall = l;
        }
    }

    public static final synchronized void showStatus(String string) {
        Applet applet;
        if (string == null) {
            return;
        }
        if (!PsConfig.isApplication() && (applet = PsConfig.getApplet()) != null && applet.getAppletContext() != null) {
            applet.showStatus(string);
        }
    }

    protected static final synchronized void append(String string) {
        if (m_messageBuffer == null) {
            m_messageBuffer = new StringBuffer();
        }
        m_messageBuffer.append(string + "\n");
        if (PsDebug.hasConsole() && m_thread == null) {
            m_thread = new Thread((Runnable)m_console, "JavaView: Console Flusher");
            m_thread.start();
        }
    }

    public static boolean isNotify() {
        return m_bNotify;
    }

    public static synchronized void setError(boolean bl) {
        m_bError = bl;
        if (PsDebug.hasConsole()) {
            PsDebug.getConsole().update();
        }
    }

    public static long getFlushInterval() {
        return m_flushInterval;
    }

    public static final synchronized void notify(String string) {
        if (!m_bNotify) {
            return;
        }
        if (string == null) {
            return;
        }
        PsDebug.append(PsConfig.getMessage("Notify") + ": " + string + "\n\t" + PsDebug.getMethodName(null, 2));
    }

    public static synchronized void disposeConsole() {
        if (m_console != null) {
            m_console.stop();
            m_console.dispose();
            m_console = null;
            m_thread = null;
            m_messageBuffer = null;
        }
        m_bMessage = true;
        m_bNotify = false;
        m_bWarning = true;
        m_bError = true;
    }

    private static final String getMethodName(Exception exception, int n) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (exception != null) {
            exception.printStackTrace(printWriter);
        } else {
            new Throwable().printStackTrace(printWriter);
        }
        String string = stringWriter.toString();
        if (string == null) {
            return "";
        }
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = string.indexOf("PsDebug.message");
                break;
            }
            case 2: {
                n2 = string.indexOf("PsDebug.notify");
                break;
            }
            case 3: {
                n2 = string.indexOf("PsDebug.warning");
                break;
            }
            case 4: {
                n2 = string.indexOf("PsDebug.error");
            }
        }
        if (n2 == -1) {
            return string;
        }
        int n3 = string.indexOf("at ", n2);
        if (n3 == -1) {
            return "";
        }
        int n4 = string.indexOf(")", n3);
        if (n4 == -1) {
            return "";
        }
        return string.substring(n3, n4 + 1);
    }
}

