/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import jv.object.PsConfig;
import jv.object.PsDebug;

public class PsUtil {
    private static /* synthetic */ Class class$java$lang$Object;

    public static String getFileBaseName(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        String string2 = PsUtil.getFileName(string);
        if (string2 == null) {
            return null;
        }
        if (string2.endsWith("zip") || string2.endsWith("gz")) {
            string2 = string2.substring(0, string2.lastIndexOf(46));
        }
        return string2.substring(0, string2.lastIndexOf(46));
    }

    public static String getFileExtension(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        String string2 = PsUtil.getFileName(string);
        String string3 = "";
        if (string2.endsWith("zip")) {
            string2 = string2.substring(0, string2.lastIndexOf(46));
            string3 = ".zip";
        } else if (string2.endsWith("gz")) {
            string2 = string2.substring(0, string2.lastIndexOf(46));
            string3 = ".gz";
        }
        String string4 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
        return string4 + string3;
    }

    public static BufferedReader open(String string) {
        BufferedReader bufferedReader;
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        if (PsConfig.isApplication()) {
            bufferedReader = string.startsWith("http:") || string.startsWith("ftp:") || string.startsWith("file:") ? PsUtil.openURL(string) : PsUtil.openFile(string);
        } else if (string.startsWith("http:") || string.startsWith("ftp:") || string.startsWith("file:")) {
            bufferedReader = PsUtil.openURL(string);
        } else {
            bufferedReader = PsUtil.openFile(string);
            if (bufferedReader == null) {
                PsDebug.warning("relative url encountered, try with codebase.");
                bufferedReader = PsUtil.openURL(PsConfig.getCodeBase() + string);
            }
        }
        return bufferedReader;
    }

    public static PrintWriter writeFile(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            return printWriter;
        }
        catch (IOException iOException) {
            PsDebug.warning("file " + fileWriter + " not found, IOException" + "\n\texception.getMessage() = " + iOException.getMessage() + "\n\texception.toString()   = " + iOException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("exception.getMessage() = " + securityException.getMessage() + "\n\texception.toString()   = " + securityException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
    }

    public static boolean hasSomeBits(int n, int n2) {
        return (n & n2) > 0;
    }

    public static Object newInstance(Class clazz, String string) {
        if (clazz == null || string == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        Class clazz2 = clazz;
        String string2 = null;
        Object object = null;
        try {
            do {
                if ((object = PsUtil.newInstance(string2 = clazz2.getName() + string)) == null) continue;
                return object;
            } while ((clazz2 = clazz2.getSuperclass()) != null && clazz2 != (class$java$lang$Object != null ? class$java$lang$Object : PsUtil.class$("java.lang.Object")));
            PsDebug.warning("Class not found: " + clazz.getName() + string);
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("failed with security exception, className = " + string2 + "\n\t SecurityExceptionEx = " + securityException.toString() + ", Message = " + securityException.getMessage());
            return null;
        }
    }

    public static Object newInstance(String string) {
        if (string == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            PsDebug.error("failed to create instance, className = " + string + "\n\tNoSuchMethodError = " + noSuchMethodError.toString() + ", Message = " + noSuchMethodError.getMessage());
            return null;
        }
        catch (InstantiationException instantiationException) {
            PsDebug.warning("failed to create instance, className = " + string + "\n\tInstantiationException = " + instantiationException.toString() + ", Message = " + instantiationException.getMessage());
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            PsDebug.warning("failed with access exception, className = " + string + "\n\tIllegalAccessException = " + illegalAccessException.toString() + ", Message = " + illegalAccessException.getMessage());
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("failed with security exception, className = " + string + "\n\tSecurityExceptionEx = " + securityException.toString() + ", Message = " + securityException.getMessage());
            return null;
        }
    }

    public static int clearBits(int n, int n2) {
        return n &= ~n2;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static BufferedReader openURL(String string) {
        if (string == null) {
            PsDebug.warning("missing url");
            return null;
        }
        try {
            Closeable closeable;
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            if (string.endsWith("gz")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (string.endsWith("zip")) {
                closeable = new ZipInputStream(inputStream);
                closeable.getNextEntry();
                inputStream = closeable;
            }
            closeable = new BufferedReader(new InputStreamReader(inputStream));
            return closeable;
        }
        catch (MalformedURLException malformedURLException) {
            PsDebug.warning("file " + string + " not found, MalformedURLFoundException" + "\n\texception.getMessage() = " + malformedURLException.getMessage() + "\n\texception.toString()   = " + malformedURLException.toString());
            PsDebug.error("... failed, URL = ", string);
            return null;
        }
        catch (IOException iOException) {
            PsDebug.warning("file " + string + " not found, IOException" + "\n\texception.getMessage() = " + iOException.getMessage() + "\n\texception.toString()   = " + iOException.toString());
            PsDebug.error("... failed, URL = ", string);
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("file " + string + " not found, SecurityException" + "\n\texception.getMessage() = " + securityException.getMessage() + "\n\texception.toString()   = " + securityException.toString());
            PsDebug.error("... failed, URL = ", string);
            return null;
        }
    }

    public static boolean hasAllBits(int n, int n2) {
        return (n & n2) == n2;
    }

    public static int setBits(int n, int n2) {
        return n |= n2;
    }

    public static boolean hasBits(int n, int n2) {
        return (n & n2) == n2;
    }

    public static String getFilePath(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        if (string.indexOf(92) > -1) {
            return string.substring(0, string.lastIndexOf(92) + 1);
        }
        return string.substring(0, string.lastIndexOf(47) + 1);
    }

    public static BufferedReader openFile(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        File file = null;
        try {
            Closeable closeable;
            file = new File(string);
            Closeable closeable2 = new FileInputStream(file);
            if (string.endsWith("gz")) {
                closeable2 = new GZIPInputStream((InputStream)closeable2);
            } else if (string.endsWith("zip")) {
                closeable = new ZipInputStream((InputStream)closeable2);
                closeable.getNextEntry();
                closeable2 = closeable;
            }
            closeable = new BufferedReader(new InputStreamReader((InputStream)closeable2));
            return closeable;
        }
        catch (FileNotFoundException fileNotFoundException) {
            PsDebug.warning("file " + file + " not found, FileNotFoundException" + "\n\texception.getMessage() = " + fileNotFoundException.getMessage() + "\n\texception.toString()   = " + fileNotFoundException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
        catch (IOException iOException) {
            PsDebug.warning("file " + file + " not found, FileNotFoundException" + "\n\texception.getMessage() = " + iOException.getMessage() + "\n\texception.toString()   = " + iOException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
        catch (SecurityException securityException) {
            PsDebug.warning("exception.getMessage() = " + securityException.getMessage() + "\n\texception.toString()   = " + securityException.toString());
            PsDebug.error("... failed, file = ", string);
            return null;
        }
    }

    public static String getFileName(String string) {
        if (string == null) {
            PsDebug.warning("missing filename");
            return null;
        }
        if (string.indexOf(92) > -1) {
            return string.substring(string.lastIndexOf(92) + 1, string.length());
        }
        return string.substring(string.lastIndexOf(47) + 1, string.length());
    }
}

