/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PvCameraEvent;
import jv.project.PvCameraListenerIf;
import jv.thirdParty.ruler.PgAxes;
import jv.vecmath.PdVector;
import jv.viewer.PvScene;

public final class PjAxes
extends PsObject
implements PvCameraListenerIf {
    protected PdVector m_viewVect;
    protected PgAxes m_axes;
    protected PgGeometry m_geom;
    protected PvScene m_scene;

    public PjAxes(int n) {
        this.setName("Variable Axes");
        this.m_axes = new PgAxes(n);
        this.m_viewVect = new PdVector(0.0, 0.0, -1.0);
        this.init();
    }

    public void dragCamera(PvCameraEvent pvCameraEvent) {
        this.pickCamera(pvCameraEvent);
    }

    public boolean update(Object object) {
        if (object == null) {
            return true;
        }
        if (object == this.m_geom) {
            this.m_axes.configure(this.m_geom.getBounds(), this.m_viewVect);
            return this.m_axes.update(this.m_axes);
        }
        if (object == this.m_scene) {
            this.m_axes.configure(this.m_scene.getBounds(), this.m_viewVect);
            return this.m_axes.update(this.m_axes);
        }
        if (object == this.m_axes) {
            return super.update(null);
        }
        return super.update(object);
    }

    public void setScene(PvScene pvScene) {
        this.m_scene = pvScene;
        this.m_scene.addUpdateListener(this);
    }

    public void pickCamera(PvCameraEvent pvCameraEvent) {
        this.m_viewVect.copy(pvCameraEvent.getViewDir());
        if (this.m_geom != null) {
            this.m_axes.configure(this.m_geom.getBounds(), this.m_viewVect);
        } else if (this.m_scene != null) {
            this.m_axes.configure(this.m_scene.getBounds(), this.m_viewVect);
        } else {
            return;
        }
        this.m_axes.update(this.m_axes);
    }

    public void setGeometry(PgGeometry pgGeometry) {
        this.m_geom = pgGeometry;
        this.m_geom.addUpdateListener(this);
    }

    public PgAxes getAxes() {
        return this.m_axes;
    }

    public void init() {
        super.init();
        this.m_axes.init();
        this.m_axes.showTitles(true);
        this.m_axes.setMode(2);
    }

    public void removeScene(PvScene pvScene) {
        if (this.m_scene != pvScene) {
            PsDebug.warning("scene was not registered.");
            return;
        }
        pvScene.removeUpdateListener(this);
        this.m_scene = null;
    }

    public void removeGeometry(PgGeometry pgGeometry) {
        if (this.m_geom != pgGeometry) {
            PsDebug.warning("geometry was not registered.");
            return;
        }
        pgGeometry.removeUpdateListener(this);
        this.m_geom = null;
    }
}

