/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class PuReflect {
    public static PdMatrix planeReflect(PdVector pdVector, PdVector pdVector2) {
        PdVector pdVector3 = new PdVector(3);
        pdVector3.m_data[0] = pdVector2.m_data[0];
        pdVector3.m_data[1] = pdVector2.m_data[1];
        pdVector3.m_data[2] = pdVector2.m_data[2];
        if (!pdVector3.normalize()) {
            return null;
        }
        double d = pdVector3.m_data[0];
        double d2 = pdVector3.m_data[1];
        double d3 = pdVector3.m_data[2];
        double d4 = PdVector.dot(pdVector, pdVector3);
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdMatrix.m_data[0][0] = 1.0 - 2.0 * d * d;
        pdMatrix.m_data[0][1] = -2.0 * d * d2;
        pdMatrix.m_data[0][2] = -2.0 * d * d3;
        pdMatrix.m_data[0][3] = 2.0 * d * d4;
        pdMatrix.m_data[1][0] = -2.0 * d * d2;
        pdMatrix.m_data[1][1] = 1.0 - 2.0 * d2 * d2;
        pdMatrix.m_data[1][2] = -2.0 * d2 * d3;
        pdMatrix.m_data[1][3] = 2.0 * d2 * d4;
        pdMatrix.m_data[2][0] = -2.0 * d * d3;
        pdMatrix.m_data[2][1] = -2.0 * d2 * d3;
        pdMatrix.m_data[2][2] = 1.0 - 2.0 * d3 * d3;
        pdMatrix.m_data[2][3] = 2.0 * d3 * d4;
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix pointReflect(PdVector pdVector) {
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdMatrix.m_data[0][0] = -1.0;
        pdMatrix.m_data[0][1] = 0.0;
        pdMatrix.m_data[0][2] = 0.0;
        pdMatrix.m_data[0][3] = 2.0 * pdVector.m_data[0];
        pdMatrix.m_data[1][0] = 0.0;
        pdMatrix.m_data[1][1] = -1.0;
        pdMatrix.m_data[1][2] = 0.0;
        pdMatrix.m_data[1][3] = 2.0 * pdVector.m_data[1];
        pdMatrix.m_data[2][0] = 0.0;
        pdMatrix.m_data[2][1] = 0.0;
        pdMatrix.m_data[2][2] = -1.0;
        pdMatrix.m_data[2][3] = 2.0 * pdVector.m_data[2];
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix rotateLine(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector.getSize() < 3) {
            PsDebug.warning("argument base missing or dimension too small");
            return null;
        }
        if (pdVector2 == null || pdVector2.getSize() < 3) {
            PsDebug.warning("argument axis missing or dimension too small");
            return null;
        }
        double d = pdVector.m_data[0];
        double d2 = pdVector.m_data[1];
        double d3 = pdVector.m_data[2];
        PdVector pdVector3 = pdVector2;
        double d4 = pdVector3.m_data[0];
        double d5 = pdVector3.m_data[1];
        double d6 = pdVector3.m_data[2];
        double d7 = pdVector3.sqrLength();
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdMatrix.m_data[0][0] = 2.0 * d4 * d4 / d7;
        pdMatrix.m_data[0][1] = 2.0 * d5 * d4 / d7;
        pdMatrix.m_data[0][2] = 2.0 * d6 * d4 / d7;
        pdMatrix.m_data[0][3] = 2.0 * d - pdMatrix.m_data[0][0] * d - pdMatrix.m_data[0][1] * d2 - pdMatrix.m_data[0][2] * d3;
        pdMatrix.m_data[1][0] = pdMatrix.m_data[0][1];
        pdMatrix.m_data[1][1] = 2.0 * d5 * d5 / d7;
        pdMatrix.m_data[1][2] = 2.0 * d6 * d5 / d7;
        pdMatrix.m_data[1][3] = 2.0 * d2 - pdMatrix.m_data[1][0] * d - pdMatrix.m_data[1][1] * d2 - pdMatrix.m_data[1][2] * d3;
        pdMatrix.m_data[2][0] = pdMatrix.m_data[0][2];
        pdMatrix.m_data[2][1] = pdMatrix.m_data[1][2];
        pdMatrix.m_data[2][2] = 2.0 * d6 * d6 / d7;
        pdMatrix.m_data[2][3] = 2.0 * d3 - pdMatrix.m_data[2][0] * d - pdMatrix.m_data[2][1] * d2 - pdMatrix.m_data[2][2] * d3;
        double[] dArray = pdMatrix.m_data[0];
        dArray[0] = dArray[0] - 1.0;
        double[] dArray2 = pdMatrix.m_data[1];
        dArray2[1] = dArray2[1] - 1.0;
        double[] dArray3 = pdMatrix.m_data[2];
        dArray3[2] = dArray3[2] - 1.0;
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix rotateLine(PdVector pdVector, PdVector pdVector2, double d) {
        if (pdVector == null || pdVector.getSize() < 3) {
            PsDebug.warning("argument base missing or dimension too small");
            return null;
        }
        if (pdVector2 == null || pdVector2.getSize() < 3) {
            PsDebug.warning("argument axis missing or dimension too small");
            return null;
        }
        PdVector pdVector3 = new PdVector(3);
        pdVector3.m_data[0] = pdVector2.m_data[0];
        pdVector3.m_data[1] = pdVector2.m_data[1];
        pdVector3.m_data[2] = pdVector2.m_data[2];
        if (!pdVector3.normalize()) {
            return null;
        }
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdMatrix.m_data[0][0] = d2 + (1.0 - d2) * pdVector3.m_data[0] * pdVector3.m_data[0];
        pdMatrix.m_data[0][1] = -d3 * pdVector3.m_data[2] + (1.0 - d2) * pdVector3.m_data[0] * pdVector3.m_data[1];
        pdMatrix.m_data[0][2] = d3 * pdVector3.m_data[1] + (1.0 - d2) * pdVector3.m_data[0] * pdVector3.m_data[2];
        pdMatrix.m_data[0][3] = pdVector.m_data[0] - pdMatrix.m_data[0][0] * pdVector.m_data[0] - pdMatrix.m_data[0][1] * pdVector.m_data[1] - pdMatrix.m_data[0][2] * pdVector.m_data[2];
        pdMatrix.m_data[1][0] = d3 * pdVector3.m_data[2] + (1.0 - d2) * pdVector3.m_data[0] * pdVector3.m_data[1];
        pdMatrix.m_data[1][1] = d2 + (1.0 - d2) * pdVector3.m_data[1] * pdVector3.m_data[1];
        pdMatrix.m_data[1][2] = -d3 * pdVector3.m_data[0] + (1.0 - d2) * pdVector3.m_data[1] * pdVector3.m_data[2];
        pdMatrix.m_data[1][3] = pdVector.m_data[1] - pdMatrix.m_data[1][0] * pdVector.m_data[0] - pdMatrix.m_data[1][1] * pdVector.m_data[1] - pdMatrix.m_data[1][2] * pdVector.m_data[2];
        pdMatrix.m_data[2][0] = -d3 * pdVector3.m_data[1] + (1.0 - d2) * pdVector3.m_data[0] * pdVector3.m_data[2];
        pdMatrix.m_data[2][1] = d3 * pdVector3.m_data[0] + (1.0 - d2) * pdVector3.m_data[1] * pdVector3.m_data[2];
        pdMatrix.m_data[2][2] = d2 + (1.0 - d2) * pdVector3.m_data[2] * pdVector3.m_data[2];
        pdMatrix.m_data[2][3] = pdVector.m_data[2] - pdMatrix.m_data[2][0] * pdVector.m_data[0] - pdMatrix.m_data[2][1] * pdVector.m_data[1] - pdMatrix.m_data[2][2] * pdVector.m_data[2];
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix translate(PdVector pdVector) {
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdMatrix.setIdentity();
        pdMatrix.m_data[0][3] = pdVector.m_data[0];
        pdMatrix.m_data[1][3] = pdVector.m_data[1];
        pdMatrix.m_data[2][3] = pdVector.m_data[2];
        return pdMatrix;
    }

    public static boolean makeRotation(PdMatrix pdMatrix, PdVector pdVector, double d) {
        if (pdMatrix == null) {
            PsDebug.warning("missing matrix argument");
            return false;
        }
        if (pdVector == null || pdVector.getSize() < 3) {
            PsDebug.warning("argument axis missing or dimension too small");
            return false;
        }
        PdVector pdVector2 = new PdVector(3);
        pdVector2.m_data[0] = pdVector.m_data[0];
        pdVector2.m_data[1] = pdVector.m_data[1];
        pdVector2.m_data[2] = pdVector.m_data[2];
        if (!pdVector2.normalize()) {
            return false;
        }
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = 1.0 - d2;
        double d5 = pdVector2.m_data[0];
        double d6 = pdVector2.m_data[1];
        double d7 = pdVector2.m_data[2];
        pdMatrix.m_data[0][0] = d2 + d4 * d5 * d5;
        pdMatrix.m_data[0][1] = -d7 * d3 + d4 * d5 * d6;
        pdMatrix.m_data[0][2] = d6 * d3 + d4 * d5 * d7;
        pdMatrix.m_data[1][0] = d7 * d3 + d4 * d5 * d6;
        pdMatrix.m_data[1][1] = d2 + d4 * d6 * d6;
        pdMatrix.m_data[1][2] = -d5 * d3 + d4 * d6 * d7;
        pdMatrix.m_data[2][0] = -d6 * d3 + d4 * d5 * d7;
        pdMatrix.m_data[2][1] = d5 * d3 + d4 * d6 * d7;
        pdMatrix.m_data[2][2] = d2 + d4 * d7 * d7;
        return true;
    }

    public static PdMatrix scale(PdVector pdVector) {
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdMatrix.setIdentity();
        pdMatrix.setDiagonal(pdVector);
        return pdMatrix;
    }

    public static PdMatrix planeReflect(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        PdVector pdVector4 = new PdVector(3);
        pdVector4.normalOfPlane(pdVector, pdVector2, pdVector3);
        double d = pdVector4.m_data[0];
        double d2 = pdVector4.m_data[1];
        double d3 = pdVector4.m_data[2];
        double d4 = PdVector.dot(pdVector, pdVector4);
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdMatrix.m_data[0][0] = 1.0 - 2.0 * d * d;
        pdMatrix.m_data[0][1] = -2.0 * d * d2;
        pdMatrix.m_data[0][2] = -2.0 * d * d3;
        pdMatrix.m_data[0][3] = 2.0 * d * d4;
        pdMatrix.m_data[1][0] = -2.0 * d * d2;
        pdMatrix.m_data[1][1] = 1.0 - 2.0 * d2 * d2;
        pdMatrix.m_data[1][2] = -2.0 * d2 * d3;
        pdMatrix.m_data[1][3] = 2.0 * d2 * d4;
        pdMatrix.m_data[2][0] = -2.0 * d * d3;
        pdMatrix.m_data[2][1] = -2.0 * d2 * d3;
        pdMatrix.m_data[2][2] = 1.0 - 2.0 * d3 * d3;
        pdMatrix.m_data[2][3] = 2.0 * d3 * d4;
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }
}

