/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jv.number.PdColor;
import jv.number.PuInteger;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvCameraEvent;
import jv.project.PvCameraIf;
import jv.project.PvCameraListenerIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.project.PvViewerIf;
import jv.thirdParty.ruler.PgAxes;
import jv.thirdParty.ruler.PjAxes;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jv.viewer.PsAboutDialog;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay_IP;
import jv.viewer.PvGeometry;
import jv.viewer.PvGrid;
import jv.viewer.PvModelCamera;
import jv.viewer.PvScene;

public final class PvDisplay
extends Canvas
implements PvDisplayIf,
Runnable,
KeyListener,
MouseListener,
MouseMotionListener,
ActionListener,
Serializable {
    private static final int MOUSE_PICKED = 101;
    private static final int MOUSE_DRAGGED = 102;
    private static final int MOUSE_RELEASED = 103;
    protected static final int KEY_0 = 48;
    protected static final int KEY_1 = 49;
    protected static final int KEY_2 = 50;
    protected static final int KEY_3 = 51;
    protected static final int KEY_4 = 52;
    protected static final int KEY_5 = 53;
    protected static final int KEY_6 = 54;
    protected static final int KEY_7 = 55;
    protected static final int KEY_8 = 56;
    protected static final int KEY_9 = 57;
    protected static final int KEY_A = 65;
    protected static final int KEY_B = 66;
    protected static final int KEY_C = 67;
    protected static final int KEY_D = 68;
    protected static final int KEY_E = 69;
    protected static final int KEY_F = 70;
    protected static final int KEY_G = 71;
    protected static final int KEY_H = 72;
    protected static final int KEY_I = 73;
    protected static final int KEY_J = 74;
    protected static final int KEY_K = 75;
    protected static final int KEY_L = 76;
    protected static final int KEY_M = 77;
    protected static final int KEY_N = 78;
    protected static final int KEY_O = 79;
    protected static final int KEY_P = 80;
    protected static final int KEY_Q = 81;
    protected static final int KEY_R = 82;
    protected static final int KEY_S = 83;
    protected static final int KEY_T = 84;
    protected static final int KEY_U = 85;
    protected static final int KEY_V = 86;
    protected static final int KEY_W = 87;
    protected static final int KEY_X = 88;
    protected static final int KEY_Y = 89;
    protected static final int KEY_Z = 90;
    public static final int M_MODE_ORBIT = 0;
    public static final int M_MODE_SCALE = 1;
    public static final int M_MODE_SCALE_RECT = 2;
    public static final int M_MODE_TRANS = 3;
    public static final int M_MODE_TRANS_Z = 4;
    public static final int M_MODE_PICK = 5;
    public static final int M_MODE_INITIAL_PICK = 6;
    public static final int M_MODE_HIGHLIGHT = 7;
    public static final int M_MODE_DISPLAY_PICK = 8;
    public static final int M_MODE_MARK = 9;
    public static final int M_MODE_MARK_ELEMENTS = 10;
    public static final int M_MODE_UNMARK = 11;
    public static final int M_MODE_ADD = 12;
    public static final int M_MODE_DELETE = 13;
    public static final int M_MODE_DUPLICATE = 14;
    protected static final int M_MODE_ADD_ELEMENT = 15;
    public String m_defBackgroundImage;
    public String m_backgroundImage;
    protected static final String[] m_majorModeMessage = new String[]{PsConfig.getMessage("MODE_ORBIT"), PsConfig.getMessage("MODE_SCALE"), PsConfig.getMessage("MODE_SCALE_RECT"), PsConfig.getMessage("MODE_TRANS"), PsConfig.getMessage("MODE_TRANS_Z"), PsConfig.getMessage("MODE_PICK"), PsConfig.getMessage("MODE_INITIAL_PICK"), PsConfig.getMessage("MODE_HIGHLIGHT"), PsConfig.getMessage("MODE_DISPLAY_PICK"), PsConfig.getMessage("MODE_MARK"), PsConfig.getMessage("MODE_MARK_ELEMENTS"), PsConfig.getMessage("MODE_UNMARK"), PsConfig.getMessage("MODE_ADD"), PsConfig.getMessage("MODE_DELETE"), PsConfig.getMessage("MODE_DUPLICATE"), PsConfig.getMessage("MODE_ADD_ELEMENT")};
    protected static final int M_MODE_RESET = 0;
    protected static final int M_MODE_CENTER = 1;
    protected static final int M_MODE_FOCUS = 2;
    protected static final int M_MODE_START = 3;
    protected static final int M_MODE_STOP = 4;
    protected static final String[] m_minorModeMessage = new String[]{PsConfig.getMessage("MODE_RESET"), PsConfig.getMessage("MODE_CENTER"), PsConfig.getMessage("MODE_FOCUS"), PsConfig.getMessage("MODE_START"), PsConfig.getMessage("MODE_STOP")};
    protected static final boolean M_SWITCH_GRID = true;
    protected static final boolean M_SWITCH_DCUE = false;
    protected static final boolean M_SWITCH_HIDD = false;
    protected boolean m_bMouseInside;
    protected boolean m_bMouseDown;
    protected String m_name;
    protected boolean m_bIsEnabledUpdate;
    private transient Applet m_applet;
    protected transient Frame m_frame;
    protected transient PsUpdateIf m_parent;
    protected transient PvViewerIf m_viewer;
    protected Hashtable m_camera;
    protected PvCamera m_currentCamera;
    protected PsPanel m_cameraPanel;
    protected PsPanel m_infoPanel;
    protected PvScene m_scene;
    protected PvGeometry m_currentGeom;
    private String m_currentFrameName;
    protected PgGeometryIf m_geomIf;
    protected boolean m_bCentered;
    protected static final String GEOM_AXES = "axes frame";
    protected static final String GEOM_AXES_0 = "x-axis";
    protected static final String GEOM_AXES_1 = "y-axis";
    protected static final String GEOM_AXES_2 = "z-axis";
    protected static final String GEOM_BNDBOX = "bndbox";
    protected static final String GEOM_FRAME = "frame";
    protected static final String GEOM_XY_GRID = "xy-grid";
    protected Hashtable m_specialGeom;
    protected int m_mode;
    protected int m_modeMajor;
    protected int m_defModeMajor;
    protected boolean m_bLocalTransform;
    protected PvModelCamera m_modelCamera;
    protected int m_transformationMode;
    protected int m_ambientDim;
    protected int m_ambientSpace;
    protected int m_ambientProj;
    protected transient Vector m_cameraListener;
    protected transient Vector m_pickListener;
    protected transient PvPickListenerIf m_pickFocus;
    protected int m_pickedVertex;
    protected PiVector m_pick;
    protected PiVector m_markBox;
    protected PdVector worldPick;
    protected Dimension m_currLoc;
    protected double[] m_currNormLoc;
    protected int m_imageFitMode;
    protected transient Image m_backImage;
    private transient Image m_image;
    private transient int[][] m_zBuffer;
    protected int m_nHeight;
    protected int m_nWidth;
    protected static Dimension m_defSize = new Dimension(300, 300);
    protected PuInteger m_height;
    protected PuInteger m_width;
    private transient Graphics m_g;
    protected int m_sceneFlags;
    protected static float PS_ZOOM = 1000.0f;
    protected PdColor m_foregroundColor;
    protected PdColor m_backgroundColor;
    protected boolean m_bShowBackface;
    protected boolean m_bShowBackImage;
    protected boolean m_bShowDepthcue;
    protected boolean m_bShowEdgesOnce;
    protected boolean m_bShowEdgeAura;
    protected boolean m_bShowGrid;
    protected boolean m_bEnableSorting;
    protected boolean m_bEnableTag;
    protected boolean m_bEnableZBuffer;
    private boolean m_bSaveEnableZBuffer;
    protected boolean m_bEnableFastZBuffer;
    protected transient Thread m_thread;
    protected boolean m_bEnableAnimation;
    protected boolean m_bDrawing;
    private static final int MOUSE_X_CONSTRAINT = 1;
    private static final int MOUSE_Y_CONSTRAINT = 2;
    private int m_mouseShiftConstraint;
    protected boolean m_bMouseShiftConstraint;
    private int xUp;
    private int yUp;
    private int xDown;
    private int yDown;
    private boolean bDrag;
    protected PuInteger m_sleep;
    protected boolean m_bFpsEnabled;
    private long m_period;
    private int m_pCount;
    protected transient PopupMenu m_popup;
    protected transient MenuItem[] m_menuItem;
    private int m_prevKey;
    protected PgJvxSrc m_coordFrame;
    protected PgAxes m_axes;
    protected boolean m_bNewZBuffer;
    private boolean m_bFirstAfterPick;
    private boolean m_bSaveShowingVertices;
    private boolean m_bSaveShowingBndbox;
    private boolean m_bIsGlowingBndbox;
    private PiVector m_newElement;

    public boolean isShowingBackImage() {
        return this.m_bShowBackImage;
    }

    public void showBackImage(boolean bl) {
        this.m_bShowBackImage = bl;
    }

    public Image getBackgroundImage() {
        return this.m_backImage;
    }

    public boolean isEnabledClip() {
        return this.m_currentCamera.m_bEnableClip;
    }

    public boolean isClip() {
        return this.isEnabledClip();
    }

    public void fit() {
        if (this.m_scene == null) {
            return;
        }
        if (this.m_nHeight <= 0) {
            return;
        }
        PdVector[] pdVectorArray = this.m_scene.getBounds();
        if (pdVectorArray == null) {
            return;
        }
        this.m_currentCamera.fit(PdVector.dist(pdVectorArray[0], pdVectorArray[1]));
        PdVector pdVector = new PdVector(3);
        pdVector.blend(0.5, pdVectorArray[0], 0.5, pdVectorArray[1]);
        this.m_currentCamera.setInterest(pdVector);
        this.m_currentCamera.updatePanels(this.m_currentCamera);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        }
        this.updateCameraListener(101);
    }

    public boolean isShowingDepthcue() {
        if (this.m_currentCamera.getProjectionMode() == 0) {
            return this.m_bShowDepthcue;
        }
        return false;
    }

    public void showDepthcue(boolean bl) {
        this.m_bShowDepthcue = bl;
    }

    public void setBackgroundImage(Image image) {
        if (image == null) {
            this.m_backImage = null;
            this.showBackImage(false);
            return;
        }
        this.m_backImage = image;
        this.showBackImage(true);
    }

    public void setBackgroundImage(String string) {
        Image image = !PsConfig.isApplication() ? PsConfig.getApplet().getImage(PsConfig.getApplet().getCodeBase(), string) : Toolkit.getDefaultToolkit().getImage(string);
        if (image == null) {
            if (!PsConfig.isApplication()) {
                string = PsConfig.getApplet().getCodeBase() + string;
            }
            PsDebug.warning("failed loading image = " + string);
            return;
        }
        this.setBackgroundImage(image);
        this.m_backgroundImage = string;
    }

    protected void setEnabledModelOfSpecials(boolean bl) {
        if (this.isShowingFrame()) {
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_FRAME), bl);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_bEnableFastZBuffer && this.m_bEnableZBuffer != this.m_bSaveEnableZBuffer) {
            this.m_bEnableZBuffer = this.m_bSaveEnableZBuffer;
            this.repaint();
        }
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.m_markBox.m_data[2] = n;
        this.m_markBox.m_data[3] = n2;
        this.m_currLoc.width = n;
        this.m_currLoc.height = this.m_nHeight - 1 - n2;
        if (Math.abs(this.xUp - this.xDown) <= 2 || Math.abs(this.yUp - this.yDown) <= 2) {
            this.bDrag = false;
        }
        this.xUp = n;
        this.yUp = n2;
        this.m_bMouseDown = false;
        if (this.m_mode == 6) {
            this.bDrag = false;
            return;
        }
        if (this.m_mode == 8) {
            this.bDrag = false;
            return;
        }
        if (this.m_mode == 5) {
            if (this.m_currentGeom != null && !this.isEnabledTags()) {
                this.m_currentGeom.releaseVertex(this.m_pickedVertex);
                if (this.m_geomIf != null) {
                    this.m_geomIf.update(this.m_geomIf);
                }
            }
            this.bDrag = false;
            return;
        }
        if (this.m_mode == 13) {
            PvPickEvent pvPickEvent = this.getPickEvent(n, n2);
            if (pvPickEvent == null) {
                return;
            }
            PgGeometryIf pgGeometryIf = pvPickEvent.getGeometry();
            if (pgGeometryIf == null) {
                return;
            }
            this.removeGeometry(pgGeometryIf);
            this.update(this);
            return;
        }
        if (this.m_mode == 9) {
            if (this.m_currentGeom != null) {
                if (this.m_markBox.m_data[0] == this.m_markBox.m_data[2] && this.m_markBox.m_data[1] == this.m_markBox.m_data[3]) {
                    this.m_currentGeom.pickVertex(n, n2);
                } else {
                    this.m_currentGeom.tagVertices(Math.min(this.m_markBox.m_data[0], n), Math.min(this.m_markBox.m_data[1], n2), Math.abs(n - this.m_markBox.m_data[0]), Math.abs(n2 - this.m_markBox.m_data[1]));
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.bDrag = false;
            this.repaint();
            PvPickEvent pvPickEvent = new PvPickEvent(3);
            pvPickEvent.setGeometry(this.m_geomIf);
            pvPickEvent.setMarkBox(this.m_markBox);
            pvPickEvent.setMarkBoxWorld(this.markBox2World(this.m_markBox));
            if (this.m_pickFocus != null) {
                this.m_pickFocus.markVertices(pvPickEvent);
            } else if (this.m_pickListener != null) {
                Enumeration enumeration = this.m_pickListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((PvPickListenerIf)enumeration.nextElement()).markVertices(pvPickEvent);
                }
            }
            this.m_markBox.setConstant(0);
            return;
        }
        if (this.m_mode == 10) {
            this.bDrag = false;
            return;
        }
        if (this.m_mode == 2) {
            this.bDrag = false;
            PdVector[] pdVectorArray = this.markBox2World(this.m_markBox);
            PdVector pdVector = PdVector.blendNew(0.5, pdVectorArray[0], 0.5, pdVectorArray[2]);
            this.m_currentCamera.setInterest(pdVector);
            double d = PdVector.dist(pdVectorArray[0], pdVectorArray[2]);
            if (d < 1.0E-4) {
                PsDebug.warning("mark box too small, no zoom");
                return;
            }
            this.m_currentCamera.fit(d);
            if (this.getTransformationMode() != 0) {
                this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
            }
            this.updateCameraListener(103);
            this.repaint();
            this.m_markBox.setConstant(0);
            return;
        }
        if (this.m_mode == 11) {
            if (this.m_currentGeom != null) {
                if (this.m_markBox.m_data[0] == this.m_markBox.m_data[2] && this.m_markBox.m_data[1] == this.m_markBox.m_data[3]) {
                    int n3 = this.m_currentGeom.pickVertex(n, n2);
                    if (n3 != -1) {
                        this.m_currentGeom.releaseVertex(n3);
                    }
                } else {
                    this.m_currentGeom.untagVertices(Math.min(this.m_markBox.m_data[0], n), Math.min(this.m_markBox.m_data[1], n2), Math.abs(n - this.m_markBox.m_data[0]), Math.abs(n2 - this.m_markBox.m_data[1]));
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.bDrag = false;
            this.repaint();
            PvPickEvent pvPickEvent = new PvPickEvent(3);
            pvPickEvent.setGeometry(this.m_geomIf);
            pvPickEvent.setMarkBox(this.m_markBox);
            pvPickEvent.setMarkBoxWorld(this.markBox2World(this.m_markBox));
            if (this.m_pickFocus != null) {
                this.m_pickFocus.unmarkVertices(pvPickEvent);
            } else if (this.m_pickListener != null) {
                Enumeration enumeration = this.m_pickListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((PvPickListenerIf)enumeration.nextElement()).unmarkVertices(pvPickEvent);
                }
            }
            this.m_markBox.setConstant(0);
        }
    }

    private void drawPickBox(Graphics graphics) {
        if (this.m_markBox == null || this.m_markBox.getSize() < 4) {
            PsDebug.warning("missing mark box.");
            return;
        }
        if (this.m_markBox.getSize() < 4) {
            PsDebug.warning("mark box too small, size = " + this.m_markBox.getSize());
            return;
        }
        int[] nArray = this.m_markBox.m_data;
        graphics.drawLine(nArray[0], nArray[1], nArray[2], nArray[1]);
        graphics.drawLine(nArray[2], nArray[1], nArray[2], nArray[3]);
        graphics.drawLine(nArray[2], nArray[3], nArray[0], nArray[3]);
        graphics.drawLine(nArray[0], nArray[3], nArray[0], nArray[1]);
    }

    public void setSizeWithinFrame(int n, int n2) {
        int n3;
        int n4;
        if (n2 < 0 || n < 0) {
            PsDebug.warning("value <= 0");
            return;
        }
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return;
        }
        Dimension dimension = frame.getSize();
        if (this.m_nWidth < 0 || this.m_nHeight < 0) {
            Insets insets = frame.getInsets();
            n4 = insets.left + insets.right;
            n3 = insets.top + insets.bottom;
        } else {
            n4 = dimension.width - this.m_nWidth;
            n3 = dimension.height - this.m_nHeight;
        }
        ((Component)frame).setSize(n4 + n, n3 + n2);
        this.resizeImage();
        frame.validate();
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor.getColor();
    }

    public void setBackgroundColor(Color color) {
        this.m_backgroundColor.setColor(color);
        super.setBackground(this.m_backgroundColor.getColor());
    }

    public boolean hasPaintTag(int n) {
        return (this.m_sceneFlags & n) != 0;
    }

    protected void paintGeom(Graphics graphics) {
        ++this.m_pCount;
        if (!this.hasPaintTag(1)) {
            return;
        }
        boolean bl = this.hasPaintTag(8);
        if (this.hasPaintTag(8192)) {
            if (this.hasPaintTag(2) && !bl) {
                graphics.setColor(this.m_backgroundColor.getColor());
                graphics.fillRect(0, 0, this.m_nWidth, this.m_nHeight);
                graphics.setColor(this.m_foregroundColor.getColor());
            }
            if (this.m_bShowBackImage && this.m_backImage != null && !bl) {
                int n = this.m_backImage.getWidth(this);
                int n2 = this.m_backImage.getHeight(this);
                switch (this.m_imageFitMode) {
                    case 0: {
                        graphics.drawImage(this.m_backImage, (this.m_nWidth - n) / 2, (this.m_nHeight - n2) / 2, n, n2, this.m_backgroundColor.getColor(), this);
                        break;
                    }
                    case 1: {
                        int n3 = 1 + this.m_nWidth / n;
                        int n4 = 1 + this.m_nHeight / n2;
                        int n5 = 0;
                        while (n5 < n4) {
                            int n6 = 0;
                            while (n6 < n3) {
                                graphics.drawImage(this.m_backImage, n6 * n, n5 * n2, n, n2, this.m_backgroundColor.getColor(), this);
                                ++n6;
                            }
                            ++n5;
                        }
                        break;
                    }
                    case 2: {
                        graphics.drawImage(this.m_backImage, 0, 0, this.m_nWidth, this.m_nHeight, this);
                    }
                }
            }
        }
        Cursor cursor = null;
        if (this.isEnabledZBuffer()) {
            cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
        if (this.isEnabledZBuffer() || this.m_bEnableFastZBuffer && this.m_bSaveEnableZBuffer) {
            this.resetZBuffer();
        }
        PvScene pvScene = this.m_scene;
        synchronized (pvScene) {
            block22: {
                if (this.m_scene == null || this.m_currentGeom == null) break block22;
                this.m_scene.paint(graphics, this);
            }
            Object var10_11 = null;
        }
        if (this.m_bIsGlowingBndbox) {
            this.glowBndbox(false);
        }
        if (this.hasPaintTag(4) && !bl) {
            PsPanel.drawBorder(this, graphics, 2);
        }
        if (this.hasPaintTag(256) && !bl) {
            this.drawInfo(graphics);
        }
        if (this.hasPaintTag(16)) {
            this.drawCross(graphics, 2, this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height);
        }
        if ((this.m_mode == 9 || this.m_mode == 11 || this.m_mode == 2) && this.m_bMouseDown) {
            this.drawPickBox(graphics);
        }
        if (this.isEnabledZBuffer()) {
            this.setCursor(cursor);
        }
    }

    public boolean isShowingAxes() {
        return this.hasPaintTag(1024);
    }

    public void showAxes(boolean bl) {
        if (bl) {
            if (!this.hasAxes()) {
                this.getAxes();
            }
            PgGeometry[] pgGeometryArray = this.m_axes.getAxes();
            int n = 0;
            while (n < pgGeometryArray.length) {
                this.addGeometry(pgGeometryArray[n], 1);
                this.m_specialGeom.put(GEOM_AXES + "_" + String.valueOf(n), pgGeometryArray[n]);
                ++n;
            }
            this.addGeometry(this.m_axes, 1);
            this.m_specialGeom.put(GEOM_AXES, this.m_axes);
            this.updateCameraListener(101);
        } else if (this.m_specialGeom.containsKey(GEOM_AXES)) {
            PgGeometry[] pgGeometryArray = this.m_axes.getAxes();
            if (pgGeometryArray != null) {
                int n = 0;
                while (n < pgGeometryArray.length) {
                    String string = GEOM_AXES + "_" + String.valueOf(n);
                    this.removeGeometry(pgGeometryArray[n]);
                    this.m_specialGeom.remove(string);
                    ++n;
                }
            }
            this.removeGeometry(this.m_axes);
            this.m_specialGeom.remove(GEOM_AXES);
        }
        this.setPaintTag(1024, bl);
        this.update(this);
    }

    public PgAxes getAxes() {
        if (this.m_axes == null) {
            PjAxes pjAxes = null;
            if (!this.m_specialGeom.containsKey(GEOM_AXES)) {
                pjAxes = new PjAxes(3);
                this.m_axes = pjAxes.getAxes();
                this.m_axes.showTitles(true);
                this.m_axes.setName(PsConfig.getMessage("Axes"));
                pjAxes.setScene(this.m_scene);
                this.addCameraListener(pjAxes);
                pjAxes.update(this.m_scene);
            }
        }
        return this.m_axes;
    }

    public void setAxes(PgAxes pgAxes) {
        if (this.m_axes != null) {
            this.showAxes(false);
        }
        this.m_axes = pgAxes;
    }

    public int getAmbientSpace() {
        if (this.m_currentGeom != null && this.m_ambientSpace != this.m_currentGeom.getAmbientSpace()) {
            this.setAmbientSpace(this.m_currentGeom.getAmbientSpace());
        }
        return this.m_ambientSpace;
    }

    public void setAmbientSpace(int n) {
        if (this.m_currentGeom != null && this.m_currentGeom.getAmbientSpace() != n) {
            this.m_currentGeom.setAmbientSpace(n);
            if (this.m_geomIf != null) {
                this.m_geomIf.setAmbientSpace(n);
            }
        }
        switch (n) {
            default: {
                this.m_ambientDim = 3;
                break;
            }
            case 0: {
                this.m_ambientDim = 1;
                break;
            }
            case 1: 
            case 2: {
                this.m_ambientDim = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.m_ambientDim = 4;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.m_ambientDim = 5;
            }
        }
        this.m_ambientSpace = n;
    }

    public void setEnabledUpdate(boolean bl) {
        this.m_bIsEnabledUpdate = bl;
    }

    public boolean isEnabledLocalTransform() {
        return this.m_bLocalTransform;
    }

    private void getModelFromWorld(PvGeometry pvGeometry, PdVector pdVector, PdVector pdVector2) {
        if (pvGeometry == null) {
            return;
        }
        this.getModelFromWorld(pvGeometry.getGeometry(), pdVector, pdVector2);
    }

    private void getModelFromWorld(PgGeometryIf pgGeometryIf, PdVector pdVector, PdVector pdVector2) {
        if (pgGeometryIf == null) {
            return;
        }
        if (pgGeometryIf.hasModelMatrix()) {
            PdMatrix pdMatrix = new PdMatrix(4);
            pdMatrix.invert34(pgGeometryIf.getModelMatrix());
            if (pdVector != null) {
                pdVector.leftMultMatrix(pdMatrix);
            }
            if (pdVector2 != null) {
                pdVector2.leftMultMatrix(pdMatrix);
            }
        }
        if (pgGeometryIf.getDimOfVertices() == 2 && pdVector != null && pdVector2 != null) {
            double d = 0.0;
            if (Math.abs(pdVector2.getEntry(2)) > 1.0E-9) {
                d = -pdVector.getEntry(2) / pdVector2.getEntry(2);
            } else {
                PsDebug.warning("horizontal pick direction");
            }
            pdVector.blendBase(pdVector, d, pdVector2);
        }
    }

    private int[] getPixelFromWorld(PdVector pdVector) {
        PdVector pdVector2 = PdVector.copyNew(pdVector);
        int n = pdVector2.getSize();
        if (n != 4) {
            pdVector2.setSize(4);
            int n2 = n;
            while (n2 < 4) {
                pdVector2.setEntry(n2, 0.0);
                ++n2;
            }
            pdVector2.setEntry(3, 1.0);
        }
        pdVector2.leftMultMatrix(this.m_currentCamera.m_trans);
        int[] nArray = new int[]{(int)pdVector2.getEntry(0), (int)pdVector2.getEntry(1), (int)pdVector2.getEntry(2)};
        return nArray;
    }

    public PgGeometryIf[] getGeometries() {
        PvGeometry[] pvGeometryArray = this.getGeometryContainers();
        if (pvGeometryArray == null || pvGeometryArray.length == 0) {
            return null;
        }
        PgGeometryIf[] pgGeometryIfArray = new PgGeometryIf[pvGeometryArray.length];
        if (pgGeometryIfArray == null || pgGeometryIfArray.length == 0) {
            return null;
        }
        int n = 0;
        PgGeometryIf pgGeometryIf = this.getSelectedGeometry();
        if (pgGeometryIf != null && !this.m_specialGeom.contains(pgGeometryIf) && n < pgGeometryIfArray.length) {
            pgGeometryIfArray[n++] = this.getSelectedGeometry();
        }
        int n2 = 0;
        while (n2 < pvGeometryArray.length) {
            PgGeometryIf pgGeometryIf2 = pvGeometryArray[n2].getGeometry();
            if (pgGeometryIf2 != pgGeometryIfArray[0] && n < pgGeometryIfArray.length) {
                pgGeometryIfArray[n++] = pgGeometryIf2;
            }
            ++n2;
        }
        return pgGeometryIfArray;
    }

    public boolean isShowingFrame() {
        return this.hasPaintTag(512);
    }

    public void showFrame(boolean bl) {
        if (bl) {
            if (!this.m_specialGeom.containsKey(GEOM_FRAME)) {
                this.m_coordFrame = new PgJvxSrc();
                this.m_coordFrame.setName(PsConfig.getMessage("CoordinateFrame"));
                this.m_coordFrame.showVertices(true);
                this.m_coordFrame.showPolygons(true);
                this.m_coordFrame.showPolygonEndArrow(true);
                this.m_coordFrame.setDefaultLabelEnabled(false);
                this.m_coordFrame.showIndices(true);
                this.m_coordFrame.setGlobalPolygonSize(1.0);
                this.m_coordFrame.setGlobalPolygonColor(Color.black);
                this.updateCoordFrame(this.m_ambientDim, this.m_ambientSpace, this.m_ambientProj);
                this.addGeometry(this.m_coordFrame, 1);
                this.m_specialGeom.put(GEOM_FRAME, this.m_coordFrame);
                PvGeometry pvGeometry = this.m_scene.getGeometry(this.m_coordFrame);
                pvGeometry.setPosition(100, 100);
            }
        } else if (this.m_specialGeom.containsKey(GEOM_FRAME)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_FRAME));
            this.m_specialGeom.remove(GEOM_FRAME);
        }
        this.setPaintTag(512, bl);
        this.update(this);
    }

    public Frame getFrame() {
        return this.m_frame;
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public void addPickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_pickListener == null) {
            this.m_pickListener = new Vector();
        } else if (this.hasPickListener(pvPickListenerIf)) {
            PsDebug.warning("listener = " + pvPickListenerIf.getName() + " of listener already used.");
            return;
        }
        this.m_pickListener.addElement(pvPickListenerIf);
    }

    public void init() {
        this.stop();
        this.m_bLocalTransform = false;
        this.m_bMouseShiftConstraint = false;
        this.setEnabledUpdate(true);
        this.setTransformationMode(0);
        this.m_pickedVertex = -1;
        this.m_pick.set(0, 0, 0);
        this.setForegroundColor(Color.black);
        if (!PsConfig.isApplication() && PsConfig.getApplet() != null && PsConfig.getApplet().getBackground() != null) {
            this.setBackgroundColor(PsConfig.getApplet().getBackground());
        } else {
            this.setBackgroundColor(Color.lightGray);
        }
        this.selectCamera(0);
        this.m_sceneFlags = 0;
        this.setPaintTag(8199, true);
        this.setEnabledFastZBuffer(true);
        this.setEnabledZBuffer(false);
        this.setEnabledAnimation(false);
        this.setImageFitMode(1);
        this.showBackImage(false);
        this.showBndBox(false);
        this.showDepthcue(true);
        this.showEdgeAura(false);
        this.showEdgesOnce(true);
        this.showFrame(false);
        this.showAxes(false);
        this.showGrid(false);
        this.setEnabledPainters(true);
        this.setEnabledClip(false);
        this.m_sleep.setDefBounds(0, 100, 1, 5);
        this.m_sleep.setDefValue(40);
        this.m_sleep.setEnabled(false);
        this.m_sleep.init();
        this.setCurrentMajorMode(this.m_defModeMajor);
        this.m_specialGeom.clear();
        if (this.m_currentGeom != null) {
            this.m_currentCamera.init();
            this.fit();
            this.repaint();
        }
    }

    public boolean removeGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return true;
        }
        if (!this.containsGeometry(pgGeometryIf)) {
            if (pgGeometryIf != null) {
                PsDebug.message("geometry=" + pgGeometryIf.getName() + " not registered in listener");
            }
            return false;
        }
        pgGeometryIf.removeDisplay(this);
        PvGeometry pvGeometry = this.m_scene.getGeometry(pgGeometryIf);
        PvGeometry pvGeometry2 = this.m_scene.removeGeometry(pvGeometry);
        if (this.m_currentGeom != pvGeometry2) {
            if (pvGeometry2 != null && pvGeometry2.getGeometry() != null) {
                this.selectGeometry(pvGeometry2.getGeometry());
            } else {
                this.selectGeometry(null);
            }
        }
        return true;
    }

    public PgGeometryIf getSelectedGeometry() {
        if (this.m_currentGeom == null) {
            return null;
        }
        return this.m_currentGeom.getGeometry();
    }

    public PsPanel getCameraPanel() {
        if (!(this.m_cameraPanel != null && this.m_cameraPanel.getLanguage().equals(PsConfig.getLanguage()) || this.m_currentCamera == null)) {
            this.m_cameraPanel = this.m_currentCamera.getInfoPanel();
        }
        return this.m_cameraPanel;
    }

    public void run() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.m_bFpsEnabled) {
            this.m_pCount = 0;
            d = new Date().getTime();
        }
        while (this.m_thread != null) {
            double d3;
            if (!this.m_bDrawing) {
                if (this.getTransformationMode() == 0) {
                    this.m_currentCamera.mouseAnimate();
                } else {
                    this.m_modelCamera.mouseAnimate();
                }
                boolean bl = this.hasPaintTag(1);
                this.setPaintTag(1, false);
                this.updateCameraListener(101);
                this.setPaintTag(1, bl);
            }
            if (this.m_thread == null) {
                return;
            }
            try {
                Thread.sleep(this.m_sleep.getValue());
            }
            catch (InterruptedException interruptedException) {}
            if (!this.m_bFpsEnabled || !((d3 = (double)new Date().getTime()) - d > (double)(this.m_period * 1000L))) continue;
            d2 = (d2 + (double)this.m_pCount / ((d3 - d) / 1000.0)) / 2.0;
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                ((PvDisplay_IP)this.m_infoPanel).m_lFps.setText(String.valueOf((double)((int)(d2 * 100.0)) / 100.0));
            }
            d = d3;
            this.m_pCount = 0;
        }
    }

    public boolean isEnabledClearScreen() {
        return this.hasPaintTag(8192);
    }

    public void resetTransformModel() {
        PdMatrix pdMatrix = new PdMatrix(4);
        pdMatrix.setIdentity();
        if (this.m_modelCamera != null) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
            this.m_modelCamera.setModelMatrix(pdMatrix);
            this.m_modelCamera.getAmbientMatrix().setIdentity();
            this.m_modelCamera.getAmbientInvMatrix().setIdentity();
        }
        if (this.m_currentGeom != null && this.m_currentGeom.hasModelMatrix()) {
            this.m_currentGeom.setModelMatrix(pdMatrix);
        }
        if (this.m_currentGeom != null && this.m_currentGeom.hasAmbientMatrix()) {
            this.m_currentGeom.getAmbientMatrix().setIdentity();
            this.m_currentGeom.getAmbientInvMatrix().setIdentity();
        }
        this.setEnabledLocalTransform(false);
    }

    public void setEnabledTags(boolean bl) {
        this.m_bEnableTag = bl;
    }

    private void drawCross(Graphics graphics, int n, int n2, int n3) {
        graphics.drawLine(n2 - n, n3, n2 + n, n3);
        graphics.drawLine(n2, n3 - n, n2, n3 + n);
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread = null;
        }
        if (this.m_bFpsEnabled) {
            this.m_bFpsEnabled = false;
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                ((PvDisplay_IP)this.m_infoPanel).m_cFps.setState(this.m_bFpsEnabled);
                ((PvDisplay_IP)this.m_infoPanel).m_lFps.setText(PsConfig.getMessage("lFps"));
                this.m_sleep.setEnabled(false);
            }
        }
    }

    public boolean isEnabledPainters() {
        return this.m_bEnableSorting;
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    protected int getCurrentCameraType() {
        if (this.m_currentCamera == null) {
            PsDebug.warning("current camera missing.");
            return 0;
        }
        return this.m_currentCamera.getProjectionMode();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.m_bMouseInside = true;
        this.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_menuItem[0]) {
            this.setCurrentMajorMode(0);
            return;
        }
        if (object == this.m_menuItem[1]) {
            this.setCurrentMajorMode(1);
            return;
        }
        if (object == this.m_menuItem[2]) {
            this.setCurrentMajorMode(3);
            return;
        }
        if (object == this.m_menuItem[3]) {
            this.setCurrentMajorMode(6);
            return;
        }
        if (object == this.m_menuItem[4]) {
            if (this.m_viewer != null) {
                this.m_viewer.newDisplay();
                return;
            }
            PvDisplay pvDisplay = new PvDisplay(this.m_applet, this.m_frame);
            PsMainFrame psMainFrame = new PsMainFrame(pvDisplay, "JavaView", null);
            pvDisplay.setFrame(psMainFrame);
            PgGeometryIf[] pgGeometryIfArray = this.getGeometries();
            if (pgGeometryIfArray != null) {
                int n = 0;
                while (n < pgGeometryIfArray.length) {
                    pvDisplay.addGeometry(pgGeometryIfArray[n]);
                    ++n;
                }
                PgGeometryIf pgGeometryIf = this.getSelectedGeometry();
                if (pgGeometryIf != null && pvDisplay.containsGeometry(pgGeometryIf)) {
                    pvDisplay.selectGeometry(pgGeometryIf);
                }
            }
            pvDisplay.selectCamera(this.getCurrentCameraType());
            pvDisplay.showGrid(this.isShowingGrid());
            pvDisplay.showBndBox(this.isShowingBndBox());
            pvDisplay.showFrame(this.isShowingFrame());
            pvDisplay.showAxes(this.isShowingAxes());
            psMainFrame.setBounds(new Rectangle(50, 50, 400, 300));
            ((Component)psMainFrame).setVisible(true);
            return;
        }
        if (object == this.m_menuItem[5]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(46);
                return;
            }
        } else if (object == this.m_menuItem[6]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(25);
                return;
            }
        } else if (object == this.m_menuItem[7]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(24);
                return;
            }
        } else if (object == this.m_menuItem[8]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(26);
                return;
            }
            Applet applet = PsConfig.getApplet();
            if (!PsConfig.isApplication() && applet != null) {
                URL uRL;
                boolean bl = false;
                try {
                    uRL = new URL(PsConfig.getCodeBase() + "jars/help.html");
                    uRL.openConnection();
                    uRL.openStream();
                    applet.getAppletContext().showDocument(uRL, "Help on Viewer");
                    bl = true;
                }
                catch (MalformedURLException malformedURLException) {
                    PsDebug.warning("MalformedURLException when accessing viewer help");
                }
                catch (IOException iOException) {
                    PsDebug.warning("IOException, could not open connection");
                }
                catch (Exception exception) {
                    PsDebug.warning("file not found = " + "jars/help.html");
                }
                if (!bl) {
                    try {
                        uRL = new URL(PsConfig.getCodeBase() + "help.html");
                        uRL.openConnection();
                        uRL.openStream();
                        applet.getAppletContext().showDocument(uRL, "Help on Viewer");
                        return;
                    }
                    catch (MalformedURLException malformedURLException) {
                        PsDebug.warning("MalformedURLException when accessing viewer help");
                        return;
                    }
                    catch (IOException iOException) {
                        PsDebug.warning("IOException, could not open connection");
                        return;
                    }
                    catch (Exception exception) {
                        PsDebug.warning("file not found = " + "jars/help.html");
                        return;
                    }
                }
            }
        } else {
            if (object == this.m_menuItem[9]) {
                PsAboutDialog psAboutDialog = new PsAboutDialog(PsConfig.getFrame());
                int[] nArray = new int[]{10, 10, 400, 450};
                ((Component)psAboutDialog).setLocation(nArray[0], nArray[1]);
                ((Component)psAboutDialog).setSize(nArray[2], nArray[3]);
                psAboutDialog.validate();
                psAboutDialog.setModal(true);
                ((Component)psAboutDialog).setVisible(true);
                return;
            }
            if (object == this.m_menuItem[10]) {
                if (this.m_viewer != null) {
                    this.m_viewer.removeDisplay(this);
                    return;
                }
                Frame frame = this.hasParentFrame();
                if (frame != null) {
                    frame.dispose();
                    return;
                }
            } else if (object == this.m_menuItem[11]) {
                if (this.m_viewer != null) {
                    this.m_viewer.destroy();
                    return;
                }
                System.exit(0);
            }
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread((Runnable)this, "JavaView: Auto-Rotation");
            this.m_thread.setPriority(5);
            this.m_thread.start();
        }
    }

    private PdVector[] markBox2World(PiVector piVector) {
        PdVector[] pdVectorArray = PdVector.realloc(null, 5, 4);
        pdVectorArray[0].set(Math.min(piVector.m_data[0], piVector.m_data[2]), Math.min(piVector.m_data[1], piVector.m_data[3]), 0.0, 1.0);
        pdVectorArray[1].set(Math.max(piVector.m_data[0], piVector.m_data[2]), Math.min(piVector.m_data[1], piVector.m_data[3]), 0.0, 1.0);
        pdVectorArray[2].set(Math.max(piVector.m_data[0], piVector.m_data[2]), Math.max(piVector.m_data[1], piVector.m_data[3]), 0.0, 1.0);
        pdVectorArray[3].set(Math.min(piVector.m_data[0], piVector.m_data[2]), Math.max(piVector.m_data[1], piVector.m_data[3]), 0.0, 1.0);
        pdVectorArray[4].set(0.0, 0.0, -1000.0, 0.0);
        int n = 0;
        while (n < pdVectorArray.length) {
            pdVectorArray[n].leftMultMatrix(this.m_currentCamera.m_transInv);
            pdVectorArray[n].setSize(3);
            ++n;
        }
        return pdVectorArray;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public Image getImage() {
        return this.m_image;
    }

    private boolean resizeImage() {
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return false;
        }
        if (this.m_image != null && dimension.width == this.m_nWidth && dimension.height == this.m_nHeight) {
            return true;
        }
        if (this.m_nHeight == -1) {
            m_defSize = dimension;
        }
        this.m_nHeight = dimension.height;
        this.m_height.setValue(dimension.height);
        this.m_nWidth = dimension.width;
        this.m_width.setValue(dimension.width);
        boolean bl = this.hasParentFrame() != null;
        this.m_height.setEnabled(bl);
        this.m_width.setEnabled(bl);
        this.m_currentCamera.resizeImage(this.m_nWidth, this.m_nHeight);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.resizeImage(this.m_nWidth, this.m_nHeight);
        }
        this.m_image = this.createImage(this.m_nWidth, this.m_nHeight);
        if (this.isEnabledZBuffer()) {
            this.assureZBuffer(this.m_nWidth, this.m_nHeight);
        }
        if (this.m_image == null) {
            return false;
        }
        this.m_g = this.m_image.getGraphics();
        if (this.m_currentGeom != null) {
            this.setFrameTitle(this.m_currentGeom.getGeometry().getName());
            if (!this.m_bCentered) {
                this.m_bCentered = true;
                this.fit();
                this.center();
            }
        }
        this.m_bDrawing = true;
        this.paintGeom(this.m_g);
        this.m_bDrawing = false;
        return true;
    }

    public void setEnabledClip(boolean bl) {
        this.m_currentCamera.m_bEnableClip = bl;
    }

    public void enableClip(boolean bl) {
        this.setEnabledClip(bl);
    }

    public double getNearClip() {
        return this.m_currentCamera.m_nearClip.getValue();
    }

    public void setNearClip(double d) {
        this.m_currentCamera.m_nearClip.setValue(d);
    }

    public void releasePickFocus() {
        this.m_pickFocus = null;
    }

    public boolean hasCamera(int n) {
        if (n < 0 || PvDisplayIf.CAMERA_NAME.length <= n) {
            PsDebug.warning("camera type out of range = " + n);
            return false;
        }
        return this.m_camera.get(PvDisplayIf.CAMERA_NAME[n]) != null;
    }

    public boolean removeCamera(int n) {
        if (n < 0 || PvDisplayIf.CAMERA_NAME.length <= n) {
            return false;
        }
        return this.m_camera.remove(PvDisplayIf.CAMERA_NAME[n]) != null;
    }

    public Color getForegroundColor() {
        return this.m_foregroundColor.getColor();
    }

    public void setForegroundColor(Color color) {
        this.m_foregroundColor.setColor(color);
        super.setForeground(this.m_foregroundColor.getColor());
    }

    public void setPaintTag(int n, boolean bl) {
        if (bl) {
            this.m_sceneFlags |= n;
            if ((n & 8) != 0) {
                if (this.m_currentCamera != null) {
                    this.m_currentCamera.m_trans.multScalar(PS_ZOOM);
                }
                PvGeometry.PS_ZOOM = (int)PS_ZOOM;
                return;
            }
            if ((n & 1) != 0) {
                this.repaint();
                return;
            }
            if ((n & 0x800) != 0) {
                PvGeometry[] pvGeometryArray = this.getGeometryContainers();
                if (pvGeometryArray == null) {
                    return;
                }
                int n2 = 0;
                while (n2 < pvGeometryArray.length) {
                    if (pvGeometryArray[n2].isVisible()) {
                        PgGeometryIf pgGeometryIf = pvGeometryArray[n2].getGeometry();
                        if (pvGeometryArray[n2] != this.m_currentGeom && !this.m_specialGeom.contains(pgGeometryIf)) {
                            pvGeometryArray[n2].setVisible(false);
                            pgGeometryIf.setVisible(false);
                        }
                    }
                    ++n2;
                }
                return;
            }
        } else {
            if (this.hasPaintTag(8) && (n & 8) != 0) {
                if (this.m_currentCamera != null) {
                    this.m_currentCamera.m_trans.multScalar(1.0 / (double)PS_ZOOM);
                }
                PvGeometry.PS_ZOOM = 1;
            }
            this.m_sceneFlags &= ~n;
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        this.m_parent = psUpdateIf;
    }

    public PvDisplay() {
        this(null, null);
    }

    public PvDisplay(PvViewerIf pvViewerIf) {
        this(pvViewerIf.getApplet(), pvViewerIf.getFrame());
        this.m_viewer = pvViewerIf;
    }

    public PvDisplay(Applet applet, Frame frame) {
        this.m_backgroundImage = this.m_defBackgroundImage = "images/JavaViewLogo.gif";
        this.m_bMouseInside = false;
        this.m_bMouseDown = false;
        this.m_bIsEnabledUpdate = true;
        this.m_cameraPanel = null;
        this.m_infoPanel = null;
        this.m_mode = 0;
        this.m_modeMajor = 0;
        this.m_defModeMajor = 0;
        this.m_ambientSpace = 3;
        this.m_ambientProj = 0;
        this.m_pick = new PiVector(3);
        this.m_markBox = new PiVector(4);
        this.worldPick = new PdVector(4);
        this.m_currLoc = new Dimension();
        this.m_currNormLoc = new double[2];
        this.m_nHeight = -1;
        this.m_nWidth = -1;
        this.m_bShowGrid = false;
        this.m_bDrawing = false;
        this.m_bMouseShiftConstraint = false;
        this.bDrag = false;
        this.m_bFpsEnabled = false;
        this.m_period = 2L;
        this.m_prevKey = -1;
        this.m_bNewZBuffer = false;
        this.m_bFirstAfterPick = true;
        this.m_bSaveShowingBndbox = false;
        this.m_bIsGlowingBndbox = false;
        this.m_frame = frame;
        this.m_applet = applet;
        this.m_specialGeom = new Hashtable(3);
        this.m_camera = new Hashtable(4);
        this.addCamera("Perspective", new PvCamera(this, 0));
        this.m_foregroundColor = new PdColor(PsConfig.getMessage("foregroundColor"), this);
        this.m_backgroundColor = new PdColor(PsConfig.getMessage("backgroundColor"), this);
        this.m_scene = new PvScene();
        this.m_sleep = new PuInteger(PsConfig.getMessage("sleep"), this);
        this.m_height = new PuInteger(PsConfig.getMessage("height"), this);
        this.m_height.setDefBounds(0, 1024, 1, 10);
        this.m_height.setDefValue(PvDisplay.m_defSize.height);
        this.m_height.init();
        this.m_width = new PuInteger(PsConfig.getMessage("width"), this);
        this.m_width.setDefBounds(0, 1280, 1, 10);
        this.m_width.setDefValue(PvDisplay.m_defSize.width);
        this.m_width.init();
        this.setAmbientSpace(this.m_ambientSpace);
        this.enableEvents(48L);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.init();
    }

    public void paint(Graphics graphics) {
        if (!this.hasPaintTag(1)) {
            return;
        }
        this.m_bDrawing = true;
        if (this.resizeImage() && this.m_image != null) {
            graphics.drawImage(this.m_image, 0, 0, this);
        }
        this.m_bDrawing = false;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            if (this.m_popup == null) {
                this.m_popup = new PopupMenu(PsConfig.getMessage("pTitle"));
                this.m_menuItem = new MenuItem[20];
                this.m_menuItem[0] = new MenuItem(PsConfig.getMessage("pOrbit"));
                this.m_menuItem[1] = new MenuItem(PsConfig.getMessage("pScale"));
                this.m_menuItem[2] = new MenuItem(PsConfig.getMessage("pTranslate"));
                this.m_menuItem[3] = new MenuItem(PsConfig.getMessage("pPick"));
                this.m_menuItem[4] = new MenuItem(PsConfig.getMessage("pDisplay"));
                this.m_menuItem[5] = new MenuItem(PsConfig.getMessage("pEPS"));
                this.m_menuItem[6] = new MenuItem(PsConfig.getMessage("pConsole"));
                this.m_menuItem[7] = new MenuItem(PsConfig.getMessage("pControl"));
                this.m_menuItem[8] = new MenuItem(PsConfig.getMessage("pHelp"));
                this.m_menuItem[9] = new MenuItem(PsConfig.getMessage("pAbout"));
                this.m_menuItem[10] = new MenuItem(PsConfig.getMessage("pClose"));
                this.m_menuItem[11] = new MenuItem(PsConfig.getMessage("pExit"));
                int n = 0;
                while (n < this.m_menuItem.length) {
                    if (this.m_menuItem[n] != null) {
                        this.m_menuItem[n].addActionListener(this);
                    }
                    ++n;
                }
                this.m_popup.add(this.m_menuItem[0]);
                this.m_popup.add(this.m_menuItem[1]);
                this.m_popup.add(this.m_menuItem[2]);
                this.m_popup.addSeparator();
                this.m_popup.add(this.m_menuItem[4]);
                if (this.m_viewer != null) {
                    this.m_popup.add(this.m_menuItem[5]);
                    this.m_popup.add(this.m_menuItem[6]);
                    this.m_popup.add(this.m_menuItem[7]);
                }
                this.m_popup.addSeparator();
                this.m_popup.add(this.m_menuItem[8]);
                if (this.m_viewer != null) {
                    this.m_popup.add(this.m_menuItem[9]);
                }
                if (this.hasParentFrame() != null) {
                    this.m_popup.add(this.m_menuItem[10]);
                }
                if (PsConfig.isApplication()) {
                    this.m_popup.add(this.m_menuItem[11]);
                }
                this.add(this.m_popup);
            }
            this.m_popup.show(this, mouseEvent.getX(), mouseEvent.getY());
            this.m_popup = null;
        }
        super.processMouseEvent(mouseEvent);
    }

    public PvPickEvent getPickEvent(int n, int n2) {
        PdVector[] pdVectorArray = this.getWorldFromPixel(n, n2, 10000);
        PdVector pdVector = (PdVector)pdVectorArray[0].clone();
        PdVector pdVector2 = (PdVector)pdVectorArray[1].clone();
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PvPickEvent pvPickEvent = null;
        if (this.m_mode != 8) {
            PgGeometryIf[] pgGeometryIfArray;
            if (this.m_geomIf != null && this.m_geomIf.isVisible()) {
                this.getModelFromWorld(this.m_geomIf, pdVector, pdVector2);
                pdVector3.copyArray(pdVector);
                pdVector4.copyArray(pdVector2);
                pdVector4.normalize();
                pvPickEvent = this.m_geomIf.intersectionWithLine(pdVector3, pdVector4);
                if (pvPickEvent != null) {
                    pvPickEvent.setGeometry(this.m_geomIf);
                }
            }
            if (pvPickEvent == null && (pgGeometryIfArray = this.getGeometries()) != null) {
                int n3 = 0;
                while (n3 < pgGeometryIfArray.length) {
                    if (pgGeometryIfArray[n3] != this.m_geomIf && pgGeometryIfArray[n3].isVisible()) {
                        pdVector.copyArray(pdVectorArray[0]);
                        pdVector2.copyArray(pdVectorArray[1]);
                        this.getModelFromWorld(pgGeometryIfArray[n3], pdVector, pdVector2);
                        pdVector3.copyArray(pdVector);
                        pdVector4.copyArray(pdVector2);
                        pdVector4.normalize();
                        pvPickEvent = pgGeometryIfArray[n3].intersectionWithLine(pdVector3, pdVector4);
                        if (pvPickEvent != null) {
                            pvPickEvent.setGeometry(pgGeometryIfArray[n3]);
                            break;
                        }
                    }
                    ++n3;
                }
            }
        }
        if (pvPickEvent == null) {
            pdVectorArray[0].setSize(3);
            pdVectorArray[1].setSize(3);
            pdVectorArray[1].normalize();
            pvPickEvent = new PvPickEvent(3);
            pvPickEvent.setVertex(pdVectorArray[0]);
            pvPickEvent.setDistance(0.0);
            pvPickEvent.setViewBase(pdVectorArray[0]);
            pvPickEvent.setViewDir(pdVectorArray[1]);
        }
        pvPickEvent.setLocation(new Point(n, n2));
        return pvPickEvent;
    }

    protected void setCurrentMajorMode(int n) {
        this.m_modeMajor = n;
        this.setMinorMode(n);
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setMode(this.m_modeMajor);
        }
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setMode(this.m_modeMajor);
        }
        PsDebug.showStatus(m_majorModeMessage[this.m_modeMajor]);
    }

    private PdVector[] getWorldFromPixel(int n, int n2, int n3) {
        PdVector pdVector = new PdVector(n, n2, n3, 1.0);
        PdVector pdVector2 = new PdVector(0.0, 0.0, -1000.0, 0.0);
        if (this.m_currentCamera != null) {
            pdVector.leftMultMatrix(this.m_currentCamera.m_transInv);
            pdVector2.leftMultMatrix(this.m_currentCamera.m_transInv);
        }
        return new PdVector[]{pdVector, pdVector2};
    }

    protected PvGeometry[] getAllGeometryContainers() {
        return this.m_scene.getGeometries();
    }

    private void drawInfo(Graphics graphics) {
        int n = this.m_currLoc.width;
        int n2 = this.m_nHeight - 1 - this.m_currLoc.height;
        String string = "";
        PdVector pdVector = null;
        PgGeometryIf pgGeometryIf = null;
        PvPickEvent pvPickEvent = this.getPickEvent(n, n2);
        pgGeometryIf = pvPickEvent.getGeometry();
        pdVector = pvPickEvent.getVertex();
        string = string + "Nearest Position = ";
        if (pdVector != null) {
            int n3 = 0;
            while (n3 < pdVector.getSize()) {
                string = string + "\n  " + (float)pdVector.getEntry(n3);
                ++n3;
            }
        } else {
            string = string + "null";
        }
        string = string + "\nDistance = " + pvPickEvent.getDistance();
        if (pgGeometryIf != null) {
            string = string + "\nGeometry = " + pgGeometryIf.getName();
            if (pvPickEvent.getElementInd() != -1) {
                string = string + "\nElement  = " + pvPickEvent.getElementInd();
            }
            if (pvPickEvent.getVertexInd() != -1) {
                string = string + "\nClose to Vertex = " + pvPickEvent.getVertexInd();
            }
        }
        String[] stringArray = PuString.splitString(string, '\n');
        graphics.setFont(PsConfig.getFont(1));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.getHeight();
        int n5 = 20 * fontMetrics.charWidth('0');
        int n6 = 0;
        while (n6 < stringArray.length) {
            n5 = Math.max(n5, fontMetrics.stringWidth(stringArray[n6]));
            ++n6;
        }
        n6 = 7;
        int n7 = 7;
        int n8 = 3;
        int n9 = Math.min(n, this.m_nWidth - n5 - 2 * n8 - n6 - 5);
        int n10 = Math.min(n2, this.m_nHeight - stringArray.length * n4 - 2 * n8 - n7 - 5);
        graphics.setColor(Color.white);
        graphics.fillRect(n9 + n6, n10 + n7, n5 + 2 * n8, stringArray.length * n4 + 2 * n8);
        graphics.setColor(Color.black);
        int n11 = 0;
        while (n11 < stringArray.length) {
            graphics.drawString(stringArray[n11], n9 + n6 + n8, n10 + n7 + n8 + (n11 + 1) * n4);
            ++n11;
        }
        if (pdVector != null) {
            if (pgGeometryIf != null && pgGeometryIf.hasModelMatrix()) {
                PdMatrix pdMatrix = pgGeometryIf.getModelMatrix();
                pdVector.setSize(4);
                pdVector.setEntry(3, 1.0);
                pdVector.leftMultMatrix(pdMatrix);
            }
            int[] nArray = this.getPixelFromWorld(pdVector);
            graphics.setColor(Color.red);
            graphics.drawOval(nArray[0] - 5, nArray[1] - 5, 10, 10);
            this.drawCross(graphics, 5, nArray[0], nArray[1]);
        }
    }

    protected static void normalizedCoordsFromViewport(double[] dArray, int n, int n2, int n3, int n4) {
        double d = (double)n + 0.5;
        double d2 = (double)n4 - 1.0 - (double)n2 - 0.5;
        double d3 = Math.min(n3, n4);
        if (d3 < 1.0E-10) {
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return;
        }
        dArray[0] = 2.0 / (d3 - 1.0) * d - ((double)n3 - 1.0) / d3;
        dArray[1] = 2.0 / (d3 - 1.0) * d2 - ((double)n4 - 1.0) / d3;
    }

    public boolean isShowingEdgesOnce() {
        return this.m_bShowEdgesOnce;
    }

    public void showEdgesOnce(boolean bl) {
        this.m_bShowEdgesOnce = bl;
    }

    public void setAutoCenter(boolean bl) {
        this.m_bCentered = !bl;
    }

    public void addCameraListener(PvCameraListenerIf pvCameraListenerIf) {
        if (this.m_cameraListener == null) {
            this.m_cameraListener = new Vector();
        } else if (this.hasCameraListener(pvCameraListenerIf)) {
            PsDebug.warning("listener = " + pvCameraListenerIf.getName() + " of listener already used.");
            return;
        }
        this.m_cameraListener.addElement(pvCameraListenerIf);
    }

    public int getNumGeometries() {
        PgGeometryIf[] pgGeometryIfArray = this.getGeometries();
        if (pgGeometryIfArray == null) {
            return 0;
        }
        return pgGeometryIfArray.length;
    }

    protected PgGeometryIf[] getAllGeometries() {
        PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
        if (pvGeometryArray == null) {
            return null;
        }
        PgGeometryIf[] pgGeometryIfArray = new PgGeometryIf[pvGeometryArray.length];
        int n = 0;
        while (n < pvGeometryArray.length) {
            pgGeometryIfArray[n] = pvGeometryArray[n].getGeometry();
            ++n;
        }
        return pgGeometryIfArray;
    }

    public void setEnabledLocalTransform(boolean bl) {
        this.m_bLocalTransform = bl;
    }

    protected Frame hasParentFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof PsMainFrame) {
                return (Frame)container;
            }
            if (container instanceof Frame) {
                return null;
            }
            container = container.getParent();
        }
        return (Frame)container;
    }

    protected void updateCameraListener(int n) {
        if (this.m_currentCamera == null) {
            return;
        }
        if (this.m_cameraListener != null) {
            PvCameraEvent pvCameraEvent = new PvCameraEvent(this, 3);
            pvCameraEvent.setCamera(this.m_currentCamera);
            pvCameraEvent.setLocation(new Point(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height));
            PdVector[] pdVectorArray = this.getWorldFromPixel(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height, 10000);
            pdVectorArray[0].setSize(3);
            pvCameraEvent.setVertex(pdVectorArray[0]);
            Enumeration enumeration = this.m_cameraListener.elements();
            while (enumeration.hasMoreElements()) {
                if (n == 101) {
                    ((PvCameraListenerIf)enumeration.nextElement()).pickCamera(pvCameraEvent);
                    continue;
                }
                if (n == 102) {
                    ((PvCameraListenerIf)enumeration.nextElement()).dragCamera(pvCameraEvent);
                    continue;
                }
                if (n == 103) {
                    return;
                }
                PsDebug.warning("unknown state = " + n);
                return;
            }
        }
    }

    public boolean isShowingBndBox() {
        return this.hasPaintTag(128);
    }

    public void showBndBox(boolean bl) {
        if (bl) {
            if (!this.m_specialGeom.containsKey(GEOM_BNDBOX)) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setDimOfVertices(3);
                pgJvxSrc.setName(PsConfig.getMessage("BoundingBox"));
                pgJvxSrc.showElements(false);
                pgJvxSrc.showEdges(true);
                pgJvxSrc.setGlobalEdgeSize(1.0);
                pgJvxSrc.setGlobalEdgeColor(Color.blue);
                pgJvxSrc.setDimOfVertices(3);
                pgJvxSrc.setNumVertices(8);
                pgJvxSrc.setDimOfElements(3);
                pgJvxSrc.setNumElements(6);
                pgJvxSrc.getElement(0).set(0, 3, 2, 1);
                pgJvxSrc.getElement(1).set(0, 1, 5, 4);
                pgJvxSrc.getElement(2).set(1, 2, 6, 5);
                pgJvxSrc.getElement(3).set(2, 3, 7, 6);
                pgJvxSrc.getElement(4).set(3, 0, 4, 7);
                pgJvxSrc.getElement(5).set(4, 5, 6, 7);
                this.addGeometry(pgJvxSrc, 1);
                this.m_specialGeom.put(GEOM_BNDBOX, pgJvxSrc);
            }
            this.recomputeBndBox();
        } else if (this.m_specialGeom.containsKey(GEOM_BNDBOX)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_BNDBOX));
            this.m_specialGeom.remove(GEOM_BNDBOX);
        }
        this.setPaintTag(128, bl);
        this.update(this);
    }

    public PsPanel getInfoPanel() {
        if (this.m_infoPanel == null || !this.m_infoPanel.getLanguage().equals(PsConfig.getLanguage())) {
            this.m_infoPanel = new PvDisplay_IP();
            this.m_infoPanel.setParent(this);
            this.m_infoPanel.update(this);
        }
        return this.m_infoPanel;
    }

    public boolean containsGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        return this.m_scene.containsGeometry(pgGeometryIf);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        if (keyEvent.isControlDown()) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            int n2 = keyEvent.getKeyCode();
            switch (n2) {
                case 9: {
                    PgGeometryIf pgGeometryIf = this.getSelectedGeometry();
                    PvGeometry[] pvGeometryArray = this.getGeometryContainers();
                    if (pvGeometryArray == null) {
                        return;
                    }
                    int n3 = -1;
                    int n4 = 0;
                    while (n4 < pvGeometryArray.length) {
                        if (pgGeometryIf == pvGeometryArray[n4].getGeometry()) {
                            n3 = n4;
                            break;
                        }
                        ++n4;
                    }
                    if (n3 == -1) break;
                    n4 = 0;
                    while (n4 < pvGeometryArray.length) {
                        PgGeometryIf pgGeometryIf2 = pvGeometryArray[(n3 + n4 + 1) % pvGeometryArray.length].getGeometry();
                        if (pgGeometryIf2 != pgGeometryIf && !this.m_specialGeom.contains(pgGeometryIf2)) {
                            this.selectGeometry(pgGeometryIf2);
                            this.update(this);
                            return;
                        }
                        ++n4;
                    }
                    return;
                }
            }
            return;
        }
        this.m_currentCamera.mousePressed(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.mousePressed(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height);
        }
        if ((n = keyEvent.getKeyCode()) == this.m_prevKey) {
            return;
        }
        this.m_prevKey = n;
        if (keyEvent.isShiftDown()) {
            switch (n) {
                case 65: {
                    this.showEdgeAura(!this.isShowingEdgeAura());
                    break;
                }
                case 66: {
                    this.showBndBox(!this.isShowingBndBox());
                    break;
                }
                case 67: {
                    this.setPaintTag(16, !this.hasPaintTag(16));
                    break;
                }
                case 68: {
                    this.showDepthcue(!this.isShowingDepthcue());
                    break;
                }
                case 69: {
                    this.showEdgeAura(!this.isShowingEdgeAura());
                    break;
                }
                case 70: {
                    this.showFrame(!this.isShowingFrame());
                    break;
                }
                case 71: {
                    this.showGrid(!this.isShowingGrid());
                    break;
                }
                case 72: {
                    if (this.hasPaintTag(256)) {
                        PsDebug.showStatus(m_majorModeMessage[this.getMajorMode()]);
                        this.setPaintTag(256, false);
                        break;
                    }
                    PsDebug.showStatus(m_majorModeMessage[7]);
                    this.setPaintTag(256, true);
                    break;
                }
                case 73: {
                    this.showBackImage(!this.isShowingBackImage());
                    break;
                }
                case 76: {
                    this.setPaintTag(4, !this.hasPaintTag(4));
                    break;
                }
                case 77: {
                    this.showMagnet(!this.isShowingMagnet());
                    break;
                }
                case 80: {
                    this.setEnabledPainters(!this.isEnabledPainters());
                    break;
                }
                case 84: {
                    this.setEnabledTags(!this.isEnabledTags());
                    PsDebug.showStatus("tag mode = " + this.isEnabledTags());
                    break;
                }
                case 88: {
                    this.showAxes(!this.isShowingAxes());
                    break;
                }
                case 89: {
                    this.setEnabledFastZBuffer(!this.isEnabledFastZBuffer());
                    break;
                }
                case 90: {
                    this.setEnabledZBuffer(!this.isEnabledZBuffer());
                    break;
                }
                default: {
                    return;
                }
                case 82: 
            }
            this.update(this);
        } else {
            switch (n) {
                case 127: {
                    this.setMinorMode(13);
                    PsDebug.showStatus(m_majorModeMessage[13]);
                    break;
                }
                case 8: {
                    this.setMinorMode(13);
                    PsDebug.showStatus(m_majorModeMessage[13]);
                    break;
                }
                case 65: {
                    this.setMinorMode(12);
                    this.glowVertices(true);
                    this.showMagnet(true);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 67: {
                    PsDebug.showStatus(m_minorModeMessage[1]);
                    this.center();
                    this.repaint();
                    break;
                }
                case 68: {
                    Object object;
                    this.setMinorMode(14);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    if (this.m_currentGeom == null) {
                        PsDebug.warning("missing selected geometry");
                        break;
                    }
                    PiVector piVector = this.m_currentGeom.getTaggedVertices();
                    if (piVector == null || piVector.getSize() == 0) {
                        PsDebug.warning("missing selected vertices");
                        break;
                    }
                    int n5 = piVector.getSize();
                    PdVector[] pdVectorArray = new PdVector[n5];
                    int n6 = 0;
                    while (n6 < n5) {
                        pdVectorArray[n6] = this.m_currentGeom.getVertex(piVector.getEntry(n6));
                        ++n6;
                    }
                    this.m_currentGeom.untagAllVertices();
                    PdMatrix pdMatrix = null;
                    boolean bl = true;
                    switch (n5) {
                        case 1: {
                            pdMatrix = PuReflect.pointReflect(pdVectorArray[0]);
                            bl = true;
                            break;
                        }
                        case 2: {
                            object = PdVector.subNew(pdVectorArray[1], pdVectorArray[0]);
                            pdMatrix = PuReflect.rotateLine(pdVectorArray[0], (PdVector)object);
                            bl = false;
                            break;
                        }
                        case 3: {
                            pdMatrix = PuReflect.planeReflect(pdVectorArray[0], pdVectorArray[1], pdVectorArray[2]);
                            bl = false;
                            break;
                        }
                        default: {
                            PsDebug.warning("too many selected vertices");
                        }
                    }
                    if (pdMatrix == null || (object = this.getGeometryContainers()) == null) break;
                    int n7 = 0;
                    while (n7 < ((PvGeometry[])object).length) {
                        if (object[n7].isVisible()) {
                            PgGeometryIf pgGeometryIf = object[n7].getGeometry();
                            boolean bl2 = pdMatrix.det33() < 0.0;
                            PgGeometry pgGeometry = pgGeometryIf.reflect(pdMatrix, bl, bl2);
                            this.addGeometry(pgGeometry);
                        }
                        ++n7;
                    }
                    this.update(this);
                    break;
                }
                case 69: {
                    if (this.m_currentGeom == null) {
                        PsDebug.warning("missing selected geometry");
                        break;
                    }
                    this.setMinorMode(15);
                    this.m_newElement = new PiVector();
                    this.glowVertices(true);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 70: {
                    PsDebug.showStatus(m_minorModeMessage[2]);
                    this.fit();
                    this.repaint();
                    break;
                }
                case 72: {
                    if (this.hasPaintTag(256)) {
                        PsDebug.showStatus(m_majorModeMessage[this.getMajorMode()]);
                        this.setPaintTag(256, false);
                        break;
                    }
                    PsDebug.showStatus(m_majorModeMessage[7]);
                    this.setPaintTag(256, true);
                    break;
                }
                case 73: {
                    this.setMinorMode(6);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 77: {
                    this.setMinorMode(9);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 79: {
                    this.setMinorMode(0);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 80: {
                    this.setMinorMode(5);
                    this.showMagnet(true);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 81: {
                    PsDebug.showStatus(m_minorModeMessage[4]);
                    this.setEnabledAnimation(false);
                    this.stop();
                    this.update(this);
                    break;
                }
                case 82: {
                    this.init();
                    PsDebug.showStatus(m_minorModeMessage[0]);
                    break;
                }
                case 83: {
                    this.setMinorMode(1);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 84: {
                    this.setMinorMode(3);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 85: {
                    this.setMinorMode(11);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 87: {
                    PsDebug.showStatus(m_minorModeMessage[3]);
                    this.setEnabledAnimation(true);
                    this.start();
                    this.update(this);
                    break;
                }
                case 88: {
                    this.setMinorMode(2);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 89: {
                    this.m_bNewZBuffer = !this.m_bNewZBuffer;
                    PsDebug.showStatus("new z-buffered rendering = " + this.m_bNewZBuffer);
                    break;
                }
                case 90: {
                    this.setMinorMode(4);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setMode(this.m_mode);
        }
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setMode(this.m_mode);
        }
        this.bDrag = false;
        this.repaint();
    }

    private synchronized void setCurrentGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            this.m_currentGeom = null;
            this.m_geomIf = null;
        } else {
            PgGeometryIf pgGeometryIf;
            if (this.hasPaintTag(2048) && this.m_currentGeom != null && this.m_currentGeom != pvGeometry && !this.m_specialGeom.contains(pgGeometryIf = this.m_currentGeom.getGeometry())) {
                if (pgGeometryIf.isVisible()) {
                    pgGeometryIf.setVisible(false);
                }
                if (this.m_currentGeom.isVisible()) {
                    this.m_currentGeom.setVisible(false);
                }
            }
            this.m_currentGeom = pvGeometry;
            if (!this.m_currentGeom.isVisible()) {
                this.m_currentGeom.setVisible(true);
            }
            this.m_geomIf = pvGeometry.getGeometry();
        }
        if (this.m_currentGeom != null && this.isShowingBndBox()) {
            this.recomputeBndBox();
        }
        if (pvGeometry == null) {
            this.setFrameTitle(null);
            return;
        }
        this.setFrameTitle(this.m_geomIf.getName());
    }

    public void requestPickFocus(PvPickListenerIf pvPickListenerIf) {
        this.m_pickFocus = pvPickListenerIf;
    }

    public void setEnabledAnimation(boolean bl) {
        this.m_bEnableAnimation = bl;
        if (!this.m_bEnableAnimation) {
            this.stop();
        }
    }

    public boolean incrementAutoRotation() {
        this.m_currentCamera.mouseAnimateGeometry();
        this.updateCameraListener(101);
        return true;
    }

    public PvCameraIf[] getCameras() {
        PvCameraIf[] pvCameraIfArray = new PvCameraIf[this.m_camera.size()];
        int n = 0;
        Enumeration enumeration = this.m_camera.elements();
        while (enumeration.hasMoreElements()) {
            pvCameraIfArray[n++] = (PvCameraIf)enumeration.nextElement();
        }
        return pvCameraIfArray;
    }

    public int getAmbientProjection() {
        if (this.m_currentGeom != null) {
            this.m_ambientProj = this.m_currentGeom.getAmbientProjection();
        }
        return this.m_ambientProj;
    }

    public void setAmbientProjection(int n) {
        if (this.m_currentGeom != null) {
            this.m_currentGeom.setAmbientProjection(n);
            if (this.m_geomIf != null) {
                this.m_geomIf.setAmbientProjection(n);
            }
        }
        this.m_ambientProj = n;
    }

    private void scaleBackgroundImage(int n, int n2) {
        int n3;
        int n4;
        double d;
        if (this.m_backImage == null) {
            return;
        }
        double d2 = (0.5 + (double)n) / (double)n2;
        double d3 = this.m_backImage.getWidth(null);
        double d4 = (0.5 + d3) / (d = (double)this.m_backImage.getHeight(null));
        if (d2 < d4) {
            n4 = -1;
            n3 = n2;
        } else {
            n4 = n;
            n3 = -1;
        }
        this.m_backImage = this.m_backImage.getScaledInstance(n4, n3, 2);
    }

    public void setEnabledClearScreen(boolean bl) {
        this.setPaintTag(8192, bl);
        this.update(this);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_bMouseInside = false;
    }

    public boolean isShowingEdgeAura() {
        return this.m_bShowEdgeAura;
    }

    public void showEdgeAura(boolean bl) {
        this.m_bShowEdgeAura = bl;
    }

    public Dimension getSize() {
        Dimension dimension = super.getSize();
        return dimension;
    }

    public boolean isEnabledZBuffer() {
        return this.m_bEnableZBuffer;
    }

    public boolean isEnabledFastZBuffer() {
        return this.m_bEnableFastZBuffer;
    }

    public static void setDefaultSize(Dimension dimension) {
        PvDisplay.m_defSize.height = dimension.height;
        PvDisplay.m_defSize.width = dimension.width;
    }

    public void setEnabledPainters(boolean bl) {
        this.m_bEnableSorting = bl;
    }

    private void setMinorMode(int n) {
        this.m_mode = n;
        switch (this.m_mode) {
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                return;
            }
            case 1: {
                this.setCursor(Cursor.getPredefinedCursor(9));
                return;
            }
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                return;
            }
            case 4: {
                this.setCursor(Cursor.getPredefinedCursor(7));
                return;
            }
            case 0: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean isShowingGrid() {
        return this.m_bShowGrid;
    }

    public void showGrid(boolean bl) {
        this.m_bShowGrid = bl;
        if (this.m_bShowGrid) {
            if (!this.m_specialGeom.containsKey(GEOM_XY_GRID)) {
                PvGrid pvGrid = new PvGrid(3);
                pvGrid.setName(PsConfig.getMessage(GEOM_XY_GRID));
                this.addGeometry(pvGrid, -1);
                this.m_specialGeom.put(GEOM_XY_GRID, pvGrid);
            }
        } else if (this.m_specialGeom.containsKey(GEOM_XY_GRID)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_XY_GRID));
            this.m_specialGeom.remove(GEOM_XY_GRID);
        }
        this.update(this);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (!this.updatePosition(n2, n = mouseEvent.getY())) {
            return;
        }
        this.m_currLoc.width = n2;
        this.m_currLoc.height = this.m_nHeight - 1 - n;
        if (this.bDrag) {
            if ((Math.abs(this.xUp - n2) > 0 || Math.abs(this.yUp - n) > 0) && this.isEnabledAnimation()) {
                this.start();
            }
            this.bDrag = false;
        }
        if (this.hasPaintTag(256)) {
            this.repaint();
        }
        if (this.m_currentGeom != null && this.hasPaintTag(4096)) {
            boolean bl = false;
            if (this.m_pickedVertex != -1) {
                this.m_currentGeom.releaseVertex(this.m_pickedVertex);
                bl = true;
            }
            this.m_pickedVertex = this.m_currentGeom.pickVertex(n2, n);
            if (this.m_pickedVertex != -1) {
                bl = true;
            }
            if (bl) {
                this.repaint();
            }
        }
    }

    public boolean hasPickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_pickListener == null) {
            return false;
        }
        return this.m_pickListener.contains(pvPickListenerIf);
    }

    public boolean removePickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_pickListener == null) {
            return false;
        }
        return this.m_pickListener.removeElement(pvPickListenerIf);
    }

    public void center() {
        if (this.m_scene == null) {
            return;
        }
        PdVector[] pdVectorArray = this.m_scene.getBounds();
        if (pdVectorArray == null) {
            return;
        }
        PdVector pdVector = new PdVector(3);
        pdVector.blend(0.5, pdVectorArray[0], 0.5, pdVectorArray[1]);
        this.m_currentCamera.setInterest(pdVector);
        this.m_currentCamera.updatePanels(this.m_currentCamera);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        }
        this.updateCameraListener(101);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            return;
        }
        this.m_prevKey = -1;
        this.setMinorMode(this.m_modeMajor);
        this.m_currentCamera.mousePressed(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height);
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setMode(this.m_mode);
        }
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setMode(this.m_mode);
        }
        PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
        this.bDrag = false;
        if (!keyEvent.isShiftDown()) {
            switch (keyEvent.getKeyCode()) {
                case 65: {
                    this.glowVertices(false);
                    this.showMagnet(false);
                    return;
                }
                case 69: {
                    if (this.m_currentGeom == null) {
                        PsDebug.warning("missing selected geometry");
                        return;
                    }
                    if (this.m_newElement != null && this.m_newElement.getSize() > 0) {
                        this.m_currentGeom.addGeometryElement(this.m_newElement);
                        this.m_currentGeom.untagAllVertices();
                        this.m_geomIf.update(this.m_geomIf);
                    }
                    this.m_newElement = null;
                    this.glowVertices(false);
                    return;
                }
                case 80: {
                    this.showMagnet(false);
                    return;
                }
                case 77: 
                case 85: 
                case 88: {
                    this.repaint();
                    return;
                }
            }
        }
    }

    public double getFarClip() {
        return this.m_currentCamera.m_farClip.getValue();
    }

    public void setFarClip(double d) {
        this.m_currentCamera.m_farClip.setValue(d);
    }

    public boolean selectGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf != null && !this.containsGeometry(pgGeometryIf)) {
            PsDebug.warning("geometry=" + pgGeometryIf.getName() + " not registered in display");
            return false;
        }
        this.setCurrentGeometry(this.m_scene.getGeometry(pgGeometryIf));
        if (this.m_currentGeom != null) {
            if (this.getTransformationMode() == 1) {
                if (this.m_currentGeom.hasModelMatrix()) {
                    this.m_modelCamera.setModelMatrix(this.m_currentGeom.getModelMatrix());
                } else {
                    this.setTransformationMode(0);
                }
            } else if (this.getTransformationMode() == 2) {
                if (this.m_currentGeom.hasAmbientMatrix()) {
                    this.m_modelCamera.setAmbientMatrix(this.m_currentGeom.getAmbientMatrix(), this.m_currentGeom.getAmbientInvMatrix());
                } else {
                    this.setTransformationMode(0);
                }
            }
            this.setAmbientSpace(this.m_currentGeom.getAmbientSpace());
            this.setAmbientProjection(this.m_currentGeom.getAmbientProjection());
            if (this.isShowingFrame() && this.m_ambientDim != this.m_coordFrame.getDimOfVertices()) {
                this.updateCoordFrame(this.m_ambientDim, this.m_ambientSpace, this.m_ambientProj);
                this.update(this.m_coordFrame);
            }
        }
        if (this.m_viewer != null) {
            this.m_viewer.setGeometry(pgGeometryIf);
        }
        this.m_scene.selectGeometry(this.m_currentGeom);
        this.m_currentCamera.updatePanels(this.m_currentCamera);
        return true;
    }

    public void removeGeometries() {
        PvGeometry[] pvGeometryArray = this.getGeometryContainers();
        if (pvGeometryArray == null) {
            return;
        }
        int n = 0;
        while (n < pvGeometryArray.length) {
            PgGeometryIf pgGeometryIf = pvGeometryArray[n].getGeometry();
            pgGeometryIf.removeDisplay(this);
            this.m_scene.removeGeometry(pvGeometryArray[n]);
            ++n;
        }
        this.m_currentGeom = null;
    }

    public boolean isEnabledAnimation() {
        return this.m_bEnableAnimation;
    }

    public Point getPosition(int n, int n2) {
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return new Point(0, 0);
        }
        return frame.getLocation();
    }

    public void setDrawingOrder(int n, PgGeometryIf pgGeometryIf) {
        if (!this.containsGeometry(pgGeometryIf)) {
            if (pgGeometryIf != null) {
                PsDebug.warning("geometry=" + pgGeometryIf.getName() + " not registered in listener");
            }
            return;
        }
        PvGeometry pvGeometry = this.m_scene.getGeometry(pgGeometryIf);
        this.m_scene.removeGeometry(pvGeometry);
        pvGeometry.setDrawingOrder(n);
        this.m_scene.addGeometry(pvGeometry);
    }

    public void setPosition(int n, int n2) {
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return;
        }
        ((Component)frame).setLocation(n, n2);
    }

    public PvCameraIf getCamera() {
        return this.m_currentCamera;
    }

    public PvCameraIf getCamera(int n) {
        if (n < 0 || PvDisplayIf.CAMERA_NAME.length <= n) {
            PsDebug.warning("camera type out of range = " + n);
            return this.m_currentCamera;
        }
        return (PvCamera)this.m_camera.get(PvDisplayIf.CAMERA_NAME[n]);
    }

    public boolean selectCamera(int n) {
        if (n < 0 || PvDisplayIf.CAMERA_NAME.length <= n) {
            return false;
        }
        if (this.getCamera(n) == null) {
            this.addCamera(PvDisplayIf.CAMERA_NAME[n], new PvCamera(this, n));
        }
        this.m_currentCamera = (PvCamera)this.getCamera(n);
        this.m_currentCamera.resizeImage(this.m_nWidth, this.m_nHeight);
        this.m_currentCamera.setMode(this.m_mode);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        }
        if (this.m_cameraPanel != null) {
            if (!this.m_currentCamera.hasInspector("Info")) {
                this.m_currentCamera.addInspector("Info", this.m_cameraPanel);
            } else {
                this.m_cameraPanel.setParent(this.m_currentCamera);
                this.m_cameraPanel.update(this.m_currentCamera);
            }
        }
        this.updateCameraListener(101);
        return true;
    }

    public boolean hasAxes() {
        return this.m_axes != null;
    }

    protected int getAmbientDim() {
        return this.m_ambientDim;
    }

    public int getImageFitMode() {
        return this.m_imageFitMode;
    }

    public void setImageFitMode(int n) {
        this.m_imageFitMode = n;
    }

    private void glowVertices(boolean bl) {
        if (this.m_currentGeom == null) {
            return;
        }
        if (bl) {
            this.m_bSaveShowingVertices = this.m_currentGeom.getState(50);
        }
        if (this.m_bSaveShowingVertices) {
            return;
        }
        this.m_currentGeom.setStateFromDisplay(50, bl);
        this.m_geomIf.update(null);
        this.repaint();
    }

    public boolean update(Object object) {
        block24: {
            if (!this.isEnabledUpdate()) {
                return true;
            }
            if (object == this.m_sleep) {
                return true;
            }
            PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
            if (pvGeometryArray == null || pvGeometryArray.length <= 0) break block24;
            int n = 0;
            while (n < pvGeometryArray.length) {
                block25: {
                    if (pvGeometryArray[n].getGeometry() != object) break block25;
                    if (!pvGeometryArray[n].getName().startsWith(pvGeometryArray[n].getGeometry().getName()) && this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                        this.m_infoPanel.update(this);
                    }
                    PvScene pvScene = this.m_scene;
                    synchronized (pvScene) {
                        pvGeometryArray[n].update(object);
                        if (this.m_currentGeom == pvGeometryArray[n]) {
                            if (this.isShowingBndBox()) {
                                this.recomputeBndBox();
                            }
                            if (this.m_geomIf == null) {
                                this.setFrameTitle(null);
                            } else {
                                this.setFrameTitle(this.m_geomIf.getName());
                            }
                            if (this.m_currentGeom.getAmbientSpace() != this.m_ambientSpace) {
                                this.setAmbientSpace(this.m_currentGeom.getAmbientSpace());
                            }
                            if (this.m_currentGeom.getAmbientProjection() != this.m_ambientProj) {
                                this.setAmbientProjection(this.m_currentGeom.getAmbientProjection());
                            }
                            if (this.m_cameraPanel != null && this.m_cameraPanel.isShowing()) {
                                this.m_cameraPanel.update(this.m_currentCamera);
                            }
                        }
                        this.m_scene.update(pvGeometryArray[n]);
                        Object var5_5 = null;
                    }
                    this.repaint();
                    return true;
                }
                ++n;
            }
        }
        if (object == this) {
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                this.m_infoPanel.update(this);
            }
        } else if (object != this.m_infoPanel) {
            if (object == this.m_currentCamera) {
                this.updateCameraListener(101);
            } else if (object != this.m_backgroundColor && object != this.m_foregroundColor) {
                if (object == this.m_height || object == this.m_width) {
                    this.setSizeWithinFrame(this.m_width.getValue(), this.m_height.getValue());
                } else if (object != null) {
                    PsDebug.warning("could not handle event = ???\n\tmissing implementation of update(Object)");
                    return false;
                }
            }
        }
        this.repaint();
        return true;
    }

    public boolean isEnabledUpdate() {
        return this.m_bIsEnabledUpdate;
    }

    public void update(Graphics graphics) {
        if (!this.hasPaintTag(1)) {
            return;
        }
        this.m_bDrawing = true;
        if (this.resizeImage()) {
            this.paintGeom(this.m_g);
            if (this.m_image != null) {
                graphics.drawImage(this.m_image, 0, 0, this);
            }
        }
        this.m_bDrawing = false;
    }

    public PdMatrix getTransMatrix(int n) {
        boolean bl;
        boolean bl2 = bl = this.getTransformationMode() == 0;
        if (!bl && this.m_currentGeom != null) {
            this.m_currentGeom.setModelMatrix(this.m_modelCamera.getModelMatrix());
            if (this.getTransformationMode() == 2) {
                this.m_currentGeom.setAmbientMatrix(this.m_modelCamera.getAmbientMatrix(), this.m_modelCamera.getAmbientInvMatrix());
                this.m_currentGeom.setAmbientProjection(this.m_ambientProj);
            }
        }
        this.setEnabledModelOfSpecials(!bl);
        boolean bl3 = true;
        if (this.isShowingBndBox()) {
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_BNDBOX), bl3);
        }
        if (this.isShowingAxes()) {
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_AXES), bl3);
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_AXES + "_0"), bl3);
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_AXES + "_1"), bl3);
            this.setEnabledModelOfSpecial((PgGeometryIf)this.m_specialGeom.get(GEOM_AXES + "_2"), bl3);
        }
        switch (n) {
            case 0: {
                return this.m_currentCamera.m_trans;
            }
            case 16: {
                return this.m_currentCamera.m_transInv;
            }
            case 1: {
                return this.m_currentCamera.m_trans;
            }
            case 32: {
                return this.m_currentCamera.m_transInv;
            }
            case 2: {
                return this.m_currentCamera.m_proj;
            }
            case 64: {
                return this.m_currentCamera.m_projInv;
            }
            case 4: {
                return this.m_currentCamera.m_view;
            }
            case 128: {
                return this.m_currentCamera.m_viewInv;
            }
            case 8: {
                if (this.m_modelCamera != null) {
                    return this.m_modelCamera.getModelMatrix();
                }
                return null;
            }
            case 256: {
                if (this.m_modelCamera != null) {
                    return this.m_modelCamera.getModelInvMatrix();
                }
                return null;
            }
            case 512: {
                if (this.m_modelCamera != null) {
                    return this.m_modelCamera.getAmbientMatrix();
                }
                return null;
            }
            case 1024: {
                if (this.m_modelCamera != null) {
                    return this.m_modelCamera.getAmbientInvMatrix();
                }
                return null;
            }
        }
        PsDebug.warning("unknown matrix type.");
        return null;
    }

    public void setTransMatrix(int n, PdMatrix pdMatrix) {
        switch (n) {
            case 0: {
                this.m_currentCamera.m_trans.copy(pdMatrix);
                break;
            }
            case 16: {
                this.m_currentCamera.m_transInv.copy(pdMatrix);
                break;
            }
            case 1: {
                this.m_currentCamera.m_trans.copy(pdMatrix);
                break;
            }
            case 32: {
                this.m_currentCamera.m_transInv.copy(pdMatrix);
                break;
            }
            case 2: {
                this.m_currentCamera.m_proj.copy(pdMatrix);
                break;
            }
            case 64: {
                this.m_currentCamera.m_projInv.copy(pdMatrix);
                break;
            }
            case 4: {
                this.m_currentCamera.m_view.copy(pdMatrix);
                break;
            }
            case 128: {
                this.m_currentCamera.m_viewInv.copy(pdMatrix);
                break;
            }
            default: {
                PsDebug.warning("unknown matrix type.");
            }
        }
        this.updateCameraListener(101);
    }

    private void setFrameTitle(String string) {
        if (string != null && this.m_currentFrameName != null && this.m_currentFrameName.equals(string)) {
            return;
        }
        this.m_currentFrameName = string;
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return;
        }
        if (this.m_currentFrameName != null) {
            frame.setTitle(PsConfig.getProgram() + " v" + PsConfig.getVersion() + ": " + this.m_currentFrameName);
            return;
        }
        frame.setTitle(PsConfig.getProgram() + " v" + PsConfig.getVersion() + ": ");
    }

    public String getBackgroundImageFile() {
        return this.m_backgroundImage;
    }

    private void updateCoordFrame(int n, int n2, int n3) {
        if (this.m_coordFrame == null) {
            PsDebug.warning("missing coordinate frame, must call showFrame(true) before.");
            return;
        }
        this.m_coordFrame.setAmbientSpace(n2);
        this.m_coordFrame.setAmbientProjection(n3);
        this.m_coordFrame.setDimOfVertices(n);
        this.m_coordFrame.setNumVertices(n + 1);
        this.m_coordFrame.setDimOfPolygons(2);
        this.m_coordFrame.setNumPolygons(n);
        String[] stringArray = new String[]{"X", "Y", "Z", "T", "U", "V", "W"};
        int n4 = 0;
        while (n4 < n) {
            PdVector pdVector = this.m_coordFrame.getVertex(n4 + 1);
            pdVector.setEntry(n4, 1.0);
            pdVector.setName(stringArray[n4]);
            this.m_coordFrame.getPolygon(n4).set(0, n4 + 1);
            ++n4;
        }
    }

    public boolean hasCameraListener(PvCameraListenerIf pvCameraListenerIf) {
        if (this.m_cameraListener == null) {
            return false;
        }
        return this.m_cameraListener.contains(pvCameraListenerIf);
    }

    public boolean removeCameraListener(PvCameraListenerIf pvCameraListenerIf) {
        if (this.m_cameraListener == null) {
            return false;
        }
        return this.m_cameraListener.removeElement(pvCameraListenerIf);
    }

    private void recomputeBndBox() {
        PvGeometry pvGeometry;
        PgJvxSrc pgJvxSrc = (PgJvxSrc)this.m_specialGeom.get(GEOM_BNDBOX);
        if (this.m_currentGeom == null || this.m_currentGeom.getGeometry() == pgJvxSrc) {
            return;
        }
        PdVector[] pdVectorArray = this.m_currentGeom.getBounds();
        if (pdVectorArray == null) {
            return;
        }
        if (pgJvxSrc.isShowingBackface()) {
            pgJvxSrc.showBackface(false);
        }
        pgJvxSrc.setVertex(0, pdVectorArray[0]);
        pgJvxSrc.setVertex(1, new PdVector(pdVectorArray[1].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[0].m_data[2]));
        pgJvxSrc.setVertex(2, new PdVector(pdVectorArray[1].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[0].m_data[2]));
        pgJvxSrc.setVertex(3, new PdVector(pdVectorArray[0].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[0].m_data[2]));
        pgJvxSrc.setVertex(4, new PdVector(pdVectorArray[0].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[1].m_data[2]));
        pgJvxSrc.setVertex(5, new PdVector(pdVectorArray[1].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[1].m_data[2]));
        pgJvxSrc.setVertex(6, pdVectorArray[1]);
        pgJvxSrc.setVertex(7, new PdVector(pdVectorArray[0].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[1].m_data[2]));
        pgJvxSrc.makeElementNormals();
        if (this.m_scene != null && (pvGeometry = this.m_scene.getGeometry(pgJvxSrc)) != null) {
            pvGeometry.update(pgJvxSrc);
        }
    }

    private void setEnabledModelOfSpecial(PgGeometryIf pgGeometryIf, boolean bl) {
        PdMatrix pdMatrix;
        PdMatrix pdMatrix2;
        PdMatrix pdMatrix3;
        if (pgGeometryIf == null) {
            return;
        }
        PvGeometry pvGeometry = this.m_scene.getGeometry(pgGeometryIf);
        if (pvGeometry == null) {
            return;
        }
        if (!bl) {
            pvGeometry.setModelMatrix(null);
            pvGeometry.setAmbientMatrix(null, null);
            return;
        }
        if (this.m_currentGeom != null) {
            pdMatrix3 = this.m_currentGeom.getAmbientMatrix();
            pdMatrix2 = this.m_currentGeom.getAmbientInvMatrix();
            pdMatrix = this.m_currentGeom.getModelMatrix();
        } else if (this.m_modelCamera != null) {
            pdMatrix3 = this.m_modelCamera.getAmbientMatrix();
            pdMatrix2 = this.m_modelCamera.getAmbientInvMatrix();
            pdMatrix = this.m_modelCamera.getModelMatrix();
        } else {
            return;
        }
        pvGeometry.setModelMatrix(pdMatrix);
        if (this.getTransformationMode() == 2) {
            pvGeometry.setAmbientMatrix(pdMatrix3, pdMatrix2);
            pvGeometry.setAmbientProjection(this.m_ambientProj);
        } else {
            pvGeometry.setAmbientMatrix(null, null);
        }
        PgGeometryIf pgGeometryIf2 = pvGeometry.getGeometry();
        if (pgGeometryIf2 == null) {
            return;
        }
        pgGeometryIf2.setModelMatrix(pdMatrix);
        if (this.getTransformationMode() == 2) {
            pgGeometryIf2.setAmbientMatrix(pdMatrix3, pdMatrix2);
            pgGeometryIf2.setAmbientProjection(this.m_ambientProj);
            return;
        }
        pgGeometryIf2.setAmbientMatrix(null, null);
    }

    public boolean addGeometry(PgGeometryIf pgGeometryIf) {
        return this.addGeometry(pgGeometryIf, 0);
    }

    private boolean addGeometry(PgGeometryIf pgGeometryIf, int n) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing geometry.");
            return false;
        }
        if (this.containsGeometry(pgGeometryIf)) {
            return true;
        }
        pgGeometryIf.addDisplay(this);
        PvGeometry pvGeometry = new PvGeometry(pgGeometryIf.getDimOfVertices());
        pvGeometry.setDrawingOrder(n);
        pvGeometry.setDisplay(this);
        pvGeometry.setGeometry(pgGeometryIf);
        this.m_scene.addGeometry(pvGeometry);
        if (this.m_scene.m_numGeometries == 0 && n != 0) {
            this.setCurrentGeometry(pvGeometry);
        }
        if (this.m_scene.m_numGeometries == 1 && n == 0) {
            this.setCurrentGeometry(pvGeometry);
            if (!this.m_bCentered) {
                this.fit();
            }
        }
        return true;
    }

    public boolean isEnabledTags() {
        return this.m_bEnableTag;
    }

    public void setAutoRotation(PdVector pdVector, double d) {
        if (!PuReflect.makeRotation(this.m_currentCamera.m_incrView, pdVector, d)) {
            return;
        }
        if (this.getTransformationMode() == 0) {
            this.m_currentCamera.m_incrViewInv.transpose(this.m_currentCamera.m_incrView);
            return;
        }
        this.m_modelCamera.m_incrModelInv.transpose(this.m_currentCamera.m_incrView);
    }

    protected boolean updatePosition(int n, int n2) {
        if (this.m_nWidth == 0 || this.m_nHeight == 0) {
            return false;
        }
        return this.m_currLoc.width != n || this.m_currLoc.height != this.m_nHeight - 1 - n2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Enumeration enumeration;
        Object object;
        if (this.m_bEnableFastZBuffer && this.m_bEnableZBuffer) {
            this.m_bSaveEnableZBuffer = this.m_bEnableZBuffer;
            this.m_bEnableZBuffer = false;
        }
        this.m_bFirstAfterPick = true;
        this.m_bMouseShiftConstraint = false;
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        this.m_pickedVertex = -1;
        this.bDrag = false;
        if (this.m_viewer != null) {
            this.m_viewer.selectDisplay(this);
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!this.m_bMouseInside || this.m_nWidth == 0 || this.m_nHeight == 0 || n < 0 || n2 < 0 || this.m_nWidth <= n || this.m_nHeight <= n2) {
            return;
        }
        this.m_currLoc.width = n;
        this.m_currLoc.height = this.m_nHeight - 1 - n2;
        this.m_bMouseDown = true;
        this.xDown = n;
        this.yDown = n2;
        this.m_markBox.m_data[0] = n;
        this.m_markBox.m_data[1] = n2;
        this.m_markBox.m_data[2] = n;
        this.m_markBox.m_data[3] = n2;
        if (this.m_thread != null) {
            this.stop();
        }
        this.m_currentCamera.mousePressed(n, n2);
        if (this.getTransformationMode() != 0) {
            this.m_modelCamera.mousePressed(n, n2);
        }
        this.updateCameraListener(101);
        if (mouseEvent != null && mouseEvent.isControlDown()) {
            object = this.getAllGeometryContainers();
            if (object == null || ((PvGeometry[])object).length == 0) {
                return;
            }
            enumeration = new PdVector(((PvGeometry[])object).length);
            int n3 = 0;
            while (n3 < ((PvGeometry[])object).length) {
                if (object[n3].isVisible()) {
                    PdVector[] pdVectorArray = this.getWorldFromPixel(n, n2, 10000);
                    this.getModelFromWorld((PvGeometry)object[n3], pdVectorArray[0], pdVectorArray[1]);
                    pdVectorArray[0].setSize(3);
                    pdVectorArray[1].setSize(3);
                    pdVectorArray[1].normalize();
                    PvPickEvent pvPickEvent = ((PvGeometry)object[n3]).getGeometry().intersectionWithLine(pdVectorArray[0], pdVectorArray[1]);
                    if (pvPickEvent == null) {
                        ((PdVector)((Object)enumeration)).setEntry(n3, Double.MAX_VALUE);
                    } else {
                        ((PdVector)((Object)enumeration)).setEntry(n3, pvPickEvent.getDistance());
                    }
                }
                ++n3;
            }
            n3 = ((PdVector)((Object)enumeration)).indexOfMin();
            if (((PdVector)((Object)enumeration)).getEntry(n3) != Double.MAX_VALUE) {
                this.selectGeometry(((PvGeometry)object[n3]).getGeometry());
                this.update(this);
                return;
            }
        }
        if (this.m_mode == 12 || this.m_mode == 15) {
            if (this.m_currentGeom == null) {
                return;
            }
            this.m_pickedVertex = this.m_currentGeom.pickVertex(n, n2);
            if (this.m_pickedVertex == -1) {
                object = this.getWorldFromPixel(n, n2, 0);
                this.getModelFromWorld(this.m_currentGeom, (PdVector)object[0], (PdVector)object[1]);
                this.m_pickedVertex = this.m_currentGeom.addGeometryVertex((PdVector)object[0]);
                PsDebug.showStatus("new vertex[" + this.m_pickedVertex + "] = (" + ((PdVector)object[0]).m_data[0] + "," + ((PdVector)object[0]).m_data[1] + "," + ((PdVector)object[0]).m_data[2] + "," + ((PdVector)object[0]).m_data[3]);
            } else {
                this.m_pick.copyArray(this.m_currentGeom.m_vertexTrans[this.m_pickedVertex]);
            }
            if (this.m_newElement != null) {
                this.m_newElement.addEntry(this.m_pickedVertex);
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.repaint();
            return;
        }
        if (this.m_mode == 6) {
            if (this.m_pickListener == null || this.m_pickListener.size() == 0) {
                return;
            }
            object = this.getPickEvent(n, n2);
            if (this.m_pickFocus != null) {
                this.m_pickFocus.pickInitial((PvPickEvent)object);
                return;
            }
            if (this.m_pickListener != null) {
                enumeration = this.m_pickListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((PvPickListenerIf)enumeration.nextElement()).pickInitial((PvPickEvent)object);
                }
                return;
            }
        } else if (this.m_mode == 8) {
            if (this.m_pickListener == null || this.m_pickListener.size() == 0) {
                return;
            }
            object = this.getPickEvent(n, n2);
            if (this.m_pickFocus != null) {
                this.m_pickFocus.pickDisplay((PvPickEvent)object);
                return;
            }
            if (this.m_pickListener != null) {
                enumeration = this.m_pickListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((PvPickListenerIf)enumeration.nextElement()).pickDisplay((PvPickEvent)object);
                }
                return;
            }
        } else {
            if (this.m_mode == 10) {
                if (this.m_currentGeom == null) {
                    return;
                }
                object = this.getPickEvent(n, n2);
                int n4 = ((PvPickEvent)object).getElementInd();
                if (n4 == -1) {
                    return;
                }
                PiVector piVector = this.m_geomIf.getElement(n4);
                if (piVector == null) {
                    return;
                }
                if (piVector.hasTag(1)) {
                    piVector.clearTag(1);
                } else {
                    piVector.setTag(1);
                }
                this.m_geomIf.update(this.m_geomIf);
                this.bDrag = false;
                this.repaint();
                return;
            }
            if (this.m_mode == 5) {
                if (this.m_currentGeom == null) {
                    return;
                }
                this.m_pickedVertex = this.m_currentGeom.pickVertex(n, n2);
                if (this.m_pickedVertex == -1) {
                    return;
                }
                this.m_pick.copyArray(this.m_currentGeom.m_vertexTrans[this.m_pickedVertex]);
                object = this.m_currentGeom.getVertex(this.m_pickedVertex);
                if (this.m_pickFocus != null) {
                    this.m_pickFocus.pickVertex(this.m_geomIf, this.m_pickedVertex, (PdVector)object);
                } else if (this.m_pickListener != null) {
                    enumeration = this.m_pickListener.elements();
                    while (enumeration.hasMoreElements()) {
                        ((PvPickListenerIf)enumeration.nextElement()).pickVertex(this.m_geomIf, this.m_pickedVertex, (PdVector)object);
                    }
                }
                this.repaint();
                return;
            }
            if (this.m_mode == 9 || this.m_mode == 2 || this.m_mode == 11) {
                // empty if block
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (this.m_bFirstAfterPick) {
            this.m_bFirstAfterPick = false;
            try {
                Thread.sleep(this.m_sleep.getValue());
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        int n2 = mouseEvent.getX();
        if (!this.updatePosition(n2, n = mouseEvent.getY())) {
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (!this.m_bMouseShiftConstraint) {
                this.m_mouseShiftConstraint = Math.abs(n2 - this.xDown) >= Math.abs(n - this.yDown) ? 2 : 1;
                this.m_bMouseShiftConstraint = true;
            }
            if (this.m_bMouseShiftConstraint && this.m_mode != 9 && this.m_mode != 11 && this.m_mode != 10 && this.m_mode != 2) {
                if (this.m_mouseShiftConstraint == 2) {
                    n = this.yDown;
                } else {
                    n2 = this.xDown;
                }
            }
        }
        this.m_markBox.m_data[2] = n2;
        this.m_markBox.m_data[3] = n;
        this.m_currLoc.width = n2;
        this.m_currLoc.height = this.m_nHeight - 1 - n;
        PvDisplay.normalizedCoordsFromViewport(this.m_currNormLoc, n2, n, this.m_nWidth, this.m_nHeight);
        if (this.m_mode == 12 || this.m_mode == 15) {
            if (this.m_pickedVertex == -1 || this.m_currentGeom == null) {
                return;
            }
            PdVector[] pdVectorArray = this.getWorldFromPixel(n2, n, this.m_pick.getEntry(2));
            this.getModelFromWorld(this.m_currentGeom, pdVectorArray[0], pdVectorArray[1]);
            this.m_currentGeom.setGeometryVertex(this.m_pickedVertex, pdVectorArray[0]);
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            PsDebug.showStatus("move vertex[" + this.m_pickedVertex + "] = (" + pdVectorArray[0].m_data[0] + "," + pdVectorArray[0].m_data[1] + "," + pdVectorArray[0].m_data[2] + "," + pdVectorArray[0].m_data[3]);
            this.repaint();
        } else if (this.m_mode == 6) {
            if (this.m_bDrawing) {
                return;
            }
            if (this.m_pickListener != null && this.m_pickListener.size() > 0) {
                PvPickEvent pvPickEvent = this.getPickEvent(n2, n);
                if (this.m_pickFocus != null) {
                    this.m_pickFocus.dragInitial(pvPickEvent);
                } else if (this.m_pickListener != null) {
                    Enumeration enumeration = this.m_pickListener.elements();
                    while (enumeration.hasMoreElements()) {
                        ((PvPickListenerIf)enumeration.nextElement()).dragInitial(pvPickEvent);
                    }
                }
            }
        } else if (this.m_mode == 8) {
            if (this.m_pickListener != null && this.m_pickListener.size() > 0) {
                PvPickEvent pvPickEvent = this.getPickEvent(n2, n);
                if (this.m_pickFocus != null) {
                    this.m_pickFocus.dragDisplay(pvPickEvent);
                } else if (this.m_pickListener != null) {
                    Enumeration enumeration = this.m_pickListener.elements();
                    while (enumeration.hasMoreElements()) {
                        ((PvPickListenerIf)enumeration.nextElement()).dragDisplay(pvPickEvent);
                    }
                }
            }
        } else if (this.m_mode == 5) {
            Object object;
            if (this.m_pickedVertex == -1 || this.m_currentGeom == null) {
                return;
            }
            if (!this.m_currentGeom.isVisible()) {
                return;
            }
            PdVector[] pdVectorArray = this.getWorldFromPixel(n2, n, this.m_pick.getEntry(2));
            this.getModelFromWorld(this.m_currentGeom, pdVectorArray[0], pdVectorArray[1]);
            PiVector piVector = null;
            if (!this.isEnabledTags() || (piVector = this.m_currentGeom.getTaggedVertices()) == null || piVector.getSize() == 0) {
                this.m_currentGeom.setGeometryVertex(this.m_pickedVertex, pdVectorArray[0]);
            } else {
                object = PdVector.copyNew(pdVectorArray[0]);
                ((PdVector)object).setSize(this.m_currentGeom.getDimOfVertices());
                ((PdVector)object).sub(this.m_currentGeom.getVertex(this.m_pickedVertex));
                int n3 = piVector.getSize();
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = piVector.getEntry(n4);
                    PdVector pdVector = this.m_currentGeom.getVertex(n5);
                    pdVector.add((PdVector)object);
                    this.m_currentGeom.setGeometryVertex(n5, pdVector);
                    ++n4;
                }
            }
            if (this.m_pickFocus != null) {
                this.m_pickFocus.dragVertex(this.m_geomIf, this.m_pickedVertex, pdVectorArray[0]);
            } else if (this.m_pickListener != null) {
                object = this.m_pickListener.elements();
                while (object.hasMoreElements()) {
                    ((PvPickListenerIf)object.nextElement()).dragVertex(this.m_geomIf, this.m_pickedVertex, pdVectorArray[0]);
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
        } else if (this.m_mode != 9 && this.m_mode != 10 && this.m_mode != 2 && this.m_mode != 11) {
            if (this.getTransformationMode() == 0) {
                this.m_currentCamera.mouseDragged(n2, n);
                this.m_currentCamera.updatePanels(this.m_currentCamera);
            } else {
                this.m_modelCamera.mouseDragged(n2, n);
                this.m_modelCamera.updatePanels(this.m_modelCamera);
            }
            this.updateCameraListener(102);
            this.bDrag = true;
        }
        this.repaint();
    }

    public boolean isShowingMagnet() {
        return this.hasPaintTag(4096);
    }

    public void showMagnet(boolean bl) {
        if (!bl && this.m_pickedVertex != -1 && this.m_currentGeom != null) {
            this.m_currentGeom.releaseVertex(this.m_pickedVertex);
        }
        this.m_pickedVertex = -1;
        this.setPaintTag(4096, bl);
    }

    public int addCamera(String string, PvCamera pvCamera) {
        if (string == null || pvCamera == null) {
            PsDebug.warning("missing arguments", this);
            return -1;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < PvDisplayIf.CAMERA_NAME.length) {
            if (PvDisplayIf.CAMERA_NAME[n2].equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return -1;
        }
        this.m_camera.put(string, pvCamera);
        pvCamera.setParent(this);
        pvCamera.setName(string);
        return n;
    }

    private void glowBndbox(boolean bl) {
        if (this.m_bIsGlowingBndbox == bl) {
            return;
        }
        if (bl) {
            this.m_bSaveShowingBndbox = this.isShowingBndBox();
        }
        this.m_bIsGlowingBndbox = bl;
        if (this.m_bSaveShowingBndbox) {
            return;
        }
        this.showBndBox(bl);
        this.repaint();
    }

    public void setMajorMode(int n) {
        this.m_defModeMajor = n;
        this.setCurrentMajorMode(this.m_defModeMajor);
    }

    public int getMajorMode() {
        return this.m_mode;
    }

    protected int getTransformationMode() {
        return this.m_transformationMode;
    }

    protected void setTransformationMode(int n) {
        this.m_transformationMode = n;
        if (this.m_transformationMode == 0) {
            this.m_modelCamera = null;
            return;
        }
        if (this.m_modelCamera == null) {
            this.m_modelCamera = new PvModelCamera(this);
        }
        this.m_modelCamera.setTransformationMode(this.m_transformationMode);
        this.m_modelCamera.resizeImage(this.m_nWidth, this.m_nHeight);
        this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        if (this.m_currentGeom == null) {
            return;
        }
        if (this.m_transformationMode != 0) {
            this.m_modelCamera.setModelMatrix(this.m_currentGeom.getModelMatrix());
        }
        if (this.m_transformationMode == 2) {
            this.m_modelCamera.setAmbientMatrix(this.m_currentGeom.getAmbientMatrix(), this.m_currentGeom.getAmbientInvMatrix());
        }
        if (this.isShowingFrame() && this.m_ambientDim != this.m_coordFrame.getDimOfVertices()) {
            this.updateCoordFrame(this.m_ambientDim, this.m_ambientSpace, this.m_ambientProj);
            this.update(this.m_coordFrame);
        }
    }

    public void setEnabledZBuffer(boolean bl) {
        this.m_bEnableZBuffer = bl;
        this.m_bSaveEnableZBuffer = bl;
        if (bl) {
            this.assureZBuffer(this.m_nWidth, this.m_nHeight);
            return;
        }
        this.m_zBuffer = null;
    }

    protected int[][] getZBuffer() {
        return this.m_zBuffer;
    }

    protected void resetZBuffer() {
        this.assureZBuffer(this.m_nWidth, this.m_nHeight);
        int n = 0;
        while (n < this.m_nHeight) {
            System.arraycopy(this.m_zBuffer[this.m_nHeight], 0, this.m_zBuffer[n], 0, this.m_nWidth);
            ++n;
        }
    }

    public void setEnabledFastZBuffer(boolean bl) {
        this.m_bEnableFastZBuffer = bl;
    }

    private void assureZBuffer(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (this.m_zBuffer != null && this.m_zBuffer.length == n2 + 1 && this.m_zBuffer[0].length == n) {
            return;
        }
        this.m_zBuffer = new int[n2 + 1][n];
        int n3 = 0;
        while (n3 < n) {
            this.m_zBuffer[n2][n3] = Integer.MIN_VALUE;
            ++n3;
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = 350;
        dimension.height = 350;
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = 350;
        dimension.height = 350;
        return dimension;
    }

    protected PvGeometry[] getGeometryContainers() {
        PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
        if (pvGeometryArray == null) {
            return null;
        }
        int n = pvGeometryArray.length - this.m_specialGeom.size();
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            PsDebug.warning("special geometries not unregistered.");
            return null;
        }
        PvGeometry[] pvGeometryArray2 = new PvGeometry[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < pvGeometryArray.length) {
            if (!this.m_specialGeom.contains(pvGeometryArray[n3].getGeometry())) {
                pvGeometryArray2[n2++] = pvGeometryArray[n3];
            }
            ++n3;
        }
        return pvGeometryArray2;
    }
}

