/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Graphics;
import jv.vecmath.PiVector;
import jv.viewer.PvGeometry;

final class PvThickGraphics {
    private static PiVector xCorners = new PiVector(4);
    private static PiVector yCorners = new PiVector(4);

    public static void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        n2 -= (n *= PvGeometry.PS_ZOOM) / 2;
        n3 -= n / 2;
        n4 += n;
        n5 += n;
        n /= PvGeometry.PS_ZOOM;
        int n6 = 0;
        while (n6 < n) {
            graphics.drawRect(n2, n3, n4, n5);
            n2 += PvGeometry.PS_ZOOM;
            n3 += PvGeometry.PS_ZOOM;
            n4 -= 2 * PvGeometry.PS_ZOOM;
            n5 -= 2 * PvGeometry.PS_ZOOM;
            ++n6;
        }
    }

    public static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n == 1) {
            graphics.drawLine(n2, n3, n4, n5);
            return;
        }
        double d = (double)(n *= PvGeometry.PS_ZOOM) / 2.0;
        double d2 = n4 - n2;
        double d3 = n3 - n5;
        double d4 = n2 == n4 ? 0.0 : Math.atan(d3 / d2) - 1.5707963267948966;
        int n6 = (int)(d * Math.cos(d4));
        int n7 = (int)(d * Math.sin(d4));
        int[] nArray = new int[]{n2 + n6, n4 + n6, n4 - n6, n2 - n6};
        int[] nArray2 = new int[]{n3 - n7, n5 - n7, n5 + n7, n3 + n7};
        graphics.fillPolygon(nArray, nArray2, 4);
        if (n > 3 * PvGeometry.PS_ZOOM) {
            int n8 = (int)d;
            graphics.fillOval(n2 - n8, n3 - n8, n - PvGeometry.PS_ZOOM, n - PvGeometry.PS_ZOOM);
            graphics.fillOval(n4 - n8, n5 - n8, n - PvGeometry.PS_ZOOM, n - PvGeometry.PS_ZOOM);
        }
    }

    public static void drawOval(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        n2 -= (n *= PvGeometry.PS_ZOOM) / 2;
        n3 -= n / 2;
        n4 += n;
        n5 += n;
        n /= PvGeometry.PS_ZOOM;
        int n6 = 0;
        while (n6 < n) {
            graphics.drawOval(n2, n3, n4, n5);
            if (n6 + 1 < n) {
                graphics.drawOval(n2, n3, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM);
                graphics.drawOval(n2 + PvGeometry.PS_ZOOM, n3, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM);
                graphics.drawOval(n2, n3 + PvGeometry.PS_ZOOM, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM);
                graphics.drawOval(n2 + PvGeometry.PS_ZOOM, n3 + PvGeometry.PS_ZOOM, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM);
                n2 += PvGeometry.PS_ZOOM;
                n3 += PvGeometry.PS_ZOOM;
                n4 -= 2 * PvGeometry.PS_ZOOM;
                n5 -= 2 * PvGeometry.PS_ZOOM;
            }
            ++n6;
        }
    }

    PvThickGraphics() {
    }

    public static void drawArc(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n2 -= (n *= PvGeometry.PS_ZOOM) / 2;
        n3 -= n / 2;
        n4 += n;
        n5 += n;
        n /= PvGeometry.PS_ZOOM;
        int n8 = 0;
        while (n8 < n) {
            graphics.drawArc(n2, n3, n4, n5, n6, n7);
            if (n8 + 1 < n) {
                graphics.drawArc(n2, n3, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM, n6, n7);
                graphics.drawArc(n2 + 1, n3, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM, n6, n7);
                graphics.drawArc(n2, n3 + 1, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM, n6, n7);
                graphics.drawArc(n2 + 1, n3 + 1, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM, n6, n7);
                n2 += PvGeometry.PS_ZOOM;
                n3 += PvGeometry.PS_ZOOM;
                n4 -= 2 * PvGeometry.PS_ZOOM;
                n5 -= 2 * PvGeometry.PS_ZOOM;
            }
            ++n8;
        }
    }

    public static void draw3DRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        n2 -= (n *= PvGeometry.PS_ZOOM) / 2;
        n3 -= n / 2;
        n4 += n;
        n5 += n;
        n /= PvGeometry.PS_ZOOM;
        int n6 = 0;
        while (n6 < n) {
            graphics.draw3DRect(n2, n3, n4, n5, bl);
            n2 += PvGeometry.PS_ZOOM;
            n3 += PvGeometry.PS_ZOOM;
            n4 -= 2 * PvGeometry.PS_ZOOM;
            n5 -= 2 * PvGeometry.PS_ZOOM;
            ++n6;
        }
    }

    public static void drawLineAura(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        double d;
        if (n == 1) {
            graphics.drawLine(n2, n3, n4, n5);
            return;
        }
        double d2 = (double)(n *= PvGeometry.PS_ZOOM) / 2.0;
        double d3 = n4 - n2;
        double d4 = n3 - n5;
        if (n2 == n4) {
            d = d4 > 0.0 ? 0.0 : -Math.PI;
        } else {
            d = Math.atan(d4 / d3) - 1.5707963267948966;
            if (n4 < n2) {
                d = d4 > 0.0 ? (d += Math.PI) : (d -= Math.PI);
            }
        }
        int n7 = (int)(d2 * Math.cos(d));
        int n8 = (int)(d2 * Math.sin(d));
        if (n6 == 0) {
            xCorners.set(n2 - n7, n4 - n7, n4 + n7, n2 + n7);
            yCorners.set(n3 + n8, n5 + n8, n5 - n8, n3 - n8);
        } else if (n6 == 1) {
            xCorners.set(n2 - n7, n4 - n7, n4, n2);
            yCorners.set(n3 + n8, n5 + n8, n5, n3);
        } else {
            xCorners.set(n2 + n7, n4 + n7, n4, n2);
            yCorners.set(n3 - n8, n5 - n8, n5, n3);
        }
        graphics.fillPolygon(PvThickGraphics.xCorners.m_data, PvThickGraphics.yCorners.m_data, 4);
    }

    public static void drawCircle(Graphics graphics, int n, int n2, int n3) {
        graphics.drawOval(n - n3, n2 - n3, 2 * n3, 2 * n3);
    }

    public static void drawCircle(Graphics graphics, int n, int n2, int n3, int n4) {
        n4 += n / 2;
        n4 *= PvGeometry.PS_ZOOM;
        int n5 = 0;
        while (n5 < n) {
            PvThickGraphics.drawCircle(graphics, n2, n3, n4);
            if (n5 + 1 < n) {
                PvThickGraphics.drawCircle(graphics, n2 + PvGeometry.PS_ZOOM, n3, n4 - PvGeometry.PS_ZOOM);
                PvThickGraphics.drawCircle(graphics, n2 - PvGeometry.PS_ZOOM, n3, n4 - PvGeometry.PS_ZOOM);
                PvThickGraphics.drawCircle(graphics, n2, n3 + PvGeometry.PS_ZOOM, n4 - PvGeometry.PS_ZOOM);
                PvThickGraphics.drawCircle(graphics, n2, n3 - PvGeometry.PS_ZOOM, n4 - PvGeometry.PS_ZOOM);
                n4 -= PvGeometry.PS_ZOOM;
            }
            ++n5;
        }
    }

    public static void drawPolygon(Graphics graphics, int n, int[] nArray, int[] nArray2, int n2) {
        if (n == PvGeometry.PS_ZOOM) {
            graphics.drawPolygon(nArray, nArray2, n2);
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            PvThickGraphics.drawLine(graphics, n, nArray[n3], nArray2[n3], nArray[(n3 + 1) % n2], nArray2[(n3 + 1) % n2]);
            ++n3;
        }
    }

    public static void drawPolygon(Graphics graphics, int n, int[] nArray, int[] nArray2, int n2, boolean bl) {
        if (n == PvGeometry.PS_ZOOM) {
            graphics.drawPolygon(nArray, nArray2, n2);
            return;
        }
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[nArray2.length];
        boolean bl2 = PvThickGraphics.getParallelCurve(nArray3, nArray4, nArray, nArray2, n2, n *= PvGeometry.PS_ZOOM, true, bl);
        if (!bl2) {
            return;
        }
        --n2;
        int n3 = 0;
        while (n3 < n2) {
            xCorners.set(nArray[n3], nArray3[n3], nArray3[n3 + 1], nArray[n3 + 1]);
            yCorners.set(nArray2[n3], nArray4[n3], nArray4[n3 + 1], nArray2[n3 + 1]);
            graphics.fillPolygon(PvThickGraphics.xCorners.m_data, PvThickGraphics.yCorners.m_data, 4);
            ++n3;
        }
        if (n2 > 0) {
            xCorners.set(nArray[n2], nArray3[n2], nArray3[0], nArray[0]);
            yCorners.set(nArray2[n2], nArray4[n2], nArray4[0], nArray2[0]);
            graphics.fillPolygon(PvThickGraphics.xCorners.m_data, PvThickGraphics.yCorners.m_data, 4);
        }
    }

    public static void drawRoundRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n2 -= (n *= PvGeometry.PS_ZOOM) / 2;
        n3 -= n / 2;
        n4 += n;
        n5 += n;
        n /= PvGeometry.PS_ZOOM;
        int n8 = 0;
        while (n8 < n) {
            graphics.drawRoundRect(n2, n3, n4, n5, n6, n7);
            if (n8 + 1 < n) {
                graphics.drawRoundRect(n2, n3, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM, n6, n7);
                graphics.drawRoundRect(n2 + PvGeometry.PS_ZOOM, n3, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM, n6, n7);
                graphics.drawRoundRect(n2, n3 + PvGeometry.PS_ZOOM, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM, n6, n7);
                graphics.drawRoundRect(n2 + PvGeometry.PS_ZOOM, n3 + PvGeometry.PS_ZOOM, n4 - PvGeometry.PS_ZOOM, n5 - PvGeometry.PS_ZOOM, n6, n7);
                n2 += PvGeometry.PS_ZOOM;
                n3 += PvGeometry.PS_ZOOM;
                n4 -= 2 * PvGeometry.PS_ZOOM;
                n5 -= 2 * PvGeometry.PS_ZOOM;
            }
            ++n8;
        }
    }

    public static void fillCircle(Graphics graphics, int n, int n2, int n3) {
        graphics.fillOval(n - (n3 *= PvGeometry.PS_ZOOM), n2 - n3, 2 * n3, 2 * n3);
    }

    public static boolean getParallelCurve(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, double d, boolean bl, boolean bl2) {
        double d2;
        double d3;
        int n2 = n - 1;
        if (bl) {
            ++n2;
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n];
        int n3 = 0;
        while (n3 < n2) {
            double d4;
            d3 = nArray3[(n3 + 1) % n] - nArray3[n3];
            d2 = nArray4[n3] - nArray4[(n3 + 1) % n];
            if (Math.abs(d3) + Math.abs(d2) < Math.abs(d)) {
                return false;
            }
            if (nArray3[(n3 + 1) % n] == nArray3[n3]) {
                d4 = d2 > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            } else {
                d4 = Math.atan(d2 / d3);
                if (nArray3[(n3 + 1) % n] < nArray3[n3]) {
                    d4 = d2 > 0.0 ? (d4 += Math.PI) : (d4 -= Math.PI);
                }
            }
            dArray[n3] = d4 >= 0.0 ? d4 : Math.PI * 2 + d4;
            ++n3;
        }
        d3 = 0.2;
        if (bl && n > 2) {
            n3 = 0;
            while (n3 < n) {
                dArray2[n3] = (dArray[(n3 - 1 + n) % n] + dArray[n3] - Math.PI) / 2.0;
                d2 = Math.abs(dArray[(n3 - 1 + n) % n] - dArray[n3]);
                if (d2 < d3 || Math.abs(d2 - Math.PI) < d3 || Math.abs(d2 - Math.PI * 2) < d3 || Math.abs(d2 - Math.PI * 3) < d3) {
                    return false;
                }
                if (Math.abs(d2) >= Math.PI) {
                    int n4 = n3;
                    dArray2[n4] = dArray2[n4] + Math.PI;
                }
                ++n3;
            }
        } else {
            n3 = 1;
            while (n3 < n - 1) {
                dArray2[n3] = (dArray[n3 - 1] + dArray[n3] - Math.PI) / 2.0;
                d2 = Math.abs(dArray[n3 - 1] - dArray[n3]);
                if (d2 < d3 || Math.abs(d2 - Math.PI) < d3 || Math.abs(d2 - Math.PI * 2) < d3 || Math.abs(d2 - Math.PI * 3) < d3) {
                    return false;
                }
                if (d2 >= Math.PI) {
                    int n5 = n3;
                    dArray2[n5] = dArray2[n5] + Math.PI;
                }
                ++n3;
            }
            dArray2[0] = dArray[0] - 1.5707963267948966;
            dArray2[n - 1] = dArray[n - 1] - 1.5707963267948966;
        }
        n3 = 0;
        while (n3 < n) {
            if (bl2) {
                nArray[n3] = (int)((double)nArray3[n3] - d * Math.cos(dArray2[n3]));
                nArray2[n3] = (int)((double)nArray4[n3] + d * Math.sin(dArray2[n3]));
            } else {
                nArray[n3] = (int)((double)nArray3[n3] + d * Math.cos(dArray2[n3]));
                nArray2[n3] = (int)((double)nArray4[n3] - d * Math.sin(dArray2[n3]));
            }
            ++n3;
        }
        return true;
    }
}

