/*
 * Decompiled with CFR 0.152.
 */
package third.dol.closedpoly;

import jv.geom.PgPolygon;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public class PjClosedPoly
extends PjProject {
    protected static final int VERTEX_SIZE = 3;
    protected PgPolygon m_poly = new PgPolygon(2);
    protected PgPolygon m_workingPoly = new PgPolygon(2);
    protected int m_mode = 2;
    public static final int MODE_MIRROR = 0;
    public static final int MODE_LOCAL = 1;
    public static final int MODE_GLOBAL = 2;
    protected PuInteger m_steps = new PuInteger("Number Of Vertices", (PsUpdateIf)this);
    private static /* synthetic */ Class class$third$dol$closedpoly$PjClosedPoly;

    public PjClosedPoly() {
        super("Closed Polygon");
        if (((Object)((Object)this)).getClass() == (class$third$dol$closedpoly$PjClosedPoly != null ? class$third$dol$closedpoly$PjClosedPoly : (class$third$dol$closedpoly$PjClosedPoly = PjClosedPoly.class$("third.dol.closedpoly.PjClosedPoly")))) {
            this.init();
        }
    }

    public void setMode(int n) {
        this.m_mode = n;
    }

    public void mirrorVertex(int n, PgPolygon pgPolygon) {
        int n2 = pgPolygon.getNumVertices();
        if (n2 < 3) {
            return;
        }
        PdVector pdVector = pgPolygon.getVertex(n);
        PdVector pdVector2 = pgPolygon.getVertex((n + n2 - 1) % n2);
        PdVector pdVector3 = pgPolygon.getVertex((n + 1) % n2);
        PdVector pdVector4 = new PdVector(2);
        PdVector pdVector5 = new PdVector(2);
        pdVector4.copy(pdVector2);
        pdVector4.sub(pdVector3);
        pdVector5.set(-pdVector4.getEntry(1), pdVector4.getEntry(0));
        if (pdVector5.length() < 1.0E-10) {
            return;
        }
        pdVector5.normalize();
        pdVector4.copy(pdVector3);
        pdVector4.sub(pdVector);
        double d = PdVector.dot((PdVector)pdVector5, (PdVector)pdVector4);
        pdVector5.multScalar(2.0 * d);
        pdVector5.add(pdVector);
        pgPolygon.setVertex(n, pdVector5);
    }

    public void globalTransformation(int n, PdVector pdVector, PgPolygon pgPolygon) {
        int n2 = pgPolygon.getNumVertices();
        int n3 = (n + n2 / 2) % n2;
        PdVector[] pdVectorArray = new PdVector[n2];
        int n4 = 0;
        while (n4 < n2) {
            pdVectorArray[n4] = new PdVector(2);
            pdVectorArray[n4].copy(pgPolygon.getVertex(n4));
            ++n4;
        }
        PdVector[] pdVectorArray2 = new PdVector[n2];
        int n5 = 0;
        while (n5 < n2) {
            pdVectorArray2[n5] = new PdVector(2);
            ++n5;
        }
        if (this.traktrixAll(n, pdVector, pdVectorArray2, pdVectorArray)) {
            PdVector pdVector2 = new PdVector(2);
            pdVector2.sub(pdVectorArray[n3], pdVectorArray2[n3]);
            pdVector2.multScalar(1.0);
            pdVector2.add(pdVectorArray2[n3]);
            PdVector.copy((PdVector[])pdVectorArray, (int)0, (PdVector[])pdVectorArray2, (int)0, (int)n2);
            if (this.traktrixAll(n3, pdVector2, pdVectorArray2, pdVectorArray)) {
                PdVector.copy((PdVector[])pdVectorArray, (int)0, (PdVector[])pdVectorArray2, (int)0, (int)n2);
                if (this.traktrixAll(n, pdVector, pdVectorArray2, pdVectorArray)) {
                    pgPolygon.setVertices(pdVectorArray2);
                    return;
                }
            }
        } else {
            PdVector pdVector3 = new PdVector(2);
            pdVector3.sub(pdVector, pdVectorArray[n]);
            int n6 = 0;
            while (n6 < n2) {
                pdVectorArray2[n6].add(pdVectorArray[n6], pdVector3);
                ++n6;
            }
            pdVector3.sub(pdVectorArray[n3], pdVectorArray2[n3]);
            pdVector3.multScalar(1.0);
            pdVector3.add(pdVectorArray2[n3]);
            PdVector.copy((PdVector[])pdVectorArray, (int)0, (PdVector[])pdVectorArray2, (int)0, (int)n2);
            if (this.traktrixAll(n3, pdVector3, pdVectorArray2, pdVectorArray)) {
                PdVector.copy((PdVector[])pdVectorArray, (int)0, (PdVector[])pdVectorArray2, (int)0, (int)n2);
                if (this.traktrixAll(n, pdVector, pdVectorArray2, pdVectorArray)) {
                    pgPolygon.setVertices(pdVectorArray2);
                }
            }
        }
    }

    public boolean update(Object object) {
        if (object == this.m_steps) {
            int n = this.m_steps.getValue();
            if (n % 2 != 0) {
                --n;
            }
            if (n < 4) {
                n = 4;
            }
            this.computeNGon(n, this.m_workingPoly);
            this.m_poly.copy((PgGeometry)this.m_workingPoly);
            this.m_poly.setClosed(true);
            this.m_poly.update(null);
            if (this.getDisplay() != null) {
                this.getDisplay().fit();
            }
            return true;
        }
        return false;
    }

    public void start() {
        this.m_poly.setName("Curve");
        this.addGeometry((PgGeometryIf)this.m_poly);
        this.selectGeometry((PgGeometryIf)this.m_poly);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(1);
            pvDisplayIf.setMajorMode(5);
        }
        super.start();
    }

    public boolean traktrixAll(int n, PdVector pdVector, PdVector[] pdVectorArray, PdVector[] pdVectorArray2) {
        int n2 = pdVectorArray2.length;
        if (n2 < 4 || n2 % 2 != 0) {
            return false;
        }
        pdVectorArray[n].copy(pdVector);
        PdVector pdVector2 = new PdVector(2);
        int n3 = n2 / 2;
        int n4 = 1;
        while (n4 < n3) {
            pdVector2.copy(pdVectorArray[(n4 - 1 + n) % n2]);
            pdVector2.sub(pdVectorArray2[(n4 - 1 + n) % n2]);
            this.traktrix(pdVectorArray2[(n4 - 1 + n) % n2], pdVectorArray2[(n4 + n) % n2], pdVector2, pdVectorArray[(n + n4) % n2]);
            ++n4;
        }
        n4 = 1;
        while (n4 < n3) {
            pdVector2.copy(pdVectorArray[(n + n2 - (n4 - 1)) % n2]);
            pdVector2.sub(pdVectorArray2[(n + n2 - (n4 - 1)) % n2]);
            this.traktrix(pdVectorArray2[(n + n2 - (n4 - 1)) % n2], pdVectorArray2[(n + n2 - n4) % n2], pdVector2, pdVectorArray[(n + n2 - n4) % n2]);
            ++n4;
        }
        pdVectorArray[(n + n3) % n2].copy(pdVectorArray2[(n + n3) % n2]);
        return this.getNearestSupplement(pdVectorArray[(n + n3 - 1) % n2], pdVectorArray[(n + n3 + 1) % n2], pdVectorArray[(n + n3) % n2]);
    }

    public void dragVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
        if (this.m_mode != 0) {
            this.pickVertex(pgGeometryIf, n, pdVector);
            return;
        }
        this.m_poly.copy((PgGeometry)this.m_workingPoly);
        this.m_poly.setClosed(true);
        this.m_poly.update(null);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void computeNGon(int n, PgPolygon pgPolygon) {
        pgPolygon.setNumVertices(n);
        double d = Math.PI * 2 / (double)n;
        double d2 = Math.cos(d);
        double d3 = Math.sqrt(0.5 / (1.0 - d2));
        double d4 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            pgPolygon.setVertex(n2, new PdVector(d3 * Math.cos(d4), d3 * Math.sin(d4)));
            d4 += d;
            ++n2;
        }
    }

    public void localTransformation(int n, PdVector pdVector, PgPolygon pgPolygon) {
        PdVector pdVector2;
        PdVector pdVector3;
        int n2 = pgPolygon.getNumVertices();
        if (n2 < 4) {
            return;
        }
        PdVector[] pdVectorArray = new PdVector[]{pgPolygon.getVertex((n + 2) % n2), pgPolygon.getVertex((n + n2 - 2) % n2)};
        double[] dArray = new double[]{PdVector.dist((PdVector)pdVectorArray[0], (PdVector)pdVector), PdVector.dist((PdVector)pdVectorArray[1], (PdVector)pdVector)};
        int n3 = -1;
        if (dArray[0] > 2.0) {
            n3 = 0;
        } else if (dArray[1] > 2.0) {
            n3 = 1;
        }
        if (n3 != -1) {
            pdVector3 = new PdVector(2);
            pdVector2 = pgPolygon.getVertex(n);
            pdVector3.copy(pdVector);
            pdVector3.sub(pdVector2);
            double d = PdVector.dot((PdVector)pdVector2, (PdVector)pdVector2);
            double d2 = PdVector.dot((PdVector)pdVector2, (PdVector)pdVector3);
            double d3 = PdVector.dot((PdVector)pdVector3, (PdVector)pdVectorArray[n3]);
            double d4 = PdVector.dot((PdVector)pdVector3, (PdVector)pdVector3);
            double d5 = PdVector.dot((PdVector)pdVectorArray[n3], (PdVector)pdVectorArray[n3]);
            double d6 = PdVector.dot((PdVector)pdVector2, (PdVector)pdVectorArray[n3]);
            if (Math.abs(d4) > 1.0E-10) {
                double d7 = (d2 - d3) / d4;
                d7 *= d7;
                if ((d7 -= (d + d5 - 2.0 * d6 - 4.0) / d4) > 0.0) {
                    double d8 = (-d2 + d3) / d4 + Math.sqrt(d7);
                    if (d8 < 0.0) {
                        d8 = (-d2 + d3) / d4 - Math.sqrt(d7);
                    }
                    if (d8 > 0.0 && d8 < 1.0) {
                        pdVector3.multScalar(d8);
                        pdVector.copy(pdVector2);
                        pdVector.add(pdVector3);
                    }
                }
            }
        }
        pdVector3 = new PdVector(2);
        pdVector3.copy(pgPolygon.getVertex((n + 1) % n2));
        if (!this.getNearestSupplement(pdVectorArray[0], pdVector, pdVector3)) {
            return;
        }
        pdVector2 = new PdVector(2);
        pdVector2.copy(pgPolygon.getVertex((n + n2 - 1) % n2));
        if (!this.getNearestSupplement(pdVectorArray[1], pdVector, pdVector2)) {
            return;
        }
        pgPolygon.setVertex((n + 1) % n2, pdVector3);
        pgPolygon.setVertex((n + n2 - 1) % n2, pdVector2);
        pgPolygon.setVertex(n, pdVector);
    }

    public PgPolygon getPolygon() {
        PgPolygon pgPolygon = new PgPolygon(2);
        pgPolygon.copy((PgGeometry)this.m_workingPoly);
        return pgPolygon;
    }

    public void init() {
        super.init();
        this.m_steps.setDefValue(8);
        this.m_steps.setDefBounds(4, 12, 2, 4);
        this.m_steps.init();
        this.m_workingPoly.setGlobalVertexSize(3);
        this.computeNGon(this.m_steps.getValue(), this.m_workingPoly);
        this.m_poly.setGlobalVertexSize(3);
        this.m_poly.copy((PgGeometry)this.m_workingPoly);
        this.m_poly.setClosed(true);
    }

    public boolean getNearestSupplement(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        PdVector pdVector4 = new PdVector(2);
        pdVector4.copy(pdVector);
        pdVector4.sub(pdVector2);
        double d = pdVector4.getEntry(0);
        double d2 = pdVector4.getEntry(1);
        double d3 = pdVector4.length() / 2.0;
        if (d3 > 1.0 || d3 < 1.0E-10) {
            return false;
        }
        double d4 = Math.sqrt(1.0 - d3 * d3);
        PdVector pdVector5 = new PdVector(2);
        pdVector5.set(d3 * d - d4 * d2, d4 * d + d3 * d2);
        pdVector5.multScalar(1.0 / (2.0 * d3));
        pdVector5.add(pdVector2);
        pdVector4.set(d3 * d + d4 * d2, d3 * d2 - d4 * d);
        pdVector4.multScalar(1.0 / (2.0 * d3));
        pdVector4.add(pdVector2);
        double d5 = PdVector.dist((PdVector)pdVector4, (PdVector)pdVector3);
        double d6 = PdVector.dist((PdVector)pdVector5, (PdVector)pdVector3);
        if (d5 < d6) {
            pdVector3.copy(pdVector4);
        } else {
            pdVector3.copy(pdVector5);
        }
        return true;
    }

    public void traktrix(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        PdVector pdVector5 = new PdVector(2);
        pdVector5.copy(pdVector2);
        pdVector5.sub(pdVector);
        pdVector5.multScalar(2.0);
        pdVector5.sub(pdVector3);
        double d = pdVector5.getEntry(0);
        double d2 = pdVector5.getEntry(1);
        pdVector5.set(-d2, d);
        double d3 = pdVector5.length();
        if (d3 < 1.0E-10) {
            pdVector4.copy(pdVector2);
            return;
        }
        pdVector5.multScalar(1.0 / d3);
        pdVector5.multScalar(-2.0 * PdVector.dot((PdVector)pdVector5, (PdVector)pdVector3));
        pdVector5.add(pdVector3);
        pdVector5.add(pdVector3);
        pdVector5.multScalar(0.5);
        pdVector5.add(pdVector2);
        pdVector4.copy(pdVector5);
        PdVector pdVector6 = new PdVector(2);
        pdVector6.copy(pdVector);
        pdVector6.add(pdVector3);
        double d4 = PdVector.dist((PdVector)pdVector5, (PdVector)pdVector6);
        if (Math.abs(d4 - 1.0) > 1.0E-10) {
            PsDebug.warning((String)("distance: " + d4));
        }
    }

    public void pickVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
        if (pgGeometryIf == this.m_poly) {
            if (this.m_mode == 0) {
                this.mirrorVertex(n, this.m_workingPoly);
            } else if (this.m_mode == 1) {
                PdVector pdVector2 = new PdVector(2);
                pdVector2.set(pdVector.getEntry(0), pdVector.getEntry(1));
                this.localTransformation(n, pdVector2, this.m_workingPoly);
            } else if (this.m_mode == 2) {
                PdVector pdVector3 = new PdVector(2);
                pdVector3.set(pdVector.getEntry(0), pdVector.getEntry(1));
                this.globalTransformation(n, pdVector3, this.m_workingPoly);
            }
            this.m_poly.copy((PgGeometry)this.m_workingPoly);
            this.m_poly.setClosed(true);
            this.m_poly.update(null);
        }
    }
}

