/*
 * Decompiled with CFR 0.152.
 */
package third.dol.elastic;

import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdVector;

public class PjElastic
extends PjProject {
    protected PgPolygon m_geom = new PgPolygon(2);
    protected PuDouble m_firstCurvature = new PuDouble("1st Curvature", (PsUpdateIf)this);
    protected PuDouble m_secondCurvature = new PuDouble("2nd Curvature", (PsUpdateIf)this);
    protected PuInteger m_steps;
    protected PdVector m_start;
    protected PuDouble m_firstDir = new PuDouble("Initial Direction", (PsUpdateIf)this);
    protected PuDouble m_a;
    protected PuDouble m_b;
    private static /* synthetic */ Class class$third$dol$elastic$PjElastic;

    public PjElastic() {
        super("Discrete Elastic Curves");
        this.m_steps = new PuInteger("Iterations", (PsUpdateIf)this);
        this.m_a = new PuDouble("Parameter a", (PsUpdateIf)this);
        this.m_b = new PuDouble("Parameter b", (PsUpdateIf)this);
        this.m_start = new PdVector(2);
        if (((Object)((Object)this)).getClass() == (class$third$dol$elastic$PjElastic != null ? class$third$dol$elastic$PjElastic : (class$third$dol$elastic$PjElastic = PjElastic.class$("third.dol.elastic.PjElastic")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == this.m_firstCurvature) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_secondCurvature) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_firstDir) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_steps) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_a) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        if (object == this.m_b) {
            this.compute();
            this.m_geom.update(null);
            return true;
        }
        return false;
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    public void start() {
        this.m_geom.setName("Discrete Elastic Curve");
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(1);
            pvDisplayIf.setMajorMode(3);
        }
        this.m_geom.update(null);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PgPolygon getPolygon() {
        return this.m_geom;
    }

    public void init() {
        super.init();
        this.m_firstCurvature.setDefValue(0.1);
        this.m_firstCurvature.setDefBounds(-5.0, 5.0, 0.01, 0.05);
        this.m_firstCurvature.init();
        this.m_secondCurvature.setDefValue(0.1);
        this.m_secondCurvature.setDefBounds(-5.0, 5.0, 0.01, 0.05);
        this.m_secondCurvature.init();
        this.m_firstDir.setDefValue(0.0);
        this.m_firstDir.setDefBounds(-Math.PI, Math.PI, 0.1, 0.5);
        this.m_firstDir.init();
        this.m_steps.setDefValue(14);
        this.m_steps.setDefBounds(0, 100, 1, 5);
        this.m_steps.init();
        this.m_a.setDefValue(1.1);
        this.m_a.setDefBounds(-3.0, 3.0, 0.01, 0.05);
        this.m_a.init();
        this.m_b.setDefValue(0.0);
        this.m_b.setDefBounds(-1.0, 1.0, 0.01, 0.05);
        this.m_b.init();
        this.m_start.set(0.0, 0.0);
        this.compute();
        this.m_geom.update(null);
    }

    public void compute() {
        double d = this.m_a.getValue();
        double d2 = this.m_b.getValue();
        double d3 = this.m_firstCurvature.getValue();
        double d4 = this.m_secondCurvature.getValue();
        double d5 = this.m_start.getEntry(0);
        double d6 = this.m_start.getEntry(1);
        double d7 = this.m_firstDir.getValue();
        int n = this.m_steps.getValue() + 4;
        this.m_geom.setNumVertices(n);
        this.m_geom.setVertex(0, new PdVector(d5, d6));
        int n2 = 1;
        while (n2 < n) {
            double d8;
            if (n2 == 1) {
                d8 = 0.0;
            } else if (n2 == 2) {
                d8 = d3;
            } else if (n2 == 3) {
                d8 = d4;
            } else {
                d8 = 2.0 * d * d4 / (1.0 + d4 * d4) - d3 + d2;
                d3 = d4;
                d4 = d8;
            }
            this.m_geom.setVertex(n2, new PdVector(d5 += Math.cos(d7 += 2.0 * Math.atan(d8)), d6 += Math.sin(d7)));
            ++n2;
        }
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        PdVector pdVector = pvPickEvent.getVertex();
        this.m_start.set(pdVector.getEntry(0), pdVector.getEntry(1));
        this.compute();
        this.m_geom.update(null);
    }
}

