/*
 * Decompiled with CFR 0.152.
 */
package third.dol.flow;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PcMatrix;
import jv.vecmath.PdVector;
import jvx.geom.PgTube;
import third.dol.closedpoly.PjClosedPoly;
import third.dol.flow.PjFlow_IP;

public class PjFlow
extends PjClosedPoly
implements Runnable {
    public static final int MODE_2D = 0;
    public static final int MODE_3D = 1;
    public static final int MODE_SURF = 2;
    public static final int SLEEP = 100;
    protected PcMatrix m_i;
    protected PcMatrix m_j;
    protected PcMatrix m_k;
    protected PgPolygon m_threepoly;
    protected PcMatrix[] m_Sk;
    protected PdVector m_lastV0;
    protected int m_stepNum;
    protected PuDouble m_r;
    protected int m_mode = 0;
    protected PgTube m_tube;
    protected PgElementSet m_surface;
    protected PuInteger m_surfSteps;
    protected Thread m_thread;
    private static /* synthetic */ Class class$third$dol$flow$PjFlow;

    public void evolve(double d, int n, int n2, PdVector pdVector, PgPolygon pgPolygon) {
        PdVector[] pdVectorArray = this.getDirections(n2, d, pdVector, n, pgPolygon);
        if (pdVectorArray == null) {
            pgPolygon.setClosed(true);
            return;
        }
        PdVector[] pdVectorArray2 = pgPolygon.getVertices();
        int n3 = pgPolygon.getNumVertices();
        int n4 = 0;
        while (n4 < n3) {
            pdVectorArray2[n4].add(pdVectorArray[n4]);
            ++n4;
        }
        pdVector.copy(pdVectorArray[0]);
    }

    public void setSurf() {
        PjFlow_IP pjFlow_IP = (PjFlow_IP)this.getInfoPanel();
        pjFlow_IP.setSurf();
        this.m_steps.getInfoPanel().setEnabled(false);
        this.m_surfSteps.getInfoPanel().setEnabled(true);
        this.m_threepoly.setVisible(false);
        this.m_poly.setVisible(false);
        this.m_surface.setVisible(true);
        this.m_surface.update(null);
        this.m_threepoly.update(null);
        this.m_poly.update(null);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(0);
            pvDisplayIf.setMajorMode(0);
            pvDisplayIf.fit();
        }
        this.m_mode = 2;
    }

    public void stepByStepEvolvation(double d, int n) {
        this.m_threepoly.setNumVertices(this.m_threepoly.getNumVertices() - 1);
        this.evolve(d, n, this.m_stepNum, this.m_lastV0, this.m_threepoly);
        this.m_threepoly.setClosed(true);
        ++this.m_stepNum;
    }

    public PdVector quatToR3(PcMatrix pcMatrix) {
        if (pcMatrix == null) {
            return null;
        }
        PdVector pdVector = new PdVector(3);
        pdVector.m_data[0] = pcMatrix.m_data[0][0].im;
        pdVector.m_data[1] = pcMatrix.m_data[1][0].im;
        pdVector.m_data[2] = pcMatrix.m_data[1][0].re;
        return pdVector;
    }

    public PjFlow() {
        this.setName("Evolve Closed Polygon");
        this.m_i = new PcMatrix(2);
        this.m_j = new PcMatrix(2);
        this.m_k = new PcMatrix(2);
        this.m_threepoly = new PgPolygon(3);
        this.m_tube = new PgTube(3);
        this.m_r = new PuDouble("Evolvation Constant r", (PsUpdateIf)this);
        this.m_lastV0 = new PdVector(0.0, 0.0, 0.0);
        this.m_surface = new PgElementSet(3);
        this.m_surfSteps = new PuInteger("Iterations", (PsUpdateIf)this);
        this.m_thread = new Thread();
        if (this.getClass() == (class$third$dol$flow$PjFlow != null ? class$third$dol$flow$PjFlow : (class$third$dol$flow$PjFlow = PjFlow.class$("third.dol.flow.PjFlow")))) {
            this.init();
        }
    }

    public void set2d() {
        PjFlow_IP pjFlow_IP = (PjFlow_IP)this.getInfoPanel();
        pjFlow_IP.set2d();
        this.m_steps.getInfoPanel().setEnabled(true);
        this.m_surfSteps.getInfoPanel().setEnabled(false);
        this.m_threepoly.setVisible(false);
        this.m_poly.setVisible(true);
        this.m_surface.setVisible(false);
        this.m_surface.update(null);
        this.m_threepoly.update(null);
        this.m_poly.update(null);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(1);
            pvDisplayIf.setMajorMode(5);
            pvDisplayIf.fit();
        }
        this.m_mode = 0;
    }

    public void startAnimation() {
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    public void stopAnimation() {
        this.m_thread.stop();
    }

    public void set3d() {
        PjFlow_IP pjFlow_IP = (PjFlow_IP)this.getInfoPanel();
        pjFlow_IP.set3d();
        this.m_steps.getInfoPanel().setEnabled(false);
        this.m_surfSteps.getInfoPanel().setEnabled(false);
        this.m_threepoly.setVisible(true);
        this.m_poly.setVisible(false);
        this.m_surface.setVisible(false);
        this.m_surface.update(null);
        this.m_threepoly.update(null);
        this.m_poly.update(null);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(0);
            pvDisplayIf.setMajorMode(0);
            pvDisplayIf.fit();
        }
        this.m_mode = 1;
    }

    public void polygonUebernehmen() {
        int n = this.m_workingPoly.getNumVertices();
        this.m_threepoly.setNumVertices(n);
        int n2 = 0;
        while (n2 < n) {
            PdVector pdVector = this.m_workingPoly.getVertex(n2);
            this.m_threepoly.setVertex(n2, new PdVector(pdVector.getEntry(0), pdVector.getEntry(1), 0.0));
            ++n2;
        }
        this.m_threepoly.setClosed(true);
        this.m_lastV0 = new PdVector(0.0, 0.0, 0.0);
        this.m_stepNum = 0;
    }

    public boolean update(Object object) {
        if (object != null) {
            if (object == this.m_r) {
                if (this.m_mode == 2) {
                    this.computeSurface();
                    this.m_surface.update(null);
                }
                return super.update(null);
            }
            if (object == this.m_surfSteps) {
                this.computeSurface();
                this.m_surface.update(null);
                return super.update(null);
            }
        }
        return super.update(object);
    }

    protected PcMatrix getM(PuComplex puComplex, PgPolygon pgPolygon) {
        int n = pgPolygon.getNumVertices();
        PcMatrix pcMatrix = new PcMatrix(2);
        pcMatrix.setIdentity();
        this.m_Sk = new PcMatrix[n];
        PcMatrix pcMatrix2 = new PcMatrix(2);
        PdVector pdVector = new PdVector();
        int n2 = 0;
        while (n2 < n) {
            pdVector.copy(pgPolygon.getVertex((n2 + 1) % n));
            pdVector.sub(pgPolygon.getVertex(n2));
            this.m_Sk[n2] = new PcMatrix(2);
            this.m_Sk[n2].copy(this.m_i);
            this.m_Sk[n2].multScalar(new PuComplex(pdVector.getEntry(0), 0.0));
            pcMatrix2.copy(this.m_j);
            pcMatrix2.multScalar(new PuComplex(pdVector.getEntry(1), 0.0));
            this.m_Sk[n2].add(pcMatrix2);
            pcMatrix2.copy(this.m_k);
            pcMatrix2.multScalar(new PuComplex(pdVector.getEntry(2), 0.0));
            this.m_Sk[n2].add(pcMatrix2);
            pcMatrix2.copy(this.m_Sk[n2]);
            pcMatrix2.multScalar(puComplex);
            pcMatrix2.m_data[0][0].add(1.0);
            pcMatrix2.m_data[1][1].add(1.0);
            pcMatrix.leftMult(pcMatrix2);
            ++n2;
        }
        return pcMatrix;
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_threepoly);
        this.addGeometry((PgGeometryIf)this.m_surface);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PdVector[] getDirections(int n, double d, PdVector pdVector, int n2, PgPolygon pgPolygon) {
        PuComplex puComplex = new PuComplex(-d / (1.0 + d * d), 1.0 / (1.0 + d * d));
        if (n % 2 != 0) {
            puComplex.mult(-1.0);
        }
        PuComplex puComplex2 = PuComplex.inv((PuComplex)puComplex);
        PuComplex puComplex3 = PuComplex.inv((PuComplex)PuComplex.conj((PuComplex)puComplex));
        PcMatrix pcMatrix = this.getM(puComplex, pgPolygon);
        PuComplex[] puComplexArray = pcMatrix.eigenvalues();
        PuComplex[] puComplexArray2 = new PuComplex[2];
        PuComplex[] puComplexArray3 = pcMatrix.aEigenvector(puComplexArray[0]);
        puComplexArray2[0] = puComplexArray3 == null ? null : PuComplex.div((PuComplex)puComplexArray3[1], (PuComplex)puComplexArray3[0]);
        puComplexArray3 = pcMatrix.aEigenvector(puComplexArray[1]);
        puComplexArray2[1] = puComplexArray3 == null ? null : PuComplex.div((PuComplex)puComplexArray3[1], (PuComplex)puComplexArray3[0]);
        if (puComplexArray2[0] == null && puComplexArray2[1] == null) {
            return null;
        }
        PcMatrix[] pcMatrixArray = new PcMatrix[2];
        PuComplex puComplex4 = new PuComplex();
        PuComplex puComplex5 = new PuComplex();
        int n3 = 0;
        do {
            if (puComplexArray2[n3] == null) continue;
            double d2 = puComplexArray2[n3].sqrAbs();
            puComplex5.copy(PuComplex.sub((PuComplex)puComplex3, (PuComplex)puComplex2));
            puComplex5.div(1.0 + d2);
            puComplex5.mult(puComplexArray2[n3]);
            puComplex4.copy(PuComplex.conj((PuComplex)puComplex5));
            puComplex4.mult(puComplexArray2[n3]);
            puComplex4.sub(puComplex2);
            pcMatrixArray[n3] = new PcMatrix(2);
            pcMatrixArray[n3].m_data[0][0].copy(puComplex4);
            pcMatrixArray[n3].m_data[1][0].copy(puComplex5);
            pcMatrixArray[n3].m_data[0][1].copy(PuComplex.conj((PuComplex)puComplex5));
            pcMatrixArray[n3].m_data[0][1].mult(-1.0);
            pcMatrixArray[n3].m_data[1][1].copy(PuComplex.conj((PuComplex)puComplex4));
        } while (++n3 < 2);
        PdVector pdVector2 = this.quatToR3(pcMatrixArray[0]);
        PdVector pdVector3 = this.quatToR3(pcMatrixArray[1]);
        int n4 = 0;
        if (puComplexArray2[0] == null) {
            n4 = 1;
            pdVector2 = pdVector3;
        } else if (puComplexArray2[1] == null) {
            n4 = 0;
        } else {
            if (n2 == 0) {
                n2 = 1;
            }
            if (pdVector != null && (double)n2 * PdVector.dot((PdVector)pdVector2, (PdVector)pdVector) / pdVector2.length() > (double)n2 * PdVector.dot((PdVector)pdVector3, (PdVector)pdVector) / pdVector3.length()) {
                pdVector2 = pdVector3;
                n4 = 1;
            }
        }
        int n5 = pgPolygon.getNumVertices();
        PdVector[] pdVectorArray = new PdVector[n5];
        pdVectorArray[0] = pdVector2;
        PcMatrix pcMatrix2 = new PcMatrix(2);
        PcMatrix pcMatrix3 = new PcMatrix(2);
        pcMatrix2.copy(pcMatrixArray[n4]);
        PcMatrix pcMatrix4 = new PcMatrix(2);
        PcMatrix pcMatrix5 = new PcMatrix(2);
        PuComplex puComplex6 = new PuComplex();
        int n6 = 1;
        while (n6 < n5) {
            pcMatrix4.copy(this.m_Sk[n6 - 1]);
            pcMatrix4.sub(pcMatrix2);
            pcMatrix5.m_data[0][0].copy(pcMatrix4.m_data[1][1]);
            pcMatrix5.m_data[1][1].copy(pcMatrix4.m_data[0][0]);
            pcMatrix5.m_data[1][0].copy(pcMatrix4.m_data[1][0]);
            pcMatrix5.m_data[1][0].mult(-1.0);
            pcMatrix5.m_data[0][1].copy(pcMatrix4.m_data[0][1]);
            pcMatrix5.m_data[0][1].mult(-1.0);
            puComplex6.copy(pcMatrix4.m_data[0][0]);
            puComplex6.mult(pcMatrix4.m_data[1][1]);
            puComplex6.sub(PuComplex.mult((PuComplex)pcMatrix4.m_data[0][1], (PuComplex)pcMatrix4.m_data[1][0]));
            puComplex6.inv();
            pcMatrix5.multScalar(puComplex6);
            pcMatrix3.copy(pcMatrix5);
            pcMatrix3.leftMult(pcMatrix2);
            pcMatrix3.leftMult(pcMatrix4);
            pcMatrix2.copy(pcMatrix3);
            pdVectorArray[n6] = this.quatToR3(pcMatrix3);
            ++n6;
        }
        return pdVectorArray;
    }

    public void run() {
        double d = this.m_r.getValue();
        while (true) {
            this.stepByStepEvolvation(d, 1);
            this.m_threepoly.update(null);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void init() {
        super.init();
        this.m_i.setConstant(new PuComplex(0.0, 0.0));
        this.m_i.m_data[0][0].set(0.0, 1.0);
        this.m_i.m_data[1][1].set(0.0, -1.0);
        this.m_j.setConstant(new PuComplex(0.0, 0.0));
        this.m_j.m_data[0][1].set(0.0, 1.0);
        this.m_j.m_data[1][0].set(0.0, 1.0);
        this.m_k.setConstant(new PuComplex(0.0, 0.0));
        this.m_k.m_data[0][1].set(-1.0, 0.0);
        this.m_k.m_data[1][0].set(1.0, 0.0);
        this.m_r.setDefValue(0.1);
        this.m_r.setDefBounds(0.05, 0.5, 0.01, 0.5);
        this.m_r.init();
        this.m_surfSteps.setDefValue(10);
        this.m_surfSteps.setDefBounds(1, 50, 1, 5);
        this.m_surfSteps.init();
        this.m_threepoly.setName("Evolved Curve");
        this.m_threepoly.setGlobalPolygonSize(2.0);
        this.m_threepoly.setGlobalPolygonColor(Color.black);
        this.polygonUebernehmen();
        this.m_tube.setName("Tube");
        this.m_tube.setPolygon(this.m_threepoly);
        this.m_tube.setThickness(0.05);
        this.m_tube.setDiscr(6);
        this.m_surface.setName("Evolved Surface");
        this.m_mode = 0;
        this.set2d();
        this.m_thread.stop();
    }

    public void computeSurface() {
        double d = this.m_r.getValue();
        PgPolygon pgPolygon = new PgPolygon(3);
        int n = this.m_workingPoly.getNumVertices();
        pgPolygon.setNumVertices(n);
        int n2 = 0;
        while (n2 < n) {
            PdVector pdVector = this.m_workingPoly.getVertex(n2);
            pgPolygon.setVertex(n2, new PdVector(pdVector.getEntry(0), pdVector.getEntry(1), 0.0));
            ++n2;
        }
        PdVector pdVector = new PdVector(0.0, 0.0, 0.0);
        int n3 = 0;
        int n4 = this.m_surfSteps.getValue();
        this.m_surface.setNumVertices((n + 1) * (n4 + 1));
        int n5 = 0;
        int n6 = 0;
        do {
            int n7 = 0;
            while (n7 < n + 1) {
                this.m_surface.setVertex(n6, PdVector.copyNew((PdVector)pgPolygon.getVertex(n7 % n)));
                ++n6;
                ++n7;
            }
            this.evolve(d, 1, n3, pdVector, pgPolygon);
            this.evolve(d, 1, ++n3, pdVector, pgPolygon);
            ++n3;
        } while (++n5 <= n4);
        this.m_surface.makeQuadrConn(n4 + 1, n + 1);
        this.m_surface.makeQuadrBnd(n4 + 1, n + 1);
    }
}

