################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox)
#       version 0.94 from 2/15/01. You can find more information at
#       http://www.zpr.uni-koeln.de/CATBox
#
#	file:   DFS-Traversal.py
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#
#       Copyright (C) 1998-2000, ZAIK/ZPR, Universitt zu Kln
#
#       All rights reserved. Do not distribute
#
#
#       This file is version $Revision: 1.2 $
#                       from $Date: 2000/09/11 10:49:30 $
#             last change by $Author: pattberg $.
#
#
################################################################################

# Options ----------------------------------------------------------------------
breakpoints = [6]
interactive = [1]
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Breadth-First-Search-Traversal</TITLE>
</HEAD>
<body>
<b>Name:</b>
<br>Breadth-First Search
<p><b>Purpose:</b>
<br>This algorithm traverses a tree in breadth-first order and visualizes
the predecessor-tree being built
<p><b>Description:</b>
<br>The algorithm keeps a queue of neighboring nodes that have not yet
been visited. New unvisited neighbors are appended at the end of the queue, and
are processed by the algorithm in first-in first-out order.
<p><b>Prerequisites:</b>
<br>None
<p><b>Legend:</b>
Vertices
<ul>
<li><IMG SRC="Icons/greennde.gif" HSPACE=2 VSPACE=2 ALIGN=MIDDLE> Unvisited</li>
<li><IMG SRC="Icons/bluenode.gif" HSPACE=2 VSPACE=2 ALIGN=MIDDLE> Neighboring node, that has been added to queue</li>
<li><IMG SRC="Icons/rednode.gif" HSPACE=2 VSPACE=2 ALIGN=MIDDLE> Visited, processed node</li>
</ul>
Edges
<ul>
<li><IMG SRC="Icons/black.gif" HEIGHT=10 WIDTH=30 ALIGN=MIDDLE> Unvisited</li>
<li><IMG SRC="Icons/yellow.gif" HEIGHT=10 WIDTH=30 ALIGN=MIDDLE> Current</li>
<li><IMG SRC="Icons/red.gif" HEIGHT=10 WIDTH=30 ALIGN=MIDDLE> Edge going to a neighboring vertex</li>
<li><IMG SRC="Icons/grey.gif" HEIGHT=10 WIDTH=30 ALIGN=MIDDLE> Visited, but not required edge</li>
</ul>
<p><br><b>Reference:</b>
<br>CATBox Book, page _CATBOXBOOK_
</body>
</HTML>
"""
#--------------------------------------------------------------------------------

PickVertex   = lambda : self.PickVertex(1,None)
label        = VisibleVertexLabeling(A)
pred         = AnimatedPredecessor(A)
Neighborhood = lambda v,a=A,g=G: AnimatedNeighborhood(a,g,v,["red"])
Q            = AnimatedVertexQueue(A,"blue","red")

class MyGraphInformer(GraphInformer):

    def VertexInfo(self,v):
	if label[v]:
	    return "Vertex %d - label %d - pred %d"%(v,label[v],pred[v])
	elif v in Q.contents:
            return "Vertex %d - Queue position %d"%(v,Q.contents.index(v)+1)
	else:
            return "Vertex %d - not visited yet"%v
        return

A.SetAllVerticesColor("green")

for v in G.vertices:
    label[v] = None
    pred[v]  = None

A.RegisterGraphInformer(MyGraphInformer(G))
