################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version _VERSION_ from _BUILDDATE_. You can find more information at 
#       http://www.zpr.uni-koeln.de/CATBox
#
#	file:   DFS-Traversal.py
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#
#       _COPYRIGHT_
#
#       This file is version $Revision: 1.2 $ 
#                       from $Date: 2001/04/05 11:10:15 $
#             last change by $Author: pattberg $.
#
#
################################################################################

# Options ----------------------------------------------------------------------
breakpoints = [4]
interactive = []
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Depth-First-Search-Traversal</TITLE>
</HEAD>
<BODY>

This algorithm traverses a graph in depth-first
order and visualises the predecessor tree being built.

</BODY></HTML>
"""
#--------------------------------------------------------------------------------
#self.NeededProperties({'pMist':1})

component       = {}
NewComponent    = lambda cm = ComponentMaker(G,A): cm.NewComponent()

Neighborhood    = lambda v,a=A,g=G: AnimatedNeighborhood(a,g,v,["red"],"white")
Vertices     = BlinkingContainerWrapper(A,G.vertices,"white")
label        = VisibleVertexLabeling(A)
pred         = AnimatedPredecessor(A)

A.SetAllEdgesColor("gray")
A.SetAllVerticesColor("green")

for v in G.vertices:
    pred[v] = None
