################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version 0.94A from 4/09/01. You can find more information at 
#       http://www.zpr.uni-koeln.de/CATBox
#
#	file:   TwoSources.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#
#       Copyright (C) 1998-2000, ZAIK/ZPR, Universitt zu Kln
#       
#       All rights reserved. Do not distribute
#	
#
#       This file is version $Revision: 1.5 $ 
#                       from $Date: 2000/07/17 10:30:23 $
#             last change by $Author: pattberg $.
#
#
################################################################################

#### Options #################################################

breakpoints = [15]
interactive = [2,3]
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Shortest Path - Two Sources</TITLE>
</HEAD>
<BODY>

This algorithm finds a shortest path (cardinality of edges)
from the source to the sink in a graph. 

</BODY></HTML>
"""
found = 0

#### Variables ###############################################

def pickCallback(A,v,type):
    if type == "s":
        A.SetVertexAnnotation(v,type,"green")
    else:
        A.SetVertexAnnotation(v,type,"red")
    return

Neighborhood       = lambda v,a=A,g=G: AnimatedNeighborhood(a,g,v,["red"])
pickCallbackSource = lambda v, type="s", a=A: pickCallback(a,v,type)
PickSource         = lambda f=pickCallbackSource: self.PickVertex(1,None,f)
pickCallbackSink   = lambda v, type="t", a=A: pickCallback(a,v,type)
PickSink           = lambda f=pickCallbackSink: self.PickVertex(G.Order(),None,f)
ShowPath           = lambda u,v: showPathByPredecessorArray(u,v,pred,A,"yellow")

T1 = AnimatedSubGraph(G,A,"red")
T2 = AnimatedSubGraph(G,A,"red")
Q1 = AnimatedVertexQueue(A, "blue", "red")
F1 = AnimatedVertexQueue(A, "white", "red")
Q2 = AnimatedVertexQueue(A, "blue", "red")
F2 = AnimatedVertexQueue(A, "white", "red")

pred  = AnimatedPredecessor(A)
level = VisibleVertexLabeling(A)
 

#### Internal initialisation #################################

A.SetAllVerticesColor("green")

for v in G.vertices:
    pred[v] = None
