(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13057,        433]*)
(*NotebookOutlinePosition[     16335,        524]*)
(*  CellTagsIndexPosition[     16240,        517]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Basic Overview of ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "`RunThrough`"
}], "Section"],

Cell[TextData[{
  "This sample notebook demonstrates how to display a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics inside JavaView using the RunThrough mechanism of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". More thorough examples are given in the notebook Overview.nb available \
at the download site of JavaView at http://www.javaview.de.\nThe package ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "`RunThrough` is an add-on package to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " which must be installed before using this demonstration. Some examples in \
this notebook assume that ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " was installed in the default place AddOns/Applications/",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " inside the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installation.\nNote, the package ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "`JLink` which provides much more functionality and a better integration of \
",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Load the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " add-on package."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(<< JavaView`RunThrough`\)], "Input",
  CellLabel->"In[1]:="],

Cell["Create a cuboid geometry.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(cube\  = \ 
        Graphics3D[
          Cuboid[{0, 0, 0}, {5, 2, 1}]];\)\), "\[IndentingNewLine]", 
    \(\(Show[cube];\)\)}], "Input",
  CellLabel->"In[10]:="],

Cell[TextData[{
  "Display the cuboid in an external ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(RunJavaView[cube]\)], "Input",
  CellLabel->"In[7]:="],

Cell[CellGroupData[{

Cell["View an Animation", "Subsection"],

Cell[TextData[{
  "A list of geometries of the same type are displayed in ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " either as a collection of individual geometries or as an animation of a \
single geometry."
}], "Text"],

Cell[TextData[{
  "Display a list of cuboids in an external ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display as a set of individual ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " geometries."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(randCube\  := \ 
        Cuboid[10 {Random[], Random[], 
              Random[]}];\)\), "\[IndentingNewLine]", 
    \(\(cubes\  = \ 
        Table[Graphics3D[randCube], {20}];\)\), "\[IndentingNewLine]", 
    \(\(RunJavaView[cubes];\)\)}], "Input",
  CellLabel->"In[24]:="],

Cell["\<\
Display the same list of cuboids as an animation of a single cube.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(RunJavaView[cubes, \ Animatable \[Rule] True];\)\)], "Input",
  CellLabel->"In[27]:="],

Cell["Here is the smooth animation of a deformable surface.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(catenoid = 
        Table[\ ParametricPlot3D[\n\t{Cos[t]*Cos[x]*Cosh[y] + 
                Sin[t]*Sin[x]*Sinh[y], \n\t\t\t\t\(-Cos[t]\)*Sin[x]*Cosh[y] + 
                Sin[t]*Cos[x]*Sinh[y], \n\t\t\t\tCos[t]*y + 
                Sin[t]*x}, \n\t{x, \(-Pi\), Pi}, {y, \(-Pi\)/2, 
              Pi/2}, \n\t\tAspectRatio -> Automatic, \n\t\tBoxed -> 
              False, \n\t\tAxes -> 
              False, \n\t\tPlotPoints\  -> \ {13, 
                7}, \n\t\tPlotRange -> {{\(-2.5\), 2.5}, {\(-2.5\), 
                  2.5}, {\(-4. \), 4. }}], \[IndentingNewLine]{t, 0. , 
            Pi/2. , Pi/12. }];\)\), "\[IndentingNewLine]", 
    \(\(RunJavaView[catenoid, \ Animatable \[Rule] True];\)\)}], "Input",
  CellLabel->"In[18]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Save to and Read from Geometry files", "Subsection"],

Cell[TextData[{
  "The command WriteMgs[] saves a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics in a geometry file for later processing. For example, ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " is able to read such a file from an applet and from the command line, or \
the file may be re-imported back into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["Generate a cuboid as working example.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(cube\  = \ Graphics3D[Cuboid[{0, 0, 0}, {5, 2, 1}]];\)\)], "Input",
  CellLabel->"In[2]:="],

Cell["\<\
Save the cuboid in a geometry file cuboids.mgs to a temporary directory. \
Ensure that the directory c:\\Temp\\ exists, or adjust the path below.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(fileName\  = \ "\<c:\Temp\cube.mgs\>";\)\), "\[IndentingNewLine]", 
    \(\(WriteMgs[cube, fileName];\)\)}], "Input",
  CellLabel->"In[9]:="],

Cell[TextData[{
  "Re-import the previously saved geometry file as a regular ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics. There is no difference between the original \"cube\" and \
\"importCube\"."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(importCube\  = \ Get[fileName];\)\), "\[IndentingNewLine]", 
    \(\(Show[importCube];\)\)}], "Input",
  CellLabel->"In[11]:="],

Cell[TextData[{
  "Import a geometry file which was generated with JavaView. ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " allows to save geometries in the Mgs format."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(importSample\  = \ 
        Get["\<AddOns\\Applications\\JavaView\\mgs\\sample.mgs\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(Show[importSample];\)\)}], "Input",
  CellLabel->"In[19]:="],

Cell["Save an Animation", "Subsubsection"],

Cell[TextData[{
  "The command WriteAnim[] saves a list of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics as an animation in a geometry file. For example, ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " is able to play such a file as animation in an applet and from the \
command line, or the file may be re-imported back into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Create a list of cuboids in an external ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display as a set of individual ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " geometries."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(rcoord := {Random[], Random[], Random[]}\), "\[IndentingNewLine]", 
    \(\(cubeAnim\  = \ 
        Table[Graphics3D[Cuboid[10  rcoord]], {i, 1, 20}];\)\)}], "Input",
  CellLabel->"In[2]:="],

Cell["\<\
Save the cuboids as animation in a geometry file cuboidAnim.mgs in a \
temporary directory.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(fileName\  = \ \
"\<AddOns\\Applications\\JavaView\\mgs\\cubeAnim.mgs\>";\)\), "\
\[IndentingNewLine]", 
    \(\(WriteAnim[cubeAnim, fileName];\)\)}], "Input",
  CellLabel->"In[4]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Create a Web Page of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Graphics"
}], "Subsection"],

Cell[TextData[{
  "The following command saves the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics in a web page with a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " applet. This web page may be opened in a web browser, or published on a \
web site."
}], "Text"],

Cell["Generate a cuboid as working example.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(cube\  = \ 
        Graphics3D[Cuboid[{5, 2, 1}], 
          PlotLabel \[Rule] "\<Cuboid\>"];\)\)], "Input",
  CellLabel->"In[2]:="],

Cell[TextData[{
  "Create an Html page which displays the cuboid in a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " applet. The web page can be opened in any web browser."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(WriteHtml[
      cube, "\<AddOns\\Applications\\JavaView\\cube.html\>"]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \("AddOns\\Applications\\JavaView\\cube.html"\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  "Note, it is essential to save in the directory of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " installation unless the path options of WriteHtml[] are adjusted as \
explained below."
}], "Text"],

Cell["\<\
The DOS path name separator \"\\\" in the path name of the Html file must be \
casted. On Unix systems a slash \"/\" must be used.\
\>", "Text"],

Cell["Adjusting the Codebase of Applet", "Subsubsection"],

Cell[TextData[{
  "The ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " applet in the Html page needs the Java library 'javaview.jar' which \
contains the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " viewer. A web browser finds the location of the library by concatenating \
two string attributes of the applet: codebase and archive. The codebase \
attribute may either be an absolute or relative URL, and the archive \
attribute is a relative URL. If the codebase attribute is a relative URL then \
it is relative to the URL of the Html page.\nThe option \"Codebase\" \
specifies the codebase attribute of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " applet. The codebase attribute is \"./\" on default, i.e. it refers to \
the directory of the Html page."
}], "Text"],

Cell[TextData[{
  "The option \"PathToArchive\" specifies the path of the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " archive relative to the codebase of the applet. A default installation of \
",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installation puts the Java archive to <<mathematica \
root>>\\AddOns\\Applications\\",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  "\\Java\\javaview.jar, and the default value of PathToArchive is \"Java/\".\
\nThe path name separators in the archive attributes must always be a slash \
\"/\". "
}], "Text"],

Cell["\<\
Save the web page in a non-standard directory and adjust the codebase and \
archive attributes of the applet.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(htmlFile\  = \ "\<AddOns\\Applications\\JavaView\\html\\cube.html\>";\
\)\), "\[IndentingNewLine]", 
    \(\(codebase\  = \ "\<../\>";\)\), "\[IndentingNewLine]", 
    \(\(archive = \ "\<Java/\>";\)\), "\[IndentingNewLine]", 
    \(WriteHtml[cube, htmlFile, Codebase \[Rule] codebase, 
      PathToArchive \[Rule] archive]\)}], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \("AddOns\\Applications\\JavaView\\html\\cube.html"\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "Note, if the web page is published on a web site, then the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " archive must be published as well."
}], "Text"]
}, Closed]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 723}},
CellGrouping->Manual,
WindowSize->{800, 612},
WindowMargins->{{Automatic, 83}, {Automatic, 7}},
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.1.3"->{
    Cell[3024, 93, 150, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3260, 105, 79, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3530, 115, 168, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4078, 139, 265, 9, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4645, 159, 128, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4887, 168, 107, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6269, 205, 91, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6479, 212, 207, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6856, 223, 271, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7283, 237, 228, 6, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8203, 268, 264, 9, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8684, 285, 153, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[9507, 319, 91, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[9758, 328, 231, 6, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[12156, 403, 171, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]},
  "3.5"->{
    Cell[3024, 93, 150, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3260, 105, 79, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3530, 115, 168, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4078, 139, 265, 9, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4645, 159, 128, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[4887, 168, 107, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6269, 205, 91, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6479, 212, 207, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6856, 223, 271, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7283, 237, 228, 6, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8203, 268, 264, 9, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8684, 285, 153, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[9507, 319, 91, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[9758, 328, 231, 6, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[12156, 403, 171, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.1.3", 13718, 451},
  {"3.5", 14972, 482}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 120, 5, 77, "Section"],
Cell[1840, 56, 1181, 35, 178, "Text"],
Cell[3024, 93, 150, 6, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3177, 101, 80, 2, 33, "Input"],
Cell[3260, 105, 79, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3342, 108, 185, 5, 54, "Input"],
Cell[3530, 115, 168, 6, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3701, 123, 74, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[3800, 129, 39, 0, 56, "Subsection"],
Cell[3842, 131, 233, 6, 48, "Text"],
Cell[4078, 139, 265, 9, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[4346, 150, 296, 7, 75, "Input"],
Cell[4645, 159, 128, 3, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[4776, 164, 108, 2, 33, "Input"],
Cell[4887, 168, 107, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[4997, 171, 758, 13, 264, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5792, 189, 58, 0, 56, "Subsection"],
Cell[5853, 191, 413, 12, 48, "Text"],
Cell[6269, 205, 91, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[6363, 208, 113, 2, 33, "Input"],
Cell[6479, 212, 207, 4, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[6689, 218, 164, 3, 54, "Input"],
Cell[6856, 223, 271, 7, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[7130, 232, 150, 3, 54, "Input"],
Cell[7283, 237, 228, 6, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[7514, 245, 210, 5, 54, "Input"],
Cell[7727, 252, 42, 0, 42, "Subsubsection"],
Cell[7772, 254, 428, 12, 67, "Text"],
Cell[8203, 268, 264, 9, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[8470, 279, 211, 4, 54, "Input"],
Cell[8684, 285, 153, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[8840, 291, 206, 5, 54, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[9083, 301, 126, 5, 52, "Subsection"],
Cell[9212, 308, 292, 9, 48, "Text"],
Cell[9507, 319, 91, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[9601, 322, 154, 4, 33, "Input"],
Cell[9758, 328, 231, 6, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[10014, 338, 128, 3, 33, "Input"],
Cell[10145, 343, 101, 2, 27, "Output"]
}, Open  ]],
Cell[10261, 348, 228, 6, 48, "Text"],
Cell[10492, 356, 154, 3, 29, "Text"],
Cell[10649, 361, 57, 0, 42, "Subsubsection"],
Cell[10709, 363, 802, 18, 132, "Text"],
Cell[11514, 383, 639, 18, 94, "Text"],
Cell[12156, 403, 171, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[12352, 411, 383, 7, 96, "Input"],
Cell[12738, 420, 107, 2, 27, "Output"]
}, Open  ]],
Cell[12860, 425, 181, 5, 29, "Text"]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

