package vgp.tutor.key;

import jv.anim.PsAnimation;
import jv.anim.PsKeyframe;
import jv.geom.PgElementSet;
import jv.loader.PjImportModel;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.project.PjProject;
import jv.project.PvViewerIf;

/**
 * Demo project of keyframe animation of precomputed models.
 * 
 * @author		Konrad Polthier
 * @version		16.09.00, 1.20 revised (kp) Register this project as time listener instead of keyframe object.<br>
 *					04.07.00, 1.10 revised (kp) Made keyframe object the dynamic geometry.<br>
 *					00.00.99, 1.00 created (kp)
 */
public class PjKeyframe extends PjProject {
	private		static String			m_defaultModel		= "models/cmc/Lawson_3_90_60_Anim.*.byu";
	private		static int				m_defaultNumKeys	= 5;

	protected	PgGeometry				m_geom;
	protected	PsKeyframe				m_keyframe;
	protected	String					m_fileName;
	protected	int						m_numKeys;
	protected	PjImportModel			m_import;

	public PjKeyframe() {
		super("Keyframe Animation");
		m_import = new PjImportModel();
		m_import.setTypeOfInfoPanel(PjImportModel.SMALL_INFO_PANEL);
		m_import.setParent(this);

		m_keyframe = new PsKeyframe();
		m_keyframe.setParent(this);

		// Show animation panel
		PsAnimation anim = new PsAnimation();
		setAnimation(anim);
		anim.setName(m_keyframe.getName());
		// Register the keyframe as time listener.
		anim.addTimeListener(m_keyframe);
		anim.enableKeys(true);

		if (getClass() == PjKeyframe.class)
		  init();
	}
	public void init() {
		super.init();
	}
	public void start() {
		PvViewerIf viewer = getViewer();
		if (m_fileName == null) {
			m_fileName = viewer.getParameter("Model");
			try {
				String num = viewer.getParameter("Number");
				if (num != null)
					m_numKeys = Integer.parseInt(num);
			} catch (NumberFormatException e) {
				m_numKeys = 1;
			}
		}
		if (m_fileName == null)
			setFileName(PsConfig.getCodeBase()+m_defaultModel, m_defaultNumKeys);
		if (load()) {
			// If applet parameter does not forbid showing of animation panel
			// then show it now:
			PsAnimation anim = m_keyframe.getAnimation();
			if (anim!=null) {
				String panelVis	= viewer.getParameter("Animation");
				if (panelVis==null || panelVis.equalsIgnoreCase("show"))
					anim.getAnimationPanel().setVisible(true);
			}
		}
		super.start();
	}
	public String getFileName()		{ return m_fileName; }
	public void setFileName(String fileName, int numKeys) {
		if (fileName != null) {
			m_fileName	= fileName;
			m_numKeys	= numKeys;
		} else {
			m_fileName	= PsConfig.getCodeBase()+m_defaultModel;
			m_numKeys	= m_defaultNumKeys;
		}
	}
	public boolean load() {
		if (m_fileName == null) {
			if (PsDebug.WARNING) PsDebug.warning("missing fileName to load");
			return false;
		}
		if (m_geom != null)
			removeGeometry(m_geom);
		// Reset the keyframe object
		m_keyframe.init();
		double startTime	= 0.;
		double endTime		= 100.;
		double time			= startTime;
		double timeIncr	= (endTime - startTime) / (double)(m_numKeys - 1.);
		for (int i=0; i<m_numKeys; i++) {
			String name = m_fileName.replace('*', String.valueOf(i+1).charAt(0));
			if (PsDebug.NOTIFY) PsDebug.notify("loading name = "+name);
			m_import.load(name);
			m_keyframe.addKey((PgGeometry)(m_import.getGeometry().clone()), time);
			time += timeIncr;
		}
		String name = PsUtil.getFileName(m_fileName);
		m_keyframe.setName(name);
		PsAnimation anim = m_keyframe.getAnimation();
		if (anim != null) {
			anim.setName(name);
			anim.update(anim);
		}
		m_keyframe.setTime(startTime);
		// Add dynamic, interpolated geometry to display
		m_geom = m_keyframe.getDynamic();
		if (m_geom==null) {
			// If reading failed, return false.
			return false;
		}
		// Hide elements to speed up rendering of large models.
		if (m_geom instanceof PgElementSet)
			((PgElementSet)m_geom).showElements(false);
		addGeometry(m_geom);
		selectGeometry(m_geom);
		return true;
	}

	/** Each time another geometry is loaded, <code>PjImportModel</code> calls <code>update</code>. */
	public boolean update(Object object) {
		if (PsDebug.NOTIFY) PsDebug.notify("called");
		if (object == m_keyframe) {
			return true;
		} else if (object == m_import) {
			return true;
		}
		return super.update(object);
	}
}
