package vgp.tutor.parm;

import jv.geom.PgElementSet;
import jv.function.PuFunction;
import jv.object.PsDebug;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jvx.surface.PgDomainDescr;
import jvx.surface.PgParmSurface;

/**
 * Describes a parametrized surface over a two dimensional domain.
 * Coordinate functions may be given as strings and
 * interactively edited. Parameter domain allows adjusting using sliders.
 * 
 * @see			jvx.surface.PgDomainDescr
 * @see			jvx.surface.PgParmSurface
 * @author		Konrad Polthier
 * @version		27.08.99, 1.10 revised (kp) Name PgDomain changed to PgDomainDescr.<br>
 *					27.08.98, 1.00 created (kp) from PgParmSurface.
 */
public class PjParmSurface extends PjProject {
	/** Domain of parametrized surface. */
	protected	PgDomainDescr			m_domain;
	/** Function object consisting of functions as strings. */
	protected	PuFunction				m_function;
	/** Geometry of surface, dimension of vertices is equal to numFunctions. */
	protected	PgElementSet			m_surface;
	/** Parametrized Surface. */
	protected	PgParmSurface			m_parmSurface;

	public PjParmSurface() {
		super("Parametrized Surface");
		int dimOfDomain	= 2;
		int numFunctions	= 3;
		m_domain		= new PgDomainDescr(dimOfDomain);
		m_function	= new PuFunction(dimOfDomain, numFunctions);
		m_surface	= new PgElementSet(numFunctions);
		m_surface.setName("Kuen Surface");
		m_parmSurface = new PgParmSurface(numFunctions);
		m_parmSurface.setDomain(m_domain);
		m_parmSurface.setFunction(m_function);
		m_parmSurface.setSurface(m_surface);
		m_parmSurface.setParent(this);
		if (getClass() == PjParmSurface.class)
			init();
	}
	public void init() {
		super.init();
		m_domain.setName("Domain of Kuen");
		m_domain.setMaxSize(-10., 0.01, 10., Math.PI-.01);
		m_domain.setSize(-4.5, 0.05, 4.5, Math.PI-.05);
		m_domain.setDiscr(16, 16);
		m_domain.init();
		m_function.setName("Functions of Kuen");
		m_function.setExpression("2./(1.+(u*sin(v))^2)*sqrt(1.+u*u)*sin(v)*cos(u-atan(u))", 0);
		m_function.setExpression("2./(1.+(u*sin(v))^2)*sqrt(1.+u*u)*sin(v)*sin(u-atan(u))", 1);
		m_function.setExpression("log(tan(v/2.))+2./(1.+(u*sin(v))^2)*cos(v)", 2);
	}
	public void start() {
		if (PsDebug.NOTIFY) PsDebug.notify("PjParmSurface.start: computing torus as element set");
		m_parmSurface.computeSurface();
		addGeometry(m_surface);
		selectGeometry(m_surface);
		super.start();
	}

	/**
	 * Update the class whenever a child has changed.
	 * Method is usually invoked from the children.
	 */
	public boolean update(Object event) {
		if (PsDebug.NOTIFY) PsDebug.notify("PjParmSurface.update() called");
		if (event == m_parmSurface) {
			return super.update(null);
		}
		return super.update(event);
	}    
}
