#include <stdio.h>
#include <math.h>

#define PI           3.14159265358979323846
#define TWOPI        6.28318530717958647693
#define PIBY2        1.57079632679489661923
#define DEG_TO_RAD   0.0174532925199432957692  /*  (PI / 180)  */
#define RAD_TO_DEG   57.2957795130823208768    /*  (180 / PI)  */
#define GOLDEN_RATIO  1.618033988749894848205

typedef float real;
typedef int   boolean;
typedef float vector [3];

conv_to_xyz (radius, theta, phi, vert)
     real radius, theta, phi;
     vector vert;
{
  vert [0] = radius * sin (theta) * cos (phi);
  vert [1] = radius * sin (theta) * sin (phi);
  vert [2] = radius * cos (theta);
}

conv_to_polar (vert, radius, theta, phi)
     vector vert;
     real *radius, *theta, *phi;
{
  *radius = sqrt (vert [0] * vert [0] +
                  vert [1] * vert [1] +
                  vert [2] * vert [2]);
  *phi = atan2 (vert [1], vert [0]);
  if (*radius == 0.0)
    *theta = 0.0;
  else 
    *theta = acos (vert [2] / *radius);
}

main (argc, argv)
     int argc;
     char **argv;
{
  int f, N;
  FILE *fp;
  float p, q, scale;
  vector a;

  N = 33;
  f = atoi (argv [1]);
  p = ((float) f - 1.0) / ((float) N - 1.0);
  q = 1.0 - p;

  fp = fopen ("script", "w");

  fprintf (fp, "%% p = %f, q = %f\n\n", p, q);

  /* issue the unknot command */

  
  conv_to_xyz (1.0, (p * 160.0 + 10.0) * DEG_TO_RAD, 0.0, a);
  scale = sqrt (a [0] * a [0] + a [1] * a [1]);
  
  fprintf (fp, "Draw=f\n");
  fprintf (fp, "del all\nunknot 22 %f\n", scale * 6.0);
  fprintf (fp, "translate 0 0 %f\n", a [2] * 6.0);
  fprintf (fp, "coord /tmp/kp-hopf.dum\n");
  fprintf (fp, "!fixit-hopf\n");
  fprintf (fp, "delete all\n");
  fprintf (fp, "Draw=t\n");
  fprintf (fp, "clrf zf\ndisp\ndisp\nclrf n\n");
  fprintf (fp, "</tmp/kp-hopf.dum\n");
  fprintf (fp, "gflush\n");


  
  fclose (fp);
}

