/*

   compile with:

        cc -o ginv ginv.c -lfm_s -lgl_s -lc_s
	strip ginv

*/


/*
 *	ginv.c
 *
 *	ginv (Graphics Inventory)
 *
 *	v1.0,	May 1991
 *
 *	(c) 1991 Rodney Hoinkes
 *	Centre for Landscape Research
 *	University of Toronto
 *	rodney@dgp.utoronto.ca
 *
 *	This software is released under the conventions of
 *	'anyware', meaning you can put it anyware, do anything,
 *	or rm it as you please as long as you don't try to
 *	get money for it (good luck if you want to try!).
 *
 *	This software was written to test out the getgdesc
 *	function and to see what different hardware configurations
 *	look like to a graphics program that really wants to know.
 *  The following data was gathered from some machines I have
 *	access to for general info.  
 *
 *	compile with: cc -o ginv ginv.c -lfm_s -lgl_s -lc_s
 *	stripping the executable will greatly reduce its size
 *	strip ginv
 *
 *	If there is interest, I am working on a version to inform
 *	the make process.
 *
 *	A machine-independent version of psgl (GL->Postscript) is also
 *	in the debugging stages since the current GL implementation
 *	differs depending which machine you compile on, not just what
 *	parameter set you use. This version does not require compile
 *	definitions, but determines machine at run-time.
 *
 *
 *
 */
#include <stdio.h>
#include <gl.h>
#include <device.h>
#include <fmclient.h>

main(argc,argv)
int argc;
char *argv[];
{
	register int i,j,c;
	short machinetype;
	float softversion;
	char version[40],software[6],machine[6];
	char buf[50][255];
	char opbuf[50][40], yes[4000], no[4000];
	char op[50];
	char showfonts = 0;

	/* check commandline parameters */
	if(argc == 2) {
		if(!strcmp(argv[1],"-h")) {
			printf("usage: %s [-h] [-f]\n",argv[0]);
			printf("\t-h\tThis help menu.\n");
			printf("\t-f\tShow list of installed fonts.\n");
			exit(1);
		}
		else if(!strcmp(argv[1],"-f")) showfonts = 1;
	}
	/* open program window and setup display settings */
	noport();

	foreground();
	winopen("SetupCheck");
	gconfig();

	/* get machine information */
	gversion(version);
	for(i=2;i<strlen(version);++i){
		if(version[i]=='-') break;
		machine[i-2]=version[i];
	}
	machine[i-2]='\0';
	software[0]=version[i+1];
	software[1]=version[i+2];
	software[2]=version[i+3];
	software[3]='\0';
	softversion = atof(software);

	printf("IRIS 4D Graphics Inventory (ginv v1.0)\n");
	printf("--------------------------------------\n");
	printf("Machine: %s running IRIX version %s\n",machine,software);

	printf("%d Screen(s) Accessible on this machine.\n\n",getgdesc(GD_NSCRNS));

	i = 0;
	sprintf(buf[i++],"Screen Resolution:  %d x %d pixels.",getgdesc(GD_XPMAX),getgdesc(GD_YPMAX));
	sprintf(buf[i++],"Zbuffer Resolution: 0x%X min  0x%X max.",getgdesc(GD_ZMIN),getgdesc(GD_ZMAX));

	if(getgdesc(GD_BITS_ACBUF_HW))
		sprintf(buf[i++],"Hardware Accumulation Buffer with %d bitplanes per colour component.",getgdesc(GD_BITS_ACBUF_HW));
	else if(getgdesc(GD_BITS_ACBUF))
		sprintf(buf[i++],"Software Accumulation Buffer with %d bitplanes per colour component.",getgdesc(GD_BITS_ACBUF));
	else
		strcpy(buf[i++],"No Accumulation Buffer present.");

	sprintf(buf[i++],"Alpha bitplanes in DoubleBuffered: %d, SingleBuffered: %d",getgdesc(GD_BITS_NORM_DBL_ALPHA),getgdesc(GD_BITS_NORM_SNG_ALPHA));
	sprintf(buf[i++],"Red   bitplanes in DoubleBuffered: %d, SingleBuffered: %d",getgdesc(GD_BITS_NORM_DBL_RED),getgdesc(GD_BITS_NORM_SNG_RED));
	sprintf(buf[i++],"Green bitplanes in DoubleBuffered: %d, SingleBuffered: %d",getgdesc(GD_BITS_NORM_DBL_GREEN),getgdesc(GD_BITS_NORM_SNG_GREEN));
	sprintf(buf[i++],"Blue  bitplanes in DoubleBuffered: %d, SingleBuffered: %d",getgdesc(GD_BITS_NORM_DBL_BLUE),getgdesc(GD_BITS_NORM_SNG_BLUE));
	sprintf(buf[i++],"Zbuffer  bitplanes present: %d",getgdesc(GD_BITS_NORM_ZBUFFER));
	sprintf(buf[i++],"Stencil  bitplanes present: %d",getgdesc(GD_BITS_STENCIL));
	sprintf(buf[i++],"Overlay  bitplanes present: %d",getgdesc(GD_BITS_OVER_SNG_CMODE));
	sprintf(buf[i++],"PopUp    bitplanes present: %d",getgdesc(GD_BITS_PUP_SNG_CMODE));
	sprintf(buf[i++],"Underlay bitplanes present: %d",getgdesc(GD_BITS_UNDR_SNG_CMODE));
	sprintf(buf[i++],"User-defined Clipping Planes present: %d",getgdesc(GD_CLIPPLANES));
	if(getgdesc(GD_PNTSMOOTH_CMODE))
		sprintf(buf[i++],"antialiased points available in colormap");
	else
		sprintf(buf[i++],"antialiased points not available in colormap");
	if(getgdesc(GD_PNTSMOOTH_RGB))
		sprintf(buf[i++],"antialiased points available in RGB");
	else
		sprintf(buf[i++],"antialiased points not available in RGB");
	if(getgdesc(GD_LINESMOOTH_CMODE))
		sprintf(buf[i++],"antialiased lines available in colormap");
	else
		sprintf(buf[i++],"antialiased lines not available in colormap");
	if(getgdesc(GD_LINESMOOTH_RGB))
		sprintf(buf[i++],"antialiased lines available in RGB");
	else
		sprintf(buf[i++],"antialiased lines not available in RGB");
	if(getgdesc(GD_POLYSMOOTH))
		sprintf(buf[i++],"antialiased polygons available in RGB");
	else
		sprintf(buf[i++],"antialiased polygons not available in RGB");
	if(getgdesc(GD_NVERTEX_POLY) == GD_NOLIMIT)
		sprintf(buf[i++],"Number of verticies per polygon allowed: Unlimited.");
	else
		sprintf(buf[i++],"Number of verticies per polygon allowed: %d.",getgdesc(GD_NVERTEX_POLY));

	j = 0;
	sprintf(opbuf[j],"afunction");
	if(getgdesc(GD_AFUNCTION))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"logicop");
	if(getgdesc(GD_LOGICOP))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"fogvertex");
	if(getgdesc(GD_FOGVERTEX))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"two-sided lighting");
	if(getgdesc(GD_LIGHTING_TWOSIDE))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"blendfunction");
	if(getgdesc(GD_BLEND))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"readsource AUTO/FONT/BACK");
	if(getgdesc(GD_READSOURCE))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"readsource ZBUFFER");
	if(getgdesc(GD_READSOURCE_ZBUFFER))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"scrbox");
	if(getgdesc(GD_SCRBOX))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"subpixel points");
	if(getgdesc(GD_SUBPIXEL_PNT))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"subpixel lines");
	if(getgdesc(GD_SUBPIXEL_LINE))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"subpixel polygons");
	if(getgdesc(GD_SUBPIXEL_POLY))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"stereo");
	if(getgdesc(GD_STEREO))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"texture-mapping");
	if(getgdesc(GD_TEXTURE))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"polymode");
	if(getgdesc(GD_POLYMODE))
		op[j++] = 1;
	else
		op[j++] = 0;

	sprintf(opbuf[j],"64x64 patterns");
	if(getgdesc(GD_PATSIZE_64))
		op[j++] = 1;
	else
		op[j++] = 0;



	for(c=0;c<j;++c) {
		if(op[c]) {
			strcat(yes,opbuf[c]);
			strcat(yes,", ");
		} else {
			strcat(no,opbuf[c]);
			strcat(no,", ");
		}
	}

	for(c=0;c<i;++c) puts(buf[c]);

	yes[strlen(yes)-2] = '.';
	no[strlen(no)-2] = '.';
	printf("\nFUNCTIONS AVAILABLE:\n");
	puts(yes);
	printf("\nFUNCTIONS NOT AVAILABLE:\n");
	puts(no);


	if(showfonts) {
		printf("\nINSTALLED FONTS\n\n");
		fmenumerate(puts);
	}
}
