################################################################################
#
#       This file is part of Gato (Graph Animation Toolbox) 
#       version 0.96G from 05/16/2001. You can find more information at 
#       http://www.zpr.uni-koeln.de/~gato
#
#	file:   GatoIcons.py
#	        automatically created by mkGatoIcons
#
#       Copyright (C) 1998-2000, ZAIK/ZPR, Universitt zu Kln
#
#       This library is free software; you can redistribute it and/or
#       modify it under the terms of the GNU Library General Public
#       License as published by the Free Software Foundation; either
#       version 2 of the License, or (at your option) any later version.
#
#       This library is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#       Library General Public License for more details.
#
#       You should have received a copy of the GNU Library General Public
#       License along with this library; if not, write to the Free
#       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#
#
################################################################################
black = """
R0lGODdhHgAeAPcAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAz
zAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDM
ZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMz
ADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZ
zDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YA
ZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/
zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lm
ZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/
AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwz
zMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zM
ZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8z
AP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoa
GigoKDU1NUNDQ1BQUF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx
8f///wAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxIsKDBgwgTKlzIsKHDhxAjSpxI
saLFixgzatzIsaPHjyBDihxJsqTJkyhTngwoADs=
"""

blacknde = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//
AAAA//8A/wD//////ywAAAAAGgAYAAMEgPDJSau9eILMJTAfEIBbNxmBCKzsaD5s
OKZtianHSoM5yYUs0IOWmt2IKA1paaOESCxYUbe6qGg9GIgZsDJ1UmrKYKFeP9rV
tlpeA8NTkXVKTDPJbfW7dp2LATk5T1FeQDFnaDcqHyMiUEk/gIdBNCYsOTMobC8w
k5ucoKGioxMRADs=
"""

bledge = """
R0lGODdhHgAeAPcAAACZzAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAz
zAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDM
ZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMz
ADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZ
zDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YA
ZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/
zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lm
ZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/
AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwz
zMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zM
ZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8z
AP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoa
GigoKDU1NUNDQ1BQUF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx
8f///wAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxIsKDBgwgTKlzIsKHDhxAjSpxI
saLFixgzatzIsaPHjyBDihxJsqTJkyhTngwoADs=
"""

bluenode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//
AAAA//8A/wD//////ywAAAAAGgAYAAMEWPDJSau9eILMJfgg2FHhx5TjEzJse4oZ
6M7sx5kzQNuX3PouWAWXo716up2RN0wWd5um8bSMSpVQ5LKqxeasJOK0xryOyTEx
9wYMCtMlVMoTL8/v+LxeEiEAOw==
"""

catbox_splash = """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"""

delete = """
R0lGODdhIAAgAPcPAAAAAIAAAACAAICAAAAAgIAAgACAgMDAwICAgP8AAAD/AP//
AAAA//8A/wD//////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAAgACAABwiTAAMIHEiwoMGDCBMqXMiw
ocOHECNKNAigosWLFiUCOMCxo8cDFSNu/PhxIwCII0l6NPkwpUqOI082dPkypcyF
NFW6vJkwp86OPBH6JLkT58uSK40eBZpU4VCiTYUuXRn1IMarGEs6ncoUqFKuNhk+
RQpTLFeYZc2eZTnzLEiQDseuDLp1Ld2eWPNO3Mu3r9+/CwMCADs=
"""

dkblnode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//
AAAA//8A/wD//////ywAAAAAGgAYAAMEefDJSau9eILMJfgg2FGhADCfuY0h4zou
KmYgA8N27nzcl7+nl4t3qeVANyCx8kkeY7ol6WT47XQxqeaEwwGcMO3D133GbuJx
EGfj/mRFd3ItTJOh1/JuxfRh/zJ8fW9sUYJ9ckJehxYtP1UhLCGTaTSUlSOZmpuc
GBEAOw==
"""

dkgnnode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//
AAAA//8A/wD//////ywAAAAAGgAYAAMEhvDJSau9eILMJfgg2FHhZ5TjEyoHa7Ah
B7rG8BrtuWXf8eYAnEL4wYB+OkAOWLR8hksFAEptVkwtH0zItZKUQ9Yw6HJ5PeQa
DjfVas9orliJhO2u4PW4/L5/62w3S3AqPXVRPiIXJlQ+XC+EaEEDfGIHkRpHSAJJ
fkYloCmZoJ6ipqeoqQ8RADs=
"""

edge = """
R0lGODdhIAAgAPcPAAAAAIAAAACAAICAAAAAgIAAgACAgMDAwICAgP8AAAD/AP//
AAAA//8A/wD//////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAAgACAABwh0AAMIHEiwoMGDCBMqXMiw
ocOHDAFIBABxIYAEGBNQrHjwYkaMGzkS9PgxpEiBJDOaPJkS5MmCKSW+hDlx4kyE
Nm8azKlzpMyePlf25Ak0AFGgR4f+LGp0aVGbNZXGHPrR5c2WGnViFcpxK1WVT5My
HUs2YUAAOw==
"""

edit = """
R0lGODdhIAAgAPcPAAAAAIAAAACAAICAAAAAgIAAgACAgMDAwICAgP8AAAD/AP//
AAAA//8A/wD//////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAgACAABwh0AAEIHEiwoMGDCBMqXMgQ
gUMEDCMCeEgRosSEDglmvHhwo0aLHD8a9BhSIEmTIEuiFKnyY8WULVGevPiyZs2G
NnPOHKkzJ86eNxcCtflzKMWiRncWTFoRaVKnRqEOlQqUak+rOrH6FMr0oVaiMcOK
HUu2ZEAAOw==
"""

gato = """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"""

getgray = """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"""

gnedge = """
R0lGODdhHgAeAPcAAH7+qX3+qX39qXz9qXv8qnv7qnz8qXv8qXv7qXr7qnr6qnn6
qnj5q3f5q3b3rG7xrgAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz
/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDM
mQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMz
MzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ
/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYA
mWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZ
M2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb/
/5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplm
mZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/
M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz
/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszM
mczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8z
M/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z
///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoaGigo
KDU1NUNDQ1BQUF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx8f//
/wAAAAEBAQICAgMDAywAAAAAHgAeAAcIrQAfOHCgwIACBQIMGBDAEICAAAwjMoTY
0OHAggolVgTAEUAAjh85CugYIOPIjihTqlwZcaXLlx0fwpxJs6bNmzhz6tzJs6fP
n0BVhgxKtKjRozs3BtW4VONQngkWajy5swGDAgwQDGCq04BWAgcWTG258qlIqQcO
CDiwdaxQkB8pMhzQduzYAHg9lnyIl2LdiFJbbhw5USTFwIHdniQ8eKLdxxKl9u0L
+bFUAwF1ADs=
"""

gred = """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"""

greennde = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//
AAAA//8A/wD//////ywAAAAAGgAYAAMEWPDJSau9eILMJfgg2FHhp5TjEypse4oZ
6M7sx5kzQNuX3PouWAWXo716up2RN0wWd5um8bSMSpVQ5LKqxeasJOK0xryOyTEx
9wYMCtMlVMoTL8/v+LxeEiEAOw==
"""

grey = """
R0lGODdhHgAeAPcAAL6+vgAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAz
zAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDM
ZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMz
ADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZ
zDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YA
ZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/
zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lm
ZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/
AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwz
zMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zM
ZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8z
AP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoa
GigoKDU1NUNDQ1BQUF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx
8f///wAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxIsKDBgwgTKlzIsKHDhxAjSpxI
saLFixgzatzIsaPHjyBDihxJsqTJkyhTngwoADs=
"""

greynode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//
AAAA//8A/wD//////ywAAAAAGgAYAAMEXvDJSau9eILMJfgg2FHhh5TjEyJse4oZ
6M7sx5kzQNuX3PouWAXnOuh2GwsxeED2jjlW85ckQaNO5fVHez2721rVCgaPNcuu
+IxW59jo8LuzQvJupXwqrt/7/4CBFREAOw==
"""

ltblnode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//
AAAA//8A/wD//////ywAAAAAGgAYAAMEhfDJSau9eILMJfgg2FHhx5TjExoO67Qh
B7YOYxg2U38ykNMAF8vAu8yGRxysWPncaqyTMupgkgA1Ggs7RG4sTpqOqNTZrJ4g
dHjSutBp6lM9PX2b3KzOp10ag2NIUVRwKh8tg1ldIn9yWmZVd2BhdYhEkn+UQ5GF
eCUoKWmfmKGlpqeoDxEAOw==
"""

ltgnnode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//
AAAA//8A/wD//////ywAAAAAGgAYAAMElvDJSau9eILMJfgg2FGgAAiOKY4l4iyP
8yjqln2C+zrKHD8mzse1QBhzu4Xjg8EheqlhD6q6fHa+pVH2QjAtQ6JMMXA8s0Ew
QDzzQpWzgI20fnNz8N23cs0q12ZTQHN0Z28oWS57hWZYOXZehBpSD4YxSi9VVoBK
Ln5Gi3xDgW1nS5JqYWYukaGbIbCoQrGuI7a3uLkcEQA7
"""

mist = """
R0lGODdhIAAgAPcPAAAAAIAAAACAAICAAAAAgIAAgACAgMDAwICAgP8AAAD/AP//
AAAA//8A/wD//////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAAgACAABwixAAMIHEiwoMGDCBMqXMiw
ocMACCJKRPAQYcSDFysKzJiQY0OKDkEyFEkQgMmTAAaS7FgQpUuTEEeWPJmgps0E
KFcaFEnzpk+cAHQS5Gnyp1GTQjcOLGr0aEqLApk2dQo1gNSpPmFitAoA61StBSle
9XoT7FCuZKliHJsWqEW2ac2G7dq27NO1de0qhItVrsGebf3+pRv37l6+WQUfBNz0
ZEWUThUvfOlS4+DKljNrzhwQADs=
"""

pink = """
R0lGODdhHgAeAPcAAL8/vwAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAz
zAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDM
ZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMz
ADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZ
zDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YA
ZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/
zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lm
ZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/
AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwz
zMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zM
ZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8z
AP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoa
GigoKDU1NUNDQ1BQUF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx
8f///wAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxIsKDBgwgTKlzIsKHDhxAjSpxI
saLFixgzatzIsaPHjyBDihxJsqTJkyhTngwoADs=
"""

red = """
R0lGODdhHgAeAPcAAP8AAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAz
zAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDM
ZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMz
ADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZ
zDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YA
ZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/
zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lm
ZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/
AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwz
zMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zM
ZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8z
AP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoa
GigoKDU1NUNDQ1BQUF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx
8f///wAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxIsKDBgwgTKlzIsKHDhxAjSpxI
saLFixgzatzIsaPHjyBDihxJsqTJkyhTngwoADs=
"""

rednode = """
R0lGODdhGgAYAPEAAP///wAAAP8AAL8/vywAAAAAGgAYAAACU4SPqcsXDU2YlEZU
p8gXVAGGm9VQ4glOkHYGqLqYoSySCduiY+y+Onzr5V6PoG7zKxp9RN4v6WS2lBjc
MQVcXrElK3RFq9m6GU5HUs6e1+y221AAADs=
"""

swap = """
R0lGODdhIAAgAPcPAAAAAIAAAACAAICAAAAAgIAAgACAgMDAwICAgP8AAAD/AP//
AAAA//8A/wD//////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAAgACAABwixAAMIHEiwoMGDCBMGSKCw
YcIEDB1KHAgx4kSHFS1eDACgY8GMGicCqAiAIsiMIkkKPMkypMGREEuubAmyYUeZ
Jivm1LlxJsSPKBHePMiTYM2DQ4m6XBi0YFKiSosSfHrx6FSqE60OvImzqlSBXHv6
dBlW6MOfL7Fu7WoUbVqPb6MmLHsVbk+uXfE6tSsUr1+7MBOwffu3bODBSAsDVnmX
Lli+Fx2LjTt5LuLKWzFrHhgQADs=
"""

vertex = """
R0lGODdhIAAgAPcPAAAAAIAAAACAAICAAAAAgIAAgACAgMDAwICAgP8AAAD/AP//
AAAA//8A/wD//////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAAgACAABwixAAMIHEiwoMGDCBMqXMiw
ocMACCJKRPAQYcSDFysKzJiQY0OKDkEyFEkQgMmTAAaS7FgQpUuTEEeWPJmgps0E
KFcaFEnzpk+cAHQS5Gnyp1GTQjcOLGr0aEqLApk2dQo1gNSpPmFitAoA61StBSle
9XoT7FCuZKliHJsWqEW2ac2G7dq27NO1de0qhItVrsGebf3+pRv37l6+WQUfBNz0
ZEWUThUvfOlS4+DKljNrzhwQADs=
"""

whitnode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//
AAAA//8A/wD//////ywAAAAAGgAYAAMETPDJSau9eILMJfgg2FHh95TjKVoht2Ym
vFUzWdOxl2s7f90+FtDzG6p+RSHG2NMhlVBaMkqa4oxCbNOa7Wxt25a3RE7xyFiz
es1eR2wAOw==
"""

yellow = """
R0lGODdhHgAeAPcAAP//AAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAz
zAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDM
ZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMz
ADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZ
zDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YA
ZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/
zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lm
ZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/
AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwz
zMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zM
ZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8z
AP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+Z
zP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoa
GigoKDU1NUNDQ1BQUF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx
8f///wAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxIsKDBgwgTKlzIsKHDhxAjSpxI
saLFixgzatzIsaPHjyBDihxJsqTJkyhTngwIADs=
"""

def Init():
    import GatoUtil
    imageCache = GatoUtil.ImageCache() # singleton
    imageCache.AddImage("Icons/black.gif",black)
    imageCache.AddImage("Icons/blacknde.gif",blacknde)
    imageCache.AddImage("Icons/bledge.gif",bledge)
    imageCache.AddImage("Icons/bluenode.gif",bluenode)
    imageCache.AddImage("Icons/catbox_splash.gif",catbox_splash)
    imageCache.AddImage("Icons/delete.gif",delete)
    imageCache.AddImage("Icons/dkblnode.gif",dkblnode)
    imageCache.AddImage("Icons/dkgnnode.gif",dkgnnode)
    imageCache.AddImage("Icons/edge.gif",edge)
    imageCache.AddImage("Icons/edit.gif",edit)
    imageCache.AddImage("Icons/gato.gif",gato)
    imageCache.AddImage("Icons/getgray.gif",getgray)
    imageCache.AddImage("Icons/gnedge.gif",gnedge)
    imageCache.AddImage("Icons/gred.gif",gred)
    imageCache.AddImage("Icons/greennde.gif",greennde)
    imageCache.AddImage("Icons/grey.gif",grey)
    imageCache.AddImage("Icons/greynode.gif",greynode)
    imageCache.AddImage("Icons/ltblnode.gif",ltblnode)
    imageCache.AddImage("Icons/ltgnnode.gif",ltgnnode)
    imageCache.AddImage("Icons/mist.gif",mist)
    imageCache.AddImage("Icons/pink.gif",pink)
    imageCache.AddImage("Icons/red.gif",red)
    imageCache.AddImage("Icons/rednode.gif",rednode)
    imageCache.AddImage("Icons/swap.gif",swap)
    imageCache.AddImage("Icons/vertex.gif",vertex)
    imageCache.AddImage("Icons/whitnode.gif",whitnode)
    imageCache.AddImage("Icons/yellow.gif",yellow)

