(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     24955,        868]*)
(*NotebookOutlinePosition[     32034,       1052]*)
(*  CellTagsIndexPosition[     31873,       1043]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Sample Applications of the ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " Packages\n",
  StyleBox["\tby Konrad Polthier\n\t",
    FontSize->16],
  StyleBox["(Extended User's Guide, Draft 0.7, 20.09.01)",
    FontSize->16,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Left],

Cell[CellGroupData[{

Cell["A Reminder How to Setup JavaView`JLink`", "Subsection"],

Cell["Load the JavaView`JLink` package and initialize JavaView.", \
"MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\[IndentingNewLine]", 
    \(\(viewer = InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[26]:="],

Cell[TextData[{
  "Clear ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from all Java processes. After calling UninstallJava[] the package \
JavaView`JLink` must be loaded again."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(UninstallJava[];\)\)], "Input",
  CellLabel->"In[24]:="],

Cell[CellGroupData[{

Cell["\<\
For experts, the initialization of JavaView basically performs the following \
operations:\
\>", "Text"],

Cell["\<\
Load J/Link, here with a Microsoft virtual machine. This sequence of commands \
can be replaced by launching the package <<JavaView`JLink`.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(Needs["\<JLink`\>"]\), "\[IndentingNewLine]", 
    \(\(InstallJava[CommandLine \[Rule] "\<wjview\>", 
        MicrosoftJava \[Rule] True];\)\), "\[IndentingNewLine]", 
    \(\(Off[General::"\<spell1\>"];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell[TextData[{
  "Create a JavaView viewer manager and open an empty display window. Note, \
the window might appear behind ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " windows. This sequence of commands can be replaced with \
InstallJavaView[]."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(viewer = 
        JavaNew["\<jv.viewer.PvViewer\>"];\)\), "\[IndentingNewLine]", 
    \(\(disp = 
        viewer@newDisplay["\<JavaView: From Mathematica\>", 
            True];\)\), "\[IndentingNewLine]", 
    \(\(frame = disp@getFrame[];\)\), "\[IndentingNewLine]", 
    \(\(frame@setSize[400, 400];\)\), "\[IndentingNewLine]", 
    \(\(JavaShow[frame];\)\)}], "Input",
  CellLabel->"In[4]:="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Adaptions of ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " for J/Link"
}], "Subsection"],

Cell[TextData[{
  "I made a few modifications of JavaView for a better integration with \
J/Link and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Basically, I wrote a set of listener classes to allow ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to register for JavaView events. These classes reside in the JavaView \
package jvx.math which are available with the archive jvx.jar. The sample \
applications of this notebook require no further adaption of JavaView since \
the listener classes now belong to the basic API of JavaView."
}], "Text"],

Cell[CellGroupData[{

Cell["Arrays of PdVectors and PiVectors", "Subsubsection"],

Cell[TextData[{
  "1. Arrays of PdVector resp. PiVector are frequently used in geometry \
classes in JavaView, for example, the set of vertices of a surfaces is an \
array of PdVectors. J/Link will convert such an array to a list of PdVector \
resp. PiVector, where access to individual number would require another \
method call. Therefore, I provided routines getEntries[] and setEntries[] of \
PdVector and PiVector to convert an array of PdVector resp. PiVector to a \
double array of doubles resp. integers. The implicit rule in J/Link converts \
such arrays to a list of lists in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " which are then processed as in the usual way."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Each of the fundamental linear algebra classes PiVector respectively \
PdVector basically contains an array of integer respectively double values \
which are mapped to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists by J/Link."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(<< JavaView`JLink`\)], "Input",
  CellLabel->"In[26]:="],

Cell[BoxData[
    \(mathvi = {2, 3, 4}\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({2, 3, 4}\)], "Output",
  CellLabel->"Out[2]="],

Cell[CellGroupData[{

Cell[BoxData[
    \(vi = JavaNew["\<jv.vecmath.PiVector\>"]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "jv.vecmath.PiVector"] \[RightGuillemet]\),
      JLink`Objects`JavaObject39190529]], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(vi@getSize[]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[BoxData[
    \(\(vi@set[mathvi];\)\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \(\(vi@setEntry[1, 17];\)\)], "Input",
  CellLabel->"In[6]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(vi@getEntries[]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({2, 17, 4}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  "Many geometry items in JavaView are available as arrays of PdVector and \
PiVector which are easily exchanged back and forth with a list of lists in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Convert the points of a geometry into a list in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(geom = 
        JavaNew["\<jv.geom.PgElementSet\>", 3];\)\), "\[IndentingNewLine]", 
    \(\(geom@computeTorus[5, 5, 2. , 1. ];\)\), "\[IndentingNewLine]", 
    \(vertex\  = \ geom@getVertices[]\)}], "Input",
  CellLabel->"In[8]:="],

Cell["\<\
The array of points is converted to a list of lists of double values.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(mathList = PdVector`getEntries[vertex]\)], "Input",
  CellLabel->"In[11]:="]
}, Open  ]],

Cell[TextData[{
  "Assign a list of points produced in ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "to a geometry in JavaView."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(numULines\  = \ 5;\)\), "\[IndentingNewLine]", 
    \(\(numVLines\  = \ 6;\)\), "\[IndentingNewLine]", 
    \(point = 
      Flatten[Table[{x, y, Sin[x*y]}, \[IndentingNewLine]{x, 1, 
              numULines}, {y, 1, numVLines}], 1]\  // \ N\)}], "Input",
  CellLabel->"In[33]:="],

Cell["\<\
Create JavaView geometry and display it in the JavaView display.\
\>", "Text"],

Cell["\<\
Assure that JavaView was correctly loaded. Also, we need the viewer to access \
the JavaView display.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(viewer = InstallJavaView[];\)\)], "Input",
  CellLabel->"In[27]:="],

Cell["\<\
Create an empty JavaView point set and assign the vertices of the previous \
example.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(geom = 
        JavaNew["\<jv.geom.PgPointSet\>", 3];\)\), "\[IndentingNewLine]", 
    \(\(geom@setName["\<Graph of Sin[x*y]\>"];\)\), "\[IndentingNewLine]", 
    \(\(geom@
        setNumVertices[numULines*numVLines];\)\), "\[IndentingNewLine]", 
    \(\(geom@
        setVertices[PdVector`copyNew[point]];\)\), "\[IndentingNewLine]", 
    \(JavaView[geom]\)}], "Input",
  CellLabel->"In[36]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "jv.geom.PgPointSet"] \[RightGuillemet]\),
      JLink`Objects`JavaObject76939265]], "Output",
  CellLabel->"Out[40]="]
}, Open  ]],

Cell["Get the currently selected display from the viewer.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(disp = viewer@getDisplay[];\)\), "\[IndentingNewLine]", 
    \(disp@getName[]\)}], "Input",
  CellLabel->"In[41]:="],

Cell[BoxData[
    \("JavaView: From Mathematica"\)], "Output",
  CellLabel->"Out[42]="]
}, Open  ]],

Cell["Get all displays registered in the viewer.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(viewer@getDisplays[]\)], "Input",
  CellLabel->"In[45]:="],

Cell[BoxData[
    RowBox[{"{", 
      InterpretationBox[\(\[LeftGuillemet]JavaObject[
            "jv.viewer.PvDisplay"] \[RightGuillemet]\),
        JLink`Objects`JavaObject81199105], "}"}]], "Output",
  CellLabel->"Out[45]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Package jvx.math", "Subsubsection"],

Cell[TextData[{
  "I provide listener classes for basic JavaView events to be used from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in the same ways as the listener classes provided by J/Link for Java \
events. See the section on \"Advanced Examples\" for applications of the \
listener classes."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Menu for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (pending)"
}], "Subsubsection"],

Cell[TextData[{
  "I provide a menu entry to launch ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from control panel in JavaView. See the sample applications below."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initialization and Viewing of Graphics and Geometries", "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "This sample shows the basic steps to load JavaView`JLink`, create a \
JavaView display window, and use two ways to display either a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics or a simple JavaView geometry."
}], "Text"],

Cell["Initialize JavaView`JLink`.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\[IndentingNewLine]", 
    \(viewer\  = \ InstallJavaView[]\)}], "Input",
  CellLabel->"In[49]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "jv.viewer.PvViewer"] \[RightGuillemet]\),
      JLink`Objects`JavaObject82378753]], "Output",
  CellLabel->"Out[50]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Display a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Graphics"
}], "Subsubsection"],

Cell[TextData[{
  "Here we repeat the above step with a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics is converted into a string in C form by the command \
FormatGraphics[g] which is the only command we use here from the package \
JavaView`RunThrough`. The definition of helper command FormatGraphics[g] is \
included in JavaView`RunThrough`. The loader class has already been \
pre-loaded in InstallJavaView[]."
}], "Text"],

Cell[TextData[{
  "Create a sample ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(<< Graphics`Polyhedra`\), "\n", 
    \(\(dode = \ Graphics3D[Dodecahedron[]];\)\)}], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[TextData[{
  "Generate a JavaView geometry from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics and add it to the display. The load method parses the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics string and creates a JavaView geometry object."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(geomArr = 
        PgLoader`load[
          FormatGraphics[dode], "\<mgs\>"];\)\), "\[IndentingNewLine]", 
    \(\(geom = geomArr[\([1]\)];\)\), "\[IndentingNewLine]", 
    \(\(disp@removeGeometries[];\)\), "\[IndentingNewLine]", 
    \(\(disp@addGeometry[geom];\)\), "\[IndentingNewLine]", 
    \(\(geom@update[geom];\)\)}], "Input",
  CellLabel->"In[18]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display a JavaView Geometry", "Subsubsection"],

Cell["\<\
Here we create a simple JavaView surface and show it in the display.\
\>", "Text"],

Cell["Create an empty JavaView surface geometry.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(\(geom\  = \ 
        JavaNew["\<jv.geom.PgElementSet\>", 3];\)\(\ \)\)\)], "Input",
  CellLabel->"In[9]:="],

Cell["Compute a sample torus surface.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(geom@computeTorus[20, 15, 2. , \ 1. ];\)\), "\[IndentingNewLine]", 
    \(\(geom@setName["\<Torus\>"];\)\)}], "Input",
  CellLabel->"In[10]:="],

Cell["\<\
Add the geometry to the display. When the geometry has changed the method \
geom@update[geom] must be called to initiate a repaint in the display.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(disp@addGeometry[geom];\)\), "\[IndentingNewLine]", 
    \(\(geom@update[geom];\)\)}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Manipulating a Geometry", "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "This example uses ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to generate a vector field from interactive modifications of a JavaView \
geometry in the display.\n1. We create a sample sphere.\n2. We modify the \
sphere interactively in the JavaView display by dragging vertices around.\n3. \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is used to compute the difference between corresponding vertices of the \
original and the modified sphere as vector field.\n4. Mathematica assigns the \
offset vector field to the original sphere."
}], "Text"],

Cell["\<\
In this example we use the shortcut provided in the package JavaView`JLink` \
to create a JavaView display. The display becomes visible when first calling \
JavaView[g] or JavaViewGeom[geom]\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\[IndentingNewLine]", 
    \(\(viewer = InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell["Create an empty sample geometry with JavaView", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(\(geom\  = \ 
        JavaNew["\<jv.geom.PgElementSet\>", 3];\)\(\ \)\)\)], "Input",
  CellLabel->"In[3]:="],

Cell["\<\
We remove its interior boundary, enable drawing of vertices and labels of \
indices.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(geom@computeSphere[6, 6, 1. ];\)\), "\[IndentingNewLine]", 
    \(\(geom@setName["\<Discrete Sphere\>"];\)\), "\[IndentingNewLine]", 
    \(\(geom@showVertices[True];\)\), "\[IndentingNewLine]", 
    \(\(geom@showIndices[True];\)\)}], "Input",
  CellLabel->"In[4]:="],

Cell[TextData[{
  "Show geometry in JavaView display, display opens on first call. Maybe \
hidden behind ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " windows."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(JavaView[geom]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "jv.geom.PgElementSet"] \[RightGuillemet]\),
      JLink`Objects`JavaObject64487425]], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "Save a copy of the vertex array of the original sphere as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list of PdVector's. Print 15th vertex for testing."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(origVertex\  = \ 
        PdVector`getEntries[
          PdVector`copyNew[geom@getVertices[]]];\)\), "\[IndentingNewLine]", 
    \(origVertex[\([16]\)]\)}], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \({\(-0.7694208842938133`\), 0.5590169943749476`, 
      0.3090169943749474`}\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "Before invoking the next command, pick vertex 15 in the display and move \
it slightly to a new position. Note the 15: Java starts array indices at 0 \
and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " at 1. The pick mode is temporarily enabled by keeping the p-key pressed, \
and then drag a single vertex. Move a few vertices. "
}], "Text",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Save a copy of the vertex array of the modified sphere as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list of PdVector's. The 15th vertex should have changed."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(vertex\  = \ 
        PdVector`getEntries[
          PdVector`copyNew[geom@getVertices[]]];\)\), "\[IndentingNewLine]", 
    \(vertex[\([16]\)]\)}], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \({\(-0.7694208842938133`\), 0.5590169943749476`, 
      0.3090169943749474`}\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell[TextData[{
  "Let ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " compute the distance vector for each vertex. The 15th vector should be \
non-zero."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(vector = Subtract[vertex, origVertex];\)\), "\[IndentingNewLine]", 
    \(vector[\([16]\)]\)}], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    \({0.`, 0.`, 0.`}\)], "Output",
  CellLabel->"Out[14]="]
}, Open  ]],

Cell["\<\
The method copyNew[] creates an array of PdVectors from an array of \
doubles.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(pdvector\  = \ PdVector`copyNew[vector];\)\)], "Input",
  CellLabel->"In[15]:="],

Cell["Create a vector field and assign the distance vectors.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(vf\  = \ 
        JavaNew["\<jv.geom.PgVectorField\>", 
          geom@getDimOfVertices[]];\)\), "\[IndentingNewLine]", 
    \(\(vf@setGeometry[geom];\)\), "\[IndentingNewLine]", 
    \(\(vf@setVectors[pdvector];\)\)}], "Input",
  CellLabel->"In[16]:="],

Cell["\<\
Assign the vector field to the geometry, and initiate a repaint of the \
display. Before, we also restore the original vertices.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(geom@
        setVertices[
          PdVector`copyNew[origVertex]];\)\), "\[IndentingNewLine]", 
    \(geom@addVectorField[vf]\), "\[IndentingNewLine]", 
    \(\(geom@update[geom];\)\)}], "Input",
  CellLabel->"In[19]:="],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[20]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remove/Add a Single Element", "Subsubsection"],

Cell["\<\
Manually remove and add an individual element to a triangulation by using \
commands. Note, this sequence of commands is a feasibility demo and does not \
extend to larger number of elements. Larger number of elements are usually \
assigned either by allocating elements with setNumElements[int] and then \
using a sequence of setElement[int, int []] calls, or by high-level methods \
like makeQuadrConn[int,int] which generates the connectivity of a m*n grid.\
\>", "Text"],

Cell["\<\
Remove an arbitrary element. We recompute element adjacency to refresh \
boundary.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(geom@removeElement[18];\)\), "\[IndentingNewLine]", 
    \(\(geom@makeNeighbour[];\)\), "\[IndentingNewLine]", 
    \(\(geom@showBoundaries[True];\)\), "\[IndentingNewLine]", 
    \(\(geom@update[geom];\)\)}], "Input",
  CellLabel->"In[68]:="],

Cell["\<\
Restore the previously element by adding an element. We recompute element \
adjacency to refresh boundary.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(geom@
        addElement[JavaNew["\<jv.vecmath.PiVector\>", \ 22, 21, 27, 28], \ 
          18];\)\), "\[IndentingNewLine]", 
    \(\(geom@makeNeighbour[];\)\), "\[IndentingNewLine]", 
    \(\(geom@update[geom];\)\)}], "Input",
  CellLabel->"In[72]:="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Advanced Examples", "Section",
  CellGroupingRules->"SectionGrouping"],

Cell[CellGroupData[{

Cell[TextData[{
  "Using a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " Slider to Steer a Calculation"
}], "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Similar to example Real-Time Algebra. Mouse position in display is \
interpreted as two input parameters.\nSee notebook: ",
  ButtonBox["SliderListener.nb",
    ButtonData:>{"SliderListener.nb", None},
    ButtonStyle->"Hyperlink"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Mouse Events for Real-Time Algebra", "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Similar to example Real-Time Algebra example in the J/Link manual. Mouse \
position in a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display is interpreted as two input parameters.\nSee notebook: ",
  ButtonBox["MouseListener.nb",
    ButtonData:>{"MouseListener.nb", None},
    ButtonStyle->"Hyperlink"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Camera Events from Display", "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Example uses asynchronous event handling. Catch, for example, position \
events from the camera in a ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display for input of calculations.\nSee notebook: ",
  ButtonBox["CameraListener.nb",
    ButtonData:>{"CameraListener.nb", None},
    ButtonStyle->"Hyperlink"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Timer Events for Animations", "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "Create an animation where a satellite flies around a torus. All \
calculations are performed by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " initiated by events from the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " animation dialog.\nSee notebook: ",
  ButtonBox["satellite.nb",
    ButtonData:>{"satellite.nb", None},
    ButtonStyle->"Hyperlink"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Pick Events and ",
  StyleBox["Mathematica'",
    FontSlant->"Italic"],
  "s Delaunay Algorithm"
}], "Subsection",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "This notebook demonstrates a use of real-time heavy computations by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " while interacting with the ",
  StyleBox["JavaView",
    FontSlant->"Italic"],
  " display. We show a planar triangulation and drag vertices around while ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " simultaneously calculates the Delaunay triangulation.\nSee notebook: ",
  ButtonBox["Delaunay.nb",
    ButtonData:>{"Delaunay.nb", None},
    ButtonStyle->"Hyperlink"]
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 723}},
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{757, 688},
WindowMargins->{{Automatic, 5}, {Automatic, 0}},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {"Konrad Polthier"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The ", 
          StyleBox[ "JavaView", FontSlant -> "Italic"], " Packages"}], 
        "PageHeader"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"PrintingMargins"->{{56.6875, 56.6875}, {56.6875, \
56.6875}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FacingPages"->True},
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.1.3"->{
    Cell[2252, 69, 113, 2, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[2514, 78, 241, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[2978, 98, 201, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3449, 111, 311, 8, 74, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5786, 178, 313, 8, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7425, 252, 177, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7885, 269, 131, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8130, 279, 191, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8721, 299, 163, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8979, 309, 147, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[9782, 335, 105, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[10156, 350, 96, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[11781, 413, 81, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[12907, 453, 154, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[13252, 467, 340, 9, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[14164, 497, 96, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[14396, 505, 85, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[14653, 513, 208, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[15717, 545, 252, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[16117, 557, 99, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[16352, 565, 146, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[16794, 578, 223, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[17327, 600, 237, 6, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[18370, 634, 243, 6, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[18995, 657, 215, 7, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[19479, 678, 140, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[19727, 688, 108, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[20117, 699, 190, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[21218, 733, 144, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[21634, 746, 168, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]},
  "3.5"->{
    Cell[2252, 69, 113, 2, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[2514, 78, 241, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[2978, 98, 201, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3449, 111, 311, 8, 74, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5786, 178, 313, 8, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7425, 252, 177, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7885, 269, 131, 3, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8130, 279, 191, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8721, 299, 163, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[8979, 309, 147, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[9782, 335, 105, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[10156, 350, 96, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[11781, 413, 81, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[12907, 453, 154, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[13252, 467, 340, 9, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[14164, 497, 96, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[14396, 505, 85, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[14653, 513, 208, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[15717, 545, 252, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[16117, 557, 99, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[16352, 565, 146, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[16794, 578, 223, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[17327, 600, 237, 6, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[18370, 634, 243, 6, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[18995, 657, 215, 7, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[19479, 678, 140, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[19727, 688, 108, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[20117, 699, 190, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[21218, 733, 144, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[21634, 746, 168, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]},
  "Notation:S4"->{
    Cell[13064, 461, 185, 4, 54, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}]},
  "Notation:S4.3"->{
    Cell[13064, 461, 185, 4, 54, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.1.3", 26605, 911},
  {"3.5", 29118, 972},
  {"Notation:S4", 31639, 1033},
  {"Notation:S4.3", 31754, 1036}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 446, 14, 124, "Chapter",
  CellGroupingRules->"SectionGrouping"],

Cell[CellGroupData[{
Cell[2188, 67, 61, 0, 56, "Subsection"],
Cell[2252, 69, 113, 2, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[2368, 73, 143, 3, 54, "Input"],
Cell[2514, 78, 241, 7, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[2758, 87, 78, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[2861, 93, 114, 3, 29, "Text"],
Cell[2978, 98, 201, 4, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3182, 104, 264, 5, 75, "Input"],
Cell[3449, 111, 311, 8, 74, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3763, 121, 418, 9, 117, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4230, 136, 165, 6, 56, "Subsection"],
Cell[4398, 144, 574, 12, 86, "Text"],

Cell[CellGroupData[{
Cell[4997, 160, 58, 0, 42, "Subsubsection"],
Cell[5058, 162, 703, 12, 124, "Text"],

Cell[CellGroupData[{
Cell[5786, 178, 313, 8, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[6102, 188, 76, 2, 33, "Input"],
Cell[6181, 192, 75, 2, 33, "Input"],
Cell[6259, 196, 67, 2, 27, "Output"],

Cell[CellGroupData[{
Cell[6351, 202, 96, 2, 33, "Input"],
Cell[6450, 206, 195, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6682, 215, 69, 2, 33, "Input"],
Cell[6754, 219, 59, 2, 27, "Output"]
}, Open  ]],
Cell[6828, 224, 76, 2, 33, "Input"],
Cell[6907, 228, 80, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[7012, 234, 72, 2, 33, "Input"],
Cell[7087, 238, 68, 2, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[7182, 244, 240, 6, 48, "Text"],
Cell[7425, 252, 177, 6, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[7627, 262, 255, 5, 75, "Input"],
Cell[7885, 269, 131, 3, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[8019, 274, 96, 2, 33, "Input"]
}, Open  ]],
Cell[8130, 279, 191, 6, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[8324, 287, 303, 6, 96, "Input"],
Cell[8630, 295, 88, 2, 29, "Text"],
Cell[8721, 299, 163, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[8887, 305, 89, 2, 33, "Input"],
Cell[8979, 309, 147, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[9151, 317, 418, 9, 117, "Input"],
Cell[9572, 328, 195, 4, 27, "Output"]
}, Open  ]],
Cell[9782, 335, 105, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[9912, 340, 139, 3, 54, "Input"],
Cell[10054, 345, 87, 2, 27, "Output"]
}, Open  ]],
Cell[10156, 350, 96, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[10277, 355, 78, 2, 33, "Input"],
Cell[10358, 359, 227, 5, 27, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10634, 370, 41, 0, 42, "Subsubsection"],
Cell[10678, 372, 323, 7, 67, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11038, 384, 118, 5, 42, "Subsubsection"],
Cell[11159, 391, 190, 5, 29, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11398, 402, 115, 1, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[11516, 405, 262, 6, 48, "Text"],
Cell[11781, 413, 81, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[11887, 418, 142, 3, 54, "Input"],
Cell[12032, 423, 195, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12264, 432, 118, 5, 42, "Subsubsection"],
Cell[12385, 439, 519, 12, 86, "Text"],
Cell[12907, 453, 154, 6, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[13064, 461, 185, 4, 54, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3"}],
Cell[13252, 467, 340, 9, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[13595, 478, 382, 8, 117, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14014, 491, 52, 0, 42, "Subsubsection"],
Cell[14069, 493, 92, 2, 29, "Text"],
Cell[14164, 497, 96, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[14263, 500, 130, 3, 33, "Input"],
Cell[14396, 505, 85, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[14484, 508, 166, 3, 54, "Input"],
Cell[14653, 513, 208, 4, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[14864, 519, 118, 2, 54, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15031, 527, 85, 1, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[15119, 530, 595, 13, 175, "Text"],
Cell[15717, 545, 252, 5, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[15972, 552, 142, 3, 54, "Input"],
Cell[16117, 557, 99, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[16219, 560, 130, 3, 33, "Input"],
Cell[16352, 565, 146, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[16501, 571, 290, 5, 96, "Input"],
Cell[16794, 578, 223, 7, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[17042, 589, 71, 2, 33, "Input"],
Cell[17116, 593, 196, 4, 27, "Output"]
}, Open  ]],
Cell[17327, 600, 237, 6, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[17589, 610, 212, 5, 54, "Input"],
Cell[17804, 617, 134, 3, 27, "Output"]
}, Open  ]],
Cell[17953, 623, 414, 9, 67, "Text",
  CellGroupingRules->"SectionGrouping"],
Cell[18370, 634, 243, 6, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[18638, 644, 205, 5, 54, "Input"],
Cell[18846, 651, 134, 3, 27, "Output"]
}, Open  ]],
Cell[18995, 657, 215, 7, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[19235, 668, 152, 3, 54, "Input"],
Cell[19390, 673, 74, 2, 27, "Output"]
}, Open  ]],
Cell[19479, 678, 140, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[19622, 684, 102, 2, 33, "Input"],
Cell[19727, 688, 108, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[19838, 691, 276, 6, 75, "Input"],
Cell[20117, 699, 190, 4, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[20332, 707, 244, 6, 75, "Input"],
Cell[20579, 715, 60, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20676, 722, 52, 0, 42, "Subsubsection"],
Cell[20731, 724, 484, 7, 86, "Text"],
Cell[21218, 733, 144, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[21365, 739, 266, 5, 96, "Input"],
Cell[21634, 746, 168, 4, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[21805, 752, 275, 6, 75, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22129, 764, 76, 1, 77, "Section",
  CellGroupingRules->"SectionGrouping"],

Cell[CellGroupData[{
Cell[22230, 769, 171, 6, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[22404, 777, 262, 6, 56, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22703, 788, 102, 1, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[22808, 791, 347, 9, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23192, 805, 94, 1, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[23289, 808, 348, 9, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23674, 822, 95, 1, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[23772, 825, 404, 12, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24213, 842, 173, 6, 56, "Subsection",
  CellGroupingRules->"SectionGrouping"],
Cell[24389, 850, 538, 14, 94, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

