(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7717,        242]*)
(*NotebookOutlinePosition[     11266,        341]*)
(*  CellTagsIndexPosition[     11172,        334]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Camera Events from ",
  StyleBox["JavaView",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0.250004, 0.500008]],
  " Display\n",
  StyleBox["\tby Konrad Polthier",
    FontSize->16]
}], "Chapter",
  CellGroupingRules->"SectionGrouping",
  TextAlignment->Left],

Cell[TextData[{
  "When the JavaView display is opened, rotate the torus with the mouse. The \
camera events are caught by ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " The viewing direction of the camera is interpreted as rgb values and used \
to set the surface color immediately. As an effect the surface color will \
continuously change during rotation."
}], "Text"],

Cell["\<\
This notebook tests the camera listener class \"jvx.math.MathCameraListener\" \
of JavaView. This listener operates asynchronously by starting another thread \
for the event handling. This avoids delays during the rotation and user \
perceiption of the ongoing event handling.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Load Java runtime into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and load JavaView."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(<< JavaView`JLink`\), "\n", 
    \(\(viewer = InstallJavaView[];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell["\<\
Get the active JavaView 3d-display to be able to register the event handler \
below.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(\(disp = viewer@getDisplay[];\)\)], "Input",
  CellLabel->"In[3]:="],

Cell["Create a sample geometry.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(geom\  = \ 
        JavaNew["\<jv.geom.PgElementSet\>", 3];\)\), "\[IndentingNewLine]", 
    \(\(geom@computeTorus[10, 10, 2. , 1. ];\)\)}], "Input",
  CellLabel->"In[4]:="],

Cell["Show sample geometry in JavaView display.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(JavaView[geom]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "jv.geom.PgElementSet"] \[RightGuillemet]\),
      JLink`Objects`JavaObject87752705]], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell["\<\
This function will be called upon camera events. The argument evt is instance \
of jv.project.PvCameraEvent. Here we interpret the viewing direction of the \
camera as vector on the 1_sphere in rgb color space.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    RowBox[{
      StyleBox[\(evalCameraPosition[evt_, message_]\),
        "InlineInput"], 
      StyleBox[":=",
        "InlineInput"], 
      StyleBox["\[IndentingNewLine]",
        "InlineInput"], 
      StyleBox["\t",
        "InlineInput"], 
      RowBox[{
        StyleBox["JavaBlock",
          "InlineInput"], 
        StyleBox["[",
          "InlineInput"], 
        StyleBox["\[IndentingNewLine]",
          "InlineInput"], "\t\t", 
        StyleBox[\(\(dir = evt@getViewDir[];\)\[IndentingNewLine]
          \t\t\(rgb = Abs[dir@getEntries[]];\)\[IndentingNewLine]
          \t\t\(col = 
              JavaNew["\<java.awt.Color\>", rgb[\([1]\)], rgb[\([2]\)], 
                rgb[\([3]\)]];\)\[IndentingNewLine]
          \t\t\(geom@setGlobalElementColor[col];\)\[IndentingNewLine]
          \t\t\(geom@update[geom];\)\[IndentingNewLine]
          \t\tReleaseObject[evt]\),
          "InlineInput"], 
        StyleBox["\[IndentingNewLine]",
          "InlineInput"], 
        StyleBox["\t",
          "InlineInput"], 
        StyleBox["]",
          "InlineInput"]}]}]], "Input",
  CellLabel->"In[7]:="],

Cell["Register a listener of camera events in the 2D-display.", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(listener = 
        JavaNew["\<jvx.math.MathCameraListener\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(listener@
        setHandler["\<pickCamera\>", "\<evalCameraPosition\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(listener@
        setHandler["\<dragCamera\>", "\<evalCameraPosition\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(disp@addCameraListener[listener];\)\)}], "Input",
  CellLabel->"In[8]:="],

Cell["\<\
Share the kernel to allow further interaction with the geometry and display. \
After this call, rotate the surface inside the display and see the surface \
color changing.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[
    \(ShareKernel[]\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell[TextData[{
  "After having rotated the surface by hand you might want to switch to \
auto-rotate mode by pressing the w-key while mouse focus is in the display, \
or from within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The surface will then continuously rotate. Pressing the q-key will stop \
auto-rotate mode. Open the control panel to view and modify material \
properties of the surface."
}], "Text"],

Cell[TextData[{
  "Enable auto-rotation in display from within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". First specify rotation axis and angle increments, and then let the \
display run. Alternatively, use the w-key."
}], "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[BoxData[{
    \(\(axis\  = 
        JavaNew["\<jv.vecmath.PdVector\>", 0. , 1. , 
          0. ];\)\), "\[IndentingNewLine]", 
    \(disp@setAutoRotation[axis, Pi/30. ]\), "\[IndentingNewLine]", 
    \(\(disp@setEnabledAnimation[True];\)\), "\[IndentingNewLine]", 
    \(disp@start[]\)}], "Input",
  CellLabel->"(sharing) In[13]:="],

Cell["\<\
Press the w-key while mouse focus is over the display to enable \
auto-rotation. Use the q-key to stop auto-rotation.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell["\<\
Use right-mouse click within the display to open the control panel. See the \
surface color continuously changing in the material panel.\
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.5"}]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 723}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{703, 686},
WindowMargins->{{Automatic, 66}, {-15, Automatic}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {"Konrad Polthier"}], "PageHeader"]}, {Cell[ 
        TextData[ {"The ", 
          StyleBox[ "JavaView", FontSlant -> "Italic"], " Packages"}], 
        "PageHeader"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}, {Inherited, Cell[ 
        TextData[ {
          "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
        "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"PrintingMargins"->{{57.375, 57.375}, {57.375, 57.375}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FacingPages"->True},
CellLabelAutoDelete->False,
Magnification->1.25,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.1.3"->{
    Cell[2716, 80, 170, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3017, 93, 146, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3257, 103, 79, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3538, 112, 95, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3943, 128, 272, 5, 74, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5350, 169, 109, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5890, 185, 233, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6705, 212, 285, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7333, 230, 179, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7515, 236, 198, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]},
  "3.5"->{
    Cell[2716, 80, 170, 6, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3017, 93, 146, 4, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3257, 103, 79, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3538, 112, 95, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[3943, 128, 272, 5, 74, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5350, 169, 109, 1, 36, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[5890, 185, 233, 5, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[6705, 212, 285, 7, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7333, 230, 179, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[7515, 236, 198, 4, 55, "MathCaption",
      CellTags->{"S2.1.3", "3.5"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.1.3", 9482, 288},
  {"3.5", 10320, 309}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 284, 10, 98, "Chapter",
  CellGroupingRules->"SectionGrouping"],
Cell[2004, 61, 384, 8, 67, "Text"],
Cell[2391, 71, 300, 5, 67, "Text"],

Cell[CellGroupData[{
Cell[2716, 80, 170, 6, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[2889, 88, 125, 3, 54, "Input"],
Cell[3017, 93, 146, 4, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3166, 99, 88, 2, 33, "Input"],
Cell[3257, 103, 79, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[3339, 106, 196, 4, 54, "Input"],
Cell[3538, 112, 95, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],

Cell[CellGroupData[{
Cell[3658, 117, 71, 2, 33, "Input"],
Cell[3732, 121, 196, 4, 27, "Output"]
}, Open  ]],
Cell[3943, 128, 272, 5, 74, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[4218, 135, 1129, 32, 222, "Input"],
Cell[5350, 169, 109, 1, 36, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[5462, 172, 425, 11, 96, "Input"],
Cell[5890, 185, 233, 5, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[6126, 192, 71, 2, 33, "Input"],
Cell[6200, 196, 60, 2, 27, "Output"]
}, Open  ]],
Cell[6275, 201, 427, 9, 86, "Text"],
Cell[6705, 212, 285, 7, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[6993, 221, 337, 7, 113, "Input"],
Cell[7333, 230, 179, 4, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}],
Cell[7515, 236, 198, 4, 55, "MathCaption",
  CellTags->{"S2.1.3", "3.5"}]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

